/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.jobhandler.integral;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.ErpOrderApiService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.GetPushIntegralOrderToErpRequestVO;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@JobHandler(value="PushIntegralOrderOf361ToErpHandler")
public class PushIntegralOrderOf361ToErpHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(PushIntegralOrderOf361ToErpHandler.class);
    public static final int MIN_PARAMS_LENGTH = 2;
    @Autowired
    private ErpOrderApiService erpOrderApiService;
    @Resource
    private IntegralOrdersPOMapper integralOrdersPoMapper;

    public ReturnT<String> execute(String s) throws Exception {
        log.info("PushIntegralOrderOf361ToErpHandler#execute\u53c2\u6570:{}", (Object)s);
        XxlJobLogger.log((String)("\u6267\u884c\u53c2\u6570:" + s), (Object[])new Object[0]);
        if (StringUtils.isEmpty((Object)s)) {
            XxlJobLogger.log((String)"\u53c2\u6570null", (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        String[] split = s.split(",");
        if (split.length < 2) {
            XxlJobLogger.log((String)"\u53c2\u6570\u9519\u8bef!", (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        String merchantIdStr = split[0];
        if (StringUtils.isEmpty((Object)merchantIdStr)) {
            XxlJobLogger.log((String)"merchantId\u7a7a", (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        for (int i = 1; i < split.length; ++i) {
            ResponseData<Boolean> booleanResponseData = this.erpOrderApiService.pushIntegralOrderOf361ToErp(this.convertPushIntegralOrderOf361ToErpParams(Integer.parseInt(merchantIdStr), Integer.parseInt(split[i])));
            log.info("\u624b\u52a8\u63a8\u5355\u7ed3\u679c:{}", (Object)JSON.toJSONString(booleanResponseData));
        }
        return ReturnT.SUCCESS;
    }

    private GetPushIntegralOrderToErpRequestVO convertPushIntegralOrderOf361ToErpParams(Integer merchantId, Integer orderId) {
        GetPushIntegralOrderToErpRequestVO vo = new GetPushIntegralOrderToErpRequestVO();
        if (merchantId == null) {
            IntegralOrdersPO integralOrdersPo = this.integralOrdersPoMapper.selectByPrimaryKey(orderId);
            vo.setMerchantId(integralOrdersPo.getMerchantId());
            vo.setOrderNo(integralOrdersPo.getOrderNo());
            vo.setOrderId(integralOrdersPo.getId());
        } else {
            vo.setMerchantId(merchantId);
            vo.setOrderId(orderId);
        }
        vo.setExecuteType("pushByIdOrOrderNo");
        return vo;
    }
}

