/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.jobhandler.integral;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrderCancelService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrdersNewService;
import com.wmeimob.fastboot.util.InputValidator;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@JobHandler(value="CustomizedIntegralOrderCancelJob")
public class CustomizedIntegralOrderCancelJobHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomizedIntegralOrderCancelJobHandler.class);
    @Autowired
    private IntegralOrderCancelService integralOrderCancelService;
    @Autowired
    private IntegralOrdersNewService integralOrdersNewService;

    public ReturnT<String> execute(String s) throws Exception {
        return this.cancelIntegralOrder(s);
    }

    private ReturnT<String> cancelIntegralOrder(String params) {
        log.info("CustomizedIntegralOrderCancelJobHandler#execute:{}", (Object)params);
        XxlJobLogger.log((String)("\u53c2\u6570\uff1a" + params), (Object[])new Object[0]);
        ReturnT returnT = new ReturnT();
        returnT.setCode(100);
        returnT.setContent((Object)("params" + params));
        try {
            JSONObject paramsJson = JSONObject.parseObject((String)params);
            XxlJobLogger.log((String)JSON.toJSONString((Object)paramsJson), (Object[])new Object[0]);
            String orderNo = paramsJson.getString("orderNo");
            String merchantId = paramsJson.getString("merchantId");
            InputValidator.checkEmpty((Object)merchantId, (String)"\u5546\u6237id");
            InputValidator.checkEmpty((Object)orderNo, (String)"\u8ba2\u5355\u53f7");
            IntegralOrdersPO integralOrdersPo = this.integralOrdersNewService.queryIntegralOrderByOrderNoWithMerchantId(Integer.parseInt(merchantId), orderNo);
            String orderStatus = integralOrdersPo.getOrderStatus();
            if (!IntegralOrdersStatusEnum.PAY_AWAIT.getCode().equals(orderStatus)) {
                returnT.setMsg("\u8ba2\u5355\u5df2\u7ecf\u4e0d\u662f\u5f85\u652f\u4ed8\uff0c\u8df3\u8fc7\uff01" + orderNo);
                return returnT;
            }
            this.integralOrderCancelService.cancel(orderNo);
            returnT.setCode(0);
            returnT.setMsg("\u6267\u884c\u6210\u529f");
            return returnT;
        }
        catch (Exception e) {
            log.warn("CustomizedIntegralOrderCancelJobHandler#cancelIntegralOrder\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            XxlJobLogger.log((String)("CustomizedIntegralOrderCancelJobHandler#cancelIntegralOrder\u5f02\u5e38:" + e.getMessage()), (Object[])new Object[]{e});
            returnT.setMsg("\u5f02\u5e38\u4e86\uff1a " + e.getMessage());
            return returnT;
        }
    }
}

