/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.api.integaralstore.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsSkuPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuLogPO;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuPO;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuPOExample;
import com.wmeimob.fastboot.bizvane.service.admin.AsyncInterfaceService;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.ApiIntegralStockService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.IntegralStockChangeListVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.IntegralStockSetErrorVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.IntegralStockSetRequestVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ApiIntegralStockServiceImpl
implements ApiIntegralStockService {
    private static final Logger log = LoggerFactory.getLogger(ApiIntegralStockServiceImpl.class);
    @Resource
    private IntegralGoodsPOMapper integralGoodsPoMapper;
    @Resource
    private IntegralGoodsSkuPOMapper integralGoodsSkuPoMapper;
    @Autowired
    private AsyncInterfaceService asyncInterfaceService;
    private static final String OPERATION = "\u7cfb\u7edf";
    private static final Integer OPERATION_TYPE = 3;

    @Override
    public ResponseData<List<IntegralStockSetErrorVO>> setIntegralStock(IntegralStockSetRequestVO integralStockSetRequestVo) {
        log.info("ApiIntegralStockServiceImpl#setIntegralStock:{}", (Object)JSON.toJSONString((Object)integralStockSetRequestVo));
        ResponseData responseData = ResponseUtil.getDefaultResponse(new ArrayList(), (Boolean)false);
        ArrayList<IntegralStockSetErrorVO> integralStockSetErrorMsgList = new ArrayList<IntegralStockSetErrorVO>();
        try {
            ResponseData<Boolean> checkResult = this.checkParametersSetIntegralStock(integralStockSetRequestVo);
            if (!((Boolean)checkResult.getData()).booleanValue()) {
                responseData.setMessage(checkResult.getMessage());
                return responseData;
            }
            List<IntegralStockChangeListVO> changeList = integralStockSetRequestVo.getChangeList();
            for (IntegralStockChangeListVO changeListVo : changeList) {
                String errorMsg;
                ResponseData<Boolean> check2Result = this.checkParametersIntegrity(changeListVo);
                if (!((Boolean)check2Result.getData()).booleanValue()) {
                    String errorMsg2 = check2Result.getMessage();
                    log.warn(changeListVo.getGoodsId() + ": " + check2Result.getMessage());
                    IntegralStockSetErrorVO errorPo = this.gatherErrorInfo(changeListVo, errorMsg2);
                    integralStockSetErrorMsgList.add(errorPo);
                    continue;
                }
                IntegralGoodsPOWithBLOBs integralGoodsPo = this.integralGoodsPoMapper.selectByPrimaryKey(changeListVo.getGoodsId());
                if (StringUtils.isEmpty((Object)integralGoodsPo)) {
                    String errorMsg3 = "\u5546\u54c1[" + changeListVo.getGoodsId() + "]\u4e0d\u5b58\u5728";
                    log.warn(errorMsg3);
                    IntegralStockSetErrorVO errorPo = this.gatherErrorInfo(changeListVo, errorMsg3);
                    integralStockSetErrorMsgList.add(errorPo);
                    continue;
                }
                IntegralGoodsSkuPOExample example = new IntegralGoodsSkuPOExample();
                example.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(integralStockSetRequestVo.getMerchantId()).andGoodsIdEqualTo(changeListVo.getGoodsId()).andSkuNoEqualTo(changeListVo.getSkuNo());
                List integralGoodsSkuPoList = this.integralGoodsSkuPoMapper.selectByExample(example);
                if (CollectionUtils.isEmpty((Collection)integralGoodsSkuPoList)) {
                    errorMsg = "\u5546\u54c1[" + changeListVo.getGoodsId() + "]\u4e0bsku[" + changeListVo.getSkuNo() + "]\u89c4\u683c\u4e0d\u5b58\u5728";
                    log.warn(errorMsg);
                    IntegralStockSetErrorVO errorInfo = this.gatherErrorInfo(changeListVo, errorMsg);
                    integralStockSetErrorMsgList.add(errorInfo);
                    continue;
                }
                if (integralGoodsSkuPoList.size() > 1) {
                    errorMsg = "\u5546\u54c1[" + changeListVo.getGoodsId() + "]\u4e0bsku[" + changeListVo.getSkuNo() + "]\u91cd\u590d\uff01";
                    log.warn(errorMsg);
                    integralStockSetErrorMsgList.add(this.gatherErrorInfo(changeListVo, errorMsg));
                    continue;
                }
                IntegralGoodsSkuPO integralGoodsSkuPo = (IntegralGoodsSkuPO)integralGoodsSkuPoList.get(0);
                IntegralGoodsSkuPO updateGoodsSkuPo = new IntegralGoodsSkuPO();
                Date modifyTime = new Date();
                updateGoodsSkuPo.setId(integralGoodsSkuPo.getId());
                updateGoodsSkuPo.setGmtModified(modifyTime);
                log.info("\u5546\u54c1[" + changeListVo.getGoodsId() + "]\u4e0bsku[" + changeListVo.getSkuNo() + "]: \u539f\u6709\u5e93\u5b58[" + integralGoodsSkuPo.getStock() + "] ====> \u66f4\u65b0\u4e3a[" + changeListVo.getChangeStock() + "]");
                updateGoodsSkuPo.setStock(changeListVo.getChangeStock());
                if (integralGoodsSkuPo.getStock().equals(changeListVo.getChangeStock())) {
                    log.info("\u5e93\u91cc\u503c\u5df2\u7ecf\u662f\u4f60\u8981\u66f4\u65b0\u7684\u503c\u4e86\uff01");
                    continue;
                }
                int i = this.integralGoodsSkuPoMapper.updateByPrimaryKeySelective(updateGoodsSkuPo);
                if (i <= 0) continue;
                log.info("\u5e93\u5b58\u66f4\u65b0\u6210\u529f\uff0c\u5f00\u59cb\u63d2\u5165\u79ef\u5206\u5546\u57ce\u7684\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55\uff01");
                this.asyncInterfaceService.insertIntegralGoodsStockLogRecode(this.convertInsertStockLogRecodeParameters(integralGoodsSkuPo, changeListVo));
            }
            if (integralStockSetErrorMsgList.size() > 0) {
                responseData.setCode(1);
            } else {
                responseData.setCode(0);
            }
            responseData.setData(integralStockSetErrorMsgList);
            return responseData;
        }
        catch (Exception e) {
            log.warn("ApiIntegralStockServiceImpl\u6279\u91cf\u8bbe\u7f6e\u79ef\u5206\u5546\u57ce\u5e93\u5b58\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }

    private ResponseData<Boolean> checkParametersSetIntegralStock(IntegralStockSetRequestVO integralStockSetRequestVo) {
        int maxSize = 50;
        ResponseData responseData = new ResponseData();
        responseData.setData((Object)Boolean.FALSE);
        Integer merchantId = integralStockSetRequestVo.getMerchantId();
        if (StringUtils.isEmpty((Object)merchantId)) {
            responseData.setMessage("The merchantId must not be empty!");
            return responseData;
        }
        List<IntegralStockChangeListVO> changeList = integralStockSetRequestVo.getChangeList();
        if (CollectionUtils.isEmpty(changeList)) {
            responseData.setMessage("The field of changeList must be not empty");
            return responseData;
        }
        int size = changeList.size();
        if (size > 50) {
            responseData.setMessage("\u8bb0\u5f55\u6570\u5927\u4e8e50\u6761\u8bf7\u5206\u6279\u6b21\u8bf7\u6c42\uff01");
            return responseData;
        }
        responseData.setData((Object)Boolean.TRUE);
        return responseData;
    }

    private ResponseData<Boolean> checkParametersIntegrity(IntegralStockChangeListVO changeListVo) {
        String skuNo;
        Integer goodsId;
        ResponseData responseData = new ResponseData();
        responseData.setData((Object)Boolean.TRUE);
        StringBuffer msg = new StringBuffer("changeList===>");
        Integer changeStock = changeListVo.getChangeStock();
        if (StringUtils.isEmpty((Object)changeStock)) {
            msg.append("The changeStock must be not empty! ");
            responseData.setData((Object)Boolean.FALSE);
        }
        if (StringUtils.isEmpty((Object)(goodsId = changeListVo.getGoodsId()))) {
            msg.append("The goodsId must be not empty! ");
            responseData.setData((Object)Boolean.FALSE);
        }
        if (StringUtils.isEmpty((Object)(skuNo = changeListVo.getSkuNo()))) {
            msg.append("The skuNo must be not empty! ");
            responseData.setData((Object)Boolean.FALSE);
        }
        responseData.setMessage(msg.toString());
        return responseData;
    }

    private IntegralStockSetErrorVO gatherErrorInfo(IntegralStockChangeListVO changeListVo, String errorMsg) {
        IntegralStockSetErrorVO vo = new IntegralStockSetErrorVO();
        vo.setGoodsId(changeListVo.getGoodsId());
        vo.setSkuNo(changeListVo.getSkuNo());
        vo.setErrorMessage(errorMsg);
        return vo;
    }

    private IntegralGoodsSkuLogPO convertInsertStockLogRecodeParameters(IntegralGoodsSkuPO integralGoodsSkuPo, IntegralStockChangeListVO changeListVo) {
        IntegralGoodsSkuLogPO integralGoodsSkuLogPo = new IntegralGoodsSkuLogPO();
        integralGoodsSkuLogPo.setMerchantId(integralGoodsSkuPo.getMerchantId());
        integralGoodsSkuLogPo.setGoodsId(integralGoodsSkuPo.getGoodsId());
        integralGoodsSkuLogPo.setGoodsSkuNo(changeListVo.getSkuNo());
        integralGoodsSkuLogPo.setUserCreate(OPERATION);
        integralGoodsSkuLogPo.setValid(Boolean.TRUE);
        integralGoodsSkuLogPo.setGmtCreate(new Date());
        integralGoodsSkuLogPo.setOldStock(integralGoodsSkuPo.getStock());
        integralGoodsSkuLogPo.setCreateStock(changeListVo.getChangeStock());
        integralGoodsSkuLogPo.setCreateType(OPERATION_TYPE);
        return integralGoodsSkuLogPo;
    }
}

