/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.Integralstore.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralActivityGoodRelPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralActivityPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityGoodRelPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPO;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.activity.IntegralActivityAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.activity.IntegralActivityFindListRequestVO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class IntegralActivityServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(IntegralActivityServiceImpl.class);
    @Resource
    private IntegralActivityPOMapper integralActivityPOMapper;
    @Resource
    private IntegralActivityGoodRelPOMapper integralActivityGoodRelPOMapper;

    public Boolean checkIfActivityRunning(Long sysBrandId, Long activityId) {
        IntegralActivityPOExample integralActivityPOExample = this.getActiveActivityExample(sysBrandId, activityId);
        long l = this.integralActivityPOMapper.countByExample(integralActivityPOExample);
        return l > 0L;
    }

    public IntegralActivityPOExample getActiveActivityExample(Long sysBrandId, Long activityId) {
        IntegralActivityPOExample integralActivityPOExample = new IntegralActivityPOExample();
        IntegralActivityPOExample.Criteria criteria = integralActivityPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andActivityStatusEqualTo(Boolean.TRUE).andValidEqualTo(Boolean.TRUE).andEndTimeGreaterThan(new Date());
        if (activityId != null) {
            criteria.andIntegralActivityIdNotEqualTo(activityId);
        }
        return integralActivityPOExample;
    }

    public ResponseData add(IntegralActivityAddRequestVO requestVO) {
        if (this.checkIfActivityRunning(requestVO.getSysBrandId(), null).booleanValue()) {
            return ResponseUtil.getFailedMsg((String)"\u540c\u65f6\u4ec5\u652f\u6301\u4e00\u573a\u6d3b\u52a8\uff0c\u65e0\u6cd5\u521b\u5efa\u8be5\u6d3b\u52a8");
        }
        IntegralActivityPOWithBLOBs insertPO = new IntegralActivityPOWithBLOBs();
        BeanUtils.copyProperties((Object)requestVO, (Object)insertPO);
        insertPO.setGmtCreate(new Date());
        log.info("IntegralActivityServiceImpl_add_insertPO:{}", (Object)JSON.toJSONString((Object)insertPO));
        this.integralActivityPOMapper.insertSelective(insertPO);
        return ResponseUtil.getSuccessData(null);
    }

    public ResponseData<PageInfo<IntegralActivityPO>> findList(IntegralActivityFindListRequestVO requestVO) {
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        IntegralActivityPOExample selectExample = new IntegralActivityPOExample();
        selectExample.createCriteria().andSysBrandIdEqualTo(requestVO.getSysBrandId()).andValidEqualTo(Boolean.TRUE);
        selectExample.setOrderByClause("activity_status desc, integral_activity_id desc");
        List integralActivityPOS = this.integralActivityPOMapper.selectByExample(selectExample);
        PageInfo pageInfo = new PageInfo(integralActivityPOS);
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData updateActivityStatus(Long activityId, Boolean activityStatus) {
        IntegralActivityPOWithBLOBs activity = this.integralActivityPOMapper.selectByPrimaryKey(activityId);
        if (ObjectUtils.isEmpty((Object)activity)) {
            return ResponseUtil.getFailedMsg((String)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        if (activityStatus.booleanValue() && this.checkIfActivityRunning(activity.getSysBrandId(), activityId).booleanValue()) {
            return ResponseUtil.getFailedMsg((String)"\u540c\u65f6\u4ec5\u652f\u6301\u4e00\u573a\u6d3b\u52a8\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5f00\u542f\u8be5\u6d3b\u52a8");
        }
        Integer activityNum = this.integralActivityPOMapper.activeActivity(activityId, activityStatus);
        return ResponseUtil.getSuccessData(null);
    }

    public ResponseData<IntegralActivityPOWithBLOBs> getDetail(Long activityId) {
        IntegralActivityPOWithBLOBs integralActivityPOWithBLOBs = this.integralActivityPOMapper.selectByPrimaryKey(activityId);
        return ResponseUtil.getSuccessData((Object)integralActivityPOWithBLOBs);
    }

    public ResponseData<List<IntegralActivityPO>> getActiveActivity(Long sysBrandId) {
        IntegralActivityPOExample integralActivityPOExample = this.getActiveActivityExample(sysBrandId, null);
        List integralActivityPOS = this.integralActivityPOMapper.selectByExample(integralActivityPOExample);
        return ResponseUtil.getSuccessData((Object)integralActivityPOS);
    }

    public IntegralActivityPOWithBLOBs getActiveActivityOne(Long sysBrandId) {
        IntegralActivityPOExample integralActivityPOExample = this.getActiveActivityExample(sysBrandId, null);
        List integralActivityPOS = this.integralActivityPOMapper.selectByExampleWithBLOBs(integralActivityPOExample);
        return CollectionUtils.isEmpty((Collection)integralActivityPOS) ? null : (IntegralActivityPOWithBLOBs)integralActivityPOS.get(0);
    }

    public Boolean checkActiveActivityMatchGoodsId(Long integralActivityId, Long goodsId) {
        IntegralActivityGoodRelPOExample integralActivityGoodRelPOExample = new IntegralActivityGoodRelPOExample();
        integralActivityGoodRelPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andIntegralActivityIdEqualTo(integralActivityId).andGoodIdEqualTo(Integer.valueOf(goodsId.intValue()));
        long count = this.integralActivityGoodRelPOMapper.countByExample(integralActivityGoodRelPOExample);
        return count > 0L;
    }

    public Boolean checkActiveActivityMatchAnyGoodsId(Long goodsId) {
        IntegralActivityGoodRelPOExample integralActivityGoodRelPOExample = new IntegralActivityGoodRelPOExample();
        integralActivityGoodRelPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andGoodIdEqualTo(Integer.valueOf(goodsId.intValue()));
        long count = this.integralActivityGoodRelPOMapper.countByExample(integralActivityGoodRelPOExample);
        return count > 0L;
    }
}

