/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.Integralstore.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralActivityGoodRelPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsHandWrittenMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityGoodRelPO;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityGoodRelPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPO;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.activity.IntegralActivityGetActivityGoodsResponseVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.activity.IntegralActivityGetGoodsActivityListResponseVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.goods.IntegralGoodsHandWrittenSearchVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.ActivitySubjectRequestVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.ActivitySubjectResponseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class IntegralActivityGoodServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(IntegralActivityGoodServiceImpl.class);
    @Resource
    private IntegralActivityGoodRelPOMapper integralActivityGoodRelPOMapper;
    @Resource
    private IntegralActivityPOMapper integralActivityPOMapper;
    @Resource
    private IntegralGoodsMapper integralGoodsMapper;
    @Resource
    private IntegralGoodsHandWrittenMapper integralGoodsHandWrittenMapper;

    @Transactional
    public void setGoodActivity(Integer goodId, Long activityId) {
        log.info("IntegralGoodServiceImpl_setGoodActivity_goodId:{},activityId:{}", (Object)goodId, (Object)activityId);
        IntegralActivityGoodRelPO relByGoodIdLatest = this.integralActivityGoodRelPOMapper.getRelByGoodIdLatest(goodId);
        if (relByGoodIdLatest != null && relByGoodIdLatest.getGoodId().equals(goodId) && relByGoodIdLatest.getIntegralActivityId().equals(activityId)) {
            log.info("\u6700\u65b0\u76f8\u540c\u4e0d\u9700\u8981\u66f4\u65b0");
            return;
        }
        IntegralActivityGoodRelPOExample selectExample = new IntegralActivityGoodRelPOExample();
        selectExample.createCriteria().andValidEqualTo(Boolean.TRUE).andGoodIdEqualTo(goodId).andIntegralActivityIdEqualTo(activityId);
        List integralActivityGoodRelPOS = this.integralActivityGoodRelPOMapper.selectByExample(selectExample);
        IntegralActivityGoodRelPO integralActivityGoodRelPO = this.createInsertPO(goodId, activityId);
        if (CollectionUtils.isEmpty((Collection)integralActivityGoodRelPOS)) {
            log.info("\u4e0d\u5b58\u5728\u5386\u53f2\u8bb0\u5f55\uff0c\u76f4\u63a5\u63d2\u5165\u5173\u8054\u5173\u7cfb");
            this.integralActivityGoodRelPOMapper.insertSelective(integralActivityGoodRelPO);
            return;
        }
        this.integralActivityGoodRelPOMapper.deleteByPrimaryKey(((IntegralActivityGoodRelPO)integralActivityGoodRelPOS.get(0)).getIntegralActivityGoodRelId());
        this.integralActivityGoodRelPOMapper.insertSelective(integralActivityGoodRelPO);
    }

    private IntegralActivityGoodRelPO createInsertPO(Integer goodId, Long activityId) {
        IntegralActivityGoodRelPO insertPO = new IntegralActivityGoodRelPO();
        insertPO.setIntegralActivityId(activityId);
        insertPO.setGoodId(goodId);
        insertPO.setGmtCreate(new Date());
        return insertPO;
    }

    public ResponseData<List<IntegralActivityGetGoodsActivityListResponseVO>> getGoodsActivityList(Integer goodId, Long sysBrandId) {
        List integralActivityPOS;
        IntegralActivityPO activityByGoodIdLatest = this.integralActivityGoodRelPOMapper.getActivityByGoodIdLatest(goodId);
        IntegralActivityPOExample integralActivityPOExample = new IntegralActivityPOExample();
        IntegralActivityPOExample.Criteria criteria = integralActivityPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andActivityStatusEqualTo(Boolean.TRUE).andValidEqualTo(Boolean.TRUE);
        ArrayList<IntegralActivityGetGoodsActivityListResponseVO> responseVOList = new ArrayList<IntegralActivityGetGoodsActivityListResponseVO>();
        if (!ObjectUtils.isEmpty((Object)activityByGoodIdLatest)) {
            criteria.andIntegralActivityIdNotEqualTo(activityByGoodIdLatest.getIntegralActivityId());
            IntegralActivityGetGoodsActivityListResponseVO responseVO = new IntegralActivityGetGoodsActivityListResponseVO();
            BeanUtils.copyProperties((Object)activityByGoodIdLatest, (Object)responseVO);
            responseVO.setListType(Integer.valueOf(1));
            responseVOList.add(responseVO);
        }
        if (!CollectionUtils.isEmpty((Collection)(integralActivityPOS = this.integralActivityPOMapper.selectByExample(integralActivityPOExample)))) {
            IntegralActivityGetGoodsActivityListResponseVO responseVO = new IntegralActivityGetGoodsActivityListResponseVO();
            BeanUtils.copyProperties(integralActivityPOS.get(0), (Object)responseVO);
            responseVO.setListType(Integer.valueOf(0));
            responseVOList.add(responseVO);
        }
        return ResponseUtil.getSuccessData(responseVOList);
    }

    public ActivitySubjectResponseVO activitySubjectGoods(ActivitySubjectRequestVO activitySubjectRequestVO) {
        ActivitySubjectResponseVO activitySubjectResponseVO = new ActivitySubjectResponseVO();
        IntegralActivityPOWithBLOBs integralActivityPOWithBLOBs = null;
        Integer integralActivityId = activitySubjectRequestVO.getIntegralActivityId();
        if (integralActivityId != null) {
            integralActivityPOWithBLOBs = this.integralActivityPOMapper.selectByPrimaryKey(Long.valueOf(integralActivityId.longValue()));
            activitySubjectResponseVO.setActiveActivity(integralActivityPOWithBLOBs);
        }
        List integralGoods = new ArrayList();
        if (integralActivityPOWithBLOBs.getActivityStatus().booleanValue()) {
            PageHelper.startPage((int)activitySubjectRequestVO.getPageNum(), (int)activitySubjectRequestVO.getPageSize());
            IntegralGoodsHandWrittenSearchVO integralGoodsHandWrittenSearchVO = new IntegralGoodsHandWrittenSearchVO();
            integralGoodsHandWrittenSearchVO.setSysCompanyId(integralActivityPOWithBLOBs.getSysCompanyId());
            integralGoodsHandWrittenSearchVO.setShelf(Boolean.TRUE);
            integralGoodsHandWrittenSearchVO.setValid(Boolean.TRUE);
            integralGoodsHandWrittenSearchVO.setOrderBy("actual_sales desc");
            integralGoodsHandWrittenSearchVO.setIntegralActivityId(integralActivityPOWithBLOBs.getIntegralActivityId());
            integralGoods = this.integralGoodsHandWrittenMapper.activitySubjectGoods(integralGoodsHandWrittenSearchVO);
        }
        PageInfo pageInfo = new PageInfo(integralGoods);
        activitySubjectResponseVO.setPageInfo(pageInfo);
        return activitySubjectResponseVO;
    }

    public ResponseData<PageInfo<IntegralActivityGetActivityGoodsResponseVO>> getActivityGoods(Long activityId, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List responseVOList = this.integralGoodsHandWrittenMapper.getActivityGoods(activityId);
        PageInfo resultPage = new PageInfo(responseVOList);
        return ResponseUtil.getSuccessData((Object)resultPage);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData deleteActivityGoods(Long integralActivityGoodRelId, Integer goodId) {
        IntegralActivityGoodRelPO updatePO = new IntegralActivityGoodRelPO();
        updatePO.setIntegralActivityGoodRelId(integralActivityGoodRelId);
        updatePO.setValid(Boolean.FALSE);
        updatePO.setGmtModified(new Date());
        this.integralActivityGoodRelPOMapper.updateByPrimaryKeySelective(updatePO);
        IntegralActivityGoodRelPOExample checkExample = new IntegralActivityGoodRelPOExample();
        checkExample.createCriteria().andGoodIdEqualTo(goodId).andValidEqualTo(Boolean.TRUE);
        Long activityId = this.integralActivityGoodRelPOMapper.selectActivityIdByRelId(integralActivityGoodRelId);
        Boolean activityStatus = this.integralActivityPOMapper.selectActivityStatus(activityId);
        if (activityStatus.booleanValue()) {
            IntegralGoods integralGoods = new IntegralGoods();
            integralGoods.setId(goodId);
            integralGoods.setActivityJudge(Boolean.FALSE);
            this.integralGoodsMapper.updateByPrimaryKeySelective((Object)integralGoods);
        }
        return ResponseUtil.getSuccessData(null);
    }
}

