/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.entity.IndexSubjectImg;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.enums.ModuleType;
import com.wmeimob.fastboot.bizvane.mapper.HotGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IndexSubjectImgMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IndexSubjectImgLogPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IndexSubjectImgPOMapper;
import com.wmeimob.fastboot.bizvane.po.IndexSubjectImgPOExample;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.HotGoodsService;
import com.wmeimob.fastboot.bizvane.service.IndexSubjectService;
import com.wmeimob.fastboot.bizvane.service.admin.AsyncService;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(rollbackFor={Exception.class})
public class IndexSubjectServiceImpl
implements IndexSubjectService {
    private static final Logger log = LoggerFactory.getLogger(IndexSubjectServiceImpl.class);
    @Autowired
    private HotGoodsMapper hotGoodsMapper;
    @Autowired
    private HotGoodsService hotGoodsService;
    @Autowired
    private IndexSubjectImgMapper indexSubjectImgMapper;
    @Resource
    private GoodsService goodsService;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Resource
    private IndexSubjectImgPOMapper indexSubjectImgPoMapper;
    @Resource
    private IndexSubjectImgLogPOMapper indexSubjectImgLogPoMapper;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private LoginUtil loginUtil;
    @Autowired
    private HttpServletRequest request;

    public void add(Integer merchantId, Integer moduleType, JSONObject jsonObject) {
        Date date = new Date();
        try {
            IndexSubjectImgPOExample example = new IndexSubjectImgPOExample();
            example.createCriteria().andValidEqualTo(Boolean.TRUE).andIsDelEqualTo(Boolean.FALSE).andMerchantIdEqualTo(merchantId).andModuleTypeEqualTo(moduleType);
            List poList = this.indexSubjectImgPoMapper.selectByExample(example);
            if (!CollectionUtils.isEmpty((Collection)poList)) {
                poList.forEach(e -> this.asyncService.insertIndexSubjectLog(e.getMerchantId(), e.getModuleType(), e.getImgInfo(), "{\"\u6570\u636e\u6765\u6e90\":\"\u7cfb\u7edf\u81ea\u52a8\u5907\u4efd\u4fee\u6539\u524d\u6570\u636e\"}", date));
            }
        }
        catch (Exception e2) {
            log.warn("IndexSubjectServiceImpl#add#\u5907\u4efd\u5f02\u5e38:[{}]_[{}]", (Object)e2.getMessage(), (Object)e2);
        }
        JSONArray imgInfo = jsonObject.getJSONArray("imgInfo");
        if (imgInfo.size() > 0) {
            for (int i = 0; i < imgInfo.size(); ++i) {
                JSONObject object = imgInfo.getJSONObject(i);
                if (!"4".equals(object.getString("dataType"))) continue;
                JSONArray jSONArray = object.getJSONArray("goodsNo");
            }
        }
        if (ModuleType.SHOP_INDEX.getValue().equals(moduleType)) {
            IndexSubjectImg indexSubjectImg = new IndexSubjectImg();
            indexSubjectImg.setMerchantId(merchantId);
            indexSubjectImg.setIsDel(Boolean.FALSE);
            indexSubjectImg.setModuleType(ModuleType.SHOP_INDEX.getValue());
            this.indexSubjectImgMapper.delete((Object)indexSubjectImg);
            indexSubjectImg.setGmtCreate(date);
            indexSubjectImg.setImgInfo(jsonObject);
            this.indexSubjectImgMapper.insert((Object)indexSubjectImg);
            this.hotGoods(imgInfo, merchantId, moduleType, indexSubjectImg.getId());
        }
        Integer id = jsonObject.getInteger("id");
        if (ModuleType.SUBJECT_SETTINGS.getValue().equals(moduleType)) {
            String name = jsonObject.getString("name");
            Integer sort = jsonObject.getInteger("sort");
            Boolean isOpen = jsonObject.getBoolean("isOpen");
            Boolean status = jsonObject.getBoolean("status");
            InputValidator.checkLengthRange((Object)name, (int)0, (int)20, (String)"\u4e13\u9898\u540d\u79f0");
            InputValidator.checkNumber((Integer)1, (Integer)10000, (Integer)sort, (String)"\u6392\u5e8f\u503c");
            Example example = new Example(IndexSubjectImg.class);
            example.createCriteria().andEqualTo("name", (Object)name).andEqualTo("merchantId", (Object)merchantId);
            List indexSubjectImgs = this.indexSubjectImgMapper.selectByExample((Object)example);
            if (indexSubjectImgs.size() > 0) {
                IndexSubjectImg indexSubjectImg = (IndexSubjectImg)indexSubjectImgs.get(0);
                if (!indexSubjectImg.getIsDel().booleanValue() && !indexSubjectImg.getId().equals(id)) {
                    throw new CustomException("\u4e13\u9898\u540d\u79f0\u91cd\u590d");
                }
                Example updateExample = new Example(IndexSubjectImg.class);
                updateExample.createCriteria().andEqualTo("id", (Object)indexSubjectImg.getId()).andEqualTo("merchantId", (Object)merchantId).andEqualTo("moduleType", (Object)ModuleType.SUBJECT_SETTINGS.getValue());
                IndexSubjectImg update = new IndexSubjectImg();
                update.setGmtModified(date);
                update.setIsDel(Boolean.FALSE);
                update.setSort(sort);
                update.setImgInfo(jsonObject);
                this.indexSubjectImgMapper.updateByExampleSelective((Object)update, (Object)updateExample);
                this.hotGoods(imgInfo, merchantId, moduleType, id);
                return;
            }
            IndexSubjectImg indexSubjectImg = new IndexSubjectImg();
            indexSubjectImg.setMerchantId(merchantId);
            indexSubjectImg.setIsDel(Boolean.FALSE);
            indexSubjectImg.setModuleType(ModuleType.SUBJECT_SETTINGS.getValue());
            indexSubjectImg.setName(name);
            indexSubjectImg.setSort(sort);
            indexSubjectImg.setIsOpen(isOpen);
            indexSubjectImg.setImgInfo(jsonObject);
            indexSubjectImg.setGmtModified(date);
            indexSubjectImg.setStatus(status);
            if (StringUtils.isEmpty((Object)id)) {
                indexSubjectImg.setGmtCreate(date);
                this.indexSubjectImgMapper.insert((Object)indexSubjectImg);
                this.hotGoods(imgInfo, merchantId, moduleType, indexSubjectImg.getId());
            } else {
                InputValidator.checkEmpty((Object)id, (String)"\u53c2\u6570");
                IndexSubjectImg temp = (IndexSubjectImg)this.indexSubjectImgMapper.selectByPrimaryKey((Object)id);
                if (null == temp) {
                    throw new CustomException("\u4e3b\u9898\u4e0d\u5b58\u5728");
                }
                indexSubjectImg.setId(id);
                this.indexSubjectImgMapper.updateByPrimaryKeySelective((Object)indexSubjectImg);
                this.hotGoods(imgInfo, merchantId, moduleType, id);
            }
        }
        try {
            LoginUser loginUser = this.loginUtil.getLoginUser(this.request);
            loginUser.setToken(null);
            this.asyncService.insertIndexSubjectLog(merchantId, moduleType, JSON.toJSONString((Object)jsonObject), JSON.toJSONString((Object)loginUser), date);
        }
        catch (Exception e3) {
            log.warn("IndexSubjectServiceImpl#add#insertIndexSubjectLog\u5f02\u5e38:[{}]_[{}]", (Object)e3.getMessage(), (Object)e3);
        }
    }

    private void hotGoodsUpdate(JSONArray jsonArray, Integer merchantId, Integer moduleType, Integer id) {
        Iterator iterator = jsonArray.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (iterator.hasNext()) {
            JSONObject next = (JSONObject)iterator.next();
            if (!"4".equals(next.getString("dataType"))) continue;
            JSONArray goods = next.getJSONArray("goodsNo");
            for (int i = 0; i < goods.size(); ++i) {
                list.add(goods.get(i).toString());
            }
        }
        if (list.size() > 0) {
            String[] goodsNo = new String[list.size()];
            list.toArray(goodsNo);
            this.hotGoodsService.add(merchantId, moduleType, id, goodsNo);
        }
    }

    public List<IndexSubjectImg> findByCondition(IndexSubjectImg indexSubjectImg) {
        Example example = new Example(IndexSubjectImg.class);
        example.orderBy("sort").desc();
        example.createCriteria().andEqualTo("isDel", (Object)Boolean.FALSE).andEqualTo("id", (Object)indexSubjectImg.getId()).andEqualTo("merchantId", (Object)indexSubjectImg.getMerchantId()).andEqualTo("moduleType", (Object)indexSubjectImg.getModuleType());
        return this.indexSubjectImgMapper.selectByExample((Object)example);
    }

    public void delete(Integer merchantId, Integer id) {
        Example example = new Example(IndexSubjectImg.class);
        example.createCriteria().andEqualTo("id", (Object)id).andEqualTo("merchantId", (Object)merchantId).andEqualTo("moduleType", (Object)ModuleType.SUBJECT_SETTINGS.getValue());
        IndexSubjectImg indexSubjectImg = new IndexSubjectImg();
        indexSubjectImg.setGmtModified(new Date());
        indexSubjectImg.setIsDel(Boolean.TRUE);
        this.indexSubjectImgMapper.updateByExampleSelective((Object)indexSubjectImg, (Object)example);
    }

    private void hotGoods(JSONArray jsonArray, Integer merchantId, Integer moduleType, Integer id) {
        Iterator iterator = jsonArray.iterator();
        ArrayList<String> list = new ArrayList<String>();
        if (jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                if (!"4".equals(object.getString("dataType"))) continue;
                JSONArray goods = object.getJSONArray("goodsNo");
                for (int j = 0; j < goods.size(); ++j) {
                    list.add(goods.get(j).toString());
                }
            }
        }
        if (list.size() > 0) {
            String[] goodsNo = new String[list.size()];
            list.toArray(goodsNo);
            this.hotGoodsService.add(merchantId, moduleType, id, goodsNo);
        }
    }

    public List<IndexSubjectImg> findSubListByOn(Integer merchantId) {
        Example example = new Example(IndexSubjectImg.class);
        example.createCriteria().andEqualTo("isDel", (Object)Boolean.FALSE).andEqualTo("merchantId", (Object)merchantId).andEqualTo("moduleType", (Object)2).andEqualTo("status", (Object)1);
        return this.indexSubjectImgMapper.selectByExample((Object)example);
    }

    public List<CouponDTO> couponList4Mall(CouponDTO dto) {
        try {
            return this.bizvaneInterface.getCoupon4Mall(dto);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return new ArrayList<CouponDTO>();
        }
    }
}

