/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.newseckill;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityAnalysisService;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityAnalysisRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityAnalysisResponseVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityBaseSearchVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsSkuResponseVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.StockUpdateRecordResponseVO;
import com.wmeimob.fastboot.bizvane.utils.response.Result;
import com.wmeimob.fastboot.core.annotation.Page;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"seckill/seckillAnalysis"})
public class SeckillActivityAnalysisController {
    private static final Logger log = LoggerFactory.getLogger(SeckillActivityAnalysisController.class);
    @Autowired
    SeckillActivityAnalysisService seckillActivityAnalysisService;

    @ApiOperation(value="\u79d2\u6740\u6d3b\u52a8\u6548\u679c\u5206\u6790")
    @PostMapping(value={"/getAnalysisList"})
    @Page
    public Result<SeckillActivityAnalysisResponseVO> getSeckillAnalysisList(@RequestBody SeckillActivityBaseSearchVO analysisSearchVO) {
        log.info("SeckillActivity.getSeckillAnalysisList.\u79d2\u6740\u6548\u679c\u6d3b\u52a8\u5206\u9875:{}", (Object)JSON.toJSONString((Object)analysisSearchVO));
        return this.seckillActivityAnalysisService.listSeckillActivityAnalysis(analysisSearchVO);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5269\u4f59\u5e93\u5b58\u660e\u7ec6")
    @PostMapping(value={"/getGoodsStockList"})
    @Page
    public Result<List<SeckillActivityGoodsSkuResponseVO>> getSeckillActivityGoodsStockList(@RequestBody SeckillActivityBaseSearchVO analysisSearchVO) {
        return this.seckillActivityAnalysisService.getSeckillActivityGoodsStockList(analysisSearchVO);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55")
    @PostMapping(value={"/getGoodsStockRecordList"})
    @Page
    public Result<List<StockUpdateRecordResponseVO>> getSeckillActivityStockRecordList(@RequestBody SeckillActivityBaseSearchVO analysisSearchVO) {
        return this.seckillActivityAnalysisService.getSeckillActivityStockRecordList(analysisSearchVO);
    }

    @ApiOperation(value="\u65b0\u589e\u79d2\u6740\u6d3b\u52a8\u8ba2\u5355\u8bb0\u5f55")
    @PostMapping(value={"/saveSeckillActivityOrderRecord"})
    public Result<Boolean> saveSeckillActivityOrderRecord(@RequestBody SeckillActivityAnalysisRequestVO analysisRequestVO) {
        return this.seckillActivityAnalysisService.saveSeckillActivityOrderRecord(analysisRequestVO);
    }

    @ApiOperation(value="\u7f16\u8f91\u79d2\u6740\u6d3b\u52a8\u8ba2\u5355\u8bb0\u5f55")
    @PostMapping(value={"/updateSeckillActivityOrderRecord"})
    public Result<Boolean> updateSeckillActivityOrderRecord(@RequestBody SeckillActivityAnalysisRequestVO analysisRequestVO) {
        return this.seckillActivityAnalysisService.updateSeckillActivityOrderRecord(analysisRequestVO);
    }
}

