/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.enums.IntegralStore.activity.IntegralActivityRangeEnum;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPO;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.service.Integralstore.impl.IntegralActivityGoodServiceImpl;
import com.wmeimob.fastboot.bizvane.service.Integralstore.impl.IntegralActivityServiceImpl;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.activity.IntegralActivityAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.activity.IntegralActivityFindListRequestVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.activity.IntegralActivityGetActivityGoodsResponseVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.ActivitySubjectRequestVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.ActivitySubjectResponseVO;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"integralActivity"})
public class IntegralActivityController {
    private static final Logger log = LoggerFactory.getLogger(IntegralActivityController.class);
    @Autowired
    private IntegralActivityServiceImpl integralActivityService;
    @Autowired
    private IntegralActivityGoodServiceImpl integralActivityGoodService;

    @PostMapping(value={"/add"})
    public ResponseData add(@RequestBody @Valid IntegralActivityAddRequestVO requestVO) {
        InputValidator.checkLengthRange((Object)requestVO.getActivityName(), (int)0, (int)50, (String)"\u6d3b\u52a8\u540d\u79f0");
        if (IntegralActivityRangeEnum.AUTO_LABEL.getCode().equals(requestVO.getActivityRange())) {
            InputValidator.checkEmpty((Object)requestVO.getAutoLabelId(), (String)"\u53d7\u4f17\u5305\u7f16\u53f7");
        }
        if (Boolean.TRUE.equals(requestVO.getAlertStatus())) {
            InputValidator.checkEmpty((Object)requestVO.getAlertImg(), (String)"\u5f39\u7a97\u56fe\u7247");
            InputValidator.checkEmpty((Object)requestVO.getAlertType(), (String)"\u5f39\u7a97\u7f16\u53f7");
        }
        return this.integralActivityService.add(requestVO);
    }

    @PostMapping(value={"/findList"})
    public ResponseData<PageInfo<IntegralActivityPO>> findList(@RequestBody @Valid IntegralActivityFindListRequestVO requestVO) {
        log.info("IntegralActivityController_findList_requestVO:{}", (Object)JSON.toJSONString((Object)requestVO));
        return this.integralActivityService.findList(requestVO);
    }

    @GetMapping(value={"/getDetail"})
    public ResponseData<IntegralActivityPOWithBLOBs> getDetail(@RequestParam Long activityId) {
        return this.integralActivityService.getDetail(activityId);
    }

    @GetMapping(value={"/updateActivityStatus"})
    public ResponseData updateActivityStatus(@RequestParam Long activityId, @RequestParam Boolean activityStatus) {
        log.info("IntegralActivityController_updateActivityStatus_id:{},status:{}", (Object)activityId, (Object)activityStatus);
        return this.integralActivityService.updateActivityStatus(activityId, activityStatus);
    }

    @GetMapping(value={"getGoodsActivityList"})
    public ResponseData getGoodsActivityList(@RequestParam Integer goodId, @RequestParam Long sysBrandId) {
        log.info("IntegralActivityController_getGoodsActivityList_goodId:{},sysBrandId:{}", (Object)goodId, (Object)sysBrandId);
        return this.integralActivityGoodService.getGoodsActivityList(goodId, sysBrandId);
    }

    @GetMapping(value={"getActiveActivity"})
    public ResponseData<List<IntegralActivityPO>> getActiveActivity(@RequestParam Long sysBrandId) {
        log.info("IntegralActivityController_getActiveActivity_sysBrandId:{}", (Object)sysBrandId);
        return this.integralActivityService.getActiveActivity(sysBrandId);
    }

    @GetMapping(value={"getActiveActivityOne"})
    public ResponseData<IntegralActivityPOWithBLOBs> getActiveActivityOne(@RequestParam(value="sysBrandId") Long sysBrandId) {
        log.info("IntegralActivityController_getActiveActivityOne_sysBrandId:{}", (Object)sysBrandId);
        return ResponseUtil.getSuccessData((Object)this.integralActivityService.getActiveActivityOne(sysBrandId));
    }

    @GetMapping(value={"checkActiveActivityMatchGoodsId"})
    public ResponseData<Boolean> checkActiveActivityMatchGoodsId(@RequestParam(value="integralActivityId") Long integralActivityId, @RequestParam(value="goodsId") Long goodsId) {
        log.info("IntegralActivityController_checkActiveActivityMatchGoodsId:{},{}", (Object)integralActivityId, (Object)goodsId);
        return ResponseUtil.getSuccessData((Object)this.integralActivityService.checkActiveActivityMatchGoodsId(integralActivityId, goodsId));
    }

    @GetMapping(value={"checkActiveActivityMatchAnyGoodsId"})
    public ResponseData<Boolean> checkActiveActivityMatchAnyGoodsId(@RequestParam(value="goodsId") Long goodsId) {
        log.info("IntegralActivityController_checkActiveActivityMatchAnyGoodsId:{}", (Object)goodsId);
        return ResponseUtil.getSuccessData((Object)this.integralActivityService.checkActiveActivityMatchAnyGoodsId(goodsId));
    }

    @PostMapping(value={"/activitySubjectGoods"})
    public ResponseData<ActivitySubjectResponseVO> activitySubjectGoods(@RequestBody ActivitySubjectRequestVO activitySubjectRequestVO) {
        log.info("IntegralActivityController_activitySubjectGoods:{}", (Object)JSON.toJSONString((Object)activitySubjectRequestVO));
        return ResponseUtil.getSuccessData((Object)this.integralActivityGoodService.activitySubjectGoods(activitySubjectRequestVO));
    }

    @GetMapping(value={"/getActivityGoods"})
    public ResponseData<PageInfo<IntegralActivityGetActivityGoodsResponseVO>> getActivityGoods(@RequestParam Long activityId, @RequestParam Integer pageNum, @RequestParam Integer pageSize) {
        log.info("IntegralActivityController_getActivityGoods_activityId:{}", (Object)JSON.toJSONString((Object)activityId));
        return this.integralActivityGoodService.getActivityGoods(activityId, pageNum, pageSize);
    }

    @GetMapping(value={"/deleteActivityGoods"})
    public ResponseData deleteActivityGoods(@RequestParam Long integralActivityGoodRelId, @RequestParam Integer goodId) {
        log.info("IntegralActivityController_getActivityGoods_integralActivityGoodRelId:{},goodId:{}", (Object)integralActivityGoodRelId, (Object)goodId);
        return this.integralActivityGoodService.deleteActivityGoods(integralActivityGoodRelId, goodId);
    }
}

