/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.goods_group;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.po.GoodsGroupPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.goodsgroup.GoodsGroupService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.GoodsGroupLockRequestVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupAddResquestVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupDeleteResquestVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupSearchListResponseVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupUpdateResquestVO;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goodsGroup"})
public class GoodsGroupController {
    private static final Logger log = LoggerFactory.getLogger(GoodsGroupController.class);
    @Autowired
    private GoodsGroupService goodsGroupService;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;

    @PostMapping(value={"add"})
    public ResponseData addGroup(@RequestHeader Integer merchantId, @RequestBody GoodsGroupAddResquestVO vo) {
        log.info("GoodsGroupClassController addGroup merchantID:{} vo:{}", (Object)merchantId, JSON.toJSON((Object)((Object)vo)));
        if (StringUtils.isEmpty((Object)vo.getGoodsGroupName())) {
            return ResponseUtil.getFailedMsg((String)"\u4f20\u5165\u7684\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getPid() == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f20\u5165\u7684\u5206\u7ec4\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setMerchantId(merchantId);
        GoodsGroupPO goodsGroupPO = new GoodsGroupPO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)goodsGroupPO);
        List<GoodsGroupPO> goodsGroupPOS = this.goodsGroupService.checkClassIfSameName(goodsGroupPO);
        log.info("\u67e5\u8be2\u5230\u540c\u540d\u7684\u5206\u7ec4\u662f:{}", JSON.toJSON(goodsGroupPOS));
        if (!CollectionUtils.isEmpty(goodsGroupPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u6709\u540c\u540d\u5206\u7ec4");
        }
        vo.setBrandId(this.companyBrandRelationService.getBrandIdByMerchantId(merchantId));
        return this.goodsGroupService.addGroup(vo);
    }

    @PostMapping(value={"delete"})
    public ResponseData deleteGroup(@RequestHeader Integer merchantId, @RequestBody GoodsGroupDeleteResquestVO vo) {
        log.info("GoodsGroupClassController deleteGroupClass merchantID:{} vo:{}", (Object)merchantId, JSON.toJSON((Object)((Object)vo)));
        if (vo.getId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u5220\u9664\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setMerchantId(merchantId);
        return this.goodsGroupService.deleteGroup(vo);
    }

    @PostMapping(value={"checkGroupInUsed"})
    public ResponseData checkGroupInUsed(@RequestHeader Integer merchantId, @RequestBody GoodsGroupDeleteResquestVO vo) {
        log.info("GoodsGroupClassController checkGroupInUsed merchantID:{} vo:{}", (Object)merchantId, JSON.toJSON((Object)((Object)vo)));
        if (vo.getId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u5220\u9664\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setMerchantId(merchantId);
        GoodsGroupDeleteResquestVO goodsGroupDeleteResquestVO = new GoodsGroupDeleteResquestVO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)goodsGroupDeleteResquestVO));
        List<GoodsPO> goodsPOS = this.goodsGroupService.checkGroupInUsed(goodsGroupDeleteResquestVO, Boolean.FALSE);
        log.info("\u67e5\u8be2\u5230\u4f7f\u7528\u8be5\u5206\u7ec4\u5206\u7c7b\u4fe1\u606f\u7684\u5546\u54c1\u662f:{}", JSON.toJSON(goodsPOS));
        return ResponseUtil.getSuccessData(goodsPOS);
    }

    @PostMapping(value={"update"})
    public ResponseData updateGroup(@RequestHeader Integer merchantId, @RequestBody GoodsGroupUpdateResquestVO vo) {
        log.info("GoodsGroupClassController deleteGroupClass merchantID:{} vo:{}", (Object)merchantId, JSON.toJSON((Object)((Object)vo)));
        if (vo.getId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u4fee\u6539\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setMerchantId(merchantId);
        GoodsGroupPO goodsGroupPO = new GoodsGroupPO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)goodsGroupPO);
        List<GoodsGroupPO> goodsGroupPOS = this.goodsGroupService.checkClassIfSameName(goodsGroupPO);
        log.info("\u67e5\u8be2\u5230\u540c\u540d\u7684\u5206\u7ec4\u662f:{}", JSON.toJSON(goodsGroupPOS));
        if (!CollectionUtils.isEmpty(goodsGroupPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u6709\u540c\u540d\u5206\u7ec4");
        }
        return this.goodsGroupService.updateGroup(vo);
    }

    @PostMapping(value={"searchGoodsGroupList"})
    public ResponseData searchGoodsGroupList(@RequestHeader Integer merchantId, @RequestBody GoodsGroupSearchListResponseVO vo) {
        log.info("GoodsGroupClassController searchGoodsGroupList merchantID:{} vo:{}", (Object)merchantId, JSON.toJSON((Object)((Object)vo)));
        vo.setMerchantId(merchantId);
        if (vo.getPageJudge() == null) {
            vo.setPageJudge(Boolean.TRUE);
        }
        PageInfo pageInfo = this.goodsGroupService.searchGoodsGroupList(vo);
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    @PostMapping(value={"lockUsedGroup"})
    public ResponseData lockUsedGroup(@RequestHeader Integer merchantId, @RequestBody(required=false) GoodsGroupLockRequestVO lockList) {
        log.info("GoodsGroupClassController#lockUsedGroup lockList:{}", (Object)JSON.toJSONString((Object)lockList));
        if (lockList == null) {
            lockList = new GoodsGroupLockRequestVO();
        }
        lockList.setMerchantId(merchantId);
        return this.goodsGroupService.lockUsedGroup(lockList);
    }
}

