/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.api.Integralstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.api.dto.ApiBasicTokenDTO;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.ApiIntegralGoodsService;
import com.wmeimob.fastboot.bizvane.utils.api.BasicTokenUtils;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.api.ApiQueryGoodsInfoRequestVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.api.ApiQueryGoodsInfoResponseVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"apiIntegral"})
@RestController
public class ApiIntegralGoodsController {
    private static final Logger log = LoggerFactory.getLogger(ApiIntegralGoodsController.class);
    @Autowired
    private ApiIntegralGoodsService apiIntegralGoodsService;
    @Autowired
    private BasicTokenUtils basicTokenUtils;

    @PostMapping(value={"getGoodsInfo"})
    public ResponseData<PageInfo<ApiQueryGoodsInfoResponseVO>> queryGoodsInfo(@RequestHeader(value="token", required=false, defaultValue="") String token, @RequestBody ApiQueryGoodsInfoRequestVO apiQueryGoodsInfoRequestVo) {
        log.info("ApiIntegralGoodsController#queryGoodsInfo#token=:{}======>\u8bf7\u6c42\u53c2\u6570:{}", (Object)token, (Object)JSON.toJSONString((Object)apiQueryGoodsInfoRequestVo));
        ResponseData responseData = ResponseUtil.getDefaultResponse((Object)new PageInfo(), (Boolean)false);
        try {
            ResponseData decryptToken = this.basicTokenUtils.decryptTokenFromMenDale(token);
            if (!((Boolean)decryptToken.getData()).booleanValue()) {
                responseData.setMessage(decryptToken.getMessage());
                return responseData;
            }
            ApiBasicTokenDTO apiBasicTokenDTO = (ApiBasicTokenDTO)JSONObject.parseObject((String)decryptToken.getMessage(), ApiBasicTokenDTO.class);
            apiQueryGoodsInfoRequestVo.setMerchantId(apiBasicTokenDTO.getMerchantId());
            return this.apiIntegralGoodsService.queryGoodsInfo(apiQueryGoodsInfoRequestVo);
        }
        catch (Exception e) {
            log.warn("ApiIntegralGoodsController#queryGoodsInfo\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }
}

