/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.admin;

import com.wmeimob.fastboot.bizvane.service.admin.ImportService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.admin.ImportSearchVO;
import com.wmeimob.fastboot.bizvane.vo.admin.ImportVO;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"import"})
public class ImportController {
    private static final Logger log = LoggerFactory.getLogger(ImportController.class);
    @Autowired
    private ImportService importService;

    @ApiOperation(value="\u5546\u54c1\u5bfc\u5165")
    @PostMapping(value={"/goodsImport"})
    @ResponseBody
    public ResponseData goodsImport(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody ImportVO importVO, HttpServletRequest request) throws Exception {
        log.info("ImportController_goodsImport");
        ResponseData responseData = null;
        try {
            responseData = this.importService.goodsImport(merchantId, importVO, request);
        }
        catch (Exception e) {
            log.info("\u5546\u54c1\u5bfc\u5165\u5931\u8d25:{}", (Throwable)e);
            responseData = ResponseUtil.getFailedMsg((String)"\u5546\u54c1\u5bfc\u5165\u5931\u8d25!");
        }
        return responseData;
    }

    @ApiOperation(value="sku\u5bfc\u5165")
    @PostMapping(value={"/skusImport"})
    @ResponseBody
    public ResponseData skusImport(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody ImportVO importVO, HttpServletRequest request) {
        ResponseData responseData;
        log.info("ImportController_skusImport");
        try {
            responseData = this.importService.skusImport(merchantId, importVO, request);
        }
        catch (Exception e) {
            log.info("sku\u5bfc\u5165\u5931\u8d25:{}", (Throwable)e);
            responseData = ResponseUtil.getFailedMsg((String)"sku\u5bfc\u5165\u5931\u8d25!");
        }
        return responseData;
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfc\u5165\u72b6\u6001")
    @PostMapping(value={"/queryTaskInfo"})
    @ResponseBody
    public ResponseData queryTaskInfo(HttpServletRequest request, @RequestBody ImportSearchVO importSearchVO) {
        log.info("ImportController_queryTaskInfo");
        ResponseData responseData = this.importService.queryTaskInfo(request, importSearchVO);
        return responseData;
    }
}

