/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"config"})
public class ConfigController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    @Resource
    private ConfigService configService;
    @Resource(name="commonConfigService")
    private ConfigService commonConfigService;

    @PostMapping
    public RestResult insetConfig(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Config config) {
        config.setMerchantId(merchantId);
        try {
            this.configService.add((Serializable)config);
        }
        catch (Exception e) {
            log.warn("\u65b0\u589e\u7cfb\u7edf\u914d\u7f6e\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
        return RestResult.success((Object)config);
    }

    @GetMapping
    public Config getConfig(@RequestHeader(value="merchantId") Integer merchantId) {
        Config condition = new Config();
        condition.setMerchantId(merchantId);
        Config config = (Config)this.commonConfigService.findOneByCondition((Serializable)condition);
        return config;
    }

    @PutMapping(value={"{id}"})
    public RestResult updateConfig(@PathVariable(value="id") Integer id, @RequestHeader(value="merchantId", required=false) Integer merchantId, @RequestBody Config config) {
        config.setMerchantId(merchantId);
        int result = 0;
        try {
            result = this.configService.update((Serializable)config);
        }
        catch (Exception e) {
            log.warn("\u66f4\u65b0\u7cfb\u7edf\u914d\u7f6e\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @GetMapping(value={"/isThousandShop"})
    public ResponseData isThousandShop(@RequestHeader(value="merchantId") Integer merchantId) {
        log.info("ConfigController#isThousandShop#merchantId:{}", (Object)merchantId);
        return this.configService.isThousandShop(merchantId);
    }
}

