/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ThreadPoolConfig {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolConfig.class);
    @Value(value="${thread-pool.corePoolSize}")
    private int corePoolSize;
    @Value(value="${thread-pool.maximumPoolSize}")
    private int maximumPoolSize;
    @Value(value="${thread-pool.queueCapacity}")
    private int queueCapacity;
    @Value(value="${thread-pool.keepAliveSeconds}")
    private int keepAliveSeconds;

    @Bean
    public ThreadPoolExecutor threadPoolExecutor() {
        log.info("init schedule thread pool exec count TestCodeUpdate " + this.corePoolSize);
        return new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveSeconds, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.queueCapacity), new ThreadFactoryBuilder().setNameFormat("taskExecutor-").build());
    }

    @Bean
    public ScheduledThreadPoolExecutor scheduledThreadPoolExecutor() {
        return new ScheduledThreadPoolExecutor(10, new ThreadFactoryBuilder().setNameFormat("admin-local-global-pool-%d").build());
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setKeepAliveSeconds(int keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolConfig)) {
            return false;
        }
        ThreadPoolConfig other = (ThreadPoolConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        if (this.getQueueCapacity() != other.getQueueCapacity()) {
            return false;
        }
        return this.getKeepAliveSeconds() == other.getKeepAliveSeconds();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaximumPoolSize();
        result = result * 59 + this.getQueueCapacity();
        result = result * 59 + this.getKeepAliveSeconds();
        return result;
    }

    public String toString() {
        return "ThreadPoolConfig(corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", queueCapacity=" + this.getQueueCapacity() + ", keepAliveSeconds=" + this.getKeepAliveSeconds() + ")";
    }
}

