/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.vg.service;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersDetailsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersDetailsPO;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersDetailsPOExample;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.vg.model.VGIntegralGoodsCostComputeVo;
import com.wmeimob.fastboot.vg.model.VGIntegralGoodsCostListRequestVo;
import com.wmeimob.fastboot.vg.model.VGIntegralGoodsCostListResponseVo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class VGIntegralCostService {
    private static final Logger log = LoggerFactory.getLogger(VGIntegralCostService.class);
    @Resource
    private IntegralOrdersPOMapper integralOrdersPOMapper;
    @Resource
    private IntegralOrdersDetailsPOMapper integralOrdersDetailsPOMapper;
    private static final String previousComputeDay = "-25 00:00:00";
    private static final String nextComputeDay = "-24 23:59:59";

    @Async
    public void VGGoodsCompute(VGIntegralGoodsCostComputeVo vo) {
        log.info("VGIntegralCostService#VGGoodsCompute#vo:{}", (Object)JSON.toJSONString((Object)vo));
        IntegralOrdersDetailsPOExample integralOrdersDetailsPOExample = new IntegralOrdersDetailsPOExample();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(2, calendar.get(2) - vo.getComputeMonthInterval());
        Date lastMonthDate = calendar.getTime();
        integralOrdersDetailsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andSysCompanyIdEqualTo(vo.getSysCompanyId()).andGmtCreateBetween(lastMonthDate, new Date());
        List integralOrdersDetailsPOList = this.integralOrdersDetailsPOMapper.selectByExample(integralOrdersDetailsPOExample);
        for (IntegralOrdersDetailsPO integralOrdersDetailsPO : integralOrdersDetailsPOList) {
            log.info("VGIntegralCostService#VGGoodsCompute#forstart#integralOrdersDetailsPO:{}", (Object)JSON.toJSONString((Object)integralOrdersDetailsPO));
            BigDecimal purchasePrice = integralOrdersDetailsPO.getPurchasePrice();
            Integer convertPrice = integralOrdersDetailsPO.getSaleIntegral();
            if (purchasePrice == null || purchasePrice.compareTo(BigDecimal.ZERO) == 0 || convertPrice == null || integralOrdersDetailsPO.getSaleQuantity() == null) continue;
            BigDecimal exchangeRate = new BigDecimal(convertPrice).divide(purchasePrice, 2, 4);
            integralOrdersDetailsPO.setExchangeRate(exchangeRate);
            integralOrdersDetailsPO.setMallCostPercent(vo.getMallCostPercent());
            integralOrdersDetailsPO.setTnCostPercent(vo.getTnCostPercent());
            integralOrdersDetailsPO.setTtCostPercent(vo.getTtCostPercent());
            integralOrdersDetailsPO.setTzCostPercent(vo.getTzCostPercent());
            integralOrdersDetailsPO.setYjCostPercent(vo.getYjCostPercent());
            integralOrdersDetailsPO.setVgCostPercent(vo.getVgCostPercent());
            BigDecimal currentTotalPurchasePrice = integralOrdersDetailsPO.getPurchasePrice().multiply(new BigDecimal(integralOrdersDetailsPO.getSaleQuantity()));
            integralOrdersDetailsPO.setMallCostPrice(vo.getMallCostPercent().multiply(currentTotalPurchasePrice).setScale(2, 4));
            integralOrdersDetailsPO.setTnCostPrice(vo.getTnCostPercent().multiply(currentTotalPurchasePrice).setScale(2, 4));
            integralOrdersDetailsPO.setTtCostPrice(vo.getTtCostPercent().multiply(currentTotalPurchasePrice).setScale(2, 4));
            integralOrdersDetailsPO.setTzCostPrice(vo.getTzCostPercent().multiply(currentTotalPurchasePrice).setScale(2, 4));
            integralOrdersDetailsPO.setYjCostPrice(vo.getYjCostPercent().multiply(currentTotalPurchasePrice).setScale(2, 4));
            integralOrdersDetailsPO.setVgCostPrice(vo.getVgCostPercent().multiply(currentTotalPurchasePrice).setScale(2, 4));
            log.info("VGIntegralCostService#VGGoodsCompute#forend#integralOrdersDetailsPO:{}", (Object)JSON.toJSONString((Object)integralOrdersDetailsPO));
            this.integralOrdersDetailsPOMapper.updateByPrimaryKeySelective(integralOrdersDetailsPO);
        }
    }

    public ResponseData<PageInfo<VGIntegralGoodsCostListResponseVo>> goodsList(VGIntegralGoodsCostListRequestVo vo) {
        log.info("VGIntegralCostService#goodsList#vo:{}", (Object)JSON.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        if (vo.getComputeTime() != null) {
            Calendar ca = Calendar.getInstance();
            ca.setTime(vo.getComputeTime());
            int previousMonth = ca.get(2);
            int nextMonth = previousMonth + 1;
            int year = ca.get(1);
            String previousComputeDate = year + "-" + previousMonth + previousComputeDay;
            String nextComputeDate = year + "-" + nextMonth + nextComputeDay;
            log.info("VGIntegralCostService#goodsList#previousComputeDate:{},nextComputeDate:{}", (Object)previousComputeDate, (Object)nextComputeDate);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                vo.setOrderStartTime(simpleDateFormat.parse(previousComputeDate));
                vo.setOrderEndTime(simpleDateFormat.parse(nextComputeDate));
            }
            catch (ParseException e) {
                log.error("VGIntegralCostService#goodsList#ParseException:{}", (Object)e.getMessage());
            }
        }
        List vgIntegralGoodsCostListResponseVos = this.integralOrdersPOMapper.goodsList(vo);
        PageInfo pageInfo = new PageInfo(vgIntegralGoodsCostListResponseVos);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public List<VGIntegralGoodsCostListResponseVo> goodsListExport(VGIntegralGoodsCostListRequestVo vo) {
        log.info("VGIntegralCostService#goodsListExport#vo:{}", (Object)JSON.toJSONString((Object)vo));
        if (vo.getComputeTime() != null) {
            Calendar ca = Calendar.getInstance();
            ca.setTime(vo.getComputeTime());
            int previousMonth = ca.get(2);
            int nextMonth = previousMonth + 1;
            int year = ca.get(1);
            String previousComputeDate = year + "-" + previousMonth + previousComputeDay;
            String nextComputeDate = year + "-" + nextMonth + nextComputeDay;
            log.info("VGIntegralCostService#goodsListExport#previousComputeDate:{},nextComputeDate:{}", (Object)previousComputeDate, (Object)nextComputeDate);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                vo.setOrderStartTime(simpleDateFormat.parse(previousComputeDate));
                vo.setOrderEndTime(simpleDateFormat.parse(nextComputeDate));
            }
            catch (ParseException e) {
                log.error("VGIntegralCostService#goodsListExport#ParseException:{}", (Object)e.getMessage());
            }
        }
        return this.integralOrdersPOMapper.goodsListExport(vo);
    }
}

