/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.vg.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.utils.ExcelHelper;
import com.wmeimob.fastboot.bizvane.utils.FileUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.vg.service.VGIntegralCostService;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.vg.model.VGIntegralGoodsCostComputeVo;
import com.wmeimob.fastboot.vg.model.VGIntegralGoodsCostListRequestVo;
import com.wmeimob.fastboot.vg.model.VGIntegralGoodsCostListResponseVo;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"integralCost"})
public class VGIntegralCostController {
    private static final Logger log = LoggerFactory.getLogger(VGIntegralCostController.class);
    @Autowired
    private VGIntegralCostService vgIntegralCostService;
    @Autowired
    private HttpServletRequest request;

    @PostMapping(value={"VGGoodsCompute"})
    public RestResult VGGoodsCompute(@RequestBody VGIntegralGoodsCostComputeVo vo) {
        this.vgIntegralCostService.VGGoodsCompute(vo);
        return RestResult.success();
    }

    @PostMapping(value={"goodsList"})
    public ResponseData<PageInfo<VGIntegralGoodsCostListResponseVo>> goodsList(@RequestBody VGIntegralGoodsCostListRequestVo vo) {
        return this.vgIntegralCostService.goodsList(vo);
    }

    @ApiOperation(value="\u79ef\u5206\u6e05\u7b97\u5b9e\u7269\u5546\u54c1\u8ba2\u5355\u5bfc\u51fa")
    @GetMapping(value={"/export"})
    public void integralCostExport(VGIntegralGoodsCostListRequestVo vo, HttpServletResponse res) {
        List list = this.vgIntegralCostService.goodsListExport(vo);
        log.info("VGIntegralCostController#integralCostExport#list.size():{}", (Object)list.size());
        String[] heads = new String[]{"\u4f1a\u5458\u5361\u53f7", "\u79ef\u5206\u5546\u57ce\u8ba2\u5355\u53f7", "\u4e0b\u5355\u65f6\u95f4", "\u4ea7\u54c1\u7c7b\u522b", "\u5151\u6362\u5546\u54c1sku", "\u5151\u6362\u5546\u54c1\u540d", "\u89c4\u683c\u540d", "\u6d88\u8017\u79ef\u5206\u91cf", "\u603b\u6210\u672c\u4ef7", "\u5151\u6362\u7387", "\u9526\u96c6\u5206\u644a\u6bd4\u4f8b", "\u9526\u96c6\u5206\u644a\u6210\u672c", "TT\u5206\u644a\u6bd4\u4f8b", "TT\u5206\u644a\u6210\u672c", "TN\u5206\u644a\u6bd4\u4f8b", "TN\u5206\u644a\u6210\u672c", "TZ\u5206\u644a\u6bd4\u4f8b", "TZ\u5206\u644a\u6210\u672c", "VG\u5206\u644a\u6bd4\u4f8b", "VG\u5206\u644a\u6210\u672c", "\u4e91\u9526\u5206\u644a\u6bd4\u4f8b", "\u4e91\u9526\u5206\u644a\u6210\u672c"};
        String[] fields = new String[]{"cardNo", "orderNo", "orderTime", "goodsType", "skuNo", "goodsName", "goodsSkuSpecNames", "totalIntegralPrice", "totalPurchasePrice", "exchangeRate", "mallCostPercentString", "mallCostPrice", "ttCostPercentString", "ttCostPrice", "tnCostPercentString", "tnCostPrice", "tzCostPercentString", "tzCostPrice", "vgCostPercentString", "vgCostPrice", "yjCostPercentString", "yjCostPrice"};
        try {
            Workbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, VGIntegralGoodsCostListResponseVo.class, (HttpServletRequest)this.request);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u79ef\u5206\u6e05\u7b97\u5546\u54c1\u8ba2\u5355" + FileUtil.getOsNameSuffix((HttpServletRequest)this.request), "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

