/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.skyworth;

import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.ErrorInfo;
import com.bizvane.base.common.bean.PayPackageResult;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.ChannelConfigDto;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.IntegralStore.goods.IntegralUnionPayPaymentOrderTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralCashPayChannelEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.PayOrderStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.paygateway.PayGatewayChannelTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.paygateway.PayGatewaySyncStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralCouponPayRecordPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralUnionPayMchPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralCouponPayRecordPO;
import com.wmeimob.fastboot.bizvane.po.IntegralCouponPayRecordPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralPayGatewayPO;
import com.wmeimob.fastboot.bizvane.po.IntegralRefundOrderPO;
import com.wmeimob.fastboot.bizvane.po.IntegralUnionPayMchPO;
import com.wmeimob.fastboot.bizvane.po.IntegralUnionPayMchPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralUnionPayPaymentPO;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.IntegralRefundOrderService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrdersNewService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralUnionPayPaymentService;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayChannelService;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayConfigService;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayPayService;
import com.wmeimob.fastboot.bizvane.service.paygateway.util.MD5Util;
import com.wmeimob.fastboot.bizvane.service.skyworth.IntegralUnionPayService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.IntegralCouponPayVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.unioncallback.UnionPayCallBackVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.unioncallback.UnionRefundCallBackVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.IntegralOrderWrapperVO;
import com.wmeimob.fastboot.bizvane.vo.paygateway.IntegralPayGatewayOrderVO;
import com.wmeimob.fastboot.bizvane.vo.skyworth.IntegralUnionPayMchVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import me.hao0.wepay.model.pay.JsPayResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class IntegralUnionPayServiceImpl
implements IntegralUnionPayService {
    private static final Logger log = LoggerFactory.getLogger(IntegralUnionPayServiceImpl.class);
    @Resource
    private IntegralUnionPayMchPOMapper integralUnionPayMchPOMapper;
    @Autowired
    private PayGatewayChannelService payGatewayChannelService;
    @Resource
    private WechatProperties wechatProperties;
    @Autowired
    @Lazy
    private IntegralOrdersNewService integralOrdersNewService;
    @Autowired
    private PayGatewayPayService payGatewayPayService;
    @Autowired
    private PayGatewayConfigService payGatewayConfigService;
    @Resource
    private IntegralCouponPayRecordPOMapper integralCouponPayRecordPOMapper;
    @Autowired
    private IntegralOrdersService integralOrdersService;
    @Resource
    private IntegralOrdersPOMapper integralOrdersPOMapper;
    @Autowired
    private IntegralUnionPayPaymentService integralUnionPayPaymentService;
    private static final String PRIVATE_PURCHASE = "\u79c1\u4eba\u8d2d\u4e70";
    @Resource
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private IntegralRefundOrderService integralRefundOrderService;

    public ResponseData<IntegralUnionPayMchPO> addMch(IntegralUnionPayMchVO integralUnionPayMchVO) {
        ResponseData responseData = new ResponseData();
        Integer id = integralUnionPayMchVO.getId();
        if (id != null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u65b0\u589e\u5546\u6237\u94f6\u8054\u914d\u7f6e\u65f6\u4e0d\u80fd\u4f20id\u5b57\u6bb5!");
            return responseData;
        }
        IntegralUnionPayMchPO integralUnionPayMchPO = new IntegralUnionPayMchPO();
        BeanUtils.copyProperties((Object)integralUnionPayMchVO, (Object)integralUnionPayMchPO);
        integralUnionPayMchPO.setGmtCreate(new Date());
        int i = this.integralUnionPayMchPOMapper.insertSelective(integralUnionPayMchPO);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)integralUnionPayMchPO);
        return responseData;
    }

    public ResponseData modifyMch(IntegralUnionPayMchVO integralUnionPayMchVO) {
        ResponseData responseData = new ResponseData();
        Integer id = integralUnionPayMchVO.getId();
        if (id == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u65b0\u589e\u5546\u6237\u94f6\u8054\u914d\u7f6e\u65f6\u5fc5\u987b\u4f20id\u5b57\u6bb5!");
            return responseData;
        }
        IntegralUnionPayMchPO integralUnionPayMchPO = new IntegralUnionPayMchPO();
        BeanUtils.copyProperties((Object)integralUnionPayMchVO, (Object)integralUnionPayMchPO);
        integralUnionPayMchPO.setGmtModified(new Date());
        this.integralUnionPayMchPOMapper.updateByPrimaryKeySelective(integralUnionPayMchPO);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)integralUnionPayMchPO);
        return responseData;
    }

    public IntegralUnionPayMchPO findByBrandId(Integer brandId) {
        IntegralUnionPayMchPOExample integralUnionPayMchPOExample = new IntegralUnionPayMchPOExample();
        integralUnionPayMchPOExample.createCriteria().andMerchantIdEqualTo(brandId).andValidEqualTo(Boolean.TRUE);
        List integralUnionPayMchPOS = this.integralUnionPayMchPOMapper.selectByExample(integralUnionPayMchPOExample);
        if (!CollectionUtils.isEmpty((Collection)integralUnionPayMchPOS)) {
            return (IntegralUnionPayMchPO)integralUnionPayMchPOS.get(0);
        }
        return null;
    }

    @Transactional
    public ResponseData<JsPayResponse> payment(Integer orderId) {
        IntegralOrderWrapperVO integralOrderWrapperVO = this.integralOrdersNewService.queryOrderWrapper(orderId);
        BigDecimal totalFee = integralOrderWrapperVO.getTotalFee().multiply(BigDecimal.valueOf(100L));
        if (totalFee.compareTo(BigDecimal.ZERO) == 0) {
            ResponseData objectResponseData = new ResponseData();
            objectResponseData.setCode(SysResponseEnum.INTEGRAL_ORDER_NOT_NEED_PAY.getCode());
            objectResponseData.setMessage(SysResponseEnum.INTEGRAL_ORDER_NOT_NEED_PAY.getMessage());
            return objectResponseData;
        }
        IntegralOrdersPO integralOrdersPO = integralOrderWrapperVO.getIntegralOrdersPO();
        Integer merchantId = integralOrdersPO.getMerchantId();
        ChannelConfigDto remotePayGatewayChannelUnion = this.payGatewayChannelService.getRemotePayGatewayChannelUnion(merchantId);
        if (remotePayGatewayChannelUnion == null) {
            return ResponseUtil.getFailedMsg((String)"\u83b7\u53d6\u94f6\u8054\u652f\u4ed8\u914d\u7f6e\u5931\u8d25,\u65e0\u6cd5\u652f\u4ed8");
        }
        JsPayResponse jsPayResponse = this.builderResult(orderId, IntegralUnionPayPaymentOrderTypeEnum.DEFAULT.getCode());
        if (jsPayResponse != null) {
            return ResponseUtil.getSuccessData((Object)jsPayResponse);
        }
        String bizvaneMid = remotePayGatewayChannelUnion.getBizvaneMid();
        String orderNo = integralOrdersPO.getOrderNo();
        String openId = integralOrdersPO.getOpenId();
        String memberName = integralOrdersPO.getMemberName();
        if (StringUtils.isEmpty((Object)memberName)) {
            memberName = "\u7528\u6237" + integralOrdersPO.getMemberPhone();
        }
        orderNo = orderNo.replace("JFSC", "");
        IntegralPayGatewayOrderVO integralPayGatewayOrderVo = new IntegralPayGatewayOrderVO();
        integralPayGatewayOrderVo.setBizvaneMid(bizvaneMid);
        integralPayGatewayOrderVo.setOutTradeNo(orderNo);
        integralPayGatewayOrderVo.setBody(this.wechatProperties.getPay().getBody());
        integralPayGatewayOrderVo.setBuyerUserName(memberName);
        integralPayGatewayOrderVo.setBuyerUserId(openId);
        integralPayGatewayOrderVo.setBuyerUserType(PRIVATE_PURCHASE);
        integralPayGatewayOrderVo.setSubject("");
        integralPayGatewayOrderVo.setSpbillCreateIp("");
        integralPayGatewayOrderVo.setDetail("");
        integralPayGatewayOrderVo.setAttach("");
        integralPayGatewayOrderVo.setTotalFee(Integer.valueOf(totalFee.intValue()));
        integralPayGatewayOrderVo.setPayType(PayGatewayChannelTypeEnum.UNION_TYPE.getType());
        String cryptData = this.payGatewayPayService.cryptData(bizvaneMid, PayGatewayChannelTypeEnum.UNION_TYPE.getType());
        integralPayGatewayOrderVo.setCryptData(cryptData);
        ResultBean payPackageResultResultBean = this.payGatewayPayService.prePay(integralPayGatewayOrderVo);
        Boolean success = payPackageResultResultBean.getSuccess();
        if (!success.booleanValue()) {
            ErrorInfo errorInfo = payPackageResultResultBean.getErrorInfo();
            return ResponseUtil.getFailedMsg((String)JSON.toJSONString((Object)errorInfo));
        }
        PayPackageResult result = (PayPackageResult)payPackageResultResultBean.getResult();
        String resultCode = result.getResultCode();
        if ("FAIL".equalsIgnoreCase(resultCode)) {
            String returnMsg = result.getReturnMsg();
            return ResponseUtil.getFailedMsg((String)JSON.toJSONString((Object)returnMsg));
        }
        String bizvaneTradeNo = result.getBizvaneTradeNo();
        this.integralOrdersNewService.modifyOrderBizvaneTradeNo(orderId, bizvaneTradeNo);
        String appId = result.getAppid();
        String nonceStr = result.getNonceStr();
        String sign = result.getSign();
        String prepayId = result.getPrepayId();
        String signType = "RSA";
        String timeStamp = result.getTimeStamp();
        jsPayResponse = new JsPayResponse(appId, timeStamp, nonceStr, prepayId, signType, sign);
        this.saveResult(jsPayResponse, result, IntegralUnionPayPaymentOrderTypeEnum.COUPON.getCode());
        return ResponseUtil.getSuccessData((Object)jsPayResponse);
    }

    @Transactional
    public ResponseData paymentWithCoupon(IntegralCouponPayVO integralCouponPayVO) {
        ChannelConfigDto remotePayGatewayChannelUnion;
        Integer merchantId = integralCouponPayVO.getMerchantId();
        String openId = integralCouponPayVO.getOpenId();
        String convertCouponRecordCode = integralCouponPayVO.getConvertCouponRecordCode();
        Long convertCouponRecordId = integralCouponPayVO.getConvertCouponRecordId();
        BigDecimal price = integralCouponPayVO.getPrice().multiply(BigDecimal.valueOf(100L));
        String memberName = integralCouponPayVO.getMemberName();
        if (StringUtils.isEmpty((Object)memberName)) {
            memberName = "\u7528\u6237" + integralCouponPayVO.getMemberPhone();
        }
        IntegralCouponPayRecordPOExample integralCouponPayRecordPOExample = new IntegralCouponPayRecordPOExample();
        integralCouponPayRecordPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andOrderNoEqualTo(convertCouponRecordCode).andValidEqualTo(Boolean.TRUE);
        List integralCouponPayRecordPOS = this.integralCouponPayRecordPOMapper.selectByExample(integralCouponPayRecordPOExample);
        if (CollectionUtils.isEmpty((Collection)integralCouponPayRecordPOS)) {
            IntegralCouponPayRecordPO integralCouponPayRecordPO = new IntegralCouponPayRecordPO();
            integralCouponPayRecordPO.setMerchantId(merchantId);
            integralCouponPayRecordPO.setOrderNo(convertCouponRecordCode);
            integralCouponPayRecordPO.setOrderId(Integer.valueOf(convertCouponRecordId.intValue()));
            int n = this.integralCouponPayRecordPOMapper.insertSelective(integralCouponPayRecordPO);
        }
        if ((remotePayGatewayChannelUnion = this.payGatewayChannelService.getRemotePayGatewayChannelUnion(merchantId)) == null) {
            return ResponseUtil.getFailedMsg((String)"\u83b7\u53d6\u94f6\u8054\u652f\u4ed8\u914d\u7f6e\u5931\u8d25,\u65e0\u6cd5\u652f\u4ed8");
        }
        JsPayResponse jsPayResponse = this.builderResult(Integer.valueOf(convertCouponRecordId.intValue()), IntegralUnionPayPaymentOrderTypeEnum.COUPON.getCode());
        if (jsPayResponse != null) {
            return ResponseUtil.getSuccessData((Object)jsPayResponse);
        }
        String bizvaneMid = remotePayGatewayChannelUnion.getBizvaneMid();
        IntegralPayGatewayOrderVO integralPayGatewayOrderVo = new IntegralPayGatewayOrderVO();
        integralPayGatewayOrderVo.setBizvaneMid(bizvaneMid);
        integralPayGatewayOrderVo.setOutTradeNo(convertCouponRecordCode);
        integralPayGatewayOrderVo.setBody(this.wechatProperties.getPay().getBody());
        integralPayGatewayOrderVo.setBuyerUserName(memberName);
        integralPayGatewayOrderVo.setBuyerUserId(openId);
        integralPayGatewayOrderVo.setBuyerUserType(PRIVATE_PURCHASE);
        integralPayGatewayOrderVo.setTotalFee(Integer.valueOf(price.intValue()));
        integralPayGatewayOrderVo.setSubject("");
        integralPayGatewayOrderVo.setSpbillCreateIp("");
        integralPayGatewayOrderVo.setDetail("");
        integralPayGatewayOrderVo.setAttach("");
        integralPayGatewayOrderVo.setPayType(PayGatewayChannelTypeEnum.UNION_TYPE.getType());
        String cryptData = this.payGatewayPayService.cryptData(bizvaneMid, PayGatewayChannelTypeEnum.UNION_TYPE.getType());
        integralPayGatewayOrderVo.setCryptData(cryptData);
        ResultBean payPackageResultResultBean = this.payGatewayPayService.prePay(integralPayGatewayOrderVo);
        Boolean success = payPackageResultResultBean.getSuccess();
        if (!success.booleanValue()) {
            ErrorInfo errorInfo = payPackageResultResultBean.getErrorInfo();
            return ResponseUtil.getFailedMsg((String)JSON.toJSONString((Object)errorInfo));
        }
        PayPackageResult result = (PayPackageResult)payPackageResultResultBean.getResult();
        String resultCode = result.getResultCode();
        if ("FAIL".equalsIgnoreCase(resultCode)) {
            String returnMsg = result.getReturnMsg();
            return ResponseUtil.getFailedMsg((String)JSON.toJSONString((Object)returnMsg));
        }
        String bizvaneTradeNo = result.getBizvaneTradeNo();
        IntegralCouponPayRecordPO integralCouponPayRecordPO = new IntegralCouponPayRecordPO();
        integralCouponPayRecordPO.setBizvaneTradeNo(bizvaneTradeNo);
        integralCouponPayRecordPO.setGmtModified(new Date());
        IntegralCouponPayRecordPOExample integralCouponPayRecordPOExampleUpdate = new IntegralCouponPayRecordPOExample();
        integralCouponPayRecordPOExampleUpdate.createCriteria().andMerchantIdEqualTo(merchantId).andOrderIdEqualTo(Integer.valueOf(convertCouponRecordId.intValue())).andValidEqualTo(Boolean.TRUE);
        this.integralCouponPayRecordPOMapper.updateByExampleSelective(integralCouponPayRecordPO, integralCouponPayRecordPOExampleUpdate);
        String appId = result.getAppid();
        String nonceStr = result.getNonceStr();
        String sign = result.getSign();
        String prepayId = result.getPrepayId();
        String signType = "RSA";
        String timeStamp = result.getTimeStamp();
        jsPayResponse = new JsPayResponse(appId, timeStamp, nonceStr, prepayId, signType, sign);
        this.saveResult(jsPayResponse, result, IntegralUnionPayPaymentOrderTypeEnum.COUPON.getCode());
        return ResponseUtil.getSuccessData((Object)jsPayResponse);
    }

    public int modifyMchStatus(Integer id, PayGatewaySyncStatusEnum payGatewaySyncStatusEnum) {
        IntegralUnionPayMchPO integralUnionPayMchPO = new IntegralUnionPayMchPO();
        integralUnionPayMchPO.setId(id);
        integralUnionPayMchPO.setStatus(payGatewaySyncStatusEnum.getStatus());
        integralUnionPayMchPO.setGmtModified(new Date());
        int i = this.integralUnionPayMchPOMapper.updateByPrimaryKeySelective(integralUnionPayMchPO);
        return i;
    }

    @Transactional
    public ResponseData<String> paySuccessCallBack(UnionPayCallBackVO params) {
        ResponseData errorResponseData = new ResponseData();
        errorResponseData.setCode(SysResponseEnum.FAILED.getCode());
        errorResponseData.setMessage(SysResponseEnum.FAILED.getMessage());
        errorResponseData.setData((Object)"FAIL");
        ResponseData successResponseData = new ResponseData();
        successResponseData.setCode(SysResponseEnum.SUCCESS.getCode());
        successResponseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        successResponseData.setData((Object)"SUCCESS");
        @NotNull String bizvaneMid = params.getBizvaneMid();
        IntegralPayGatewayPO payGatewayConfigByMid = this.payGatewayConfigService.getPayGatewayConfigByMid(bizvaneMid);
        if (payGatewayConfigByMid == null) {
            log.warn("paySuccessCallBack_\u5e73\u53f0\u5546\u6237\u53f7\u4e0d\u5b58\u5728!");
            return errorResponseData;
        }
        Integer merchantId = payGatewayConfigByMid.getMerchantId();
        String bizvaneSecretKey = payGatewayConfigByMid.getBizvaneSecretKey();
        String data = bizvaneMid + PayGatewayChannelTypeEnum.UNION_TYPE.getType();
        String cryptData = MD5Util.encode((String)data, (String)bizvaneSecretKey).toUpperCase();
        if (!params.getCryptData().equals(cryptData)) {
            log.warn("paySuccessCallBack_\u9a8c\u7b7e\u5931\u8d25");
            return errorResponseData;
        }
        @NotNull String payStatus = params.getPayStatus();
        if (!PayOrderStatusEnum.PAY_SUCCESS.getMessage().equalsIgnoreCase(payStatus)) {
            log.warn("\u8ba2\u5355\u72b6\u6001\u975e\u300c\u9000\u6b3e\u6210\u529f\u300d!");
            return errorResponseData;
        }
        @NotNull String outTradeNo = params.getOutTradeNo();
        if (outTradeNo.contains("IC")) {
            @NotNull String transactionid = params.getTransactionid();
            IntegralCouponPayRecordPOExample integralCouponPayRecordPOExample = new IntegralCouponPayRecordPOExample();
            integralCouponPayRecordPOExample.createCriteria().andOrderNoEqualTo(outTradeNo).andValidEqualTo(Boolean.TRUE);
            List integralCouponPayRecordPOS = this.integralCouponPayRecordPOMapper.selectByExample(integralCouponPayRecordPOExample);
            IntegralCouponPayRecordPO integralCouponPayRecordPO = (IntegralCouponPayRecordPO)integralCouponPayRecordPOS.get(0);
            this.scheduledThreadPoolExecutor.execute(() -> {
                log.info("\u5f02\u6b65\u66f4\u65b0\u79ef\u5206\u4f18\u60e0\u5238\u8ba2\u5355\u72b6\u6001");
                Integer result = this.integralOrdersService.payCouponSuccess(integralCouponPayRecordPO, transactionid);
                log.info("\u66f4\u65b0\u4f18\u60e0\u5238\u8ba2\u5355:{}\u652f\u4ed8\u72b6\u6001:{}", (Object)integralCouponPayRecordPO.getBizvaneTradeNo(), (Object)result);
            });
            return successResponseData;
        }
        outTradeNo = "JFSC" + outTradeNo;
        Integer result = this.integralOrdersService.paySuccess(outTradeNo, IntegralCashPayChannelEnum.UNION_PAY);
        log.info("\u66f4\u65b0\u5b9e\u7269\u8ba2\u5355:{}\u652f\u4ed8\u72b6\u6001:{}", (Object)outTradeNo, (Object)result);
        return successResponseData;
    }

    @Transactional
    public ResponseData<String> refundSuccessCallBack(UnionRefundCallBackVO params) {
        ResponseData errorResponseData = new ResponseData();
        errorResponseData.setCode(SysResponseEnum.FAILED.getCode());
        errorResponseData.setMessage(SysResponseEnum.FAILED.getMessage());
        errorResponseData.setData((Object)"FAIL");
        ResponseData successResponseData = new ResponseData();
        successResponseData.setCode(SysResponseEnum.SUCCESS.getCode());
        successResponseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        successResponseData.setData((Object)"SUCCESS");
        @NotNull String bizvaneMid = params.getBizvaneMid();
        IntegralPayGatewayPO payGatewayConfigByMid = this.payGatewayConfigService.getPayGatewayConfigByMid(bizvaneMid);
        if (payGatewayConfigByMid == null) {
            log.warn("paySuccessCallBack_\u5e73\u53f0\u5546\u6237\u53f7\u4e0d\u5b58\u5728!");
            return errorResponseData;
        }
        Integer merchantId = payGatewayConfigByMid.getMerchantId();
        String bizvaneSecretKey = payGatewayConfigByMid.getBizvaneSecretKey();
        String data = bizvaneMid + PayGatewayChannelTypeEnum.UNION_TYPE.getType();
        String cryptData = MD5Util.encode((String)data, (String)bizvaneSecretKey).toUpperCase();
        if (!params.getCryptData().equals(cryptData)) {
            log.warn("paySuccessCallBack_\u9a8c\u7b7e\u5931\u8d25");
            return errorResponseData;
        }
        String refundStatus = params.getRefundStatus();
        if (!PayOrderStatusEnum.PAY_SUCCESS.getMessage().equalsIgnoreCase(refundStatus)) {
            log.warn("\u9000\u6b3e\u72b6\u6001\u975e\u300c\u9000\u6b3e\u6210\u529f\u300d!");
            return errorResponseData;
        }
        String outRefundNo = "refund" + params.getOutRefundNo();
        IntegralRefundOrderPO refundOrderPO = this.integralRefundOrderService.findByRefundNo(outRefundNo);
        String orderNo = refundOrderPO.getOrderNo();
        IntegralOrdersPO ordersPO = new IntegralOrdersPO();
        ordersPO.setOrderStatus(IntegralOrdersStatusEnum.REFUND.getCode());
        IntegralOrdersPOExample integralOrdersPOExample = new IntegralOrdersPOExample();
        integralOrdersPOExample.createCriteria().andOrderNoEqualTo(orderNo).andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        int i = this.integralOrdersPOMapper.updateByExampleSelective(ordersPO, integralOrdersPOExample);
        log.info("\u66f4\u65b0\u79ef\u5206\u5546\u57ce\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u9000\u6b3e");
        IntegralOrders orders = this.integralOrdersService.refund(orderNo, merchantId, null, null, Boolean.TRUE);
        return successResponseData;
    }

    private JsPayResponse builderResult(Integer orderId, Integer orderType) {
        IntegralUnionPayPaymentPO integralUnionPayPaymentPO = this.integralUnionPayPaymentService.findByOrderId(orderId, orderType);
        if (integralUnionPayPaymentPO == null) {
            return null;
        }
        String appId = integralUnionPayPaymentPO.getAppId();
        String timeStamp = integralUnionPayPaymentPO.getTimeStamp();
        String nonceStr = integralUnionPayPaymentPO.getNonceStr();
        String prepayId = integralUnionPayPaymentPO.getPrepayId();
        String signType = integralUnionPayPaymentPO.getSignType();
        String sign = integralUnionPayPaymentPO.getSign();
        JsPayResponse jsPayResponse = new JsPayResponse(appId, timeStamp, nonceStr, prepayId, signType, sign);
        return jsPayResponse;
    }

    private void saveResult(JsPayResponse jsPayResponse, PayPackageResult result, Integer orderType) {
        IntegralUnionPayPaymentPO integralUnionPayPaymentPO = new IntegralUnionPayPaymentPO();
        integralUnionPayPaymentPO.setAppId(jsPayResponse.getAppId());
        integralUnionPayPaymentPO.setTimeStamp(jsPayResponse.getTimeStamp());
        integralUnionPayPaymentPO.setNonceStr(jsPayResponse.getNonceStr());
        integralUnionPayPaymentPO.setPrepayId(jsPayResponse.getPkg());
        integralUnionPayPaymentPO.setSignType(jsPayResponse.getSignType());
        integralUnionPayPaymentPO.setSign(jsPayResponse.getPaySign());
        integralUnionPayPaymentPO.setPayGatewayResponse(JSON.toJSONString((Object)result));
        integralUnionPayPaymentPO.setGmtCreate(new Date());
        integralUnionPayPaymentPO.setOrderType(orderType);
        int save = this.integralUnionPayPaymentService.save(integralUnionPayPaymentPO);
        log.info("IntegralUnionPayService.saveResult:{}", (Object)JSON.toJSONString((Object)integralUnionPayPaymentPO));
    }
}

