/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.newseckill.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.wmeimob.fastboot.bizvane.dto.integral.GoodSkuSpecDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralClassify;
import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralSpec;
import com.wmeimob.fastboot.bizvane.enums.CalcTemplateWay;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.IntegralStore.goods.IntegralGoodsTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralGoodsFeightTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralOrderTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.PayOrderStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityStatus;
import com.wmeimob.fastboot.bizvane.enums.skyworth.IntegralGoodsPriceTypeEnum;
import com.wmeimob.fastboot.bizvane.mapper.IntegralClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralConfigMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralSpecMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralExpressTemplateAreaPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralExpressTemplatePOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsSkuPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityOrderRecordMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivitySkuMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralExpressTemplateAreaPO;
import com.wmeimob.fastboot.bizvane.po.IntegralExpressTemplateAreaPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralExpressTemplatePO;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuPO;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuPOExample;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityOrderRecordPO;
import com.wmeimob.fastboot.bizvane.po.SeckillActivitySkuPO;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityStatisticsPO;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrderJobService;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityOrderSevice;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityService;
import com.wmeimob.fastboot.bizvane.service.seckill.SeckillActivityRpcService;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityBaseSearchVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsRpcVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityResponseRpcVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivitySearchResponseVO;
import com.wmeimob.fastboot.bizvane.util.IntegralOrderNoUtil;
import com.wmeimob.fastboot.bizvane.utils.response.Result;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.order.IntegralOrderFeightVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import tk.mybatis.mapper.entity.Example;

@Service
public class SeckillActivityRpcServiceImpl
implements SeckillActivityRpcService {
    private static final Logger log = LoggerFactory.getLogger(SeckillActivityRpcServiceImpl.class);
    @Resource
    SeckillActivityGoodsMapper seckillActivityGoodsMapper;
    @Resource
    SeckillActivityOrderRecordMapper seckillActivityOrderRecordMapper;
    @Resource
    private IntegralGoodsMapper integralGoodsMapper;
    @Resource
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;
    @Resource
    private IntegralSpecMapper integralSpecMapper;
    @Resource
    private IntegralClassifyMapper integralClassifyMapper;
    @Resource
    private IntegralConfigMapper integralConfigMapper;
    @Autowired
    SeckillActivityRpcService seckillActivityRpcService;
    @Autowired
    private IntegralOrdersService integralOrdersService;
    @Resource
    private ThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private IntegralOrderJobService integralOrderJobService;
    @Resource
    SeckillActivityService seckillActivityService;
    @Resource
    SeckillActivitySkuMapper seckillActivitySkuMapper;
    @Resource
    SeckillActivityOrderSevice seckillActivityOrderSevice;
    @Resource
    private IntegralExpressTemplatePOMapper integralExpressTemplatePOMapper;
    @Resource
    private IntegralExpressTemplateAreaPOMapper integralExpressTemplateAreaPOMapper;
    @Resource
    private IntegralGoodsPOMapper integralGoodsPOMapper;
    @Resource
    private IntegralGoodsSkuPOMapper integralGoodsSkuPOMapper;

    public Result<SeckillActivityResponseRpcVO> getSeckillActivityGoodsList(SeckillActivityBaseSearchVO searchVO) {
        log.info("SeckillActivityRpcServiceImpl|getSeckillActivityGoodsList:{}", (Object)JSON.toJSONString((Object)searchVO));
        SeckillActivitySearchResponseVO responseVO = this.seckillActivityService.queryActivityStatus(searchVO.getActivityCode());
        if (SeckillActivityStatus.checkStatus((SeckillActivityStatus)responseVO.getStatus())) {
            return Result.failure((String)"\u79d2\u6740\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        PageHelper.startPage((int)searchVO.getPageIndex(), (int)searchVO.getPageSize());
        List seckillGoodsList = this.seckillActivityGoodsMapper.getSeckillGoodsList(searchVO.getActivityCode());
        log.info("SeckillActivityRpcServiceImpl|seckillGoodsList:{}", (Object)JSONObject.toJSONString((Object)seckillGoodsList));
        if (CollectionUtils.isEmpty((Collection)seckillGoodsList)) {
            return Result.failure((String)"\u672a\u67e5\u5230\u79d2\u6740\u5546\u54c1");
        }
        PageInfo pageInfo = new PageInfo(seckillGoodsList);
        List goodsIdList = pageInfo.getList().stream().map(SeckillActivityGoodsRpcVO::getActivityGoodsId).collect(Collectors.toList());
        List skuList = this.seckillActivitySkuMapper.selectActivitySkuList(searchVO.getActivityCode(), goodsIdList);
        if (CollectionUtils.isEmpty((Collection)skuList)) {
            return Result.failure((String)"\u672a\u67e5\u5230\u79d2\u6740\u5546\u54c1");
        }
        Map<Integer, Integer> stockMap = skuList.stream().collect(Collectors.groupingBy(SeckillActivitySkuPO::getGoodsId, Collectors.summingInt(SeckillActivitySkuPO::getActivityStock)));
        List statisticsPOList = this.seckillActivityOrderRecordMapper.selectSeckillOrderRecordList(searchVO.getActivityCode(), goodsIdList);
        if (CollectionUtils.isEmpty((Collection)statisticsPOList)) {
            pageInfo.getList().forEach(goods -> {
                goods.setOrderGoodsNum(Integer.valueOf(0));
                goods.setTotalStock((Integer)stockMap.get(goods.getId()));
            });
        } else {
            Map<Integer, Integer> statisticsPOMap = statisticsPOList.stream().collect(Collectors.toMap(SeckillActivityStatisticsPO::getGoodsId, SeckillActivityStatisticsPO::getGoodsOrderPieceNum));
            pageInfo.getList().forEach(goods -> {
                goods.setOrderGoodsNum((Integer)statisticsPOMap.get(goods.getId() == null ? 0 : (Integer)statisticsPOMap.get(goods.getId())));
                goods.setTotalStock((Integer)stockMap.get(goods.getId()));
            });
        }
        SeckillActivityResponseRpcVO response = new SeckillActivityResponseRpcVO();
        response.setGoodsRpcVOList(pageInfo.getList());
        response.setActivityVO(responseVO);
        return Result.success((Object)response, (Long)pageInfo.getTotal());
    }

    public Result<SeckillActivityResponseRpcVO> getGoodsDetail(SeckillActivityBaseSearchVO searchVO) {
        log.info("SeckillActivityRpcServiceImpl|getGoodsDetail:{}", (Object)JSON.toJSONString((Object)searchVO));
        SeckillActivitySearchResponseVO responseVO = this.seckillActivityService.queryActivityStatus(searchVO.getActivityCode());
        if (SeckillActivityStatus.checkStatus((SeckillActivityStatus)responseVO.getStatus())) {
            return Result.success();
        }
        IntegralGoods goods = this.getGoodsById(searchVO);
        SeckillActivityResponseRpcVO vo = new SeckillActivityResponseRpcVO();
        vo.setIntegralGoods(goods);
        vo.setActivityVO(responseVO);
        return Result.success((Object)vo);
    }

    public Result<IntegralOrders> createOrder(SeckillActivityBaseSearchVO searchVO) {
        log.info("Step1|SeckillActivityRpcServiceImpl|createOrder:{}", (Object)JSON.toJSONString((Object)searchVO));
        try {
            this.checkIntegralOrder(searchVO);
            log.info("Step2|SeckillActivityRpcServiceImpl:{}", (Object)JSON.toJSONString((Object)searchVO));
            this.buildOrderParam(searchVO.getIntegralOrders());
            log.info("Step3|SeckillActivityRpcServiceImpl:{}", (Object)JSON.toJSONString((Object)searchVO));
            IntegralOrders orders = this.seckillActivityOrderSevice.createOrder(searchVO);
            log.info("Step4|SeckillActivityRpcServiceImpl:{}", (Object)JSON.toJSONString((Object)orders));
            this.scheduledThreadPoolExecutor.execute(() -> {
                log.info("\u8ba2\u5355\u5f85\u652f\u4ed8\u8fdb\u5165job\u5b9a\u65f6\u53d6\u6d88[" + orders.getOrderNo() + "]" + new Date());
                this.integralOrderJobService.addCustomizedIntegralOrderCancelJob(orders.getMerchantId(), orders.getOrderNo());
            });
            return Result.success((Object)orders);
        }
        catch (Exception e) {
            log.error("SeckillActivityRpcServiceImpl|checkOrder:{},{}", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
    }

    private IntegralGoods getGoodsById(SeckillActivityBaseSearchVO searchVO) {
        Example example = new Example(IntegralGoods.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", (Object)searchVO.getGoodsId());
        criteria.andEqualTo("valid", (Object)Boolean.TRUE);
        criteria.andEqualTo("shelf", (Object)Boolean.TRUE);
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectOneByExample((Object)example);
        if (integralGoods == null) {
            throw new MallAdminException("\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u5220\u9664~");
        }
        log.info("SeckillActivityRpcServiceImpl|integralGoods:{}", (Object)JSONObject.toJSONString((Object)integralGoods));
        this.buildGoodsSku(integralGoods, searchVO.getGoodsId(), searchVO.getActivityCode());
        this.buildIntegralClassify(integralGoods);
        Example example1 = new Example(IntegralConfig.class);
        example1.createCriteria().andEqualTo("merchantId", (Object)integralGoods.getMerchantId());
        List integralConfigs = this.integralConfigMapper.selectByExample((Object)example1);
        if (CollectionUtils.isEmpty((Collection)integralConfigs)) {
            log.error("SeckillActivityRpcServiceImpl|\u672a\u521d\u59cb\u5316\u79ef\u5206\u5546\u57ce\u914d\u7f6e:{}", (Object)JSONObject.toJSONString((Object)searchVO));
            return null;
        }
        integralGoods.setIsWholeStore(((IntegralConfig)integralConfigs.get(0)).getIsWholeStore());
        log.info("SeckillActivityRpcServiceImpl|result:{}", (Object)JSONObject.toJSONString((Object)integralGoods));
        return integralGoods;
    }

    private void buildGoodsSku(IntegralGoods integralGoods, Integer goodsId, String activityCode) {
        List activitySkuList = this.seckillActivitySkuMapper.selectActivitySkuList(activityCode, (List)Lists.newArrayList((Object[])new Integer[]{goodsId}));
        if (CollectionUtils.isEmpty((Collection)activitySkuList)) {
            log.error("SeckillActivityRpcServiceImpl|buildGoodsSku is null:{}", (Object)activitySkuList);
            throw new MallAdminException("\u672a\u67e5\u8be2\u5230\u5546\u54c1sku\u4fe1\u606f");
        }
        Map<String, SeckillActivitySkuPO> activitySkuMap = activitySkuList.stream().collect(Collectors.toMap(SeckillActivitySkuPO::getSkuNo, a -> a, (a, b) -> a));
        Example skuExample = new Example(IntegralGoodsSku.class);
        skuExample.createCriteria().andEqualTo("goodsId", (Object)goodsId).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("enabled", (Object)Boolean.TRUE);
        List skuList = this.integralGoodsSkuMapper.selectByExample((Object)skuExample);
        log.info("SeckillActivityRpcServiceImpl|buildGoodsSku|skuList:{}", (Object)JSON.toJSONString((Object)skuList));
        for (IntegralGoodsSku sku : skuList) {
            ArrayList<GoodSkuSpecDTO> list = new ArrayList<GoodSkuSpecDTO>();
            List specMainList = this.integralSpecMapper.getPidList(sku.getSpecIds());
            for (IntegralSpec mainSpec : specMainList) {
                GoodSkuSpecDTO goodSkuSpecDTO = new GoodSkuSpecDTO();
                IntegralSpec specMain = (IntegralSpec)this.integralSpecMapper.selectByPrimaryKey((Object)mainSpec.getPid());
                goodSkuSpecDTO.setMainSpec(specMain);
                ArrayList<IntegralSpec> child = new ArrayList<IntegralSpec>();
                Example specExample = new Example(IntegralSpec.class);
                specExample.createCriteria().andCondition("id in (" + sku.getSpecIds() + ")");
                List specList = this.integralSpecMapper.selectByExample((Object)specExample);
                for (IntegralSpec childSpec : specList) {
                    if (!childSpec.getPid().equals(specMain.getId())) continue;
                    child.add(childSpec);
                }
                goodSkuSpecDTO.setChilds(child);
                list.add(goodSkuSpecDTO);
            }
            sku.setCashPrice(activitySkuMap.get(sku.getSkuNo()).getCashPrice());
            sku.setPrice(activitySkuMap.get(sku.getSkuNo()).getPrice());
            sku.setStock(activitySkuMap.get(sku.getSkuNo()).getActivityStock());
            sku.setId(Integer.valueOf(activitySkuMap.get(sku.getSkuNo()).getId().intValue()));
            sku.setGoodSkuSpecDetails(list);
        }
        int totalStock = activitySkuList.stream().mapToInt(SeckillActivitySkuPO::getActivityStock).sum();
        integralGoods.setTotalStock(Integer.valueOf(totalStock));
        integralGoods.setSkus(skuList);
    }

    private void buildIntegralClassify(IntegralGoods integralGoods) {
        ArrayList<IntegralClassify> integralClassifyList = new ArrayList<IntegralClassify>();
        String classifyStr = integralGoods.getClassifyId();
        if (classifyStr.contains(",")) {
            String[] classifyArray;
            for (String classify : classifyArray = classifyStr.split(",")) {
                IntegralClassify integralClassify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)classify);
                if (integralClassify == null) continue;
                integralClassifyList.add(integralClassify);
            }
        } else {
            IntegralClassify integralClassify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)classifyStr);
            if (integralClassify != null) {
                integralClassifyList.add(integralClassify);
            }
        }
        integralGoods.setClassifyList(integralClassifyList);
        if (integralGoods.getUpperShelfTime() != null) {
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(integralGoods.getUpperShelfTime());
            integralGoods.setUpperShelfTimeStr(time);
        }
    }

    private void checkEmptyByShipping(IntegralOrders integralOrders) {
        if (StringUtils.isEmpty((CharSequence)integralOrders.getShippingName()) || StringUtils.isEmpty((CharSequence)integralOrders.getShippingMobile()) || StringUtils.isEmpty((CharSequence)integralOrders.getShippingProvince()) || StringUtils.isEmpty((CharSequence)integralOrders.getShippingCity()) || StringUtils.isEmpty((CharSequence)integralOrders.getShippingDistrict()) || StringUtils.isEmpty((CharSequence)integralOrders.getShippingAddress()) || "undefined".equals(integralOrders.getShippingName()) || "undefined".equals(integralOrders.getShippingMobile()) || "undefined".equals(integralOrders.getShippingProvince()) || "undefined".equals(integralOrders.getShippingCity()) || "undefined".equals(integralOrders.getShippingDistrict()) || "undefined".equals(integralOrders.getShippingAddress())) {
            throw new MallAdminException("\u8bf7\u5b8c\u5584\u6536\u8d27\u4fe1\u606f\uff01");
        }
    }

    public void checkMember(IntegralOrders integralOrders, IntegralGoods integralGoods) {
        log.info("checkMember\u5165\u53c2:{},{}", JSON.toJSON((Object)integralOrders), JSON.toJSON((Object)integralGoods));
        if (integralGoods != null && integralGoods.getMemberScope() != 0) {
            String storeWhiteList;
            Object list;
            List list1;
            log.info("\u8be5\u5546\u54c1\u9700\u8981\u6821\u9a8c\u662f\u5426\u9002\u7528\u7b49\u7ea7\u548c\u5e97\u94fa");
            if (StringUtils.isNotEmpty((CharSequence)integralGoods.getStoreWhiteList()) && CollectionUtils.isNotEmpty((Collection)(list1 = (List)(list = new Gson().fromJson(storeWhiteList = integralGoods.getStoreWhiteList(), new /* Unavailable Anonymous Inner Class!! */.getType())))) && list1.stream().noneMatch(e -> integralOrders.getStoreId().toString().equals(e.getSysStoreId()))) {
                throw new MallAdminException("\u60a8\u76ee\u524d\u7684\u5f00\u5361\u95e8\u5e97\u4e0d\u5c5e\u4e8e\u5546\u54c1\u53ef\u552e\u95e8\u5e97\u8303\u56f4");
            }
            if (!StringUtils.isEmpty((CharSequence)integralGoods.getMemberLevelNames()) && Arrays.stream(integralGoods.getMemberLevelNames().split(",")).noneMatch(e -> integralOrders.getLevelName().equals(e))) {
                throw new MallAdminException("\u60a8\u76ee\u524d\u7684\u5361\u7b49\u7ea7\u4e0d\u5c5e\u4e8e\u5546\u54c1\u53ef\u552e\u7b49\u7ea7\u8303\u56f4");
            }
        }
        log.info("\u5546\u54c1\u901a\u8fc7\u6821\u9a8c:_\u5546\u54c1Id:[{}]", (Object)integralOrders.getGoodId());
    }

    private void checkIntegralOrder(SeckillActivityBaseSearchVO searchVO) {
        IntegralOrders integralOrders = searchVO.getIntegralOrders();
        this.checkOrderParam(integralOrders);
        SeckillActivitySearchResponseVO activity = this.seckillActivityService.queryActivityStatus(searchVO.getActivityCode());
        if (!SeckillActivityStatus.ON_GOING.getCode().equals(activity.getStatus().getCode())) {
            throw new MallAdminException("\u79d2\u6740\u6d3b\u52a8" + activity.getStatus().getMessage());
        }
        this.checkPurchase(activity, integralOrders);
        searchVO.setGoodsId(integralOrders.getGoodId());
        IntegralGoods integralGoods = this.getGoodsById(searchVO);
        integralOrders.setIntegralGoods(integralGoods);
        this.checkGoodsSku(integralOrders, searchVO);
        this.checkMember(integralOrders, integralGoods);
        this.checkDelivery(integralOrders);
    }

    private void checkOrderParam(IntegralOrders integralOrders) {
        InputValidator.checkEmpty((Object)integralOrders.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)integralOrders.getSysCompanyId(), (String)"\u4f01\u4e1aid");
        InputValidator.checkEmpty((Object)integralOrders.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)integralOrders.getMemberCode(), (String)"\u4f1a\u5458code");
        InputValidator.checkEmpty((Object)integralOrders.getMemberCardNo(), (String)"\u4f1a\u5458\u5361\u53f7");
        InputValidator.checkEmpty((Object)integralOrders.getMemberPhone(), (String)"\u4f1a\u5458\u7535\u8bdd");
        InputValidator.checkEmpty((Object)integralOrders.getGoodId(), (String)"\u5546\u54c1id");
        InputValidator.checkEmpty((Object)integralOrders.getSaleQuantity(), (String)"\u8d2d\u4e70\u6570\u91cf");
        InputValidator.checkEmpty((Object)integralOrders.getGoodSkuNo(), (String)"\u5546\u54c1sku\u7f16\u53f7");
        InputValidator.checkNaturalNumber((Integer)(integralOrders.getSaleQuantity() - 1), (String)"\u8d2d\u4e70\u6570\u91cf");
    }

    private void checkDelivery(IntegralOrders integralOrders) {
        String distributionMode = this.integralOrdersService.getDistributionModeBySkuNo(integralOrders.getGoodSkuNo(), integralOrders.getGoodId());
        if (IntegralOrderTypeEnum.MAIL.getCode().equals(distributionMode)) {
            this.checkEmptyByShipping(integralOrders);
        } else if (IntegralOrderTypeEnum.OPTIONAL.getCode().equals(distributionMode) && IntegralOrderTypeEnum.MAIL.getCode().equals(integralOrders.getOrderType())) {
            this.checkEmptyByShipping(integralOrders);
        }
    }

    private void checkPurchase(SeckillActivitySearchResponseVO activity, IntegralOrders integralOrders) {
        List recordPOList;
        Integer purchaseLimit = activity.getActivityPurchaseLimit();
        Integer countLimit = activity.getActivityCountLimit();
        if ((purchaseLimit != -1 || countLimit != -1) && CollectionUtils.isNotEmpty((Collection)(recordPOList = this.seckillActivityOrderRecordMapper.selectOrderRecordList(activity.getActivityCode(), integralOrders.getMemberCode())))) {
            int orderNumTotal = recordPOList.stream().filter(record -> PayOrderStatusEnum.PAY_SUCCESS.getCode().equals(record.getOrderPayStatus()) || PayOrderStatusEnum.WAIT_PAY.getCode().equals(record.getOrderPayStatus())).mapToInt(SeckillActivityOrderRecordPO::getOrderPieceNum).sum();
            if (purchaseLimit != -1 && orderNumTotal + integralOrders.getSaleQuantity() > purchaseLimit) {
                throw new MallAdminException("\u5df2\u8fbe\u5546\u54c1\u5151\u6362\u4e0a\u9650\uff0c\u65e0\u6cd5\u4e0b\u5355");
            }
            if (countLimit != -1 && recordPOList.size() >= countLimit) {
                throw new MallAdminException("\u5df2\u8fbe\u4eca\u65e5\u79d2\u6740\u6b21\u6570\u4e0a\u9650\uff0c\u65e0\u6cd5\u4e0b\u5355");
            }
        }
    }

    private void checkGoodsSku(IntegralOrders integralOrders, SeckillActivityBaseSearchVO searchVO) {
        IntegralGoodsSku goodsSku = ((List)Optional.ofNullable(integralOrders.getIntegralGoods()).map(IntegralGoods::getSkus).orElse(new ArrayList())).stream().filter(sku -> integralOrders.getGoodSkuNo().equals(sku.getSkuNo())).findFirst().orElse(null);
        if (goodsSku == null) {
            throw new MallAdminException("\u65e0\u6b64\u5546\u54c1\u89c4\u683c");
        }
        if (integralOrders.getSaleQuantity() > goodsSku.getStock()) {
            log.error("\u5f53\u524d\u4e0b\u5355\u6570\u91cf\u5927\u4e8e\u5e93\u5b58\u6570\u91cf");
            throw new MallAdminException("\u5546\u54c1\u5e93\u5b58\u4ec5\u5269" + goodsSku.getStock() + "\u4ef6!");
        }
        integralOrders.setSaleIntegral(Integer.valueOf(goodsSku.getPrice().intValue()));
        integralOrders.setGoodSkuSpecNames(goodsSku.getSpecNames());
        integralOrders.setIntegralGoodsSku(goodsSku);
        searchVO.setSkuId(goodsSku.getId());
    }

    private void buildOrderParam(IntegralOrders integralOrders) {
        if (IntegralOrderTypeEnum.RAISING.getCode().equals(integralOrders.getOrderType()) && StringUtils.isNotBlank((CharSequence)integralOrders.getSelfPickTimeStr())) {
            integralOrders.setSelfPickTime(new Date(Long.parseLong(integralOrders.getSelfPickTimeStr())));
        }
        if ("null".equals(integralOrders.getOrderType())) {
            if (StringUtils.isNotBlank((CharSequence)integralOrders.getShippingAddress())) {
                integralOrders.setOrderType(IntegralOrderTypeEnum.MAIL.getCode());
            } else {
                integralOrders.setOrderType(IntegralOrderTypeEnum.RAISING.getCode());
            }
        }
        if (IntegralOrderTypeEnum.MAIL.getCode().equals(integralOrders.getOrderType())) {
            if ("1".equals(integralOrders.getIsDeliverCheck())) {
                integralOrders.setOrderStatus(IntegralOrdersStatusEnum.AUDITING.getCode());
            } else {
                integralOrders.setOrderStatus(IntegralOrdersStatusEnum.UN_SHIPPED.getCode());
            }
        } else {
            integralOrders.setOrderStatus(IntegralOrdersStatusEnum.UN_SHIPPED.getCode());
        }
        if (!IntegralGoodsPriceTypeEnum.INTEGRAL.getType().equalsIgnoreCase(integralOrders.getIntegralGoods().getPriceType())) {
            integralOrders.setOrderStatus(IntegralOrdersStatusEnum.PAY_AWAIT.getCode());
        }
        if (IntegralOrderTypeEnum.RAISING.getCode().equals(integralOrders.getOrderType())) {
            integralOrders.setOrderStoreName(integralOrders.getStoreName());
        }
        BigDecimal feight = BigDecimal.ZERO;
        if (!IntegralOrderTypeEnum.RAISING.getCode().equals(integralOrders.getOrderType())) {
            feight = this.handleFreigth(this.buildIntegralOrderFreight(integralOrders));
        }
        if (feight.compareTo(BigDecimal.ZERO) > 0) {
            integralOrders.setOrderStatus(IntegralOrdersStatusEnum.PAY_AWAIT.getCode());
        }
        integralOrders.setFreight(feight);
        integralOrders.setGoodsType(IntegralGoodsTypeEnum.GOODS.getCode());
        integralOrders.setOrderTime(new Date());
        integralOrders.setGmtCreate(new Date());
        integralOrders.setOrderNo(IntegralOrderNoUtil.getOrderNo());
    }

    private IntegralOrderFeightVO buildIntegralOrderFreight(IntegralOrders integralOrders) {
        IntegralOrderFeightVO integralOrderFeightVO = new IntegralOrderFeightVO();
        integralOrderFeightVO.setTemplateId(integralOrders.getTemplateId());
        integralOrderFeightVO.setMerchantId(String.valueOf(integralOrders.getMerchantId()));
        integralOrderFeightVO.setGoodsId(String.valueOf(integralOrders.getGoodId()));
        integralOrderFeightVO.setOrderType(integralOrders.getOrderType());
        integralOrderFeightVO.setSaleQuantity(String.valueOf(integralOrders.getSaleQuantity()));
        integralOrderFeightVO.setShippingProvince(integralOrders.getShippingProvince());
        integralOrderFeightVO.setShippingCity(integralOrders.getShippingCity());
        integralOrderFeightVO.setShippingDistrict(integralOrders.getShippingDistrict());
        integralOrderFeightVO.setSkuNo(integralOrders.getGoodSkuNo());
        return integralOrderFeightVO;
    }

    private BigDecimal handleFreigth(IntegralOrderFeightVO integralOrderFeightVO) {
        log.info("\u5f00\u59cb\u5904\u7406\u79ef\u5206\u5546\u54c1\u8fd0\u8d39\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)integralOrderFeightVO));
        BigDecimal freight = BigDecimal.ZERO;
        IntegralGoodsPOWithBLOBs integralGoodsPO = this.integralGoodsPOMapper.selectByPrimaryKey(Integer.valueOf(integralOrderFeightVO.getGoodsId()));
        log.info("handleFreigth_integralGoodsPO:{}", (Object)JSON.toJSONString((Object)integralGoodsPO));
        IntegralGoodsSkuPOExample integralGoodsSkuPOExample = new IntegralGoodsSkuPOExample();
        integralGoodsSkuPOExample.createCriteria().andMerchantIdEqualTo(Integer.valueOf(integralOrderFeightVO.getMerchantId())).andSkuNoEqualTo(integralOrderFeightVO.getSkuNo()).andValidEqualTo(Boolean.TRUE);
        IntegralGoodsSkuPO sku = (IntegralGoodsSkuPO)this.integralGoodsSkuPOMapper.selectByExample(integralGoodsSkuPOExample).get(0);
        if (IntegralGoodsFeightTypeEnum.FREIGHT.getCode().equals(integralGoodsPO.getFreightType())) {
            log.info("\u8be5\u5546\u54c1\u4f7f\u7528\u7edf\u4e00\u8fd0\u8d39\uff01{}", (Object)integralGoodsPO.getDefaultFreight());
            freight = integralGoodsPO.getDefaultFreight();
        } else if (Objects.nonNull(integralOrderFeightVO.getTemplateId()) && IntegralOrderTypeEnum.MAIL.getCode().equals(integralOrderFeightVO.getOrderType())) {
            Integer templateId = Integer.valueOf(integralOrderFeightVO.getTemplateId());
            IntegralExpressTemplatePO integralExpressTemplatePO = this.integralExpressTemplatePOMapper.selectByPrimaryKey(templateId);
            Assert.notNull((Object)integralExpressTemplatePO, (String)"\u60a8\u65e0\u6cd5\u8d2d\u4e70\u8be5\u5546\u54c1\uff0c\u56e0\u4e3a\u5546\u5bb6\u5bf9\u8be5\u5546\u54c1\u7684\u8fd0\u8d39\u6a21\u677f\u8bbe\u7f6e\u6709\u8bef");
            log.info("\u8be5\u5546\u54c1\u8fd0\u8d39\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)integralExpressTemplatePO));
            if (CalcTemplateWay.SELLER.getValue() != integralExpressTemplatePO.getFreight().byteValue() && IntegralGoodsFeightTypeEnum.TEMPLATE.getCode().equals(integralGoodsPO.getFreightType())) {
                log.info("\u8be5\u5546\u54c1\u4f7f\u7528\u8fd0\u8d39\u6a21\u677f!");
                List areaPOList = new ArrayList();
                String province = this.filterRegionName(integralOrderFeightVO.getShippingProvince(), "\u7701");
                String city = this.filterRegionName(integralOrderFeightVO.getShippingCity(), "\u5e02");
                String district = this.filterRegionName(integralOrderFeightVO.getShippingDistrict(), "\u533a");
                InputValidator.checkEmpty((Object)province, (String)"\u7701\u4efd");
                InputValidator.checkEmpty((Object)city, (String)"\u57ce\u5e02");
                InputValidator.checkEmpty((Object)district, (String)"\u5730\u533a");
                log.info("\u7528\u6237\u6536\u8d27\u5730\u5740\u4fe1\u606f:{}\uff0c\u7701:{}\uff0c\u5e02:{}\uff0c\u533a:{}", new Object[]{province, city, district});
                IntegralExpressTemplateAreaPOExample cityPOExample = new IntegralExpressTemplateAreaPOExample();
                cityPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andTemplateIdEqualTo(templateId).andTextLike("%" + city + "%");
                areaPOList = this.integralExpressTemplateAreaPOMapper.selectByExample(cityPOExample);
                if (CollectionUtils.isEmpty(areaPOList)) {
                    IntegralExpressTemplateAreaPOExample cityPO = new IntegralExpressTemplateAreaPOExample();
                    cityPO.createCriteria().andValidEqualTo(Boolean.TRUE).andTemplateIdEqualTo(templateId).andTextLike("%" + province + "%");
                    areaPOList = this.integralExpressTemplateAreaPOMapper.selectByExample(cityPO);
                }
                if (CollectionUtils.isEmpty(areaPOList)) {
                    IntegralExpressTemplateAreaPOExample templateAreaPOExample = new IntegralExpressTemplateAreaPOExample();
                    templateAreaPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andTemplateIdEqualTo(templateId).andTextLike("\u5168\u56fd");
                    areaPOList = this.integralExpressTemplateAreaPOMapper.selectByExample(templateAreaPOExample);
                }
                if (CollectionUtils.isEmpty(areaPOList)) {
                    return freight;
                }
                IntegralExpressTemplateAreaPO integralExpressTemplateAreaPO = (IntegralExpressTemplateAreaPO)areaPOList.get(0);
                log.info("\u8be5\u5546\u54c1\u8fd0\u8d39\u6a21\u677f\u4e0b\u7684\u6240\u6709\u5730\u533a\uff1a{}", (Object)JSON.toJSONString(areaPOList));
                BigDecimal saleQuantity = new BigDecimal(integralOrderFeightVO.getSaleQuantity());
                Byte valuation = integralExpressTemplatePO.getValuation();
                if (CalcTemplateWay.NUMBER_OF_PACKAGES.getValue() == valuation.byteValue()) {
                    log.info("\u4ef6\u6570\u8ba1\u7b97 \u4ef6\u6570:{}", (Object)saleQuantity);
                    freight = this.getFreight(freight, saleQuantity, integralExpressTemplateAreaPO);
                }
                if (CalcTemplateWay.VOLUME.getValue() == valuation.byteValue() && Objects.nonNull(sku.getVolume())) {
                    BigDecimal volume = sku.getVolume().multiply(saleQuantity);
                    log.info("\u6309\u4f53\u79ef\u8ba1\u7b97 \u4f53\u79ef:{}", (Object)volume);
                    freight = this.getFreight(freight, volume, integralExpressTemplateAreaPO);
                }
                if (CalcTemplateWay.WEIGHT.getValue() == valuation.byteValue() && Objects.nonNull(sku.getWeight())) {
                    BigDecimal weight = sku.getWeight().multiply(saleQuantity);
                    log.info("\u6309\u91cd\u91cf\u8ba1\u7b97 \u91cd\u91cf:{}", (Object)weight);
                    freight = this.getFreight(freight, weight, integralExpressTemplateAreaPO);
                }
            }
        }
        return freight;
    }

    private String filterRegionName(String name, String filter) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        int filterId = name.lastIndexOf(filter);
        if (filterId != -1) {
            return name.substring(0, filterId);
        }
        return name;
    }

    private BigDecimal getFreight(BigDecimal freight, BigDecimal numberOfPackage, IntegralExpressTemplateAreaPO integralExpressTemplateAreaPO) {
        log.info("get freight params : {},{},{} ", new Object[]{freight, numberOfPackage, JSONObject.toJSONString((Object)integralExpressTemplateAreaPO)});
        if (numberOfPackage.compareTo(BigDecimal.ZERO) > 0) {
            if (numberOfPackage.subtract(integralExpressTemplateAreaPO.getStart()).compareTo(BigDecimal.ZERO) > 0) {
                freight = freight.add(integralExpressTemplateAreaPO.getPostage());
                freight = freight.add(numberOfPackage.subtract(integralExpressTemplateAreaPO.getStart()).divide(integralExpressTemplateAreaPO.getPlus(), 0, RoundingMode.DOWN).multiply(integralExpressTemplateAreaPO.getPostageplus()));
            } else if (numberOfPackage.subtract(integralExpressTemplateAreaPO.getStart()).compareTo(BigDecimal.ZERO) <= 0) {
                freight = freight.add(integralExpressTemplateAreaPO.getPostage());
            }
        }
        return freight;
    }
}

