/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.jobhandler.integral;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.po.IntegralMerchantOfflineConfigPO;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.ErpOrderApiService;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.IntegralLogisticsService;
import com.wmeimob.fastboot.bizvane.service.config.IntegralMerchantOfflineConfigService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.thirdpartyapi.constants.Constants361;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.ErpOrderInfo361;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.Get361IntegralOrdersFromErpRequestVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.InterfaceResponse361DTO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.InterfaceResponseResult361DTO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.SaleAfterSpecInfo;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.UpdateIntegralOrderLogisticsInfoRequestVO;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@JobHandler(value="IntegralOrderSyncEprLogistics361Job")
public class IntegralOrderSyncEprLogistics361Handler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(IntegralOrderSyncEprLogistics361Handler.class);
    @Autowired
    @Lazy
    private ErpOrderApiService erpOrderApiService;
    @Autowired
    @Lazy
    private IntegralLogisticsService integralLogisticsService;
    @Resource
    private IntegralMerchantOfflineConfigService integralMerchantOfflineConfigService;

    public ReturnT<String> execute(String s) {
        log.info("IntegralOrderSyncEprLogisticsHandler#execute===>:{}", (Object)s);
        XxlJobLogger.log((String)("\u6267\u884c\u53c2\u6570" + s), (Object[])new Object[0]);
        return this.integralOrderSyncEprLogistics361Method(s);
    }

    private ReturnT<String> integralOrderSyncEprLogistics361Method(String params) {
        try {
            String[] merchantIds;
            ReturnT returnT = new ReturnT();
            returnT.setCode(100);
            returnT.setContent((Object)("\u53c2\u6570:" + params));
            if (StringUtils.isEmpty((String)params)) {
                returnT.setMsg("merchantId\u4e3a\u7a7a");
                return returnT;
            }
            for (String merchant : merchantIds = params.split(",")) {
                Integer isSyncLogistics;
                Integer merchantId = Integer.parseInt(merchant);
                IntegralMerchantOfflineConfigPO config = this.integralMerchantOfflineConfigService.getIntegralMerchantOfflineConfig(merchantId);
                if (config == null || !Constants361.IS_SYNC_LOGISTICS.equals(isSyncLogistics = config.getIsSyncLogistics())) continue;
                List unSendIntegralOrdersList = this.integralLogisticsService.getUnSendIntegralOrdersList(merchantId);
                log.info(merchantId + "\u672a\u53d1\u8d27\u8ba2\u5355\u6570\u91cf" + unSendIntegralOrdersList.size());
                if (CollectionUtils.isEmpty((Collection)unSendIntegralOrdersList)) continue;
                for (IntegralOrdersPO unSendOrder : unSendIntegralOrdersList) {
                    String resultData;
                    List erpOrderInfo361s;
                    Get361IntegralOrdersFromErpRequestVO request = new Get361IntegralOrdersFromErpRequestVO();
                    request.setMerchantId(merchantId);
                    request.setOrderNo(unSendOrder.getOrderNo());
                    request.setOrderStatus("6");
                    ResponseData integralOrdersFromErp = this.erpOrderApiService.get361IntegralOrdersFromErp(request);
                    int code = integralOrdersFromErp.getCode();
                    if (0 != code) continue;
                    XxlJobLogger.log((String)"\u5f00\u59cb\u6301\u4e45\u5316", (Object[])new Object[0]);
                    InterfaceResponse361DTO data = (InterfaceResponse361DTO)integralOrdersFromErp.getData();
                    InterfaceResponseResult361DTO result = data.getResult();
                    if (!Constants361.INTERFACE_SUCCESS.equals(result.getCode()) || CollectionUtils.isEmpty((Collection)(erpOrderInfo361s = JSONObject.parseArray((String)(resultData = result.getResult()), ErpOrderInfo361.class)))) continue;
                    for (ErpOrderInfo361 erpOrder : erpOrderInfo361s) {
                        UpdateIntegralOrderLogisticsInfoRequestVO requestVo = null;
                        try {
                            requestVo = this.convertUpdateIntegralOrderLogisticsInfo(merchantId, erpOrder);
                        }
                        catch (Exception e) {
                            log.warn("\u7ec4\u88c5361\u7269\u6d41\u66f4\u65b0\u53c2\u6570\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                            continue;
                        }
                        ResponseData booleanResponseData = this.integralLogisticsService.updateIntegralOrderLogisticsInfo(requestVo);
                        if (!((Boolean)booleanResponseData.getData()).booleanValue()) {
                            log.info("361\u6709\u7269\u6d41\u8df3\u8fc7\uff1a" + erpOrder.getOrderNo() + booleanResponseData.getMessage());
                            continue;
                        }
                        log.info(erpOrder.getOrderNo() + "\u540c\u6b65\u7269\u6d41\u6210\u529f");
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn("IntegralOrderSyncEprLogistics361Handler#integralOrderSyncEprLogistics361Method\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
        }
        return ReturnT.SUCCESS;
    }

    private UpdateIntegralOrderLogisticsInfoRequestVO convertUpdateIntegralOrderLogisticsInfo(Integer merchantId, ErpOrderInfo361 erpOrder) {
        log.info("IntegralOrderSyncEprLogistics361Handler#convertUpdateIntegralOrderLogisticsInfo:{},{}", (Object)merchantId, (Object)JSON.toJSONString((Object)erpOrder));
        UpdateIntegralOrderLogisticsInfoRequestVO params = new UpdateIntegralOrderLogisticsInfoRequestVO();
        params.setMerchantId(merchantId);
        params.setOrderNo(erpOrder.getOrderNo());
        params.setCourierCompanyName(erpOrder.getExp_Name());
        List saleAfterSpec = erpOrder.getSaleAfterSpec();
        if (!CollectionUtils.isEmpty((Collection)saleAfterSpec)) {
            SaleAfterSpecInfo saleAfterSpecInfo = (SaleAfterSpecInfo)saleAfterSpec.get(0);
            String expNum = saleAfterSpecInfo.getExpNum();
            params.setCourierNo(expNum);
        }
        params.setSendGoodTime(DateUtil.parse((String)erpOrder.getExpTime(), (String)DateUtil.ymdhms));
        params.setShippingName(erpOrder.getC_Name());
        params.setShippingMobile(erpOrder.getMobiTel());
        String address = erpOrder.getAddress();
        if (!StringUtils.isEmpty((String)address)) {
            try {
                String[] s = address.split(" ");
                params.setShippingProvince(s[0]);
                params.setShippingCity(s[1]);
                params.setShippingDistrict(s[2]);
                params.setShippingAddress(address);
            }
            catch (Exception e) {
                log.warn("361\u5730\u5740\u89e3\u6790\u5f02\u5e38\uff0c\u4fdd\u6301\u539f\u6709\u5730\u5740:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            }
        }
        params.setUserComments(StringUtils.isEmpty((String)erpOrder.getC_Remark()) ? "\u65e0" : erpOrder.getC_Remark());
        return params;
    }
}

