/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.api.integaralstore.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralCourierCompanyPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralCourierCompanyPO;
import com.wmeimob.fastboot.bizvane.po.IntegralCourierCompanyPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPOExample;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.IntegralLogisticsService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.UpdateIntegralOrderLogisticsInfoRequestVO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class IntegralLogisticsServiceImpl
implements IntegralLogisticsService {
    private static final Logger log = LoggerFactory.getLogger(IntegralLogisticsServiceImpl.class);
    @Resource
    private IntegralCourierCompanyPOMapper integralCourierCompanyPoMapper;
    @Resource
    private IntegralOrdersPOMapper integralOrdersPoMapper;

    public ResponseData<Boolean> updateIntegralOrderLogisticsInfo(UpdateIntegralOrderLogisticsInfoRequestVO updateIntegralOrderLogisticsInfoRequestVo) {
        log.info("IntegralLogisticsServiceImpl#updateIntegralOrderLogisticsInfo:{}", (Object)JSON.toJSONString((Object)updateIntegralOrderLogisticsInfoRequestVo));
        ResponseData responseData = new ResponseData();
        responseData.setCode(100);
        responseData.setData((Object)Boolean.FALSE);
        try {
            String shippingAddress;
            String shippingDistrict;
            String shippingCity;
            String shippingProvince;
            ResponseData checkNullResult = this.checkParamsIsNull(updateIntegralOrderLogisticsInfoRequestVo);
            if (!((Boolean)checkNullResult.getData()).booleanValue()) {
                responseData.setMessage(checkNullResult.getMessage());
                return responseData;
            }
            Integer merchantId = updateIntegralOrderLogisticsInfoRequestVo.getMerchantId();
            String orderNo = updateIntegralOrderLogisticsInfoRequestVo.getOrderNo();
            IntegralOrdersPOExample integralOrdersPoExample = new IntegralOrdersPOExample();
            integralOrdersPoExample.createCriteria().andMerchantIdEqualTo(merchantId).andOrderNoEqualTo(orderNo);
            List integralOrdersPoList = this.integralOrdersPoMapper.selectByExample(integralOrdersPoExample);
            if (CollectionUtils.isEmpty((Collection)integralOrdersPoList)) {
                responseData.setMessage("\u8ba2\u5355\u4e0d\u5b58\u5728");
                return responseData;
            }
            IntegralOrdersPO integralOrdersPo = (IntegralOrdersPO)integralOrdersPoList.get(0);
            if (!integralOrdersPo.getOrderStatus().equals(IntegralOrdersStatusEnum.UN_SHIPPED.getCode())) {
                if (integralOrdersPo.getOrderStatus().equals(IntegralOrdersStatusEnum.SHIPPED.getCode())) {
                    responseData.setMessage("\u8be5\u8ba2\u5355\u5df2\u7ecf\u53d1\u8d27");
                } else {
                    responseData.setMessage("\u8be5\u8ba2\u5355\u4e0d\u7b26\u5408\u53d1\u8d27\u72b6\u6001");
                }
                return responseData;
            }
            IntegralOrdersPO updateOrders = new IntegralOrdersPO();
            updateOrders.setId(integralOrdersPo.getId());
            String courierCompanyCode = updateIntegralOrderLogisticsInfoRequestVo.getCourierCompanyCode();
            if (StringUtils.isEmpty((Object)courierCompanyCode)) {
                log.info("\u5feb\u9012\u516c\u53f8\u7f16\u53f7:{}", (Object)courierCompanyCode);
                String companyCode = this.getCourierCompanyCodeByCourierCompanyName(updateIntegralOrderLogisticsInfoRequestVo.getCourierCompanyName());
                if (!StringUtils.isEmpty((Object)companyCode)) {
                    updateOrders.setCourierCompanyCode(companyCode);
                }
            } else {
                updateOrders.setCourierCompanyCode(updateIntegralOrderLogisticsInfoRequestVo.getCourierCompanyCode());
            }
            updateOrders.setCourierCompanyName(updateIntegralOrderLogisticsInfoRequestVo.getCourierCompanyName());
            updateOrders.setCourierNo(updateIntegralOrderLogisticsInfoRequestVo.getCourierNo());
            updateOrders.setSendGoodTime(updateIntegralOrderLogisticsInfoRequestVo.getSendGoodTime());
            if (!updateIntegralOrderLogisticsInfoRequestVo.getShippingName().equals(integralOrdersPo.getShippingName())) {
                updateOrders.setShippingName(updateIntegralOrderLogisticsInfoRequestVo.getShippingName());
            }
            if (!updateIntegralOrderLogisticsInfoRequestVo.getShippingMobile().equals(integralOrdersPo.getShippingMobile())) {
                updateOrders.setShippingMobile(updateIntegralOrderLogisticsInfoRequestVo.getShippingMobile());
            }
            if (!StringUtils.isEmpty((Object)(shippingProvince = updateIntegralOrderLogisticsInfoRequestVo.getShippingProvince())) && !shippingProvince.equals(integralOrdersPo.getShippingProvince())) {
                updateOrders.setShippingProvince(updateIntegralOrderLogisticsInfoRequestVo.getShippingProvince());
            }
            if (!StringUtils.isEmpty((Object)(shippingCity = updateIntegralOrderLogisticsInfoRequestVo.getShippingCity())) && !shippingCity.equals(integralOrdersPo.getShippingCity())) {
                updateOrders.setShippingCity(updateIntegralOrderLogisticsInfoRequestVo.getShippingCity());
            }
            if (!StringUtils.isEmpty((Object)(shippingDistrict = updateIntegralOrderLogisticsInfoRequestVo.getShippingDistrict())) && !shippingDistrict.equals(integralOrdersPo.getShippingDistrict())) {
                updateOrders.setShippingDistrict(updateIntegralOrderLogisticsInfoRequestVo.getShippingDistrict());
            }
            if (!StringUtils.isEmpty((Object)(shippingAddress = updateIntegralOrderLogisticsInfoRequestVo.getShippingAddress())) && !shippingAddress.equals(integralOrdersPo.getShippingAddress())) {
                updateOrders.setShippingAddress(updateIntegralOrderLogisticsInfoRequestVo.getShippingAddress());
            }
            if (!StringUtils.isEmpty((Object)updateIntegralOrderLogisticsInfoRequestVo.getUserComments()) && !updateIntegralOrderLogisticsInfoRequestVo.getUserComments().equals(integralOrdersPo.getUserComments())) {
                updateOrders.setUserComments(StringUtils.isEmpty((Object)updateIntegralOrderLogisticsInfoRequestVo.getUserComments()) ? integralOrdersPo.getUserComments() : updateIntegralOrderLogisticsInfoRequestVo.getUserComments());
            }
            updateOrders.setOrderStatus(IntegralOrdersStatusEnum.SHIPPED.getCode());
            updateOrders.setGmtModified(new Date());
            int i = this.integralOrdersPoMapper.updateByPrimaryKeySelective(updateOrders);
            log.info("\u540c\u6b65\u5165\u5e93\u7684\u6570\u636e:{}", (Object)JSON.toJSONString((Object)updateOrders));
            if (i > 0) {
                responseData.setMessage(integralOrdersPo.getOrderNo() + "\u7269\u6d41\u540c\u6b65\u6210\u529f");
                responseData.setCode(0);
                responseData.setData((Object)Boolean.TRUE);
                return responseData;
            }
            responseData.setMessage("\u66f4\u65b0\u6570\u636e\u5e93\u8bb0\u5f55\u6570 < 0,\u66f4\u65b0\u5931\u8d25");
            log.info("updateIntegralOrderLogisticsInfo\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)responseData));
            return responseData;
        }
        catch (Exception e) {
            log.warn("IntegralLogisticsServiceImpl#updateIntegralOrderLogisticsInfo\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    public String getCourierCompanyCodeByCourierCompanyName(String courierCompanyName) {
        IntegralCourierCompanyPOExample companyPoExample = new IntegralCourierCompanyPOExample();
        companyPoExample.createCriteria().andValidEqualTo(Boolean.TRUE).andNameEqualTo(courierCompanyName);
        List integralCourierCompanyList = this.integralCourierCompanyPoMapper.selectByExample(companyPoExample);
        if (!CollectionUtils.isEmpty((Collection)integralCourierCompanyList)) {
            return ((IntegralCourierCompanyPO)integralCourierCompanyList.get(0)).getCode();
        }
        return null;
    }

    public List<IntegralOrdersPO> getUnSendIntegralOrdersList(Integer merchantId) {
        IntegralOrdersPOExample example = new IntegralOrdersPOExample();
        example.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andOrderStatusEqualTo("0");
        return this.integralOrdersPoMapper.selectByExample(example);
    }

    private ResponseData<Boolean> checkParamsIsNull(UpdateIntegralOrderLogisticsInfoRequestVO updateIntegralOrderLogisticsInfoRequestVo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(100);
        responseData.setData((Object)Boolean.FALSE);
        Integer merchantId = updateIntegralOrderLogisticsInfoRequestVo.getMerchantId();
        if (StringUtils.isEmpty((Object)merchantId)) {
            responseData.setMessage("merchantId \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String orderNo = updateIntegralOrderLogisticsInfoRequestVo.getOrderNo();
        if (StringUtils.isEmpty((Object)orderNo)) {
            responseData.setMessage("orderNo \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String courierCompanyName = updateIntegralOrderLogisticsInfoRequestVo.getCourierCompanyName();
        if (StringUtils.isEmpty((Object)courierCompanyName)) {
            responseData.setMessage("courierCompanyName \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String courierNo = updateIntegralOrderLogisticsInfoRequestVo.getCourierNo();
        if (StringUtils.isEmpty((Object)courierNo)) {
            responseData.setMessage("courierNo \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        Date sendGoodTime = updateIntegralOrderLogisticsInfoRequestVo.getSendGoodTime();
        if (StringUtils.isEmpty((Object)sendGoodTime)) {
            responseData.setMessage("sendGoodTime \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String shippingName = updateIntegralOrderLogisticsInfoRequestVo.getShippingName();
        if (StringUtils.isEmpty((Object)shippingName)) {
            responseData.setMessage("shippingName \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String shippingMobile = updateIntegralOrderLogisticsInfoRequestVo.getShippingMobile();
        if (StringUtils.isEmpty((Object)shippingMobile)) {
            responseData.setMessage("shippingMobile \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String shippingProvince = updateIntegralOrderLogisticsInfoRequestVo.getShippingProvince();
        if (StringUtils.isEmpty((Object)shippingProvince)) {
            responseData.setMessage("shippingProvince \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String shippingCity = updateIntegralOrderLogisticsInfoRequestVo.getShippingCity();
        if (StringUtils.isEmpty((Object)shippingCity)) {
            responseData.setMessage("shippingCity \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String shippingDistrict = updateIntegralOrderLogisticsInfoRequestVo.getShippingDistrict();
        if (StringUtils.isEmpty((Object)shippingDistrict)) {
            responseData.setMessage("shippingDistrict \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String shippingAddress = updateIntegralOrderLogisticsInfoRequestVo.getShippingAddress();
        if (StringUtils.isEmpty((Object)shippingAddress)) {
            responseData.setMessage("shippingAddress \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        responseData.setData((Object)Boolean.TRUE);
        responseData.setCode(0);
        return responseData;
    }
}

