/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.api.integaralstore.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralOrderAuditStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralOrderStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralCourierCompanyPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralCourierCompanyPO;
import com.wmeimob.fastboot.bizvane.po.IntegralCourierCompanyPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPOExample;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.ApiIntegralOrderService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.api.IntegralSetLogisticsInfoRequestVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ApiIntegralOrderServiceImpl
implements ApiIntegralOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApiIntegralOrderServiceImpl.class);
    @Resource
    private IntegralOrdersPOMapper integralOrdersPOMapper;
    @Resource
    private IntegralCourierCompanyPOMapper integralCourierCompanyPOMapper;

    public ResponseData<Boolean> integralOrderSetLogisticsInfo(IntegralSetLogisticsInfoRequestVO integralSetLogisticsInfoRequestVo) {
        log.info("ApiIntegralOrderServiceImpl#integralOrderSetLogisticsInfo:{}", (Object)JSON.toJSONString((Object)integralSetLogisticsInfoRequestVo));
        ResponseData responseData = ResponseUtil.getBoolean((Boolean)false);
        try {
            int updateResult;
            String userComments;
            String shippingAddress;
            String shippingDistrict;
            String shippingCity;
            String shippingProvince;
            String shippingMobile;
            ResponseData checkResult = this.checkParameters(integralSetLogisticsInfoRequestVo);
            if (!((Boolean)checkResult.getData()).booleanValue()) {
                responseData.setMessage(checkResult.getMessage());
                return responseData;
            }
            IntegralCourierCompanyPOExample integralCourierCompanyPOExample = new IntegralCourierCompanyPOExample();
            integralCourierCompanyPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andNameEqualTo(integralSetLogisticsInfoRequestVo.getCourierCompanyName());
            List integralCourierCompanyPOS = this.integralCourierCompanyPOMapper.selectByExample(integralCourierCompanyPOExample);
            if (CollectionUtils.isEmpty((Collection)integralCourierCompanyPOS)) {
                responseData.setMessage("The courierCompanyName is not supported!");
                return responseData;
            }
            IntegralCourierCompanyPO integralCourierCompanyPO = (IntegralCourierCompanyPO)integralCourierCompanyPOS.get(0);
            IntegralOrdersPOExample getExample = new IntegralOrdersPOExample();
            getExample.createCriteria().andMerchantIdEqualTo(integralSetLogisticsInfoRequestVo.getMerchantId()).andOrderNoEqualTo(integralSetLogisticsInfoRequestVo.getOrderNo());
            List integralOrdersList = this.integralOrdersPOMapper.selectByExample(getExample);
            if (CollectionUtils.isEmpty((Collection)integralOrdersList)) {
                responseData.setMessage("\u8ba2\u5355[" + integralSetLogisticsInfoRequestVo.getOrderNo() + "]\u4e0d\u5b58\u5728\uff01");
                return responseData;
            }
            IntegralOrdersPO ordersPo = (IntegralOrdersPO)integralOrdersList.get(0);
            if (Boolean.FALSE.equals(ordersPo.getValid())) {
                responseData.setMessage("\u8ba2\u5355[" + integralSetLogisticsInfoRequestVo.getOrderNo() + "]\u4e3a\u65e0\u6548\u8ba2\u5355\uff01");
                return responseData;
            }
            String orderStatus = ordersPo.getOrderStatus();
            ArrayList<String> passStatus = new ArrayList<String>();
            passStatus.add(IntegralOrderStatusEnum.ORDER_UN_AUDIT.getCode());
            passStatus.add(IntegralOrderStatusEnum.ORDER_UN_SEND.getCode());
            passStatus.add(IntegralOrderStatusEnum.ORDER_YET_SEND.getCode());
            if (!passStatus.contains(orderStatus)) {
                responseData.setMessage("\u8ba2\u5355[" + integralSetLogisticsInfoRequestVo.getOrderNo() + "]\u4e0d\u5728\u53ef\u4ee5\u66f4\u6539\u7684\u72b6\u6001\u8303\u56f4\u5185\uff01");
                return responseData;
            }
            IntegralOrdersPOExample updateExample = new IntegralOrdersPOExample();
            updateExample.createCriteria().andMerchantIdEqualTo(integralSetLogisticsInfoRequestVo.getMerchantId()).andOrderNoEqualTo(integralSetLogisticsInfoRequestVo.getOrderNo()).andValidEqualTo(Boolean.TRUE);
            IntegralOrdersPO updateIntegralOrdersPo = new IntegralOrdersPO();
            updateIntegralOrdersPo.setCourierCompanyName(integralSetLogisticsInfoRequestVo.getCourierCompanyName());
            updateIntegralOrdersPo.setCourierNo(integralSetLogisticsInfoRequestVo.getCourierNo());
            updateIntegralOrdersPo.setSendGoodTime(new Date());
            updateIntegralOrdersPo.setGmtModified(new Date());
            updateIntegralOrdersPo.setOrderStatus(IntegralOrderStatusEnum.ORDER_YET_SEND.getCode());
            String isDeliverCheck = ordersPo.getIsDeliverCheck();
            if (IntegralOrderAuditStatusEnum.NECESSARY_AUDIT.getCode().equals(isDeliverCheck)) {
                updateIntegralOrdersPo.setIsDeliverCheck(IntegralOrderAuditStatusEnum.UNNECESSARY_AUDIT.getCode());
            }
            updateIntegralOrdersPo.setCourierCompanyCode(integralCourierCompanyPO.getCode());
            String shippingName = integralSetLogisticsInfoRequestVo.getShippingName();
            if (!StringUtils.isEmpty((Object)shippingName)) {
                updateIntegralOrdersPo.setShippingName(shippingName);
            }
            if (!StringUtils.isEmpty((Object)(shippingMobile = integralSetLogisticsInfoRequestVo.getShippingMobile()))) {
                updateIntegralOrdersPo.setShippingMobile(shippingMobile);
            }
            if (!StringUtils.isEmpty((Object)(shippingProvince = integralSetLogisticsInfoRequestVo.getShippingProvince()))) {
                updateIntegralOrdersPo.setShippingProvince(shippingProvince);
            }
            if (!StringUtils.isEmpty((Object)(shippingCity = integralSetLogisticsInfoRequestVo.getShippingCity()))) {
                updateIntegralOrdersPo.setShippingCity(shippingCity);
            }
            if (!StringUtils.isEmpty((Object)(shippingDistrict = integralSetLogisticsInfoRequestVo.getShippingDistrict()))) {
                updateIntegralOrdersPo.setShippingDistrict(shippingDistrict);
            }
            if (!StringUtils.isEmpty((Object)(shippingAddress = integralSetLogisticsInfoRequestVo.getShippingAddress()))) {
                updateIntegralOrdersPo.setShippingAddress(shippingAddress);
            }
            if (!StringUtils.isEmpty((Object)(userComments = integralSetLogisticsInfoRequestVo.getUserComments()))) {
                updateIntegralOrdersPo.setUserComments(userComments);
            }
            if ((updateResult = this.integralOrdersPOMapper.updateByExampleSelective(updateIntegralOrdersPo, updateExample)) > 0) {
                responseData.setCode(0);
                responseData.setMessage("\u8ba2\u5355[" + integralSetLogisticsInfoRequestVo.getOrderNo() + "]\u7269\u6d41\u66f4\u65b0\u6210\u529f\uff01");
                responseData.setData((Object)true);
            } else {
                responseData.setMessage("\u8ba2\u5355[" + integralSetLogisticsInfoRequestVo.getOrderNo() + "]\u7269\u6d41\u66f4\u65b0\u5931\u8d25");
            }
            return responseData;
        }
        catch (Exception e) {
            log.warn("ApiIntegralOrderServiceImpl#integralOrderSetLogisticsInfo\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }

    private ResponseData<Boolean> checkParameters(IntegralSetLogisticsInfoRequestVO integralSetLogisticsInfoRequestVo) {
        String shippingAddress;
        String shippingDistrict;
        String shippingCity;
        String shippingProvince;
        String shippingName;
        ResponseData responseData = ResponseUtil.getBoolean((Boolean)false);
        Integer merchantId = integralSetLogisticsInfoRequestVo.getMerchantId();
        if (StringUtils.isEmpty((Object)merchantId)) {
            responseData.setMessage("The merchantId must not be empty!");
            return responseData;
        }
        String orderNo = integralSetLogisticsInfoRequestVo.getOrderNo();
        if (StringUtils.isEmpty((Object)orderNo)) {
            responseData.setMessage("The orderNo must not be empty!");
            return responseData;
        }
        String courierNo = integralSetLogisticsInfoRequestVo.getCourierNo();
        if (StringUtils.isEmpty((Object)courierNo)) {
            responseData.setMessage("The courierNo must not be empty!");
            return responseData;
        }
        String courierCompanyName = integralSetLogisticsInfoRequestVo.getCourierCompanyName();
        if (StringUtils.isEmpty((Object)courierCompanyName)) {
            responseData.setMessage("The courierCompanyName must not be empty!");
            return responseData;
        }
        String shippingMobile = integralSetLogisticsInfoRequestVo.getShippingMobile();
        if (StringUtils.isEmpty((Object)shippingMobile)) {
            responseData.setMessage("The shippingMobile must not be empty!");
        }
        if (StringUtils.isEmpty((Object)(shippingName = integralSetLogisticsInfoRequestVo.getShippingName()))) {
            responseData.setMessage("The shippingName must not be empty!");
        }
        if (StringUtils.isEmpty((Object)(shippingProvince = integralSetLogisticsInfoRequestVo.getShippingProvince()))) {
            responseData.setMessage("The shippingProvince must not be empty!");
        }
        if (StringUtils.isEmpty((Object)(shippingCity = integralSetLogisticsInfoRequestVo.getShippingCity()))) {
            responseData.setMessage("The shippingCity must not be empty!");
        }
        if (StringUtils.isEmpty((Object)(shippingDistrict = integralSetLogisticsInfoRequestVo.getShippingDistrict()))) {
            responseData.setMessage("The shippingDistrict must not be empty!");
        }
        if (StringUtils.isEmpty((Object)(shippingAddress = integralSetLogisticsInfoRequestVo.getShippingAddress()))) {
            responseData.setMessage("The shippingAddress must not be empty!");
        }
        responseData.setData((Object)Boolean.TRUE);
        return responseData;
    }
}

