/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.AssembleNewMember;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.enums.MarketActivityEnum;
import com.wmeimob.fastboot.bizvane.enums.activity.ActivityDiscountJobStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.AssembleNewMemberMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.utils.jobutils.XxlJobUtil;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class MarketActivityService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityService.class);
    @Autowired
    private MarketActivityMapper marketActivityMapper;
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private AssembleNewMemberMapper assembleNewMemberMapper;
    @Autowired
    private MarketActivityOrdersMapper marketActivityOrdersMapper;
    @Autowired
    private OrdersMapper ordersMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private XxlJobUtil xxlJobUtil;
    @Value(value="${spring.application.name}")
    private String appName;

    public RestResult saveActivity(MarketActivity marketActivity) {
        try {
            MarketActivity temp;
            if (marketActivity.getId() != null && (temp = (MarketActivity)this.marketActivityMapper.selectByPrimaryKey((Object)marketActivity.getId())).getActivityEndTime().before(new Date())) {
                throw new MallAdminException("\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\uff0c\u4e0d\u80fd\u7f16\u8f91\u8be5\u6d3b\u52a8");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String timeStr = sdf.format(new Date());
            if (marketActivity.getId() == null) {
                List goods;
                log.info("\u8425\u9500\u6d3b\u52a8\u65b0\u589e");
                int random = (int)((Math.random() * 9.0 + 1.0) * 1000.0);
                StringBuffer sb = new StringBuffer();
                Example example = new Example(MarketActivity.class);
                example.createCriteria().andEqualTo("merchantId", (Object)marketActivity.getMerchantId()).andEqualTo("activityType", (Object)marketActivity.getActivityType()).andEqualTo("activityName", (Object)marketActivity.getActivityName());
                List marketActivities = this.marketActivityMapper.selectByExample((Object)example);
                if (marketActivities.size() > 0) {
                    throw new MallAdminException("\u6d3b\u52a8\u540d\u79f0\u5df2\u5b58\u5728");
                }
                if (MarketActivityEnum.KJHD.getType().toString().equals(marketActivity.getActivityType())) {
                    sb.append(MarketActivityEnum.KJHD.getCode()).append(timeStr).append(random);
                    goods = this.getGoods(marketActivity.getMerchantId(), null, marketActivity.getActivityType());
                    goods.forEach(marketActivityGoods -> marketActivity.getMarketActivityGoods().forEach(marketActivityGoods1 -> {
                        if (marketActivityGoods1.getGoodsNo().equals(marketActivityGoods.getGoodsNo())) {
                            throw new MallAdminException("\u6b64sku\u5546\u54c1\u53c2\u52a0\u7684\u5176\u4ed6\u780d\u4ef7\u6d3b\u52a8\u6b63\u5728\u8fdb\u884c\uff01");
                        }
                    }));
                }
                if (MarketActivityEnum.PTHD.getType().toString().equals(marketActivity.getActivityType())) {
                    sb.append(MarketActivityEnum.PTHD.getCode()).append(timeStr).append(random);
                    goods = this.getGoods(marketActivity.getMerchantId(), null, marketActivity.getActivityType());
                    goods.forEach(marketActivityGoods -> marketActivity.getMarketActivityGoods().forEach(marketActivityGoods1 -> {
                        if (marketActivityGoods1.getGoodsNo().equals(marketActivityGoods.getGoodsNo())) {
                            throw new MallAdminException("\u6b64sku\u5546\u54c1\u53c2\u52a0\u7684\u5176\u4ed6\u780d\u4ef7\u6d3b\u52a8\u6b63\u5728\u8fdb\u884c\uff01");
                        }
                    }));
                }
                marketActivity.setActivityNo(sb.toString());
                marketActivity.setGmtCreate(new Date());
                this.marketActivityMapper.insertSelective((Object)marketActivity);
                this.createDiscountActivityJod(marketActivity.getActivityEndTime(), marketActivity, ActivityDiscountJobStatusEnum.ACTIVITY_DISCOUNT_ENDED_JOB);
                marketActivity.getMarketActivityGoods().forEach(marketActivityGoods -> {
                    marketActivityGoods.setMarketActivityNo(sb.toString());
                    this.marketActivityGoodsMapper.insertSelective(marketActivityGoods);
                });
            } else {
                List goods;
                log.info("\u8425\u9500\u6d3b\u52a8\u7f16\u8f91");
                Example example = new Example(MarketActivity.class);
                example.createCriteria().andEqualTo("merchantId", (Object)marketActivity.getMerchantId()).andEqualTo("activityType", (Object)marketActivity.getActivityType()).andEqualTo("activityName", (Object)marketActivity.getActivityName()).andNotEqualTo("id", (Object)marketActivity.getId());
                List marketActivities = this.marketActivityMapper.selectByExample((Object)example);
                if (marketActivities.size() > 0) {
                    throw new MallAdminException("\u6d3b\u52a8\u540d\u79f0\u5df2\u5b58\u5728");
                }
                if (marketActivity.getActivityType() == null) {
                    if (marketActivity.getActivityNo() == null) {
                        throw new MallAdminException("\u4fee\u6539\u6d3b\u52a8\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (marketActivity.getActivityNo().startsWith(MarketActivityEnum.KJHD.getCode())) {
                        marketActivity.setActivityType(MarketActivityEnum.KJHD.getType().toString());
                    } else if (marketActivity.getActivityNo().startsWith(MarketActivityEnum.PTHD.getCode())) {
                        marketActivity.setActivityType(MarketActivityEnum.PTHD.getType().toString());
                    } else {
                        throw new MallAdminException("\u672a\u77e5\u7684\u6d3b\u52a8\u7f16\u53f7\u7c7b\u578b");
                    }
                }
                if (MarketActivityEnum.KJHD.getType().toString().equals(marketActivity.getActivityType())) {
                    goods = this.getGoods(marketActivity.getMerchantId(), marketActivity.getId(), marketActivity.getActivityType());
                    goods.forEach(marketActivityGoods -> marketActivity.getMarketActivityGoods().forEach(marketActivityGoods1 -> {
                        if (marketActivityGoods1.getGoodsNo().equals(marketActivityGoods.getGoodsNo()) && marketActivity.getActivityStatus().equals(Boolean.TRUE)) {
                            throw new MallAdminException("\u6b64sku\u5546\u54c1\u53c2\u52a0\u7684\u5176\u4ed6\u780d\u4ef7\u6d3b\u52a8\u6b63\u5728\u8fdb\u884c\uff01");
                        }
                    }));
                }
                if (MarketActivityEnum.PTHD.getType().toString().equals(marketActivity.getActivityType())) {
                    goods = this.getGoods(marketActivity.getMerchantId(), marketActivity.getId(), marketActivity.getActivityType());
                    goods.forEach(marketActivityGoods -> marketActivity.getMarketActivityGoods().forEach(marketActivityGoods1 -> {
                        Example goodsExa = new Example(Goods.class);
                        goodsExa.createCriteria().andEqualTo("merchantId", (Object)marketActivity.getMerchantId()).andEqualTo("goodsNo", (Object)marketActivityGoods1.getGoodsNo()).andEqualTo("isDel", (Object)Boolean.FALSE);
                        Goods goods1 = (Goods)this.goodsMapper.selectOneByExample((Object)goodsExa);
                        if (goods1.getSalePrice().compareTo(BigDecimal.ZERO) == 0) {
                            throw new MallAdminException("\u5546\u54c1\u7f16\u53f7\u4e3a:[" + marketActivityGoods1.getGoodsNo() + "]\u7684\u5546\u54c1\u672a\u8bbe\u7f6e\u552e\u4ef7\u4fe1\u606f\uff0c\u8bf7\u5230\u5546\u54c1\u7ba1\u7406\u8fdb\u884c\u8bbe\u7f6e\u3002");
                        }
                        if (marketActivityGoods1.getGoodsNo().equals(marketActivityGoods.getGoodsNo()) && marketActivity.getActivityStatus().equals(Boolean.TRUE)) {
                            throw new MallAdminException("\u6b64sku\u5546\u54c1\u53c2\u52a0\u7684\u5176\u4ed6\u780d\u4ef7\u6d3b\u52a8\u6b63\u5728\u8fdb\u884c\uff01");
                        }
                    }));
                }
                this.marketActivityMapper.updateByPrimaryKeySelective((Object)marketActivity);
                this.createDiscountActivityJod(marketActivity.getActivityEndTime(), marketActivity, ActivityDiscountJobStatusEnum.ACTIVITY_DISCOUNT_ENDED_JOB);
                marketActivity.getMarketActivityGoods().forEach(marketActivityGoods -> this.marketActivityGoodsMapper.updateByPrimaryKeySelective(marketActivityGoods));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return RestResult.fail((String)e.getMessage());
        }
        return RestResult.success();
    }

    private void createDiscountActivityJod(Date jobTime, MarketActivity marketActivity, ActivityDiscountJobStatusEnum activityDiscountJobStatusEnum) {
        log.info("createDiscountActivityJod :{}", (Object)JSON.toJSONString((Object)marketActivity));
        String id = String.valueOf(marketActivity.getId() == null ? "" : marketActivity.getId());
        String jobHandler = activityDiscountJobStatusEnum.getJobHandler();
        String jobDesc = activityDiscountJobStatusEnum.getPrefix() + id + activityDiscountJobStatusEnum.getLastNameCn();
        String author = activityDiscountJobStatusEnum.getAuthor();
        String param = id;
        String appName = this.appName;
        int businessType = ActivitySanEnum.DISCOUNT.getCode();
        String bizCode = id + activityDiscountJobStatusEnum.getLastName();
        this.xxlJobUtil.removeByBiz(businessType, bizCode);
        this.xxlJobUtil.addJob(jobTime, jobDesc, param, author, jobHandler, businessType, bizCode, appName);
    }

    public List<MarketActivity> getAllList(MarketActivity marketActivity) {
        Example example = new Example(MarketActivity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("merchantId", (Object)marketActivity.getMerchantId()).andEqualTo("activityType", (Object)marketActivity.getActivityType());
        if (!StringUtils.isEmpty((Object)marketActivity.getActivityName())) {
            criteria.andLike("activityName", "%" + marketActivity.getActivityName() + "%");
        }
        if (!StringUtils.isEmpty((Object)marketActivity.getActivityNo())) {
            criteria.andLike("activityNo", "%" + marketActivity.getActivityNo() + "%");
        }
        if (!StringUtils.isEmpty((Object)marketActivity.getActivityStatus())) {
            criteria.andEqualTo("activityStatus", (Object)marketActivity.getActivityStatus());
        }
        example.setOrderByClause("activity_end_time desc");
        List list = this.marketActivityMapper.selectByExample((Object)example);
        Date today = new Date();
        list.forEach(marketActivity1 -> {
            if (today.before(marketActivity1.getActivityBeginTime())) {
                marketActivity1.setActivityStatusName("\u5f85\u6267\u884c");
            }
            if (today.after(marketActivity1.getActivityEndTime())) {
                marketActivity1.setActivityStatusName("\u7ed3\u675f");
            }
            if (today.after(marketActivity1.getActivityBeginTime()) && today.before(marketActivity1.getActivityEndTime())) {
                marketActivity1.setActivityStatusName("\u8fdb\u884c\u4e2d");
            }
            if (Boolean.FALSE.equals(marketActivity1.getActivityStatus())) {
                marketActivity1.setActivityStatusName("\u5173\u95ed");
            }
        });
        return list;
    }

    public MarketActivity getDetail(Integer id) {
        log.info("\u83b7\u53d6\u6d3b\u52a8\u8be6\u60c5");
        MarketActivity marketActivity = (MarketActivity)this.marketActivityMapper.selectByPrimaryKey((Object)id);
        if (marketActivity == null) {
            throw new MallAdminException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List marketActivityGoods = this.marketActivityGoodsMapper.getGoodsDetail(marketActivity.getActivityNo(), null, null, null, null);
        List availaleStock = this.getAvailaleStock(marketActivityGoods);
        if (marketActivityGoods.size() > 0) {
            marketActivity.setMarketActivityGoods(availaleStock);
        }
        return marketActivity;
    }

    private List<MarketActivityGoods> getAvailaleStock(List<MarketActivityGoods> list) {
        List<MarketActivityGoods> collect = list.stream().map(e -> {
            GoodsSkuDetail gsd = new GoodsSkuDetail();
            gsd.setGoodsId(e.getGoodsId());
            Integer reduce = this.goodsSkuDetailMapper.select((Object)gsd).stream().map(f -> f.getStock()).reduce(0, (x, y) -> {
                y = y + x;
                return y;
            });
            e.setStock(reduce);
            return e;
        }).collect(Collectors.toList());
        return collect;
    }

    private List<MarketActivityGoods> getGoods(Integer merchantId, Integer id, String activityType) {
        ArrayList<MarketActivityGoods> list = new ArrayList<MarketActivityGoods>();
        Example example = new Example(MarketActivity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("merchantId", (Object)merchantId).andEqualTo("activityType", (Object)activityType).andCondition("DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%S') BETWEEN DATE_FORMAT(activity_begin_time,'%Y-%m-%d %H:%i:%S') AND DATE_FORMAT(activity_end_time,'%Y-%m-%d %H:%i:%S') AND activity_status=1");
        if (id != null) {
            criteria.andNotEqualTo("id", (Object)id);
        }
        List marketActivities = this.marketActivityMapper.selectByExample((Object)example);
        marketActivities.forEach(marketActivity -> {
            List marketActivityGoods = this.marketActivityGoodsMapper.getGoodsDetail(marketActivity.getActivityNo(), null, null, null, null);
            list.addAll(marketActivityGoods);
        });
        return list;
    }

    public RestResult newMemberByActivity(AssembleNewMember assembleNewMember) {
        assembleNewMember.setGmtCreate(new Date());
        this.assembleNewMemberMapper.insertSelective((Object)assembleNewMember);
        return RestResult.success();
    }

    public Map statistics(Integer id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MarketActivity marketActivity = (MarketActivity)this.marketActivityMapper.selectByPrimaryKey((Object)id);
        map.put("activity", marketActivity);
        Example example = new Example(MarketActivityOrders.class);
        example.createCriteria().andEqualTo("activityNo", (Object)marketActivity.getActivityNo());
        List marketActivityOrdersList = this.marketActivityOrdersMapper.selectByExample((Object)example);
        int underWay = 0;
        int cj = 0;
        BigDecimal deal = BigDecimal.ZERO;
        int fq = 0;
        int cy = marketActivityOrdersList.size();
        int newMember = 0;
        for (MarketActivityOrders marketActivityOrders : marketActivityOrdersList) {
            if (marketActivityOrders.getOrdersStatus().equals("0")) {
                ++underWay;
            }
            if (marketActivityOrders.getOrdersStatus().equals("1")) {
                ++cj;
                Example example1 = new Example(Orders.class);
                example1.createCriteria().andEqualTo("orderNo", (Object)marketActivityOrders.getOrdersNo());
                Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)example1);
                deal = deal.add(orders.getPayAmount());
            }
            if (!marketActivityOrders.getLaunchUserNo().equals(marketActivityOrders.getUserNo())) continue;
            ++fq;
        }
        Example example1 = new Example(AssembleNewMember.class);
        example1.createCriteria().andEqualTo("activityNo", (Object)marketActivity.getActivityNo());
        List assembleNewMembers = this.assembleNewMemberMapper.selectByExample((Object)example1);
        newMember = assembleNewMembers.size();
        map.put("underWay", underWay);
        map.put("cj", cj);
        map.put("deal", deal);
        map.put("fq", fq);
        map.put("cy", cy);
        map.put("newMember", newMember);
        map.put("time", marketActivity.getActivityEndTime().getTime() - new Date().getTime());
        return map;
    }

    public List<Goods> getActivityGoods(String activityNo, String queryParams) {
        List marketActivityGoods = this.marketActivityGoodsMapper.getGoodsDetail(activityNo, null, null, queryParams, null);
        List<Goods> goodsList = marketActivityGoods.stream().map(x -> {
            Example example = new Example(Goods.class);
            example.createCriteria().andEqualTo("goodsNo", (Object)x.getGoodsNo()).andEqualTo("isDel", (Object)0).andEqualTo("merchantId", (Object)x.getMerchantId());
            Goods goods = (Goods)this.goodsMapper.selectOneByExample((Object)example);
            Example skuExa = new Example(GoodsSkuDetail.class);
            skuExa.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
            List skuDetails = this.goodsSkuDetailMapper.selectByExample((Object)skuExa);
            Integer stock = 0;
            for (GoodsSkuDetail skuDetail : skuDetails) {
                stock = stock + skuDetail.getStock();
            }
            goods.setStock(stock);
            goods.setGoodsSkuDetailList(skuDetails);
            MarketActivityOrders mao = new MarketActivityOrders();
            mao.setActivityNo(activityNo);
            mao.setGoodsNo(x.getGoodsNo());
            mao.setActivityOrdersType("1");
            mao.setOrdersStatus("1");
            List assembled = this.marketActivityOrdersMapper.select((Object)mao);
            if (!CollectionUtils.isEmpty((Collection)assembled)) {
                goods.setAssembledNum(Integer.valueOf(assembled.size()));
                MarketActivityGoods mag = new MarketActivityGoods();
                mag.setMarketActivityNo(activityNo);
                mag.setGoodsNo(x.getGoodsNo());
                MarketActivityGoods assembledCount = (MarketActivityGoods)this.marketActivityGoodsMapper.selectOne((Object)mag);
                goods.setAssembledAmount(assembledCount.getAmount().multiply(BigDecimal.valueOf(assembled.size())).setScale(2, 4));
            } else {
                goods.setAssembledNum(Integer.valueOf(0));
                goods.setAssembledAmount(BigDecimal.ZERO);
            }
            return goods;
        }).collect(Collectors.toList());
        return goodsList;
    }

    public MarketActivity getMarketDetail(Integer id) {
        MarketActivity marketActivity = (MarketActivity)this.marketActivityMapper.selectByPrimaryKey((Object)id);
        if (marketActivity != null) {
            MarketActivityGoods mag = new MarketActivityGoods();
            mag.setMarketActivityNo(marketActivity.getActivityNo());
            List select = this.marketActivityGoodsMapper.select((Object)mag);
            if (!CollectionUtils.isEmpty((Collection)select)) {
                select.forEach(e -> {
                    Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)e.getGoodsId());
                    e.setPrice(goods.getSalePrice());
                });
                marketActivity.setMarketActivityGoods(select);
            }
        }
        return marketActivity;
    }
}

