/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mzlion.core.lang.StringUtils;
import com.wmeimob.fastboot.bizvane.dto.integral.CityInfoDTO;
import com.wmeimob.fastboot.bizvane.dto.integral.ProvinceInfoDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralCourierCompany;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrdersDetails;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.enums.CalcTemplateWay;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.IntegralStore.goods.IntegralGoodsTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralCashPayChannelEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralGoodsFeightTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralOrderSyncOfflineStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralOrderTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.PayOrderStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityStatus;
import com.wmeimob.fastboot.bizvane.enums.skyworth.IntegralGoodsPriceTypeEnum;
import com.wmeimob.fastboot.bizvane.mapper.IntegralCourierCompanyMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersDetailsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralRefundOrderMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralCouponPayRecordPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralExpressTemplateAreaPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralExpressTemplatePOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsSkuPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersDetailsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityConfigMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityOrderRecordMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivitySkuMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralCouponPayRecordPO;
import com.wmeimob.fastboot.bizvane.po.IntegralExpressTemplateAreaPO;
import com.wmeimob.fastboot.bizvane.po.IntegralExpressTemplateAreaPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralExpressTemplatePO;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuPO;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersDetailsPO;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersDetailsPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityOrderRecordPO;
import com.wmeimob.fastboot.bizvane.po.SeckillActivitySkuPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.IntegralRefundOrderService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrdersNewService;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.ErpOrderApiService;
import com.wmeimob.fastboot.bizvane.service.fegin.IntegralApiService;
import com.wmeimob.fastboot.bizvane.service.fegin.impl.IntegralOrderPushService;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityService;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivitySearchResponseVO;
import com.wmeimob.fastboot.bizvane.util.IntegralOrderNoUtil;
import com.wmeimob.fastboot.bizvane.util.SysBrandUtils;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.goods.GoodsCouponResponseVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.goods.GoodsCouponSelectLimitRequestVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.order.IntegralOrderFeightVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.GetPushIntegralOrderToErpRequestVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.IntegralOrderWrapperVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.OrderMessageVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.common.entity.CityInfo;
import com.wmeimob.fastboot.starter.common.mapper.CityInfoMapper;
import com.wmeimob.fastboot.util.InputValidator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralOrdersServiceImpl
implements IntegralOrdersService {
    private static final Logger log = LoggerFactory.getLogger(IntegralOrdersServiceImpl.class);
    @Resource
    private IntegralOrdersMapper integralOrdersMapper;
    @Resource
    private IntegralRefundOrderMapper integralRefundOrderMapper;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private IntegralGoodsSkuPOMapper integralGoodsSkuPOMapper;
    @Resource
    private IntegralGoodsByDesignerPOMapper integralGoodsByDesignerPOMapper;
    @Resource
    private IntegralOrdersDetailsMapper integralOrdersDetailsMapper;
    @Resource
    private IntegralGoodsMapper integralGoodsMapper;
    @Resource
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;
    @Resource
    private CityInfoMapper cityInfoMapper;
    @Resource
    private RedisTemplate redisTemplate;
    @Autowired
    private RedissonClient redisson;
    @Lazy
    @Autowired
    private IntegralOrdersService integralOrdersService;
    @Resource
    private IntegralCourierCompanyMapper courierCompanyMapper;
    @Autowired
    private ThreadPoolExecutor scheduledThreadPoolExecutor;
    @Resource
    private IntegralOrderPushService integralOrderPushService;
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Resource
    private IntegralCouponPayRecordPOMapper integralCouponPayRecordPOMapper;
    @Resource
    private IntegralExpressTemplatePOMapper integralExpressTemplatePOMapper;
    @Resource
    private IntegralExpressTemplateAreaPOMapper integralExpressTemplateAreaPOMapper;
    @Autowired
    private ErpOrderApiService erpOrderApiService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private IntegralApiService integralApiService;
    @Lazy
    @Autowired
    private IntegralOrdersNewService integralOrdersNewService;
    @Resource
    SeckillActivityOrderRecordMapper seckillActivityOrderRecordMapper;
    @Resource
    SeckillActivityService seckillActivityService;
    @Resource
    SeckillActivityConfigMapper seckillActivityConfigMapper;
    @Resource
    SeckillActivitySkuMapper seckillActivitySkuMapper;
    @Autowired
    private IntegralRefundOrderService integralRefundOrderService;
    @Resource
    private IntegralOrdersPOMapper integralOrdersPOMapper;
    @Resource
    private IntegralOrdersDetailsPOMapper integralOrdersDetailsPOMapper;
    @Resource
    private IntegralGoodsPOMapper integralGoodsPOMapper;

    public PageInfo<IntegralOrders> getOrdersList(IntegralOrders integralOrders, Boolean pageJudge) {
        Integer merchantId = integralOrders.getMerchantId();
        Long sysCompanyId = integralOrders.getSysCompanyId();
        InputValidator.checkEmpty((Object)merchantId, (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)sysCompanyId, (String)"\u4f01\u4e1aid");
        ResponseData brandByID = this.brandServiceRpc.getBrandByID(Long.valueOf(merchantId.intValue()));
        Boolean isMasterCard = SysBrandUtils.isMasterCard((ResponseData)brandByID);
        if (isMasterCard.booleanValue()) {
            log.info("\u8fdb\u5165\u96c6\u56e2\u903b\u8f91");
            integralOrders.setMerchantId(null);
        } else {
            log.info("\u8fdb\u5165\u4e00\u822c\u5546\u6237\u903b\u8f91");
            integralOrders.setSysCompanyId(null);
        }
        List orders = new ArrayList();
        PageInfo result = new PageInfo();
        if (pageJudge.booleanValue()) {
            PageHelper.startPage((int)integralOrders.getPageIndex(), (int)integralOrders.getPageSize());
            orders = this.integralOrdersMapper.getOrders(integralOrders);
            result = new PageInfo(orders);
        } else {
            orders = this.integralOrdersMapper.getOrders(integralOrders);
            result.setList(orders);
        }
        log.info("orders:{}", (Object)JSON.toJSONString(orders));
        orders.forEach(e -> {
            if (e.getSaleIntegral() != null && e.getSaleQuantity() != null) {
                e.setTotalIntegral(Integer.valueOf(e.getSaleIntegral() * e.getSaleQuantity()));
            }
            if (e.getSalePrice().compareTo(BigDecimal.ZERO) != 0 && e.getSaleQuantity() != null) {
                e.setTotalPrice(e.getSalePrice().multiply(BigDecimal.valueOf(e.getSaleQuantity().intValue())));
            }
            if ("0".equals(e.getOrderType())) {
                e.setStoreCode(null);
            }
            if (IntegralGoodsTypeEnum.COUPON.getCode().equals(e.getGoodsType())) {
                this.addCoupons(e);
            }
            if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)e.getDistributorName())) {
                e.setDistributorName(this.bizvaneInterface.getIntegralShopGetDistributorName(e.getMemberCode()));
            }
            e.setSyncOfflineStateDesc(IntegralOrderSyncOfflineStatusEnum.getMessageByCode((Integer)e.getSyncOfflineState()));
        });
        return result;
    }

    public IntegralOrders addCoupons(IntegralOrders orders) {
        ArrayList<GoodsCouponResponseVO> couponCodes = new ArrayList<GoodsCouponResponseVO>();
        IntegralGoodsSkuPOExample checkCouponCodesExample = new IntegralGoodsSkuPOExample();
        checkCouponCodesExample.createCriteria().andValidEqualTo(Boolean.TRUE).andOrderNoEqualTo(orders.getOrderNo());
        List integralGoodsSkuPOS = this.integralGoodsSkuPOMapper.selectByExample(checkCouponCodesExample);
        log.info("integralGoodsCouponSkuPOS:{}", (Object)JSON.toJSONString((Object)integralGoodsSkuPOS));
        if (!CollectionUtils.isEmpty((Collection)integralGoodsSkuPOS)) {
            for (IntegralGoodsSkuPO po : integralGoodsSkuPOS) {
                GoodsCouponResponseVO vo = new GoodsCouponResponseVO();
                vo.setCouponCode(po.getSkuNo());
                vo.setStartTime(DateUtil.format((Date)po.getStartTime(), (String)DateUtil.ymdhms));
                vo.setEndTime(DateUtil.format((Date)po.getEndTime(), (String)DateUtil.ymdhms));
                couponCodes.add(vo);
            }
        }
        orders.setCouponCodes(couponCodes);
        return orders;
    }

    public IntegralOrders setCourier(IntegralOrders integralOrders) {
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.selectByPrimaryKey((Object)integralOrders.getId());
        if (orders == null) {
            throw new MallAdminException("\u65e0\u6b64\u8ba2\u5355");
        }
        if (!orders.getOrderStatus().equals(IntegralOrdersStatusEnum.UN_SHIPPED.getCode())) {
            if (orders.getOrderStatus().equals(IntegralOrdersStatusEnum.SHIPPED.getCode())) {
                throw new MallAdminException("\u8be5\u8ba2\u5355\u5df2\u7ecf\u53d1\u8d27");
            }
            throw new MallAdminException("\u8be5\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        orders.setCourierCompanyName(integralOrders.getCourierCompanyName());
        orders.setCourierCompanyCode(integralOrders.getCourierCompanyCode());
        orders.setCourierNo(integralOrders.getCourierNo());
        orders.setGmtModified(new Date());
        orders.setOrderStatus(IntegralOrdersStatusEnum.SHIPPED.getCode());
        orders.setSendGoodTime(new Date());
        this.integralOrdersMapper.updateByPrimaryKey((Object)orders);
        this.scheduledThreadPoolExecutor.execute(() -> {
            try {
                CompanyBrandRelationPOExample searchCompanyRelationExample = new CompanyBrandRelationPOExample();
                searchCompanyRelationExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(orders.getMerchantId());
                List companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(searchCompanyRelationExample);
                log.info("\u67e5\u8be2\u51fa\u7684\u5546\u6237\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)companyBrandRelationPOS));
                if (CollectionUtils.isEmpty((Collection)companyBrandRelationPOS)) {
                    throw new MallAdminException("\u5546\u6237\u4fe1\u606f\u672a\u627e\u5230");
                }
                if (companyBrandRelationPOS.size() > 1) {
                    throw new MallAdminException("\u591a\u4e2a\u76f8\u540cmerchantId\u5546\u6237");
                }
                CompanyBrandRelationPO companyBrandRelationPO = (CompanyBrandRelationPO)companyBrandRelationPOS.get(0);
                OrderMessageVO orderMessageVO = new OrderMessageVO();
                if (companyBrandRelationPO.getCompanyId() == null) {
                    throw new MallAdminException("\u5546\u6237CompanyId\u4e3a\u7a7a");
                }
                if (companyBrandRelationPO.getBrandId() == null) {
                    throw new MallAdminException("\u5546\u6237BrandId\u4e3a\u7a7a");
                }
                IntegralGoodsPOWithBLOBs integralGoodsPOWithBLOBs = this.integralGoodsPOMapper.selectByPrimaryKey(orders.getGoodId());
                orderMessageVO.setSysCompanyId(Long.valueOf(companyBrandRelationPO.getCompanyId().intValue()));
                orderMessageVO.setSysBrandId(Long.valueOf(companyBrandRelationPO.getBrandId().intValue()));
                orderMessageVO.setMemberPhone(orders.getMemberPhone());
                orderMessageVO.setOrderNo(orders.getOrderNo());
                orderMessageVO.setLogisticsNo(integralOrders.getCourierNo());
                orderMessageVO.setLogisticsCompanyName(integralOrders.getCourierCompanyName());
                orderMessageVO.setMemberCode(orders.getMemberCode());
                orderMessageVO.setIntegralGoodName(integralGoodsPOWithBLOBs.getGoodsName());
                orderMessageVO.setFieldText("\u79ef\u5206\u8ba2\u5355:" + orders.getOrderNo());
                this.integralOrderPushService.sendOrderMessage(orderMessageVO);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info(e.getMessage());
            }
        });
        return orders;
    }

    public RestResult synLogisticsInfo(IntegralOrders integralOrders) {
        Example example = new Example(IntegralOrders.class);
        example.createCriteria().andEqualTo("orderNo", (Object)integralOrders.getOrderNo()).andEqualTo("valid", (Object)Boolean.TRUE);
        List integralOrdersList = this.integralOrdersMapper.selectByExample((Object)example);
        if (CollectionUtils.isEmpty((Collection)integralOrdersList)) {
            throw new MallAdminException("\u6ca1\u6709\u6b64\u8ba2\u5355");
        }
        IntegralOrders orders = (IntegralOrders)integralOrdersList.get(0);
        IntegralOrders newOrders = new IntegralOrders();
        newOrders.setId(orders.getId());
        if (orders.getOrderStatus().equals(IntegralOrdersStatusEnum.UN_SHIPPED.getCode())) {
            log.info(integralOrders.getOrderNo() + "\u672a\u53d1\u8d27\u8ba2\u5355\u7269\u6d41\u540c\u6b65\u6267\u884c");
            InputValidator.checkEmpty((Object)integralOrders.getCourierCompanyName(), (String)"\u8c03\u7528\u6765\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u65f6\u5feb\u9012\u516c\u53f8\u540d\u79f0");
            InputValidator.checkEmpty((Object)integralOrders.getCourierNo(), (String)"\u8c03\u7528\u6765\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u65f6\u5feb\u9012\u5355\u53f7");
            InputValidator.checkEmpty((Object)integralOrders.getSendGoodTime(), (String)"\u8c03\u7528\u6765\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u65f6\u53d1\u8d27\u65f6\u95f4");
            InputValidator.checkEmpty((Object)integralOrders.getShippingName(), (String)"\u8c03\u7528\u6765\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u65f6\u6536\u8d27\u4eba\u59d3\u540d");
            InputValidator.checkEmpty((Object)integralOrders.getShippingMobile(), (String)"\u8c03\u7528\u6765\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u65f6\u6536\u8d27\u4eba\u7535\u8bdd");
            InputValidator.checkEmpty((Object)integralOrders.getShippingProvince(), (String)"\u8c03\u7528\u6765\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u65f6\u6536\u8d27\u7701\u4efd");
            InputValidator.checkEmpty((Object)integralOrders.getShippingCity(), (String)"\u8c03\u7528\u6765\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u65f6\u6536\u8d27\u57ce\u5e02");
            InputValidator.checkEmpty((Object)integralOrders.getShippingDistrict(), (String)"\u8c03\u7528\u6765\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u65f6\u6536\u8d27\u884c\u653f\u533a");
            InputValidator.checkEmpty((Object)integralOrders.getShippingAddress(), (String)"\u8c03\u7528\u6765\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u65f6\u6536\u8d27\u5177\u4f53\u5730\u5740");
        } else {
            log.info(integralOrders.getOrderNo() + "\u975e\u672a\u53d1\u8d27\u8ba2\u5355\u7269\u6d41\u8986\u76d6\u6267\u884c");
            boolean orderNo = BeanUtil.isEmpty((Object)integralOrders, (String[])new String[]{"orderNo"});
            if (orderNo) {
                throw new MallAdminException("\u8986\u76d6\u6240\u9700\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a!");
            }
        }
        if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralOrders.getCourierCompanyCode())) {
            log.info("\u5feb\u9012\u516c\u53f8\u7f16\u53f7:{}", (Object)integralOrders.getCourierCompanyCode());
            Example courierCompanyExample = new Example(IntegralCourierCompany.class);
            courierCompanyExample.createCriteria().andEqualTo("name", (Object)integralOrders.getCourierCompanyName());
            List courierCompanies = this.courierCompanyMapper.selectByExample((Object)courierCompanyExample);
            if (!CollectionUtils.isEmpty((Collection)courierCompanies)) {
                newOrders.setCourierCompanyCode(((IntegralCourierCompany)courierCompanies.get(0)).getCode());
            }
        } else {
            newOrders.setCourierCompanyCode(integralOrders.getCourierCompanyCode());
        }
        newOrders.setCourierCompanyName(integralOrders.getCourierCompanyName());
        newOrders.setCourierNo(integralOrders.getCourierNo());
        newOrders.setSendGoodTime(integralOrders.getSendGoodTime());
        if (!integralOrders.getShippingName().equals(orders.getShippingName())) {
            newOrders.setShippingName(integralOrders.getShippingName());
        }
        if (!integralOrders.getShippingMobile().equals(orders.getShippingMobile())) {
            newOrders.setShippingMobile(integralOrders.getShippingMobile());
        }
        if (!integralOrders.getShippingProvince().equals(orders.getShippingProvince())) {
            newOrders.setShippingProvince(integralOrders.getShippingProvince());
        }
        if (!integralOrders.getShippingCity().equals(orders.getShippingCity())) {
            newOrders.setShippingCity(integralOrders.getShippingCity());
        }
        if (!integralOrders.getShippingDistrict().equals(orders.getShippingDistrict())) {
            newOrders.setShippingDistrict(integralOrders.getShippingDistrict());
        }
        if (!integralOrders.getShippingAddress().equals(orders.getShippingAddress())) {
            newOrders.setShippingAddress(integralOrders.getShippingAddress());
        }
        if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralOrders.getUserComments()) && !integralOrders.getUserComments().equals(orders.getUserComments())) {
            newOrders.setUserComments(com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralOrders.getUserComments()) ? orders.getUserComments() : integralOrders.getUserComments());
        }
        if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralOrders.getOrderStatus())) {
            log.info("\u8ba2\u5355\u72b6\u6001\u7a7a\uff0c\u9ed8\u8ba4\u4e3a\u5df2\u53d1\u8d27");
            newOrders.setOrderStatus(IntegralOrdersStatusEnum.SHIPPED.getCode());
        }
        newOrders.setGmtModified(new Date());
        this.integralOrdersMapper.updateByPrimaryKeySelective((Object)newOrders);
        log.info("\u540c\u6b65\u5165\u5e93\u7684\u6570\u636e:{}", (Object)JSON.toJSONString((Object)newOrders));
        return RestResult.msg((int)1, (String)"\u540c\u6b65\u6210\u529f");
    }

    public IntegralOrders updateCourierAddress(IntegralOrders integralOrders) {
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.selectByPrimaryKey((Object)integralOrders.getId());
        if (!orders.getOrderStatus().equals(IntegralOrdersStatusEnum.UN_SHIPPED.getCode())) {
            if (orders.getOrderStatus().equals(IntegralOrdersStatusEnum.SHIPPED.getCode())) {
                throw new MallAdminException("\u8be5\u8ba2\u5355\u5df2\u7ecf\u53d1\u8d27");
            }
            throw new MallAdminException("\u8be5\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        orders.setShippingName(integralOrders.getShippingName());
        orders.setShippingMobile(integralOrders.getShippingMobile());
        orders.setShippingProvince(integralOrders.getShippingProvince());
        orders.setShippingCity(integralOrders.getShippingCity());
        orders.setShippingDistrict(integralOrders.getShippingDistrict());
        orders.setShippingAddress(integralOrders.getShippingAddress());
        orders.setGmtModified(new Date());
        this.integralOrdersMapper.updateByPrimaryKey((Object)orders);
        return orders;
    }

    @Transactional
    public IntegralOrders auditor(IntegralRefundOrder integralRefundOrder) {
        Integer refundId = integralRefundOrder.getId();
        IntegralRefundOrder refundOrder = (IntegralRefundOrder)this.integralRefundOrderMapper.selectByPrimaryKey((Object)refundId);
        String orderNo = refundOrder.getOrderNo();
        Integer brandId = refundOrder.getMerchantId();
        Example example = new Example(IntegralOrders.class);
        example.createCriteria().andEqualTo("merchantId", (Object)brandId).andEqualTo("orderNo", (Object)orderNo).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.selectOneByExample((Object)example);
        if (orders == null) {
            throw new MallAdminException("\u6b64\u9000\u8d27\u8ba2\u5355\u65e0\u8ba2\u5355\uff01");
        }
        refundOrder.setAuditor(integralRefundOrder.getAuditor());
        refundOrder.setAuditTime(new Date());
        refundOrder.setAuditReback(integralRefundOrder.getAuditReback());
        refundOrder.setGmtModified(new Date());
        if (integralRefundOrder.getAuditType().equals(Boolean.TRUE)) {
            if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralRefundOrder.getAuditReback())) {
                refundOrder.setAuditReback("\u5ba1\u6279\u901a\u8fc7\uff01");
            }
            orders.setGmtModified(new Date());
            refundOrder.setAuditStatus("1");
        } else {
            if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)integralRefundOrder.getAuditReback())) {
                refundOrder.setAuditReback("\u5ba1\u6279\u9a73\u56de\uff01");
            }
            orders.setGmtModified(new Date());
            refundOrder.setAuditStatus("2");
            refundOrder.setRefundStatus("2");
        }
        this.integralOrdersMapper.updateByPrimaryKeySelective((Object)orders);
        this.integralRefundOrderMapper.updateByPrimaryKeySelective((Object)refundOrder);
        return orders;
    }

    @Transactional
    public IntegralOrders refund(String orderNo, Integer merchantId, String staffName, String storeName, Boolean refundMoney) {
        IntegralOrders order = new IntegralOrders();
        order.setOrderNo(orderNo);
        order.setValid(Boolean.valueOf(true));
        order.setMerchantId(merchantId);
        RLock orderLock = this.redisson.getLock(orderNo + "orderLock");
        log.info("\u52a0\u8ba2\u5355\u9501-----------1   orderNo={} ", (Object)orderNo);
        orderLock.lock(1000L, TimeUnit.MILLISECONDS);
        List ordersList = this.integralOrdersMapper.getOrders(order);
        if (ordersList.size() == 0) {
            orderLock.unlock();
            throw new CustomException("\u6b64\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        IntegralOrders orders = (IntegralOrders)ordersList.get(0);
        String orderStatus = orders.getOrderStatus();
        log.info("\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)orders));
        Example refundExample = new Example(IntegralRefundOrder.class);
        refundExample.createCriteria().andEqualTo("orderNo", (Object)orderNo).andEqualTo("valid", (Object)Boolean.TRUE);
        IntegralRefundOrder refundOrder = null;
        refundOrder = (IntegralRefundOrder)this.integralRefundOrderMapper.selectOneByExample((Object)refundExample);
        if (refundOrder == null) {
            orderLock.unlock();
            throw new MallAdminException("\u6b64\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\u9000\u8d27\u4fe1\u606f\uff01");
        }
        if ("1".equals(refundOrder.getRefundStatus())) {
            orderLock.unlock();
            throw new MallAdminException("\u6b64\u8ba2\u5355\u5df2\u7ecf\u6210\u529f\u9000\u8d27\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u9000\u8d27\uff01");
        }
        refundOrder.setMemberCode(orders.getMemberCode());
        orderLock.unlock();
        orders.setGmtModified(new Date());
        orders.setStoreName(storeName);
        orders.setStaffName(staffName);
        BigDecimal refundCash = refundOrder.getRefundCash() == null ? BigDecimal.ZERO : refundOrder.getRefundCash();
        BigDecimal freight = orders.getFreight() == null ? BigDecimal.ZERO : orders.getFreight();
        BigDecimal money = refundCash.add(freight);
        boolean needRefundMoney = money.compareTo(BigDecimal.ZERO) == 1;
        log.info("needRefundMoney:{},refundMoney:{}", (Object)needRefundMoney, (Object)refundMoney);
        if (needRefundMoney && refundMoney != null && !IntegralOrdersStatusEnum.PAY_AWAIT.getCode().equalsIgnoreCase(orderStatus) && !IntegralOrdersStatusEnum.REFUND.getCode().equalsIgnoreCase(orderStatus)) {
            this.integralRefundOrderService.refundMoney(refundOrder);
            refundOrder.setRefundTime(new Date());
            refundOrder.setGmtModified(new Date());
            if (orders.getFreight().compareTo(BigDecimal.ZERO) == 1) {
                refundOrder.setRefundFreight(orders.getFreight());
            }
            order.setGmtModified(new Date());
            order.setOrderStatus(IntegralOrdersStatusEnum.REFUND.getCode());
            this.integralOrdersMapper.updateByPrimaryKeySelective((Object)orders);
            this.integralRefundOrderMapper.updateByPrimaryKeySelective((Object)refundOrder);
            return order;
        }
        orders.setOrderStatus(IntegralOrdersStatusEnum.RETURNED_GOODS.getCode());
        Integer refundIntegral = refundOrder.getRefundIntegral();
        if (refundIntegral > 0) {
            RestResult result = this.bizvaneInterface.refundIntegralChange(refundOrder);
            if (RestResult.success().getCode() != result.getCode()) {
                throw new CustomException("\u79ef\u5206\u6263\u51cf\u5931\u8d25\uff01");
            }
        }
        refundOrder.setRefundStatus("1");
        refundOrder.setRefundTime(new Date());
        refundOrder.setGmtModified(new Date());
        try {
            SeckillActivityOrderRecordPO record = this.seckillActivityOrderRecordMapper.selectOrderRecordByOrderNo(orders.getOrderNo());
            log.info("IntegralOrdersServiceImpl|seckillOrderRecord:{}", (Object)JSONObject.toJSONString((Object)record));
            if (record != null) {
                SeckillActivitySearchResponseVO activity = this.seckillActivityService.queryActivityStatus(record.getActivityCode());
                return this.refundSeckillActivityStock(orders, activity, refundMoney, refundOrder, orderStatus);
            }
        }
        catch (Exception e) {
            log.error("IntegralOrdersServiceImpl|\u79d2\u6740\u6d3b\u52a8\u56de\u8865\u5931\u8d25:{},{}", (Object)e.getMessage(), (Object)e);
        }
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)orders.getGoodId());
        integralGoods.setActualSales(Integer.valueOf(integralGoods.getActualSales() - orders.getSaleQuantity()));
        int actualSaleUpdate = this.integralGoodsMapper.updateByPrimaryKey((Object)integralGoods);
        log.info("IntegralOrdersServiceImpl#refund#actualSaleUpdate:{}", (Object)actualSaleUpdate);
        Example exampleSku = new Example(IntegralGoodsSku.class);
        exampleSku.createCriteria().andEqualTo("skuNo", (Object)orders.getGoodSkuNo()).andEqualTo("goodsId", (Object)orders.getGoodId());
        IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)exampleSku);
        if (sku != null) {
            int stockUpdate = this.integralGoodsSkuMapper.addStockBySkuId(sku.getId(), orders.getSaleQuantity());
            log.info("IntegralOrdersServiceImpl#refund#stockUpdate:{}", (Object)stockUpdate);
        }
        if (refundMoney == null || IntegralOrdersStatusEnum.PAY_AWAIT.getCode().equalsIgnoreCase(orderStatus)) {
            orders.setOrderStatus(IntegralOrdersStatusEnum.CLOSE.getCode());
            refundOrder.setValid(Boolean.FALSE);
        }
        order.setGmtModified(new Date());
        this.integralOrdersMapper.updateByPrimaryKeySelective((Object)orders);
        this.integralRefundOrderMapper.updateByPrimaryKeySelective((Object)refundOrder);
        return orders;
    }

    private IntegralOrders refundSeckillActivityStock(IntegralOrders orders, SeckillActivitySearchResponseVO activity, Boolean refundMoney, IntegralRefundOrder refundOrder, String orderStatus) {
        if (activity != null) {
            if (SeckillActivityStatus.HAVE_NOT_START.getCode().equals(activity.getStatus().getCode()) || SeckillActivityStatus.ON_GOING.getCode().equals(activity.getStatus().getCode())) {
                SeckillActivitySkuPO po = new SeckillActivitySkuPO();
                po.setActivityCode(activity.getActivityCode());
                po.setSkuNo(orders.getGoodSkuNo());
                po.setGoodsId(orders.getGoodId());
                SeckillActivitySkuPO skuPO = this.seckillActivitySkuMapper.selectActivitySku(po);
                if (skuPO != null) {
                    this.seckillActivitySkuMapper.addSkuStock(skuPO.getId(), orders.getSaleQuantity());
                    log.info("IntegralOrdersServiceImpl|refund|addSkuStock:{}", (Object)orders.getSaleQuantity());
                } else {
                    log.info("IntegralOrdersServiceImpl|updateStock1");
                    this.updateNormalStock(orders);
                }
            } else {
                log.info("IntegralOrdersServiceImpl|updateStock2");
                this.updateNormalStock(orders);
            }
        } else {
            log.info("IntegralOrdersServiceImpl|updateStock3");
            this.updateNormalStock(orders);
        }
        Integer orderPayStatus = PayOrderStatusEnum.PAY_REFUND.getCode();
        if (refundMoney == null || IntegralOrdersStatusEnum.PAY_AWAIT.getCode().equalsIgnoreCase(orderStatus)) {
            orderPayStatus = PayOrderStatusEnum.PAY_CANCEL.getCode();
            orders.setOrderStatus(IntegralOrdersStatusEnum.CLOSE.getCode());
            refundOrder.setValid(Boolean.FALSE);
        }
        this.seckillActivityOrderRecordMapper.updateByOrderNo(orders.getOrderNo(), orderPayStatus);
        this.integralOrdersMapper.updateByPrimaryKeySelective((Object)orders);
        this.integralRefundOrderMapper.updateByPrimaryKeySelective((Object)refundOrder);
        return orders;
    }

    private void updateNormalStock(IntegralOrders orders) {
        Example exampleSku = new Example(IntegralGoodsSku.class);
        exampleSku.createCriteria().andEqualTo("skuNo", (Object)orders.getGoodSkuNo()).andEqualTo("goodsId", (Object)orders.getGoodId());
        IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)exampleSku);
        if (sku != null) {
            int stockUpdate = this.integralGoodsSkuMapper.addStockBySkuId(sku.getId(), orders.getSaleQuantity());
            log.info("IntegralOrdersServiceImpl#refund#stockUpdate:{}", (Object)stockUpdate);
        }
    }

    @Transactional
    public IntegralOrders refundByAudit(IntegralOrders orders1) {
        Integer saleIntegral;
        IntegralOrders order = new IntegralOrders();
        order.setOrderNo(orders1.getOrderNo());
        order.setValid(Boolean.valueOf(true));
        order.setMerchantId(orders1.getMerchantId());
        RLock orderLock = this.redisson.getLock(orders1.getOrderNo() + "orderLock");
        log.info("\u52a0\u8ba2\u5355\u9501-----------1   orderNo={} ", (Object)orders1.getOrderNo());
        orderLock.lock(1000L, TimeUnit.MILLISECONDS);
        List ordersList = this.integralOrdersMapper.getOrders(order);
        if (ordersList.size() == 0) {
            orderLock.unlock();
            throw new MallAdminException("\u6b64\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        IntegralOrders orders = (IntegralOrders)ordersList.get(0);
        log.info("\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)orders));
        orderLock.unlock();
        orders.setOrderStatus(IntegralOrdersStatusEnum.RETURNED_GOODS.getCode());
        orders.setGmtModified(new Date());
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)orders.getGoodId());
        integralGoods.setActualSales(Integer.valueOf(integralGoods.getActualSales() - orders.getSaleQuantity()));
        this.integralGoodsMapper.updateByPrimaryKey((Object)integralGoods);
        Example exampleSku = new Example(IntegralGoodsSku.class);
        exampleSku.createCriteria().andEqualTo("skuNo", (Object)orders.getGoodSkuNo()).andEqualTo("goodsId", (Object)orders.getGoodId());
        IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)exampleSku);
        if (sku != null) {
            this.integralGoodsSkuMapper.addStockBySkuId(sku.getId(), orders.getSaleQuantity());
        }
        if ((saleIntegral = orders.getSaleIntegral()) > 0) {
            RestResult result = this.bizvaneInterface.refundIntegralChangeFor361(orders);
            if (RestResult.success().getCode() != result.getCode()) {
                throw new CustomException("\u79ef\u5206\u6263\u51cf\u5931\u8d25\uff01");
            }
        }
        order.setGmtModified(new Date());
        this.integralRefundOrderService.refundMoney(orders);
        this.integralOrdersMapper.updateByPrimaryKeySelective((Object)orders);
        return orders;
    }

    public List<IntegralRefundOrder> getRefundOrders(IntegralRefundOrder integralRefundOrder) {
        List list = this.integralRefundOrderMapper.getRefundOrders(integralRefundOrder);
        if (list.size() > 0) {
            for (IntegralRefundOrder refundOrder : list) {
                if ("0".equals(refundOrder.getAuditStatus()) && com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)refundOrder.getRefundStatus())) {
                    refundOrder.setOrderType("0");
                    continue;
                }
                if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)refundOrder.getRefundStatus()) && "0".equals(refundOrder.getRefundStatus())) {
                    refundOrder.setOrderType("1");
                    continue;
                }
                if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)refundOrder.getRefundStatus()) && "1".equals(refundOrder.getRefundStatus())) {
                    refundOrder.setOrderType("2");
                    continue;
                }
                if (!"2".equals(refundOrder.getAuditStatus())) continue;
                refundOrder.setOrderType("3");
            }
        }
        return list;
    }

    @Transactional
    public IntegralOrders confirm(IntegralOrders integralOrders) {
        int selectCount;
        log.info("confirm \u751f\u6210\u8ba2\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)integralOrders));
        if (integralOrders.getOrderType().equals("0")) {
            if (integralOrders.getIsDeliverCheck().equals("1")) {
                integralOrders.setOrderStatus(IntegralOrdersStatusEnum.AUDITING.getCode());
            } else {
                integralOrders.setOrderStatus(IntegralOrdersStatusEnum.UN_SHIPPED.getCode());
            }
        } else {
            integralOrders.setOrderStatus(IntegralOrdersStatusEnum.UN_SHIPPED.getCode());
        }
        if (!IntegralGoodsPriceTypeEnum.INTEGRAL.getType().equalsIgnoreCase(integralOrders.getIntegralGoods().getPriceType())) {
            integralOrders.setOrderStatus(IntegralOrdersStatusEnum.PAY_AWAIT.getCode());
        }
        integralOrders.setOrderTime(new Date());
        integralOrders.setGmtCreate(new Date());
        String orderNo = IntegralOrderNoUtil.getOrderNo();
        integralOrders.setOrderNo(orderNo);
        log.info("\u52a0\u9501-----------1   \u7528\u6237\u540d={} membercode={}", (Object)integralOrders.getMemberName());
        IntegralGoods goods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)integralOrders.getGoodId());
        if (goods == null) {
            throw new MallAdminException("\u65e0\u6b64\u5546\u54c1");
        }
        int restrict = this.integralOrdersMapper.selectAlreadyByGoodId(integralOrders.getGoodId());
        log.info("IntegralOrdersServiceImpl#confirm#restrict:{}", (Object)restrict);
        if (restrict + integralOrders.getSaleQuantity() > goods.getRestrictedNum()) {
            throw new MallAdminException("\u6b64\u5546\u54c1\u9650\u5151\u6570\u91cf\u4e3a" + goods.getRestrictedNum() + "\u4e2a,\u5df2\u8d85\u51fa\u5151\u6362\u6570\u91cf");
        }
        if (Integer.parseInt(integralOrders.getExchangeStatus()) == 1 && (selectCount = this.integralOrdersMapper.selectCountByMcode(integralOrders.getMemberCode(), integralOrders.getGoodId())) + integralOrders.getSaleQuantity() > Integer.parseInt(integralOrders.getExchangeCount())) {
            throw new MallAdminException("\u6b64\u5546\u54c1\u5df2\u7ecf\u8d85\u8fc7\u5151\u6362\u6570\u91cf,\u4e00\u540d\u7528\u6237\u53ea\u80fd\u5151\u6362" + integralOrders.getExchangeCount() + "\u4e2a");
        }
        IntegralGoodsSkuPOExample integralGoodsSkuPOExample = new IntegralGoodsSkuPOExample();
        integralGoodsSkuPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andEnabledEqualTo(Boolean.TRUE).andGoodsIdEqualTo(integralOrders.getGoodId());
        List integralGoodsSkuPOS = this.integralGoodsSkuPOMapper.selectByExample(integralGoodsSkuPOExample);
        if (CollectionUtils.isEmpty((Collection)integralGoodsSkuPOS)) {
            throw new MallAdminException("\u8be5\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        IntegralGoodsSkuPO integralGoodsSkuPO = (IntegralGoodsSkuPO)integralGoodsSkuPOS.get(0);
        integralOrders.setSaleIntegral(Integer.valueOf(goods.getPrice().intValue()));
        integralOrders.setGoodNo(goods.getGoodsNo());
        if ("1".equals(integralOrders.getOrderType())) {
            integralOrders.setOrderStoreName(integralOrders.getStoreName());
        }
        BigDecimal skuCashPrice = BigDecimal.ZERO;
        if (integralOrders.getIntegralGoods().getGoodsType().equals(IntegralGoodsTypeEnum.COUPON.getCode())) {
            integralOrders.setOrderStatus(IntegralOrdersStatusEnum.SIGN.getCode());
            integralOrders.setGoodsType(IntegralGoodsTypeEnum.COUPON.getCode());
            GoodsCouponSelectLimitRequestVO exchangeVo = new GoodsCouponSelectLimitRequestVO();
            exchangeVo.setNum(integralOrders.getSaleQuantity());
            exchangeVo.setGoodsId(integralOrders.getGoodId());
            exchangeVo.setOrderNo(integralOrders.getOrderNo());
            int i = this.integralGoodsByDesignerPOMapper.exchangeCouponsLimit(exchangeVo);
            if (i < integralOrders.getSaleQuantity()) {
                throw new MallAdminException("\u6709\u6548\u4f18\u60e0\u5238\u6570\u91cf\u4e0d\u8db3");
            }
            skuCashPrice = goods.getCashPrice();
            if (skuCashPrice.compareTo(BigDecimal.ZERO) == 1) {
                integralOrders.setOrderStatus(IntegralOrdersStatusEnum.PAY_AWAIT.getCode());
            }
        } else {
            integralOrders.setGoodsType(IntegralGoodsTypeEnum.GOODS.getCode());
            Example example = new Example(IntegralGoodsSku.class);
            example.createCriteria().andEqualTo("skuNo", (Object)integralOrders.getGoodSkuNo()).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("goodsId", (Object)integralOrders.getGoodId());
            IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)example);
            IntegralOrderFeightVO integralOrderFeightVO = new IntegralOrderFeightVO();
            integralOrderFeightVO.setTemplateId(integralOrders.getTemplateId());
            integralOrderFeightVO.setMerchantId(String.valueOf(integralOrders.getMerchantId()));
            integralOrderFeightVO.setGoodsId(String.valueOf(integralOrders.getGoodId()));
            integralOrderFeightVO.setOrderType(integralOrders.getOrderType());
            integralOrderFeightVO.setSaleQuantity(String.valueOf(integralOrders.getSaleQuantity()));
            integralOrderFeightVO.setShippingProvince(integralOrders.getShippingProvince());
            integralOrderFeightVO.setShippingCity(integralOrders.getShippingCity());
            integralOrderFeightVO.setShippingDistrict(integralOrders.getShippingDistrict());
            integralOrderFeightVO.setSkuNo(integralOrders.getGoodSkuNo());
            BigDecimal feight = BigDecimal.ZERO;
            if (!IntegralOrderTypeEnum.RAISING.getCode().equals(integralOrders.getOrderType())) {
                feight = this.handleFreigth(integralOrderFeightVO);
            }
            if (feight.compareTo(BigDecimal.ZERO) > 0) {
                integralOrders.setOrderStatus(IntegralOrdersStatusEnum.PAY_AWAIT.getCode());
            }
            integralOrders.setFreight(feight);
            log.info("\u8fdb\u5165\u9501----------2  \u7528\u6237\u540d={} membercode={}", (Object)integralOrders.getMemberName(), (Object)integralOrders.getMemberCode());
            if (sku == null) {
                throw new MallAdminException("\u65e0\u6b64\u5546\u54c1\u89c4\u683c");
            }
            if (integralOrders.getSaleQuantity() > sku.getStock()) {
                log.info("\u903b\u8f91\u5e93\u5b58\u5224\u65ad");
                throw new MallAdminException("\u5546\u54c1\u5e93\u5b58\u4ec5\u5269" + sku.getStock() + "\u4ef6!");
            }
            integralOrders.setSaleIntegral(Integer.valueOf(sku.getPrice().intValue()));
            integralOrders.setGoodSkuSpecNames(sku.getSpecNames());
            int i = this.integralGoodsSkuMapper.updateStockBySkuId(sku.getId(), integralOrders.getSaleQuantity());
            log.info("\u66f4\u65b0\u7684\u5e93\u5b58\u91cf={}", (Object)i);
            if (i == 0) {
                log.info("\u6570\u636e\u5e93\u5e93\u5b58\u5224\u65ad");
                throw new MallAdminException("\u5546\u54c1\u5e93\u5b58\u4ec5\u5269" + sku.getStock() + "\u4ef6!");
            }
            skuCashPrice = sku.getCashPrice();
        }
        this.integralOrdersMapper.insertSelective((Object)integralOrders);
        IntegralOrdersDetails details = new IntegralOrdersDetails();
        details.setMerchantId(integralOrders.getMerchantId());
        details.setOrderId(integralOrders.getId());
        details.setOrderNo(integralOrders.getOrderNo());
        details.setGoodId(integralOrders.getGoodId());
        details.setGoodsSkuNo(integralOrders.getGoodSkuNo());
        details.setGoodsSkuSpecNames(integralOrders.getGoodSkuSpecNames());
        details.setSaleIntegral(integralOrders.getSaleIntegral());
        details.setPurchasePrice(integralGoodsSkuPO.getPurchasePrice());
        details.setSaleQuantity(integralOrders.getSaleQuantity());
        details.setSysCompanyId(integralOrders.getSysCompanyId());
        details.setGmtCreate(new Date());
        if (!IntegralGoodsPriceTypeEnum.INTEGRAL.getType().equalsIgnoreCase(integralOrders.getIntegralGoods().getPriceType())) {
            details.setSalePrice(skuCashPrice);
            details.setCashPrice(skuCashPrice);
        }
        this.integralOrdersDetailsMapper.insertSelective((Object)details);
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)integralOrders.getGoodId());
        integralGoods.setActualSales(Integer.valueOf(integralGoods.getActualSales() + integralOrders.getSaleQuantity()));
        this.integralGoodsMapper.updateByPrimaryKey((Object)integralGoods);
        if (integralOrders.getSaleIntegral() != null && integralOrders.getSaleIntegral() > 0) {
            String changeDetail = null;
            if (IntegralOrdersStatusEnum.PAY_AWAIT.getCode().equals(integralOrders.getOrderStatus())) {
                IntegralOrderWrapperVO integralOrderWrapperVO = this.integralOrdersNewService.queryOrderWrapper(integralOrders.getId());
                BigDecimal totalFee = integralOrderWrapperVO.getTotalFee();
                Integer totalIntegral = integralOrderWrapperVO.getTotalIntegral();
                changeDetail = "\u79ef\u5206\u8ba2\u5355(\u79ef\u5206+\u73b0\u91d1):" + integralOrders.getOrderNo() + "\t\t\u73b0\u91d1:" + totalFee + "\t\t\u79ef\u5206:" + totalIntegral;
            }
            RestResult result = null;
            try {
                result = this.bizvaneInterface.consumeIntegralChange(integralOrders.getMemberCode(), Integer.valueOf(integralOrders.getSaleIntegral() * integralOrders.getSaleQuantity()), integralOrders.getOrderNo(), changeDetail);
            }
            catch (Exception e) {
                log.info("\u624b\u673a\u53f7\u4e3a:{}\u7684\u5ba2\u6237\u4e0b\u79ef\u5206\u8ba2\u5355\u6263\u51cf\u79ef\u5206\u5f02\u5e38------->\u4e0b\u5355\u5546\u54c1\u6570\u636e:{}\uff0c\u5f02\u5e38msg:{}", new Object[]{integralOrders.getMemberPhone(), integralOrders.getGoodId(), e.getMessage()});
                throw new MallAdminException("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            log.info("\u89e3\u9501----------3  \u7528\u6237\u540d={} membercode={}", (Object)integralOrders.getMemberName(), (Object)integralOrders.getMemberCode());
            if (result == null || RestResult.success().getCode() != result.getCode()) {
                throw new CustomException("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        return integralOrders;
    }

    private BigDecimal handleFreigth(IntegralOrderFeightVO integralOrderFeightVO) {
        log.info("\u5f00\u59cb\u5904\u7406\u79ef\u5206\u5546\u54c1\u8fd0\u8d39\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)integralOrderFeightVO));
        BigDecimal freight = BigDecimal.ZERO;
        IntegralGoodsPOWithBLOBs integralGoodsPO = this.integralGoodsPOMapper.selectByPrimaryKey(Integer.valueOf(integralOrderFeightVO.getGoodsId()));
        log.info("handleFreigth_integralGoodsPO:{}", (Object)JSON.toJSONString((Object)integralGoodsPO));
        IntegralGoodsSkuPOExample integralGoodsSkuPOExample = new IntegralGoodsSkuPOExample();
        integralGoodsSkuPOExample.createCriteria().andMerchantIdEqualTo(Integer.valueOf(integralOrderFeightVO.getMerchantId())).andSkuNoEqualTo(integralOrderFeightVO.getSkuNo()).andValidEqualTo(Boolean.TRUE);
        IntegralGoodsSkuPO sku = (IntegralGoodsSkuPO)this.integralGoodsSkuPOMapper.selectByExample(integralGoodsSkuPOExample).get(0);
        if (IntegralGoodsFeightTypeEnum.FREIGHT.getCode().equals(integralGoodsPO.getFreightType())) {
            log.info("\u8be5\u5546\u54c1\u4f7f\u7528\u7edf\u4e00\u8fd0\u8d39\uff01{}", (Object)integralGoodsPO.getDefaultFreight());
            freight = integralGoodsPO.getDefaultFreight();
        } else if (Objects.nonNull(integralOrderFeightVO.getTemplateId()) && IntegralOrderTypeEnum.MAIL.getCode().equals(integralOrderFeightVO.getOrderType())) {
            Integer templateId = Integer.valueOf(integralOrderFeightVO.getTemplateId());
            IntegralExpressTemplatePO integralExpressTemplatePO = this.integralExpressTemplatePOMapper.selectByPrimaryKey(templateId);
            Assert.notNull((Object)integralExpressTemplatePO, (String)"\u60a8\u65e0\u6cd5\u8d2d\u4e70\u8be5\u5546\u54c1\uff0c\u56e0\u4e3a\u5546\u5bb6\u5bf9\u8be5\u5546\u54c1\u7684\u8fd0\u8d39\u6a21\u677f\u8bbe\u7f6e\u6709\u8bef");
            log.info("\u8be5\u5546\u54c1\u8fd0\u8d39\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)integralExpressTemplatePO));
            if (CalcTemplateWay.SELLER.getValue() != integralExpressTemplatePO.getFreight().byteValue() && IntegralGoodsFeightTypeEnum.TEMPLATE.getCode().equals(integralGoodsPO.getFreightType())) {
                log.info("\u8be5\u5546\u54c1\u4f7f\u7528\u8fd0\u8d39\u6a21\u677f!");
                List areaPOList = new ArrayList();
                String province = this.filterRegionName(integralOrderFeightVO.getShippingProvince(), "\u7701");
                String city = this.filterRegionName(integralOrderFeightVO.getShippingCity(), "\u5e02");
                String district = this.filterRegionName(integralOrderFeightVO.getShippingDistrict(), "\u533a");
                InputValidator.checkEmpty((Object)province, (String)"\u7701\u4efd");
                InputValidator.checkEmpty((Object)city, (String)"\u57ce\u5e02");
                InputValidator.checkEmpty((Object)district, (String)"\u5730\u533a");
                log.info("\u7528\u6237\u6536\u8d27\u5730\u5740\u4fe1\u606f:{}\uff0c\u7701:{}\uff0c\u5e02:{}\uff0c\u533a:{}", new Object[]{province, city, district});
                IntegralExpressTemplateAreaPOExample cityPOExample = new IntegralExpressTemplateAreaPOExample();
                cityPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andTemplateIdEqualTo(templateId).andTextLike("%" + city + "%");
                areaPOList = this.integralExpressTemplateAreaPOMapper.selectByExample(cityPOExample);
                if (CollectionUtils.isEmpty(areaPOList)) {
                    IntegralExpressTemplateAreaPOExample cityPO = new IntegralExpressTemplateAreaPOExample();
                    cityPO.createCriteria().andValidEqualTo(Boolean.TRUE).andTemplateIdEqualTo(templateId).andTextLike("%" + province + "%");
                    areaPOList = this.integralExpressTemplateAreaPOMapper.selectByExample(cityPO);
                }
                if (CollectionUtils.isEmpty(areaPOList)) {
                    IntegralExpressTemplateAreaPOExample templateAreaPOExample = new IntegralExpressTemplateAreaPOExample();
                    templateAreaPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andTemplateIdEqualTo(templateId).andTextLike("\u5168\u56fd");
                    areaPOList = this.integralExpressTemplateAreaPOMapper.selectByExample(templateAreaPOExample);
                }
                if (CollectionUtils.isEmpty(areaPOList)) {
                    return freight;
                }
                IntegralExpressTemplateAreaPO integralExpressTemplateAreaPO = (IntegralExpressTemplateAreaPO)areaPOList.get(0);
                log.info("\u8be5\u5546\u54c1\u8fd0\u8d39\u6a21\u677f\u4e0b\u7684\u6240\u6709\u5730\u533a\uff1a{}", (Object)JSON.toJSONString(areaPOList));
                BigDecimal saleQuantity = new BigDecimal(integralOrderFeightVO.getSaleQuantity());
                Byte valuation = integralExpressTemplatePO.getValuation();
                if (CalcTemplateWay.NUMBER_OF_PACKAGES.getValue() == valuation.byteValue()) {
                    log.info("\u4ef6\u6570\u8ba1\u7b97 \u4ef6\u6570:{}", (Object)saleQuantity);
                    freight = this.getFreight(freight, saleQuantity, integralExpressTemplateAreaPO);
                }
                if (CalcTemplateWay.VOLUME.getValue() == valuation.byteValue() && Objects.nonNull(sku.getVolume())) {
                    BigDecimal volume = sku.getVolume().multiply(saleQuantity);
                    log.info("\u6309\u4f53\u79ef\u8ba1\u7b97 \u4f53\u79ef:{}", (Object)volume);
                    freight = this.getFreight(freight, volume, integralExpressTemplateAreaPO);
                }
                if (CalcTemplateWay.WEIGHT.getValue() == valuation.byteValue() && Objects.nonNull(sku.getWeight())) {
                    BigDecimal weight = sku.getWeight().multiply(saleQuantity);
                    log.info("\u6309\u91cd\u91cf\u8ba1\u7b97 \u91cd\u91cf:{}", (Object)weight);
                    freight = this.getFreight(freight, weight, integralExpressTemplateAreaPO);
                }
            }
        }
        return freight;
    }

    private BigDecimal getFreight(BigDecimal freight, BigDecimal numberOfPackage, IntegralExpressTemplateAreaPO integralExpressTemplateAreaPO) {
        log.info("get freight params : {},{},{} ", new Object[]{freight, numberOfPackage, JSONObject.toJSONString((Object)integralExpressTemplateAreaPO)});
        if (numberOfPackage.compareTo(BigDecimal.ZERO) > 0) {
            if (numberOfPackage.subtract(integralExpressTemplateAreaPO.getStart()).compareTo(BigDecimal.ZERO) > 0) {
                freight = freight.add(integralExpressTemplateAreaPO.getPostage());
                freight = freight.add(numberOfPackage.subtract(integralExpressTemplateAreaPO.getStart()).divide(integralExpressTemplateAreaPO.getPlus(), 0, RoundingMode.DOWN).multiply(integralExpressTemplateAreaPO.getPostageplus()));
            } else if (numberOfPackage.subtract(integralExpressTemplateAreaPO.getStart()).compareTo(BigDecimal.ZERO) <= 0) {
                freight = freight.add(integralExpressTemplateAreaPO.getPostage());
            }
        }
        return freight;
    }

    private String filterRegionName(String name, String filter) {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        int filterId = name.lastIndexOf(filter);
        if (filterId != -1) {
            return name.substring(0, filterId);
        }
        return name;
    }

    public PageInfo<IntegralOrders> getOrderListByStatus(Long sysCompanyId, Integer merchantId, String orderStatus, String memberCode, Integer pageNum, Integer pageSize) {
        if (pageNum == null) {
            pageNum = 0;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        IntegralOrders params = new IntegralOrders();
        if ("1".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.UN_SHIPPED.getCode();
        } else if ("2".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.SHIPPED.getCode();
        } else if ("3".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.SIGN.getCode();
        } else if ("4".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.RETURNED_GOODS.getCode();
            params.setRefundSort("DESC");
        }
        params.setSysCompanyId(sysCompanyId);
        params.setMemberCode(memberCode);
        params.setOrderStatus(orderStatus);
        if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)orderStatus) && "10".equals(orderStatus)) {
            params.setOrderStatus(null);
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.integralOrdersMapper.getOrders(params);
        PageInfo result = new PageInfo(list);
        list.stream().forEach(e -> {
            if ("4".equals(e.getOrderStatus())) {
                Example reExample = new Example(IntegralRefundOrder.class);
                reExample.createCriteria().andEqualTo("orderNo", (Object)e.getOrderNo()).andEqualTo("valid", (Object)Boolean.TRUE);
                IntegralRefundOrder refundOrder = (IntegralRefundOrder)this.integralRefundOrderMapper.selectOneByExample((Object)reExample);
                e.setRefundOrder(refundOrder);
            }
        });
        for (IntegralOrders orders : list) {
            if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)orders.getGoodsName())) continue;
            orders.setGoodsName(orders.getGoodName());
            orders.setCoverImg("https://www.wsgxsp.com/TP/149881997658968.png");
        }
        return result;
    }

    public List<IntegralOrders> getOrderListByStatus(Long sysCompanyId, Integer merchantId, String orderStatus, String memberCode) {
        IntegralOrders params = new IntegralOrders();
        if ("1".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.UN_SHIPPED.getCode();
        } else if ("2".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.SHIPPED.getCode();
        } else if ("3".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.SIGN.getCode();
        } else if ("4".equals(orderStatus)) {
            orderStatus = IntegralOrdersStatusEnum.RETURNED_GOODS.getCode();
            params.setRefundSort("DESC");
        } else {
            throw new CustomException("\u65e0\u6b64\u8ba2\u5355\u72b6\u6001\uff01");
        }
        params.setSysCompanyId(sysCompanyId);
        params.setMemberCode(memberCode);
        params.setOrderStatus(orderStatus);
        List list = this.integralOrdersMapper.getOrders(params);
        if ("4".equals(orderStatus)) {
            for (IntegralOrders orders : list) {
                Example reExample = new Example(IntegralRefundOrder.class);
                reExample.createCriteria().andEqualTo("orderNo", (Object)orders.getOrderNo()).andEqualTo("valid", (Object)Boolean.TRUE);
                IntegralRefundOrder refundOrder = (IntegralRefundOrder)this.integralRefundOrderMapper.selectOneByExample((Object)reExample);
                orders.setRefundOrder(refundOrder);
            }
        }
        for (IntegralOrders orders : list) {
            if (!com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)orders.getGoodsName())) continue;
            orders.setGoodsName(orders.getGoodName());
            orders.setCoverImg("https://www.wsgxsp.com/TP/149881997658968.png");
        }
        return list;
    }

    public IntegralOrders getOrderById(Integer orderId) {
        IntegralOrders params = new IntegralOrders();
        params.setId(orderId);
        IntegralOrders orders = (IntegralOrders)this.integralOrdersMapper.getOrders(params).get(0);
        if (orders != null) {
            if (orders.getOrderStatus().equals(IntegralOrdersStatusEnum.RETURNED_GOODS.getCode()) || orders.getOrderStatus().equals(IntegralOrdersStatusEnum.SIGN.getCode())) {
                Example reeExample = new Example(IntegralRefundOrder.class);
                reeExample.createCriteria().andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("orderNo", (Object)orders.getOrderNo());
                IntegralRefundOrder refundOrder = (IntegralRefundOrder)this.integralRefundOrderMapper.selectOneByExample((Object)reeExample);
                orders.setRefundOrder(refundOrder);
            }
            if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)orders.getGoodsName())) {
                orders.setGoodsName(orders.getGoodName());
                orders.setCoverImg("https://www.wsgxsp.com/TP/149881997658968.png");
            }
            if (orders.getGoodsType() != null && IntegralGoodsTypeEnum.COUPON.getCode().equals(orders.getGoodsType())) {
                this.addCoupons(orders);
            }
        }
        return orders;
    }

    public void getProvince() {
        log.info("\u521d\u59cb\u5316\u52a0\u8f7d\u7701\u5e02\u533a\u6570\u636e\u5217\u8868\uff0c\u5e76\u653e\u81f3redis\u4e2d\u3002");
        Example example = new Example(CityInfo.class);
        example.createCriteria().andEqualTo("type", (Object)"0");
        List provinceList = this.cityInfoMapper.selectByExample((Object)example);
        ArrayList<ProvinceInfoDTO> provinceInfoDTOList = new ArrayList<ProvinceInfoDTO>();
        for (CityInfo cityInfo : provinceList) {
            ProvinceInfoDTO provinceInfoDTO = new ProvinceInfoDTO();
            provinceInfoDTO.setName(cityInfo.getName());
            Example cityExample = new Example(CityInfo.class);
            cityExample.createCriteria().andEqualTo("type", (Object)"1").andEqualTo("pid", (Object)cityInfo.getId());
            List cityList = this.cityInfoMapper.selectByExample((Object)cityExample);
            ArrayList<CityInfoDTO> cityInfoDTOS = new ArrayList<CityInfoDTO>();
            for (CityInfo cityInfo1 : cityList) {
                CityInfoDTO cityInfoDTO = new CityInfoDTO();
                cityInfoDTO.setName(cityInfo1.getName());
                ArrayList<String> dNames = new ArrayList<String>();
                Example districtExample = new Example(CityInfo.class);
                districtExample.createCriteria().andEqualTo("type", (Object)"2").andEqualTo("pid", (Object)cityInfo1.getId());
                List districtList = this.cityInfoMapper.selectByExample((Object)districtExample);
                for (CityInfo cityInfo2 : districtList) {
                    dNames.add(cityInfo2.getName());
                }
                cityInfoDTO.setChildNames(dNames);
                cityInfoDTOS.add(cityInfoDTO);
            }
            provinceInfoDTO.setChildNames(cityInfoDTOS);
            provinceInfoDTOList.add(provinceInfoDTO);
        }
        this.redisTemplate.opsForValue().set((Object)"city", provinceInfoDTOList);
    }

    public List<ProvinceInfoDTO> getCity() {
        List city = (List)this.redisTemplate.opsForValue().get((Object)"city");
        return city;
    }

    public String getDistributionModeBySkuNo(String skuNo, Integer goodsId) {
        String mode = "0";
        Example skuExample = new Example(IntegralGoodsSku.class);
        skuExample.createCriteria().andEqualTo("skuNo", (Object)skuNo).andEqualTo("goodsId", (Object)goodsId);
        IntegralGoodsSku sku = (IntegralGoodsSku)this.integralGoodsSkuMapper.selectOneByExample((Object)skuExample);
        if (sku == null) {
            return mode;
        }
        IntegralGoods goods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)sku.getGoodsId());
        mode = goods.getDistributionMode();
        return mode;
    }

    public void auditIntegralOrders(IntegralOrders integralOrders) {
        log.info("IntegralOrderServiceImpl#auditIntegralOrders integralOrders:{}", (Object)JSON.toJSONString((Object)integralOrders));
        if (integralOrders.getIsAuditPass() == 1) {
            this.integralOrdersMapper.updateOrdersStatusByAudit(integralOrders);
            this.scheduledThreadPoolExecutor.execute(() -> {
                log.info(integralOrders.getOrderNo() + "\u5ba1\u6838\u901a\u8fc7\u63a8\u4f2f\u4fca");
                if (IntegralOrderTypeEnum.MAIL.getCode().equals(integralOrders.getOrderType())) {
                    this.integralApiService.pushOrderToConnector(integralOrders.getOrderNo());
                }
            });
        } else if (integralOrders.getIsAuditPass() == 0) {
            this.integralOrdersService.refundByAudit(integralOrders);
            this.integralOrdersMapper.updateOrdersStatusByAudit(integralOrders);
        }
    }

    private GetPushIntegralOrderToErpRequestVO convertPushIntegralOrderOf361ToErpParams(IntegralOrders integralOrders) {
        GetPushIntegralOrderToErpRequestVO vo = new GetPushIntegralOrderToErpRequestVO();
        if (integralOrders.getMerchantId() == null) {
            IntegralOrdersPO integralOrdersPo = this.integralOrdersPOMapper.selectByPrimaryKey(integralOrders.getId());
            vo.setMerchantId(integralOrdersPo.getMerchantId());
            vo.setOrderNo(integralOrdersPo.getOrderNo());
            vo.setOrderId(integralOrdersPo.getId());
        } else {
            vo.setMerchantId(integralOrders.getMerchantId());
            vo.setOrderNo(integralOrders.getOrderNo());
            vo.setOrderId(integralOrders.getId());
        }
        vo.setExecuteType("pushByIdOrOrderNo");
        return vo;
    }

    public void verifyIntegralOrders(IntegralOrders integralOrders) {
        if (Integer.parseInt(integralOrders.getOrderType()) == 1 && Integer.parseInt(integralOrders.getOrderStatus()) == 0) {
            this.integralOrdersMapper.updateVerfify(integralOrders.getOrderNo());
        }
    }

    public IntegralOrdersPO findByOrderNo(String orderNo) {
        IntegralOrdersPOExample integralOrdersPOExample = new IntegralOrdersPOExample();
        integralOrdersPOExample.createCriteria().andOrderNoEqualTo(orderNo).andValidEqualTo(Boolean.TRUE);
        List integralOrdersPOS = this.integralOrdersPOMapper.selectByExample(integralOrdersPOExample);
        if (CollectionUtils.isEmpty((Collection)integralOrdersPOS)) {
            return null;
        }
        return (IntegralOrdersPO)integralOrdersPOS.get(0);
    }

    @Transactional
    public IntegralOrders refundCash(String orderNo, Integer merchantId, String staffName, String storeName) {
        IntegralOrdersPO integralOrdersPO = this.findByOrderNo(orderNo);
        if (integralOrdersPO == null) {
            return null;
        }
        IntegralOrdersDetailsPOExample integralOrdersDetailsPOExample = new IntegralOrdersDetailsPOExample();
        integralOrdersDetailsPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andOrderIdEqualTo(integralOrdersPO.getId()).andValidEqualTo(Boolean.TRUE);
        List integralOrdersDetailsPOS = this.integralOrdersDetailsPOMapper.selectByExample(integralOrdersDetailsPOExample);
        if (CollectionUtils.isEmpty((Collection)integralOrdersDetailsPOS)) {
            return null;
        }
        IntegralOrdersDetailsPO integralOrdersDetailsPO = (IntegralOrdersDetailsPO)integralOrdersDetailsPOS.get(0);
        Integer goodId = integralOrdersDetailsPO.getGoodId();
        IntegralGoodsPOWithBLOBs integralGoodsPOWithBLOBs = this.integralGoodsPOMapper.selectByPrimaryKey(goodId);
        if (integralGoodsPOWithBLOBs == null) {
            return null;
        }
        String priceType = integralGoodsPOWithBLOBs.getPriceType();
        BigDecimal cashPrice = integralGoodsPOWithBLOBs.getCashPrice();
        if (IntegralGoodsPriceTypeEnum.INTEGRAL.getType().equals(priceType) || BigDecimal.ZERO.compareTo(cashPrice) == 0) {
            log.info("\u7eaf\u79ef\u5206\u5546\u54c1,\u6216\u73b0\u91d1\u4e3a0\u5546\u54c1\u76f4\u63a5\u6263\u51cf\u79ef\u5206");
            return this.refund(orderNo, merchantId, staffName, storeName, Boolean.FALSE);
        }
        log.info("\u79ef\u5206+\u73b0\u91d1\u5546\u54c1\u5148\u7b49\u9000\u6b3e\u56de\u8c03\u518d\u6263\u51cf\u79ef\u5206.");
        return null;
    }

    public Integer paySuccess(String orderNo, IntegralCashPayChannelEnum integralCashPayChannelEnum) {
        Integer result = 0;
        IntegralOrdersPO integralOrdersPO = this.findByOrderNo(orderNo);
        Integer goodId = integralOrdersPO.getGoodId();
        String orderStatus = integralOrdersPO.getOrderStatus();
        if (IntegralOrdersStatusEnum.PAY_AWAIT.getCode().equals(orderStatus)) {
            IntegralOrdersPO integralOrdersPOParam = new IntegralOrdersPO();
            integralOrdersPOParam.setId(integralOrdersPO.getId());
            integralOrdersPOParam.setGmtModified(new Date());
            if (integralOrdersPO.getOrderType().equals("0")) {
                if (integralOrdersPO.getIsDeliverCheck().equals("1")) {
                    integralOrdersPOParam.setOrderStatus(IntegralOrdersStatusEnum.AUDITING.getCode());
                } else {
                    integralOrdersPOParam.setOrderStatus(IntegralOrdersStatusEnum.UN_SHIPPED.getCode());
                }
            } else {
                integralOrdersPOParam.setOrderStatus(IntegralOrdersStatusEnum.UN_SHIPPED.getCode());
            }
            IntegralGoodsPOWithBLOBs integralGoodsPOWithBLOBs = this.integralGoodsPOMapper.selectByPrimaryKey(goodId);
            if (integralGoodsPOWithBLOBs.getGoodsType().equals(IntegralGoodsTypeEnum.COUPON.getCode())) {
                integralOrdersPOParam.setOrderStatus(IntegralOrdersStatusEnum.SIGN.getCode());
            }
            integralOrdersPOParam.setCashPayChannel(integralCashPayChannelEnum.getCode());
            result = this.integralOrdersPOMapper.updateByPrimaryKeySelective(integralOrdersPOParam);
        }
        return result;
    }

    public Integer payCouponSuccess(IntegralCouponPayRecordPO integralCouponPayRecordPO, String tranId) {
        Integer result = null;
        IntegralCouponPayRecordPO integralCouponPayRecordPOParam = new IntegralCouponPayRecordPO();
        integralCouponPayRecordPOParam.setId(integralCouponPayRecordPO.getId());
        integralCouponPayRecordPOParam.setTranId(tranId);
        result = this.integralCouponPayRecordPOMapper.updateByPrimaryKeySelective(integralCouponPayRecordPOParam);
        this.bizvaneInterface.payCouponSuccess(integralCouponPayRecordPO.getOrderId());
        return result;
    }

    public com.wmeimob.fastboot.bizvane.utils.response.ResponseData getFeight(IntegralOrderFeightVO integralOrderFeightVO) {
        Integer goodsId = Integer.valueOf(integralOrderFeightVO.getGoodsId());
        IntegralGoodsPOWithBLOBs integralGoodsPO = this.integralGoodsPOMapper.selectByPrimaryKey(goodsId);
        if (Objects.isNull(integralGoodsPO)) {
            return ResponseUtil.getFailedMsg((String)"\u8be5\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
        }
        integralOrderFeightVO.setDefaultFreight(String.valueOf(integralGoodsPO.getDefaultFreight()));
        integralOrderFeightVO.setTemplateId(integralOrderFeightVO.getTemplateId());
        BigDecimal feight = BigDecimal.ZERO;
        if (!IntegralOrderTypeEnum.RAISING.getCode().equals(integralOrderFeightVO.getOrderType())) {
            feight = this.handleFreigth(integralOrderFeightVO);
        }
        IntegralExpressTemplatePO integralExpressTemplatePO = this.integralExpressTemplatePOMapper.selectByPrimaryKey(Integer.valueOf(integralOrderFeightVO.getTemplateId()));
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("feight", feight);
        params.put("valuation", integralExpressTemplatePO.getValuation());
        return ResponseUtil.getSuccessData(params);
    }
}

