/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.mapper.IntegralConfigMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralUnionPayMchPO;
import com.wmeimob.fastboot.bizvane.po.IntegralWechatMchPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.IntegralCashPayService;
import com.wmeimob.fastboot.bizvane.service.IntegralConfigService;
import com.wmeimob.fastboot.bizvane.service.paygateway.AppletInfoService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.vo.skyworth.IntegralUnionPayMchVO;
import com.wmeimob.fastboot.bizvane.vo.skyworth.IntegralWeChatMchVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralConfigServiceImpl
implements IntegralConfigService {
    private static final Logger log = LoggerFactory.getLogger(IntegralConfigServiceImpl.class);
    private static final String COMMA = ",";
    @Resource
    private IntegralConfigMapper integralConfigMapper;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private IntegralCashPayService integralCashPayService;
    @Autowired
    private AppletInfoService appletInfoService;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    private static final String MINI_PROGRAM = "2";
    private static final String MEMBER_CENTER = "10";

    public ResponseData<IntegralConfig> addConfig(IntegralConfig config) {
        log.info("\u57fa\u672c\u914d\u7f6e\u65b0\u589e\u3002\u3002\u3002");
        InputValidator.checkEmpty((Object)config.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)config.getAwaitOrderDelivery(), (String)"\u5df2\u53d1\u8d27\u8ba2\u5355\u81ea\u52a8\u7b7e\u6536\u65f6\u95f4(\u5929)");
        InputValidator.checkEmpty((Object)config.getAwaitOrderReturnable(), (String)"\u5df2\u7b7e\u6536\u8ba2\u5355\u81ea\u52a8\u5173\u95ed\u9000\u6362\u65f6\u95f4(\u5929)");
        config.setGmtCreate(new Date());
        if (Integer.parseInt(config.getIsDeliverCheck()) == 1) {
            InputValidator.checkEmpty((Object)config.getDeliverAuditorMark(), (String)"\u53d1\u8d27\u5ba1\u6838\u4eba");
        }
        this.integralConfigMapper.insertSelective((Object)config);
        String appId = null;
        WxPublicPO memberInfoAppletInfo = this.appletInfoService.getMemberInfoAppletInfo(config.getMerchantId());
        if (memberInfoAppletInfo != null) {
            appId = memberInfoAppletInfo.getAppid();
        }
        config.setAppId(appId);
        ResponseData integralConfigResponseData = this.integralCashPayService.modifyPayMch(config);
        return integralConfigResponseData;
    }

    public ResponseData<IntegralConfig> updateConfig(IntegralConfig config) {
        log.info("\u57fa\u672c\u914d\u7f6e\u4fee\u6539\u3002\u3002\u3002{}", (Object)JSONObject.toJSONString((Object)config));
        InputValidator.checkEmpty((Object)config.getId(), (String)"\u57fa\u672c\u914d\u7f6e\u4e3b\u952e");
        InputValidator.checkEmpty((Object)config.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)config.getAwaitOrderDelivery(), (String)"\u5df2\u53d1\u8d27\u8ba2\u5355\u81ea\u52a8\u7b7e\u6536\u65f6\u95f4(\u5929)");
        InputValidator.checkEmpty((Object)config.getAwaitOrderReturnable(), (String)"\u5df2\u7b7e\u6536\u8ba2\u5355\u81ea\u52a8\u5173\u95ed\u9000\u6362\u65f6\u95f4(\u5929)");
        if (Integer.parseInt(config.getIsDeliverCheck()) == 1) {
            InputValidator.checkEmpty((Object)config.getDeliverAuditorMark(), (String)"\u53d1\u8d27\u5ba1\u6838\u4eba");
        }
        config.setGmtModified(new Date());
        this.integralConfigMapper.updateByPrimaryKey((Object)config);
        String appId = null;
        WxPublicPO memberInfoAppletInfo = this.appletInfoService.getMemberInfoAppletInfo(config.getMerchantId());
        if (memberInfoAppletInfo != null) {
            appId = memberInfoAppletInfo.getAppid();
        }
        config.setAppId(appId);
        ResponseData integralConfigResponseData = this.integralCashPayService.modifyPayMch(config);
        return integralConfigResponseData;
    }

    public IntegralConfig getConfig(Integer merchantId) {
        log.info("\u83b7\u53d6\u57fa\u672c\u914d\u7f6e,\u54c1\u724cid\u4e3a{}", (Object)merchantId);
        try {
            InputValidator.checkEmpty((Object)merchantId, (String)"\u5546\u6237id");
            Example example = new Example(IntegralConfig.class);
            example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
            IntegralConfig config = (IntegralConfig)this.integralConfigMapper.selectOneByExample((Object)example);
            if (config == null) {
                log.info("merchantId=[" + merchantId + "]\u67e5\u8be2\u7ed3\u679c\u4e3anull");
                return null;
            }
            if (config.isRefundSingle()) {
                String refundSingleCondition = config.getRefundSingleCondition();
                String[] strArray = refundSingleCondition.split(COMMA);
                List<String> stringList = Arrays.asList(strArray);
                config.setRefundSingleConditionList(stringList);
            }
            IntegralWechatMchPO weChatMch = this.integralCashPayService.getWeChatMch(merchantId);
            IntegralWeChatMchVO integralWeChatMchVO = null;
            if (weChatMch != null) {
                integralWeChatMchVO = new IntegralWeChatMchVO();
                BeanUtils.copyProperties((Object)weChatMch, (Object)integralWeChatMchVO);
            }
            config.setIntegralWeChatMchVO(integralWeChatMchVO);
            IntegralUnionPayMchPO unionPayMch = this.integralCashPayService.getUnionPayMch(merchantId);
            IntegralUnionPayMchVO integralUnionPayMchVO = null;
            if (unionPayMch != null) {
                integralUnionPayMchVO = new IntegralUnionPayMchVO();
                BeanUtils.copyProperties((Object)unionPayMch, (Object)integralUnionPayMchVO);
            }
            config.setIntegralUnionPayMchVO(integralUnionPayMchVO);
            return config;
        }
        catch (Exception e) {
            log.warn("IntegralConfigServiceImpl#getConfig\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
    }

    @Async
    public void updateIntegralConfig2Redis(Integer merchantId) {
        log.info("IntegralConfigServiceImpl#updateIntegralConfig2Redis#merchantId:{}", (Object)merchantId);
        IntegralConfig config = this.getConfig(merchantId);
        this.bizvaneInterface.updateIntegralConfig2Redis(config);
    }
}

