/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.IntegralClassify;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.mapper.IntegralClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.service.IntegralClassifyService;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralClassifyServiceImpl
implements IntegralClassifyService {
    private static final Logger log = LoggerFactory.getLogger(IntegralClassifyServiceImpl.class);
    @Resource
    private IntegralClassifyMapper integralClassifyMapper;
    @Resource
    private IntegralGoodsMapper integralGoodsMapper;

    public int add(IntegralClassify integralClassify) {
        Example nameExample = new Example(IntegralClassify.class);
        nameExample.createCriteria().andEqualTo("sysCompanyId", (Object)integralClassify.getSysCompanyId()).andEqualTo("name", (Object)integralClassify.getName()).andEqualTo("valid", (Object)Boolean.TRUE);
        List nameList = this.integralClassifyMapper.selectByExample((Object)nameExample);
        if (nameList.size() > 0) {
            throw new CustomException("\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Example noExample = new Example(IntegralClassify.class);
        noExample.createCriteria().andEqualTo("sysCompanyId", (Object)integralClassify.getSysCompanyId()).andEqualTo("classifyNo", (Object)integralClassify.getClassifyNo()).andEqualTo("valid", (Object)Boolean.TRUE);
        List noList = this.integralClassifyMapper.selectByExample((Object)noExample);
        if (noList.size() > 0) {
            throw new CustomException("\u5206\u7c7b\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        integralClassify.setGmtCreate(new Date());
        integralClassify.setValid(Boolean.TRUE);
        log.info("IntegralClassifyServiceImpl#add:{}", (Object)JSON.toJSONString((Object)integralClassify));
        int num = this.integralClassifyMapper.insert((Object)integralClassify);
        return num;
    }

    public int update(IntegralClassify integralClassify) {
        Example example = new Example(IntegralClassify.class);
        example.createCriteria().andEqualTo("sysCompanyId", (Object)integralClassify.getSysCompanyId()).andEqualTo("name", (Object)integralClassify.getName()).andNotEqualTo("id", (Object)integralClassify.getId()).andEqualTo("valid", (Object)Boolean.TRUE);
        List list = this.integralClassifyMapper.selectByExample((Object)example);
        if (list.size() > 0) {
            throw new CustomException("\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Example noExample = new Example(IntegralClassify.class);
        noExample.createCriteria().andEqualTo("sysCompanyId", (Object)integralClassify.getSysCompanyId()).andEqualTo("classifyNo", (Object)integralClassify.getClassifyNo()).andNotEqualTo("id", (Object)integralClassify.getId()).andEqualTo("valid", (Object)Boolean.TRUE);
        List noList = this.integralClassifyMapper.selectByExample((Object)noExample);
        if (noList.size() > 0) {
            throw new CustomException("\u5206\u7c7b\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        integralClassify.setGmtModified(new Date());
        integralClassify.setValid(Boolean.TRUE);
        log.info("IntegralClassifyServiceImpl#update:{}", (Object)JSON.toJSONString((Object)integralClassify));
        int num = this.integralClassifyMapper.updateByPrimaryKey((Object)integralClassify);
        return num;
    }

    public int delete(Integer id) {
        log.info("IntegralClassifyServiceImpl#delete:{}", (Object)id);
        try {
            IntegralClassify classify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)id);
            Example example = new Example(IntegralGoods.class);
            example.createCriteria().andEqualTo("merchantId", (Object)classify.getMerchantId()).andEqualTo("valid", (Object)true).andLike("classifyId", "%" + id + "%");
            List list = this.integralGoodsMapper.selectByExample((Object)example);
            if (list.size() > 0) {
                throw new CustomException("\u6b64\u5206\u7c7b\u5df2\u88ab\u5546\u54c1\u4f7f\u7528!");
            }
            IntegralClassify integralClassify = new IntegralClassify();
            integralClassify.setId(id);
            integralClassify.setValid(Boolean.FALSE);
            return this.integralClassifyMapper.updateByPrimaryKeySelective((Object)integralClassify);
        }
        catch (Exception e) {
            log.warn("IntegralClassifyServiceImpl#delete\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new CustomException(e.getMessage());
        }
    }

    public List<IntegralClassify> getList(Integer merchantId) {
        Example example = new Example(IntegralClassify.class);
        example.orderBy("sort").asc();
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)true);
        return this.integralClassifyMapper.selectByExample((Object)example);
    }

    public List<IntegralClassify> queryListByCompanyId(Long sysCompanyId) {
        Example example = new Example(IntegralClassify.class);
        example.orderBy("sort").asc();
        example.createCriteria().andEqualTo("sysCompanyId", (Object)sysCompanyId).andEqualTo("valid", (Object)true);
        return this.integralClassifyMapper.selectByExample((Object)example);
    }
}

