/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsClassifyPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsClassifyPO;
import com.wmeimob.fastboot.bizvane.po.GoodsClassifyPOExample;
import com.wmeimob.fastboot.bizvane.service.GoodsClassifyService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.GoodsClassifyShowVO;
import com.wmeimob.fastboot.bizvane.vo.PrimaryInfoVO;
import com.wmeimob.fastboot.bizvane.vo.SecondaryVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class GoodsClassifyServiceImpl
implements GoodsClassifyService {
    private static final Logger log = LoggerFactory.getLogger(GoodsClassifyServiceImpl.class);
    private static final Integer EXECUTE_PRIMARY = 1;
    private static final Integer EXECUTE_SECONDARY = 2;
    @Autowired
    private GoodsClassifyMapper goodsClassifyMapper;
    @Autowired
    private GoodsClassifyCustomMapper goodsClassifyCustomMapper;
    @Resource
    private GoodsClassifyPOMapper goodsClassifyPOMapper;

    public GoodsClassify[] findByAll(Integer merchantId) {
        Example example = new Example(GoodsClassify.class);
        example.orderBy("sort").desc();
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        List goodsClassifies = this.goodsClassifyMapper.selectByExample((Object)example);
        return goodsClassifies.toArray(new GoodsClassify[0]);
    }

    public List<GoodsClassify> selectListByPid(Integer merchantId, Integer id) {
        Example example = new Example(GoodsClassify.class);
        example.createCriteria().andEqualTo("pid", (Object)id).andEqualTo("merchantId", (Object)merchantId);
        return this.goodsClassifyMapper.selectByExample((Object)example);
    }

    public GoodsClassify add(GoodsClassify goodsClassify) {
        InputValidator.checkLengthRange((Object)goodsClassify.getName(), (int)0, (int)20, (String)"\u5206\u7c7b\u540d\u79f0");
        InputValidator.checkLengthRange((Object)goodsClassify.getCoding(), (int)0, (int)20, (String)"\u7f16\u7801");
        InputValidator.checkNumber((Integer)1, (Integer)10000, (Integer)goodsClassify.getSort(), (String)"\u6392\u5e8f\u503c");
        if (InputValidator.countChinese((String)goodsClassify.getCoding()) > 0) {
            throw new MallAdminException("\u5206\u7c7b\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u4e2d\u6587");
        }
        if (goodsClassify.getPid() != 0) {
            try {
                InputValidator.checkEmpty((Object)goodsClassify.getPic(), (String)"\u5206\u7c7b\u56fe\u7247");
            }
            catch (Exception e) {
                throw new MallAdminException(e.getMessage());
            }
            GoodsClassify classify = (GoodsClassify)this.goodsClassifyMapper.selectByPrimaryKey((Object)goodsClassify.getPid());
            if (classify.getPid() != 0) {
                throw new MallAdminException("\u5206\u7c7b\u6700\u591a\u4e3a\u4e8c\u7ea7\u5206\u7c7b");
            }
        }
        Example example = new Example(GoodsClassify.class);
        example.createCriteria().andEqualTo("name", (Object)goodsClassify.getName()).andEqualTo("merchantId", (Object)goodsClassify.getMerchantId());
        List goodsClassifyList = this.goodsClassifyMapper.selectByExample((Object)example);
        if (goodsClassifyList.size() > 0) {
            throw new MallAdminException("\u5206\u7c7b\u540d\u79f0\u91cd\u590d");
        }
        Example example2 = new Example(GoodsClassify.class);
        example2.createCriteria().andEqualTo("coding", (Object)goodsClassify.getCoding()).andEqualTo("merchantId", (Object)goodsClassify.getMerchantId());
        List goodsClassifyList2 = this.goodsClassifyMapper.selectByExample((Object)example2);
        if (goodsClassifyList2.size() > 0) {
            throw new MallAdminException("\u5206\u7c7b\u7f16\u7801\u91cd\u590d");
        }
        goodsClassify.setGmtCreate(new Date());
        int insert = this.goodsClassifyMapper.insertSelective((Object)goodsClassify);
        return goodsClassify;
    }

    public int update(GoodsClassify goodsClassify) {
        InputValidator.checkLengthRange((Object)goodsClassify.getName(), (int)0, (int)20, (String)"\u5206\u7c7b\u540d\u79f0");
        InputValidator.checkLengthRange((Object)goodsClassify.getCoding(), (int)0, (int)20, (String)"\u7f16\u7801");
        InputValidator.checkNumber((Integer)1, (Integer)10000, (Integer)goodsClassify.getSort(), (String)"\u6392\u5e8f\u503c");
        if (InputValidator.countChinese((String)goodsClassify.getCoding()) > 0) {
            throw new MallAdminException("\u5206\u7c7b\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u4e2d\u6587");
        }
        if (goodsClassify.getPid() != 0) {
            InputValidator.checkEmpty((Object)goodsClassify.getPic(), (String)"\u5206\u7c7b\u56fe\u7247");
        }
        Example example = new Example(GoodsClassify.class);
        example.createCriteria().andEqualTo("name", (Object)goodsClassify.getName()).andEqualTo("merchantId", (Object)goodsClassify.getMerchantId()).andNotEqualTo("id", (Object)goodsClassify.getId());
        List goodsClassifyList = this.goodsClassifyMapper.selectByExample((Object)example);
        if (goodsClassifyList.size() > 0) {
            throw new MallAdminException("\u5206\u7c7b\u540d\u79f0\u91cd\u590d");
        }
        goodsClassify.setGmtModified(new Date());
        return this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)goodsClassify);
    }

    public int delete(Integer merchantId, GoodsClassify goodsClassify) {
        Integer integer;
        GoodsClassify classify = (GoodsClassify)this.goodsClassifyMapper.selectByPrimaryKey((Object)goodsClassify.getId());
        if (classify.getPid() == 0) {
            Example example = new Example(GoodsClassify.class);
            example.createCriteria().andEqualTo("pid", (Object)goodsClassify.getId());
            List classifyList = this.goodsClassifyMapper.selectByExample((Object)example);
            if (classifyList.size() > 0) {
                throw new MallAdminException("\u8bf7\u5148\u5220\u9664\u4e8c\u7ea7\u5206\u7c7b");
            }
        }
        if ((integer = this.goodsClassifyCustomMapper.selectCountGoodsByclassifyId(goodsClassify.getId(), merchantId)) > 0) {
            throw new MallAdminException("\u5206\u7c7b\u4e0b\u8fd8\u6709\u5546\u54c1\uff0c\u5220\u9664\u5931\u8d25");
        }
        return this.goodsClassifyMapper.deleteByPrimaryKey((Object)goodsClassify.getId());
    }

    public ResponseData<Boolean> modifyShow(GoodsClassifyShowVO goodsClassifyShow) {
        log.info("GoodsClassifyServiceImpl#modifyShow:{}", (Object)JSON.toJSONString((Object)goodsClassifyShow));
        ResponseData responseData = new ResponseData();
        responseData.setData((Object)Boolean.FALSE);
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        try {
            Integer merchantId = goodsClassifyShow.getMerchantId();
            if (merchantId == null) {
                responseData.setMessage("The merchantId must be not empty!");
                return responseData;
            }
            Integer executeType = goodsClassifyShow.getExecuteType();
            if (executeType == null) {
                responseData.setMessage("The executeType must be not empty!");
                return responseData;
            }
            PrimaryInfoVO primaryClassify = goodsClassifyShow.getPrimaryClassify();
            if (primaryClassify == null) {
                responseData.setMessage("The primaryClassify must be not empty!");
                return responseData;
            }
            Date modifyDate = new Date();
            GoodsClassifyPO updateGoodsClassifyPo = new GoodsClassifyPO();
            if (EXECUTE_PRIMARY.equals(executeType)) {
                Integer classifyId = primaryClassify.getClassifyId();
                Integer isShow = primaryClassify.getIsShow();
                if (classifyId == null || isShow == null) {
                    responseData.setMessage("\u4e00\u7ea7\u5206\u7c7bid\u548c\u5f00\u5173\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    return responseData;
                }
                updateGoodsClassifyPo.setId(classifyId);
                List goodsClassifyPoList = this.getSecondaryClassifyListById(merchantId, classifyId);
                updateGoodsClassifyPo.setIsShow(isShow == 1 ? Boolean.TRUE : Boolean.FALSE);
                if (!CollectionUtils.isEmpty((Collection)goodsClassifyPoList)) {
                    goodsClassifyPoList.forEach(goodsClassify -> {
                        GoodsClassifyPO goodsClassifyPo2 = new GoodsClassifyPO();
                        goodsClassifyPo2.setId(goodsClassify.getId());
                        goodsClassifyPo2.setIsShow(isShow == 1 ? Boolean.TRUE : Boolean.FALSE);
                        goodsClassifyPo2.setGmtModified(modifyDate);
                        this.goodsClassifyPOMapper.updateByPrimaryKeySelective(goodsClassifyPo2);
                    });
                }
                updateGoodsClassifyPo.setGmtModified(modifyDate);
                this.goodsClassifyPOMapper.updateByPrimaryKeySelective(updateGoodsClassifyPo);
            }
            if (EXECUTE_SECONDARY.equals(executeType)) {
                GoodsClassifyPO goodsClassifyUpdate;
                GoodsClassifyPO goodsPrimaryClassifyPO;
                SecondaryVO secondaryClassify = goodsClassifyShow.getSecondaryClassify();
                Integer classifyId = secondaryClassify.getClassifyId();
                Integer isShow = secondaryClassify.getIsShow();
                updateGoodsClassifyPo.setIsShow(isShow == 1 ? Boolean.TRUE : Boolean.FALSE);
                updateGoodsClassifyPo.setId(classifyId);
                updateGoodsClassifyPo.setGmtModified(modifyDate);
                this.goodsClassifyPOMapper.updateByPrimaryKeySelective(updateGoodsClassifyPo);
                Integer classifyPid = secondaryClassify.getClassifyPid();
                List secondaryClassifyListByPid = this.getSecondaryClassifyListById(merchantId, classifyPid);
                int count = 0;
                for (GoodsClassifyPO secondaryClassifyPo : secondaryClassifyListByPid) {
                    if (secondaryClassifyPo.getIsShow().booleanValue()) {
                        ++count;
                    }
                    if (count <= 0) continue;
                    break;
                }
                if ((goodsPrimaryClassifyPO = this.goodsClassifyPOMapper.selectByPrimaryKey(classifyPid)) == null) {
                    responseData.setMessage("\u505a\u4e8c\u7ea7\u5206\u7c7b\u4fee\u6539\u65f6\u6ca1\u6709");
                    responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                    responseData.setData((Object)Boolean.TRUE);
                    return responseData;
                }
                if (count > 0) {
                    if (!goodsPrimaryClassifyPO.getIsShow().booleanValue()) {
                        goodsClassifyUpdate = new GoodsClassifyPO();
                        goodsClassifyUpdate.setId(goodsPrimaryClassifyPO.getId());
                        goodsClassifyUpdate.setIsShow(Boolean.TRUE);
                        goodsClassifyUpdate.setGmtModified(modifyDate);
                        this.goodsClassifyPOMapper.updateByPrimaryKeySelective(goodsClassifyUpdate);
                    }
                } else if (goodsPrimaryClassifyPO.getIsShow().booleanValue()) {
                    goodsClassifyUpdate = new GoodsClassifyPO();
                    goodsClassifyUpdate.setId(goodsPrimaryClassifyPO.getId());
                    goodsClassifyUpdate.setIsShow(Boolean.FALSE);
                    goodsClassifyUpdate.setGmtModified(modifyDate);
                    this.goodsClassifyPOMapper.updateByPrimaryKeySelective(goodsClassifyUpdate);
                }
            }
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)Boolean.TRUE);
            return responseData;
        }
        catch (Exception e) {
            log.warn("GoodsClassifyServiceImpl#modifyShow\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage(), (Throwable)e);
        }
    }

    private List<GoodsClassifyPO> getSecondaryClassifyListById(Integer merchantId, Integer classifyId) {
        GoodsClassifyPOExample example = new GoodsClassifyPOExample();
        example.createCriteria().andValidEqualTo(Boolean.TRUE).andPidEqualTo(classifyId).andMerchantIdEqualTo(merchantId);
        return this.goodsClassifyPOMapper.selectByExample(example);
    }
}

