/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.autoconfigure.qiniu.QiNiuProperties;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.entity.LogisticCompany;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralRefundOrderMapper;
import com.wmeimob.fastboot.bizvane.mapper.LogisticInfoMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.ExcelDisposeService;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class ExcelDisposeServiceImpl
implements ExcelDisposeService {
    private static final Logger log = LoggerFactory.getLogger(ExcelDisposeServiceImpl.class);
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private IntegralGoodsMapper integralGoodsMapper;
    @Autowired
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;
    @Autowired
    private IntegralOrdersMapper integralOrdersMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private QiNiuProperties qiNiuProperties;
    @Autowired
    private LogisticInfoMapper logisticInfoMapper;
    @Autowired
    private IntegralRefundOrderMapper integralRefundOrderMapper;
    private final String reg = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
    @Autowired
    private IntegralOrdersService integralOrdersService;

    public List<IntegralGoods> integralGoodsExport(Integer merchantId) {
        InputValidator.checkEmpty((Object)merchantId, (String)"\u5546\u6237\u53f7");
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)true);
        List list = this.integralGoodsMapper.selectByExample((Object)example);
        this.parseList(list);
        return list;
    }

    public List<IntegralOrders> integralOrdersExport(IntegralOrders integralOrders) {
        List list = this.integralOrdersMapper.getOrders(integralOrders);
        log.info("\u5bfc\u51fa\u7684\u79ef\u5206\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)list));
        list.forEach(order -> {
            order.setShippingName(this.parseNull(order.getShippingName()));
            order.setShippingMobile(this.parseNull(order.getShippingMobile()));
            StringBuffer sb = new StringBuffer();
            sb.append(this.parseNull(order.getShippingProvince())).append(this.parseNull(order.getShippingCity())).append(this.parseNull(order.getShippingDistrict())).append(this.parseNull(order.getShippingAddress()));
            order.setShowAddress(sb.toString());
            String orderStatus = order.getOrderStatus();
            if ("0".equals(order.getOrderType())) {
                order.setShippingModeDetail("\u5bc4\u8d27\u5230\u5bb6");
                order.setStoreCode(null);
                order.setSelfPickTime(null);
            } else if ("1".equals(order.getOrderType())) {
                order.setShippingModeDetail("\u5bc4\u8d27\u5230\u5e97(" + order.getOrderStoreName() + ")");
                if (order.getSelfPickTime() != null) {
                    order.setSelfPickTimeStr(DateUtil.format((Date)order.getSelfPickTime(), (String)DateUtil.ymd));
                }
            }
            if (StringUtils.isEmpty((Object)order.getShippingMobile())) {
                order.setShippingMobile(order.getMemberPhone());
            }
            if (StringUtils.isEmpty((Object)order.getDistributorName())) {
                order.setDistributorName(this.bizvaneInterface.getIntegralShopGetDistributorName(order.getMemberCode()));
            }
            switch (orderStatus) {
                case "0": {
                    order.setOrderStatus("\u672a\u53d1\u8d27");
                    break;
                }
                case "1": {
                    order.setOrderStatus("\u5df2\u53d1\u8d27");
                    break;
                }
                case "2": {
                    order.setOrderStatus("\u5df2\u7b7e\u6536");
                    break;
                }
                case "3": {
                    order.setOrderStatus("\u5df2\u5173\u95ed");
                    break;
                }
                case "4": {
                    order.setOrderStatus("\u5df2\u9000\u8d27");
                    break;
                }
                case "5": {
                    order.setOrderStatus("\u9000\u8d27\u4e2d");
                    break;
                }
                case "6": {
                    order.setOrderStatus("\u9000\u8d27\u5931\u8d25");
                    break;
                }
                case "7": {
                    order.setOrderStatus("\u5f85\u5ba1\u6838");
                    break;
                }
                case "8": {
                    order.setOrderStatus("\u5f85\u652f\u4ed8");
                }
            }
        });
        return list;
    }

    private String parseNull(String parse) {
        if (parse == null || "undefined".equals(parse) || "null".equals(parse)) {
            return "";
        }
        return parse;
    }

    public RestResult importExcel(String qiuniuUrl) throws IOException {
        log.info("ExcelDisposeServiceImpl#importExcel#qiuniuUrl:{}", (Object)qiuniuUrl);
        URL url = new URL(qiuniuUrl.replace("https", "http"));
        InputStream is = url.openConnection().getInputStream();
        int failCount = 0;
        int successCount = 0;
        try {
            HSSFWorkbook wb = null;
            try {
                wb = new HSSFWorkbook(is);
            }
            catch (Exception e) {
                wb = new XSSFWorkbook(is);
            }
            Sheet sheet = wb.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            Row row = null;
            for (int i = 1; i <= lastRowNum; ++i) {
                row = sheet.getRow(i);
                if (row == null) continue;
                for (int j = 0; j < row.getLastCellNum(); ++j) {
                    Cell cell = row.getCell(j);
                    if (cell == null) continue;
                    cell.setCellType(1);
                }
                String orderNo = row.getCell(0) == null ? "" : row.getCell(0).getStringCellValue().trim();
                String company = row.getCell(1) == null ? "" : row.getCell(1).getStringCellValue().trim();
                String num = row.getCell(2) == null ? "" : row.getCell(2).getStringCellValue().trim();
                Pattern p = Pattern.compile("[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]");
                if (orderNo.isEmpty() && company.isEmpty() && num.isEmpty() && p.matcher(num).find()) continue;
                String code = (String)this.stringRedisTemplate.opsForValue().get((Object)("integralLogistic" + company));
                if (code == null) {
                    Example example = new Example(LogisticCompany.class);
                    example.createCriteria().andEqualTo("name", (Object)company);
                    LogisticCompany com = (LogisticCompany)this.logisticInfoMapper.selectOneByExample((Object)example);
                    if (com == null) {
                        ++failCount;
                        continue;
                    }
                    code = com.getCode();
                    this.stringRedisTemplate.opsForValue().set((Object)("integralLogistic" + com.getName()), (Object)com.getCode());
                }
                IntegralOrders integralOrders = null;
                try {
                    IntegralOrdersPO integralOrder = this.integralOrdersService.findByOrderNo(orderNo);
                    integralOrders = new IntegralOrders();
                    integralOrders.setId(integralOrder.getId());
                    integralOrders.setCourierNo(num);
                    integralOrders.setCourierCompanyName(company);
                    integralOrders.setCourierCompanyCode(code);
                    integralOrders.setSendGoodTime(new Date());
                    integralOrders.setOrderStatus(IntegralOrdersStatusEnum.SHIPPED.getCode());
                    IntegralOrders result = this.integralOrdersService.setCourier(integralOrders);
                    ++successCount;
                    continue;
                }
                catch (Exception e) {
                    log.info("integralOrdersService.setCourier.error:{}", (Object)ExceptionUtils.getMessage((Throwable)e));
                    ++failCount;
                }
            }
        }
        catch (Exception e) {
            log.error("ExcelDisposeServiceImpl#importExcel:error:{}", (Object)e.getMessage());
            String result = "\u5bfc\u5165\u6210\u529f:" + successCount + "\u6761,\u5931\u8d25:" + failCount + "\u6761";
            return RestResult.fail((String)result);
        }
        String result = "\u5bfc\u5165\u6210\u529f:" + successCount + "\u6761,\u5931\u8d25:" + failCount + "\u6761";
        if (failCount > 0) {
            return RestResult.fail((String)result);
        }
        return RestResult.success((Object)result);
    }

    public List<IntegralRefundOrder> refundDisposeExport(IntegralRefundOrder integralRefundOrder) {
        List list = this.integralRefundOrderMapper.getRefundOrders(integralRefundOrder);
        if (list.size() > 0) {
            for (IntegralRefundOrder refundOrder : list) {
                if ("0".equals(refundOrder.getAuditStatus()) && StringUtils.isEmpty((Object)refundOrder.getRefundStatus())) {
                    refundOrder.setOrderType("\u5f85\u5ba1\u6838");
                    continue;
                }
                if (!StringUtils.isEmpty((Object)refundOrder.getRefundStatus()) && "0".equals(refundOrder.getRefundStatus())) {
                    refundOrder.setOrderType("\u5f85\u9000\u6b3e");
                    continue;
                }
                if (!StringUtils.isEmpty((Object)refundOrder.getRefundStatus()) && "1".equals(refundOrder.getRefundStatus())) {
                    refundOrder.setOrderType("\u5df2\u9000\u6b3e");
                    continue;
                }
                if (!"2".equals(refundOrder.getAuditStatus())) continue;
                refundOrder.setOrderType("\u5df2\u9a73\u56de");
            }
        }
        return list;
    }

    private List<IntegralGoods> parseList(List<IntegralGoods> list) {
        if (list.size() > 0) {
            for (IntegralGoods goods : list) {
                Example skuExample = new Example(IntegralGoodsSku.class);
                skuExample.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("valid", (Object)Boolean.TRUE);
                List skuList = this.integralGoodsSkuMapper.selectByExample((Object)skuExample);
                if (skuList.size() > 0) {
                    int stock = 0;
                    for (IntegralGoodsSku sku : skuList) {
                        stock += sku.getStock().intValue();
                    }
                    goods.setTotalStock(Integer.valueOf(stock));
                } else {
                    goods.setTotalStock(Integer.valueOf(0));
                }
                if (goods.getShelf().booleanValue()) {
                    goods.setShelfName("\u4e0a\u67b6");
                    continue;
                }
                goods.setShelfName("\u4e0b\u67b6");
            }
        }
        return list;
    }
}

