/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.newseckill;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityStatus;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityService;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.ActivityRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.CheckIfDeductRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SecKillActivityConfigReplaceRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityDetailResponseVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityDisableRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsDTO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsSkuDTO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivitySearchRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivitySearchResponseVO;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/seckill/activity"})
public class SeckillActivityController {
    private static final Logger log = LoggerFactory.getLogger(SeckillActivityController.class);
    @Autowired
    private SeckillActivityService seckillActivityService;
    @Autowired
    private LoginUtil loginUtil;
    @Autowired
    private HttpServletRequest request;

    @PostMapping(value={"/querySecKillActivityConfigList"})
    public ResponseData<SeckillActivitySearchResponseVO> querySecKillActivityConfigList(@RequestBody SeckillActivitySearchRequestVO requestVO) {
        PageInfo result = this.seckillActivityService.querySecKillActivityConfigList(requestVO);
        return ResponseUtil.getSuccessData((Object)result);
    }

    @PostMapping(value={"/checkOverlapGoods"})
    public ResponseData<List<String>> checkOverlapGoods(List<Integer> goodsIds) {
        return ResponseUtil.getSuccessData((Object)this.seckillActivityService.checkOverlapGoods(goodsIds));
    }

    @PostMapping(value={"/addSecKillActivityConfig"})
    public ResponseData<List> addSecKillActivityConfig(@RequestHeader(value="sysBrandId") Integer merchantId, @RequestBody @Valid SecKillActivityConfigReplaceRequestVO requestVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseUtil.getFailedData((Object)false, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        LoginUser loginUser = this.loginUtil.getLoginUser(this.request);
        requestVO.setMerchantId(merchantId);
        requestVO.setLoginUser(loginUser);
        requestVO.setSysCompanyId(loginUser.getCompanyId());
        return this.seckillActivityService.addSecKillActivityConfig(requestVO);
    }

    @PostMapping(value={"/updateSecKillActivityConfig"})
    public ResponseData<Boolean> updateSecKillActivityConfig(@RequestHeader(value="sysBrandId") Integer merchantId, @RequestBody @Valid SecKillActivityConfigReplaceRequestVO requestVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseUtil.getFailedData((Object)false, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        LoginUser loginUser = this.loginUtil.getLoginUser(this.request);
        requestVO.setMerchantId(merchantId);
        requestVO.setLoginUser(loginUser);
        requestVO.setSysCompanyId(loginUser.getCompanyId());
        return this.seckillActivityService.updateSecKillActivityConfig(requestVO);
    }

    @PostMapping(value={"/querySecKillActivityGoods"})
    public ResponseData<SeckillActivityGoodsDTO> querySecKillActivityGoods(@RequestHeader(value="sysBrandId") Integer merchantId, @RequestBody SeckillActivityGoodsRequestVO requestVO) {
        try {
            PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
            requestVO.setMerchantId(merchantId);
            List list = this.seckillActivityService.querySecKillActivityGoods(requestVO);
            return ResponseUtil.getSuccessData((Object)new PageInfo(list));
        }
        catch (Exception e) {
            return ResponseUtil.getFailedData((Object)false, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/querySecKillSkuDetail"})
    public ResponseData<SeckillActivityGoodsSkuDTO> querySecKillSkuDetail(@RequestParam(value="goodsId") Integer goodsId, @RequestParam(value="activityCode", required=false) String activityCode) {
        try {
            List data = this.seckillActivityService.querySecKillSkuDetail(activityCode, goodsId);
            return ResponseUtil.getSuccessData((Object)data);
        }
        catch (Exception e) {
            return ResponseUtil.getFailedData((Object)false, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/secKillActivityDetail"})
    public ResponseData<SeckillActivityDetailResponseVO> secKillActivityDetail(@RequestParam(value="activityCode") String activityCode) {
        return this.seckillActivityService.secKillActivityDetail(activityCode);
    }

    @PostMapping(value={"/disableActivity"})
    public ResponseData<SeckillActivityDetailResponseVO> disableActivity(@RequestBody SeckillActivityDisableRequestVO requestVO) {
        LoginUser loginUser = this.loginUtil.getLoginUser(this.request);
        requestVO.setUser(loginUser);
        return ResponseUtil.getSuccessData((Object)this.seckillActivityService.disableActivity(requestVO));
    }

    @PostMapping(value={"/queryActiveActivities"})
    public ResponseData<PageInfo<SeckillActivitySearchResponseVO>> queryActiveActivities(@RequestHeader(value="sysBrandId") Integer merchantId, @RequestBody ActivityRequestVO requestVO) {
        requestVO.setMerchantId(merchantId);
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        requestVO.setStatuses((List)Lists.newArrayList((Object[])new Integer[]{SeckillActivityStatus.HAVE_NOT_START.getCode(), SeckillActivityStatus.ON_GOING.getCode()}));
        List result = this.seckillActivityService.queryActivities(requestVO, true, true);
        return ResponseUtil.getSuccessData((Object)new PageInfo(result));
    }

    @PostMapping(value={"/checkIfDeduct"})
    public ResponseData<Boolean> checkIfDeduct(@RequestBody @Valid CheckIfDeductRequestVO requestVO) {
        return ResponseUtil.getSuccessData((Object)this.seckillActivityService.checkIfDeduct(requestVO));
    }
}

