/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.enums.seckill.MarketActivitySecKillStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsSecKillStatisticalByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsSecKillVisitRecordPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityStatisticalByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsSecKillStatisticalListPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivitySecKillStatisticalDetailSearchPO;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillStatisticalService;
import com.wmeimob.fastboot.bizvane.utils.StringChangeChar;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodsStatisticalListSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillStatisticalDetailSearchRequestVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.util.StringUtil;

@Service
public class MarketActivitySecKillStatisticalServiceImpl
implements MarketActivitySecKillStatisticalService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivitySecKillStatisticalServiceImpl.class);
    @Resource
    private MarketActivityStatisticalByDesignerPOMapper marketActivityStatisticalByDesignerPOMapper;
    @Resource
    private MarketActivityGoodsSecKillStatisticalByDesignerPOMapper goodsSecKillStatisticalByDesignerPOMapper;
    @Resource
    private MarketActivityGoodsSecKillVisitRecordPOMapper goodsSecKillVisitRecordPOMapper;
    @Resource
    private MarketActivityPOMapper marketActivityPOMapper;

    @Override
    public ResponseData findStatisticalDetail(MarketActivitySecKillStatisticalDetailSearchRequestVO vo) {
        log.info("MarketActivitySecKillStatisticalServiceImpl findStatisticalDetail:{}", JSON.toJSON((Object)((Object)vo)));
        ResponseData responseData = new ResponseData();
        List detailSearchPOS = this.marketActivityStatisticalByDesignerPOMapper.selectMarketActivitySecKillStatistical(vo.getMarketActivityId());
        if (detailSearchPOS == null || detailSearchPOS.size() == 0) {
            log.info("\u7edf\u8ba1\u6570\u636e\u672a\u521b\u5efa");
            return ResponseUtil.getFailedMsg((String)"\u7edf\u8ba1\u6570\u636e\u672a\u521b\u5efa");
        }
        if (detailSearchPOS.size() > 1) {
            log.info("\u8be5\u6d3b\u52a8\u5b58\u5728\u591a\u4e2a\u7edf\u8ba1\u6570\u636e");
            return ResponseUtil.getFailedMsg((String)"\u8be5\u6d3b\u52a8\u5b58\u5728\u591a\u4e2a\u7edf\u8ba1\u6570\u636e");
        }
        Date today = new Date();
        for (MarketActivitySecKillStatisticalDetailSearchPO x : detailSearchPOS) {
            MarketActivityPO marketActivityPo = this.marketActivityPOMapper.selectByPrimaryKey(x.getMarketActivityId());
            if (MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode().equals(marketActivityPo.getActivityStatusValue())) {
                x.setActivityStatusStr(MarketActivitySecKillStatusEnum.HAVE_NOT_START.getMessage());
            } else if (MarketActivitySecKillStatusEnum.ON_GOING.getCode().equals(marketActivityPo.getActivityStatusValue())) {
                x.setActivityStatusStr(MarketActivitySecKillStatusEnum.ON_GOING.getMessage());
            } else if (MarketActivitySecKillStatusEnum.HAS_BEEN_STOP.getCode().equals(marketActivityPo.getActivityStatusValue())) {
                x.setActivityStatusStr(MarketActivitySecKillStatusEnum.HAS_BEEN_STOP.getMessage());
            } else if (MarketActivitySecKillStatusEnum.HAS_ENDED.getCode().equals(marketActivityPo.getActivityStatusValue())) {
                x.setActivityStatusStr(MarketActivitySecKillStatusEnum.HAS_ENDED.getMessage());
            } else {
                x.setActivityStatusStr("\u975e\u6b63\u5e38\u72b6\u6001");
            }
            if (x.getMarketActivityStatisticalPayNum() == null || x.getMarketActivityStatisticalPayNum() == 0 || x.getMarketActivityStatisticalVisitNum() == 0 || x.getMarketActivityStatisticalVisitNum() == null) {
                x.setSearchPayRate(BigDecimal.ZERO);
                continue;
            }
            BigDecimal payNum = new BigDecimal(x.getMarketActivityStatisticalPayNum());
            BigDecimal visNum = new BigDecimal(x.getMarketActivityStatisticalVisitNum() == null ? 0 : x.getMarketActivityStatisticalVisitNum());
            x.setSearchPayRate(payNum.divide(visNum, 2, RoundingMode.HALF_DOWN).multiply(new BigDecimal(100)));
        }
        responseData.setData(detailSearchPOS.get(0));
        return responseData;
    }

    @Override
    public PageInfo<MarketActivityGoodsSecKillStatisticalListPO> findSecKillGoodsStatisticalListByStatisticalId(MarketActivitySecKillGoodsStatisticalListSearchRequestVO vo, Boolean pageJudge) {
        List marketActivityGoodsSecKillStatisticalListPOS;
        log.info("MarketActivitySecKillStatisticalServiceImpl findSecKillGoodsStatisticalListByStatisticalId:{}", JSON.toJSON((Object)((Object)vo)));
        String orderByClause = null;
        MarketActivityGoodsSecKillStatisticalListPO searchPo = new MarketActivityGoodsSecKillStatisticalListPO();
        searchPo.setGoodsName(vo.getGoodsName());
        searchPo.setGoodsNo(vo.getGoodsNo());
        searchPo.setOrderByClause(orderByClause);
        searchPo.setMarketActivityStatisticalId(vo.getMarketActivityStatisticalId());
        PageInfo pageInfo = new PageInfo();
        if (pageJudge.equals(Boolean.TRUE)) {
            PageHelper.startPage((int)vo.getPageIndex(), (int)vo.getPageSize());
            if (!StringUtil.isEmpty((String)vo.getOrderStr())) {
                String underLinedStr = StringChangeChar.camelToUnderline((String)vo.getOrderStr(), (Integer)1);
                orderByClause = underLinedStr + "  " + vo.getOrderType();
                PageHelper.orderBy((String)orderByClause);
            }
            marketActivityGoodsSecKillStatisticalListPOS = this.goodsSecKillStatisticalByDesignerPOMapper.selectGoodsSecKillStatisticalByMainStatisticalId(searchPo);
            pageInfo = new PageInfo(marketActivityGoodsSecKillStatisticalListPOS);
        } else {
            marketActivityGoodsSecKillStatisticalListPOS = this.goodsSecKillStatisticalByDesignerPOMapper.selectGoodsSecKillStatisticalByMainStatisticalId(searchPo);
            pageInfo.setList(marketActivityGoodsSecKillStatisticalListPOS);
        }
        for (MarketActivityGoodsSecKillStatisticalListPO po : pageInfo.getList()) {
            Integer goodsStock = this.goodsSecKillStatisticalByDesignerPOMapper.selectGoodsStockFromGoods(po.getMarketActivityGoodsSeckillStatisticalId());
            if (null == goodsStock) {
                goodsStock = 0;
            }
            log.info("\u5546\u54c1\u7edf\u8ba1id:{} \u79d2\u6740\u5e93\u5b58:{} \u5b9e\u9645\u5546\u54c1\u5e93\u5b58:{}", new Object[]{po.getMarketActivityGoodsSeckillStatisticalId(), po.getActuallyStock(), goodsStock});
            if (po.getActuallyStock() > goodsStock) {
                po.setActuallyStock(goodsStock);
            }
            if (po.getVisitPayRate() != null) {
                po.setVisitPayRate(po.getVisitPayRate().multiply(new BigDecimal(100)).setScale(0, 4));
                continue;
            }
            po.setVisitPayRate(BigDecimal.ZERO);
        }
        return pageInfo;
    }
}

