/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.seckill.BrandUserDTO;
import com.wmeimob.fastboot.bizvane.dto.seckill.MarketActivitySecKillAddDTO;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.enums.MarketActivityEnum;
import com.wmeimob.fastboot.bizvane.enums.seckill.MarketActivitySecKillStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsSecKillPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityMomentPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsSecKillPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsSecKillPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityMomentPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityStatisticalPO;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivityGoodsSecKillBuilderService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillBuilderService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivityStatisticalBuilderService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodsModifyVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillModifyRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillSearchRequestVO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MarketActivitySecKillServiceImpl
implements MarketActivitySecKillService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivitySecKillServiceImpl.class);
    @Resource
    private MarketActivityPOMapper marketActivityPOMapper;
    @Autowired
    private MarketActivitySecKillBuilderService marketActivitySecKillBuilderService;
    @Autowired
    private MarketActivityGoodsSecKillBuilderService marketActivityGoodsSecKillBuilderService;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;
    @Autowired
    private MarketActivityStatisticalBuilderService marketActivityStatisticalBuilderService;
    @Resource
    private MarketActivityMomentPOMapper marketActivityMomentPOMapper;
    @Resource
    private MarketActivityGoodsSecKillPOMapper marketActivityGoodsSecKillPOMapper;

    @Override
    public PageInfo<MarketActivityPO> queryMarketActivitySecKillListByCondition(MarketActivitySecKillSearchRequestVO requestVO, Integer merchantId) {
        String marketActivityName = requestVO.getMarketActivityName();
        String marketActivityNum = requestVO.getMarketActivityNum();
        Integer marketActivityStatus = requestVO.getMarketActivityStatus();
        Date createDate = requestVO.getCreateDate();
        Date marketActivityStartTime = requestVO.getMarketActivityStartTime();
        Date marketActivityEndTime = requestVO.getMarketActivityEndTime();
        MarketActivityPOExample marketActivityPOExample = new MarketActivityPOExample();
        marketActivityPOExample.setOrderByClause("activity_end_time desc");
        MarketActivityPOExample.Criteria criteria = marketActivityPOExample.createCriteria();
        criteria.andMerchantIdEqualTo(merchantId);
        criteria.andActivityTypeEqualTo(MarketActivityEnum.SEC_KILL.getType().toString());
        criteria.andValidEqualTo(Boolean.TRUE);
        if (StringUtils.isNotBlank((CharSequence)marketActivityName)) {
            criteria.andActivityNameLike("%" + marketActivityName + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)marketActivityNum)) {
            criteria.andActivityNoEqualTo(marketActivityNum);
        }
        if (marketActivityStatus != null) {
            criteria.andActivityStatusValueEqualTo(marketActivityStatus);
        }
        if (createDate != null) {
            Date startDateOfDay = DateUtil.getStartDateOfDay((Date)createDate);
            Date endDateOfDay = DateUtil.getEndDateOfDay((Date)createDate);
            criteria.andGmtCreateBetween(startDateOfDay, endDateOfDay);
        }
        if (marketActivityStartTime != null) {
            criteria.andActivityBeginTimeGreaterThanOrEqualTo(marketActivityStartTime);
        }
        if (marketActivityEndTime != null) {
            criteria.andActivityEndTimeLessThanOrEqualTo(marketActivityEndTime);
        }
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        List marketActivityPOS = this.marketActivityPOMapper.selectByExample(marketActivityPOExample);
        PageInfo marketActivityPOPageInfo = new PageInfo(marketActivityPOS);
        return marketActivityPOPageInfo;
    }

    @Override
    public Integer stopMarketActivitySecKill(Integer marketActivityId, Integer merchantId) {
        log.info("stopMarketActivitySecKill marketActivityId :{}", (Object)marketActivityId);
        MarketActivityPO marketActivityPO = new MarketActivityPO();
        marketActivityPO.setId(marketActivityId);
        marketActivityPO.setGmtModified(new Date());
        marketActivityPO.setActivityStatusValue(MarketActivitySecKillStatusEnum.HAS_BEEN_STOP.getCode());
        MarketActivityPO marketActivityPO1 = this.marketActivityPOMapper.selectByPrimaryKey(marketActivityId);
        int i = 0;
        if (!marketActivityPO1.getActivityStatusValue().equals(MarketActivitySecKillStatusEnum.HAS_BEEN_STOP.getCode())) {
            i = this.marketActivityPOMapper.updateByPrimaryKeySelective(marketActivityPO);
        }
        return i;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResponseData<MarketActivityPO> addMarketActivitySecKill(MarketActivitySecKillAddDTO marketActivitySecKillAddDTO, LoginUser loginUser, Integer merchantId) throws Exception {
        String accountCode = loginUser.getAccountCode();
        MarketActivitySecKillAddRequestVO requestVO = marketActivitySecKillAddDTO.getRequestVO();
        CompanyBrandRelationPO companyBrandRelationPO = this.companyBrandRelationService.getPOByMerchantId(merchantId);
        BrandUserDTO brandUserDTO = new BrandUserDTO();
        brandUserDTO.setLoginUser(loginUser);
        brandUserDTO.setCompanyBrandRelationPO(companyBrandRelationPO);
        MarketActivityPO marketActivityPO = this.marketActivitySecKillBuilderService.marketActivityPOBuilder(requestVO, brandUserDTO);
        MarketActivityStatisticalPO marketActivityStatisticalPO = this.marketActivityStatisticalBuilderService.marketActivityStatisticalPOBuilder(marketActivityPO, brandUserDTO);
        marketActivitySecKillAddDTO.setMarketActivityPO(marketActivityPO);
        marketActivitySecKillAddDTO.setMarketActivityStatisticalPO(marketActivityStatisticalPO);
        List<MarketActivityGoodsSecKillPO> marketActivityGoodsSecKillPOS = this.marketActivityGoodsSecKillBuilderService.marketActivityGoodsSecKillPOBuilder(marketActivitySecKillAddDTO, brandUserDTO);
        return ResponseUtil.getSuccessData((Object)marketActivityPO);
    }

    @Override
    public Integer modifyMarketActivitySecKill(MarketActivitySecKillModifyRequestVO requestVO, Integer merchantId) {
        Integer marketActivityId = requestVO.getMarketActivityId();
        List<MarketActivitySecKillGoodsModifyVO> goodsList = requestVO.getGoodsList();
        Integer impactCount = 0;
        if (!CollectionUtils.isEmpty(goodsList)) {
            for (MarketActivitySecKillGoodsModifyVO marketActivitySecKillGoodsModifyVO : goodsList) {
                Integer count = this.marketActivityGoodsSecKillBuilderService.modifyMarketActivityGoodsSecKillPO(marketActivitySecKillGoodsModifyVO);
                log.info("\u66f4\u65b0\u8425\u9500\u6d3b\u52a8(\u79d2\u6740)\u5546\u54c1\u4fe1\u606f:{},result:{}", (Object)JSON.toJSONString((Object)marketActivitySecKillGoodsModifyVO), (Object)count);
                impactCount = impactCount + count;
            }
        }
        return impactCount;
    }

    @Override
    public ResponseData<MarketActivitySecKillResponseVO> findMarketActivitySecKillOne(Integer marketActivityId, Integer merchantId) {
        MarketActivityPO marketActivityPO = this.marketActivityPOMapper.selectByPrimaryKey(marketActivityId);
        if (marketActivityPO == null) {
            return ResponseUtil.getFailedMsg((String)"\u6b64\u6d3b\u52a8\u4e0d\u5b58\u5728!");
        }
        Integer marketActivityMerchantId = marketActivityPO.getMerchantId();
        if (!merchantId.equals(marketActivityMerchantId)) {
            return ResponseUtil.getFailedMsg((String)"\u65e0\u6cd5\u67e5\u8be2\u975e\u672c\u5546\u6237\u4fe1\u606f!");
        }
        Integer marketActivityMomentId = marketActivityPO.getMarketActivityMomentId();
        MarketActivityMomentPO marketActivityMomentPO = this.marketActivityMomentPOMapper.selectByPrimaryKey(marketActivityMomentId);
        MarketActivityGoodsSecKillPOExample marketActivityGoodsSecKillPOExample = new MarketActivityGoodsSecKillPOExample();
        marketActivityGoodsSecKillPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andMarketActivityIdEqualTo(marketActivityId).andValidEqualTo(Boolean.TRUE);
        marketActivityGoodsSecKillPOExample.setOrderByClause("sort desc");
        List marketActivityGoodsSecKillPOList = this.marketActivityGoodsSecKillPOMapper.queryMarketActivityVOByMarketActivityId(marketActivityId, merchantId);
        MarketActivitySecKillResponseVO marketActivitySecKillResponseVO = new MarketActivitySecKillResponseVO();
        marketActivitySecKillResponseVO.setMarketActivityPO(marketActivityPO);
        marketActivitySecKillResponseVO.setMarketActivityMomentPO(marketActivityMomentPO);
        marketActivitySecKillResponseVO.setMarketActivityGoodsSecKillPOList(marketActivityGoodsSecKillPOList);
        return ResponseUtil.getSuccessData((Object)marketActivitySecKillResponseVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer updateMarketActivitySecKillActivityStatus(Integer marketActivityId, Integer merchantId, Integer statusCode) {
        log.info("stopMarketActivitySecKill marketActivityId :{}", (Object)marketActivityId);
        MarketActivityPO marketActivityPO = new MarketActivityPO();
        marketActivityPO.setId(marketActivityId);
        marketActivityPO.setGmtModified(new Date());
        marketActivityPO.setActivityStatusValue(statusCode);
        MarketActivityPO marketActivityPO1 = this.marketActivityPOMapper.selectByPrimaryKey(marketActivityId);
        int i = 0;
        if (!marketActivityPO1.getActivityStatusValue().equals(MarketActivitySecKillStatusEnum.HAS_BEEN_STOP.getCode())) {
            i = this.marketActivityPOMapper.updateByPrimaryKeySelective(marketActivityPO);
        }
        return i;
    }
}

