/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.enums.MarketActivityEnum;
import com.wmeimob.fastboot.bizvane.enums.seckill.MarketActivitySecKillJobStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.ConfigPOMapper;
import com.wmeimob.fastboot.bizvane.po.ConfigPO;
import com.wmeimob.fastboot.bizvane.po.ConfigPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillJobService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.jobutils.XxlJobUtil;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MarketActivityJobServiceImpl
implements MarketActivitySecKillJobService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityJobServiceImpl.class);
    @Value(value="${spring.application.name}")
    private String appName;
    @Autowired
    private XxlJobUtil xxlJobUtil;
    @Resource
    private ConfigPOMapper configPOMapper;

    @Override
    public void createActivityJob(Integer merchantId, MarketActivityPO po, MarketActivitySecKillJobStatusEnum secKillJobStatusEnum) {
        log.info("createActivityRemindJob merchantId:{} po:{}", (Object)merchantId, JSON.toJSON((Object)po));
        String id = String.valueOf(po.getId() == null ? "" : po.getId());
        Date jobTime = po.getActivityEndTime();
        if (MarketActivitySecKillJobStatusEnum.ACTIVITY_START_JOB.getLastName().equals(secKillJobStatusEnum.getLastName())) {
            jobTime = po.getActivityBeginTime();
            log.info("\u521b\u5efa\u6d3b\u52a8\u5f00\u59cb\u4efb\u52a1 \u6d3b\u52a8\u65f6\u95f4:{}", (Object)jobTime);
        } else if (MarketActivitySecKillJobStatusEnum.ACTIVITY_ENDED_JOB.getLastName().equals(secKillJobStatusEnum.getLastName())) {
            jobTime = po.getActivityEndTime();
            log.info("\u521b\u5efa\u6d3b\u52a8\u7ed3\u675f\u4efb\u52a1 \u6d3b\u52a8\u65f6\u95f4:{}", (Object)jobTime);
        } else if (MarketActivitySecKillJobStatusEnum.ACTIVITY_REMIND_JOB.getLastName().equals(secKillJobStatusEnum.getLastName())) {
            jobTime = po.getActivityBeginTime();
            Calendar c = Calendar.getInstance();
            c.setTime(jobTime);
            c.set(12, c.get(12) - po.getMarketActivityAwaitMessageSend());
            jobTime = c.getTime();
            log.info("\u521b\u5efa\u6d3b\u52a8\u63d0\u9192\u4efb\u52a1 \u6d3b\u52a8\u65f6\u95f4:{}", (Object)jobTime);
        }
        String jobName = secKillJobStatusEnum.getPrefix() + id + secKillJobStatusEnum.getLastName();
        String jobHandler = secKillJobStatusEnum.getJobHandler();
        String jobDesc = secKillJobStatusEnum.getPrefix() + id + secKillJobStatusEnum.getLastNameCn();
        String author = secKillJobStatusEnum.getAuthor();
        String param = id;
        String appName = this.appName;
        int businessType = MarketActivityEnum.SEC_KILL.getType();
        String bizCode = id + secKillJobStatusEnum.getLastName();
        this.xxlJobUtil.addJob(jobTime, jobDesc, param, author, jobHandler, businessType, bizCode, appName);
    }

    @Override
    public void deleteJob(Integer merchantId, String bizCode) {
        log.info("deleteSecKillExec");
        this.xxlJobUtil.removeByBiz(MarketActivityEnum.SEC_KILL.getType().intValue(), bizCode);
    }

    @Override
    public void createMarketActivitySecKillOrderCancelJob(Integer merchantId, OrdersPO ordersPO, MarketActivityPO marketActivityPO) {
        String orderNo = ordersPO.getOrderNo();
        log.info("\u521b\u5efa\u79d2\u6740\u6d3b\u52a8\u5173\u95ed\u8ba2\u5355:{}\u4efb\u52a1", (Object)orderNo);
        ConfigPOExample configPOExample = new ConfigPOExample();
        configPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List configPOS = this.configPOMapper.selectByExample(configPOExample);
        if (CollectionUtils.isEmpty((Collection)configPOS)) {
            log.error("\u65e0\u6cd5\u521b\u5efa\u79d2\u6740\u8ba2\u5355:{}\u53d6\u6d88\u4efb\u52a1", (Object)orderNo);
            return;
        }
        ConfigPO configPO = (ConfigPO)configPOS.get(0);
        Integer awaitOrderConfirm = configPO.getAwaitOrderConfirm();
        Integer marketActivityAwaitOrderClose = marketActivityPO.getMarketActivityAwaitOrderClose();
        int closeMinute = Math.min(awaitOrderConfirm, marketActivityAwaitOrderClose);
        Date gmtCreate = ordersPO.getGmtCreate();
        Date jobTime = DateUtil.addMinute((Date)gmtCreate, (int)closeMinute);
        MarketActivitySecKillJobStatusEnum activityOrderNoPayClose = MarketActivitySecKillJobStatusEnum.ACTIVITY_ORDER_NO_PAY_CLOSE;
        String jobName = activityOrderNoPayClose.getPrefix() + orderNo + activityOrderNoPayClose.getLastName();
        String jobHandler = activityOrderNoPayClose.getJobHandler();
        String jobDesc = activityOrderNoPayClose.getPrefix() + orderNo + activityOrderNoPayClose.getLastNameCn();
        String author = activityOrderNoPayClose.getAuthor();
        String jobParam = orderNo;
        String appName = this.appName;
        int businessType = MarketActivityEnum.SEC_KILL.getType();
        String bizCode = activityOrderNoPayClose.getJobHandler() + orderNo;
        this.xxlJobUtil.addJob(jobTime, jobDesc, jobParam, author, jobHandler, businessType, bizCode, appName);
    }
}

