/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.paygateway.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.PayPackageResult;
import com.bizvane.base.common.bean.RefundResult;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.MerchantConfigDto;
import com.bizvane.base.remote.service.IRemotePayService;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayConfigService;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayPayService;
import com.wmeimob.fastboot.bizvane.service.paygateway.util.MD5Util;
import com.wmeimob.fastboot.bizvane.vo.paygateway.IntegralPayGatewayOrderVO;
import com.wmeimob.fastboot.bizvane.vo.paygateway.IntegralPayGatewayRefundOrderVO;
import com.wmeimob.fastboot.config.MallAdminException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayGatewayPayServiceImpl
implements PayGatewayPayService {
    private static final Logger log = LoggerFactory.getLogger(PayGatewayPayServiceImpl.class);
    @Autowired
    private IRemotePayService iRemotePayService;
    private final String salt = "bizvaneSecretKey";
    @Resource
    private PayGatewayConfigService payGatewayConfigService;

    @Override
    public ResultBean<PayPackageResult> prePay(IntegralPayGatewayOrderVO integralPayGatewayOrderVo) {
        log.info("PayGatewayPayService.prePay:{}", (Object)JSON.toJSONString((Object)integralPayGatewayOrderVo));
        String bizvaneMid = integralPayGatewayOrderVo.getBizvaneMid();
        String outTradeNo = integralPayGatewayOrderVo.getOutTradeNo();
        String body = integralPayGatewayOrderVo.getBody();
        String buyerUserName = integralPayGatewayOrderVo.getBuyerUserName();
        String buyerUserType = integralPayGatewayOrderVo.getBuyerUserType();
        String buyerUserId = integralPayGatewayOrderVo.getBuyerUserId();
        String subject = integralPayGatewayOrderVo.getSubject();
        Integer totalFee = integralPayGatewayOrderVo.getTotalFee();
        String spbillCreateIp = integralPayGatewayOrderVo.getSpbillCreateIp();
        String detail = integralPayGatewayOrderVo.getDetail();
        String payType = integralPayGatewayOrderVo.getPayType();
        String attach = integralPayGatewayOrderVo.getAttach();
        String cryptData = integralPayGatewayOrderVo.getCryptData();
        ResultBean preOrder = this.iRemotePayService.createPreOrder(bizvaneMid, outTradeNo, body, buyerUserName, buyerUserType, buyerUserId, subject, totalFee, spbillCreateIp, detail, payType, attach, cryptData);
        log.info("iRemotePayService.createPreOrder:{}", (Object)JSON.toJSONString((Object)preOrder));
        return preOrder;
    }

    @Override
    public ResultBean<RefundResult> createRefundOrder(IntegralPayGatewayRefundOrderVO integralPayGatewayRefundOrderVO) {
        log.info("PayGatewayPayService.createRefundOrder:{}", (Object)JSON.toJSONString((Object)integralPayGatewayRefundOrderVO));
        String bizvaneMid = integralPayGatewayRefundOrderVO.getBizvaneMid();
        String bizvaneTradeNo = integralPayGatewayRefundOrderVO.getBizvaneTradeNo();
        String deviceInfo = integralPayGatewayRefundOrderVO.getDeviceInfo();
        String outTradeNo = integralPayGatewayRefundOrderVO.getOutTradeNo();
        String outRefundNo = integralPayGatewayRefundOrderVO.getOutRefundNo();
        Integer totalFee = integralPayGatewayRefundOrderVO.getTotalFee();
        Integer refundFee = integralPayGatewayRefundOrderVO.getRefundFee();
        String refundFeeType = integralPayGatewayRefundOrderVO.getRefundFeeType();
        String buyerUserId = integralPayGatewayRefundOrderVO.getBuyerUserId();
        String refundAccount = integralPayGatewayRefundOrderVO.getRefundAccount();
        String refundDesc = integralPayGatewayRefundOrderVO.getRefundDesc();
        String payType = integralPayGatewayRefundOrderVO.getPayType();
        String cryptData = integralPayGatewayRefundOrderVO.getCryptData();
        String attach = integralPayGatewayRefundOrderVO.getAttach();
        ResultBean refundOrder = this.iRemotePayService.createRefundOrder(bizvaneMid, bizvaneTradeNo, deviceInfo, outTradeNo, outRefundNo, totalFee, refundFee, refundFeeType, buyerUserId, refundAccount, refundDesc, payType, cryptData, attach);
        log.info("iRemotePayService.createRefundOrder:{}", (Object)JSON.toJSONString((Object)refundOrder));
        return refundOrder;
    }

    @Override
    public String cryptData(String bizvaneMid, String paytype) {
        String data = bizvaneMid + paytype;
        MerchantConfigDto remotePayGatewayConfig = this.payGatewayConfigService.getRemotePayGatewayConfig(bizvaneMid);
        if (remotePayGatewayConfig == null) {
            throw new MallAdminException("\u94f6\u8054\u6e20\u9053\u672a\u914d\u7f6e");
        }
        String bizvaneSecretKey = remotePayGatewayConfig.getBizvaneSecretKey();
        return MD5Util.encode(data, bizvaneSecretKey).toUpperCase();
    }
}

