/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.paygateway.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.MerchantConfigDto;
import com.bizvane.base.remote.service.IRemoteMerchantConfigService;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.utils.responseinfo.ResponseData;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralBaseConfigEnum;
import com.wmeimob.fastboot.bizvane.listener.IntegralBaseConfigListener;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralPayGatewayPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralPayGatewayPO;
import com.wmeimob.fastboot.bizvane.po.IntegralPayGatewayPOExample;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayConfigService;
import com.wmeimob.fastboot.bizvane.vo.paygateway.IntegralPayGatewayVO;
import com.wmeimob.fastboot.config.MallAdminException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PayGatewayConfigServiceImpl
implements PayGatewayConfigService {
    private static final Logger log = LoggerFactory.getLogger(PayGatewayConfigServiceImpl.class);
    @Autowired
    private IntegralBaseConfigListener integralBaseConfigListener;
    @Autowired
    IRemoteMerchantConfigService iRemoteMerchantConfigService;
    @Resource
    private IntegralPayGatewayPOMapper integralPayGatewayPOMapper;
    @Autowired
    private BrandServiceRpc brandServiceRpc;

    @Override
    public IntegralPayGatewayPO findByMerchantId(Integer merchantId) {
        IntegralPayGatewayPOExample integralPayGatewayPOExample = new IntegralPayGatewayPOExample();
        integralPayGatewayPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List integralPayGatewayPOS = this.integralPayGatewayPOMapper.selectByExample(integralPayGatewayPOExample);
        if (CollectionUtils.isEmpty((Collection)integralPayGatewayPOS)) {
            return null;
        }
        return (IntegralPayGatewayPO)integralPayGatewayPOS.get(0);
    }

    @Override
    public IntegralPayGatewayPO addByMerchantId(IntegralPayGatewayVO integralPayGatewayVo) {
        log.info("PayGatewayConfigServiceImpl#addByMerchantId:{}", (Object)JSON.toJSONString((Object)integralPayGatewayVo));
        IntegralPayGatewayPO integralPayGatewayPo = new IntegralPayGatewayPO();
        integralPayGatewayPo.setMerchantId(integralPayGatewayVo.getMerchantId());
        integralPayGatewayPo.setCompanyName(integralPayGatewayVo.getCompanyName());
        integralPayGatewayPo.setBrandName(integralPayGatewayVo.getBrandName());
        integralPayGatewayPo.setBizvaneSecretKey(integralPayGatewayVo.getBizvaneSecretKey());
        integralPayGatewayPo.setDomainName(integralPayGatewayVo.getDomainName());
        integralPayGatewayPo.setNotifyUrl(integralPayGatewayVo.getNotifyUrl());
        integralPayGatewayPo.setRefundNotifyUrl(integralPayGatewayVo.getRefundNotifyUrl());
        this.integralPayGatewayPOMapper.insertSelective(integralPayGatewayPo);
        return integralPayGatewayPo;
    }

    @Override
    public IntegralPayGatewayPO addByMerchantId(Integer merchantId) {
        ResponseData brandByID = this.brandServiceRpc.getBrandByID(Long.valueOf(merchantId.longValue()));
        SysBrandPo data = (SysBrandPo)brandByID.getData();
        String bizvaneSecretKey = RandomUtil.randomString((int)20);
        String notifyUrl = this.integralBaseConfigListener.getConfigValue(IntegralBaseConfigEnum.PAY_GATEWAY_CHANNEL_UNION_NOTIFY);
        String refundNotifyUrl = this.integralBaseConfigListener.getConfigValue(IntegralBaseConfigEnum.PAY_GATEWAY_CHANNEL_UNION_REFUND_NOTIFY);
        IntegralPayGatewayVO integralPayGatewayVo = new IntegralPayGatewayVO();
        integralPayGatewayVo.setMerchantId(merchantId);
        integralPayGatewayVo.setCompanyName(data.getCompanyName());
        integralPayGatewayVo.setBrandName(data.getBrandName());
        integralPayGatewayVo.setBizvaneSecretKey(bizvaneSecretKey);
        integralPayGatewayVo.setDomainName(bizvaneSecretKey + ".bizvane.com");
        integralPayGatewayVo.setNotifyUrl(notifyUrl);
        integralPayGatewayVo.setRefundNotifyUrl(refundNotifyUrl);
        IntegralPayGatewayPO integralPayGatewayPo = this.addByMerchantId(integralPayGatewayVo);
        log.info("integralPayGatewayPOTable:{}", (Object)JSON.toJSONString((Object)integralPayGatewayPo));
        IntegralPayGatewayPO byMerchantId = this.findByMerchantId(merchantId);
        String bizvaneMid = byMerchantId.getBizvaneMid();
        if (StringUtils.isEmpty((Object)bizvaneMid)) {
            MerchantConfigDto merchantConfigDto = this.addRemotePayGatewayConfig(integralPayGatewayPo);
            if (merchantConfigDto == null) {
                throw new MallAdminException("\u4fdd\u5b58\u652f\u4ed8\u5e73\u53f0\u94f6\u8054\u652f\u4ed8\u4fe1\u606f\u5931\u8d25\uff01");
            }
            bizvaneMid = merchantConfigDto.getBizvaneMid();
            integralPayGatewayPo.setBizvaneMid(bizvaneMid);
            IntegralPayGatewayPO modifyByMerchantId = this.modifyByMerchantId(integralPayGatewayPo);
            log.info("payGatewayConfigService.modifyByMerchantId:{}", (Object)JSON.toJSONString((Object)modifyByMerchantId));
        }
        return integralPayGatewayPo;
    }

    @Override
    public IntegralPayGatewayPO modifyByMerchantId(IntegralPayGatewayPO integralPayGatewayPo) {
        integralPayGatewayPo.setGmtModified(new Date());
        this.integralPayGatewayPOMapper.updateByPrimaryKeySelective(integralPayGatewayPo);
        this.modifyRemotePayGatewayConfig(integralPayGatewayPo);
        return integralPayGatewayPo;
    }

    @Override
    public String findBizvaneMidByMerchantId(Integer merchantId) {
        IntegralPayGatewayPO integralPayGatewayPO = this.findByMerchantId(merchantId);
        if (integralPayGatewayPO == null) {
            return null;
        }
        return integralPayGatewayPO.getBizvaneMid();
    }

    @Override
    public MerchantConfigDto getRemotePayGatewayConfig(String bizvaneMid) {
        ResultBean merchantConfig = this.iRemoteMerchantConfigService.getMerchantConfig(bizvaneMid);
        log.info("iRemoteMerchantConfigService.getMerchantConfig:{}", (Object)JSON.toJSONString((Object)merchantConfig));
        Boolean success = merchantConfig.getSuccess();
        if (success.booleanValue()) {
            MerchantConfigDto result = (MerchantConfigDto)merchantConfig.getResult();
            return result;
        }
        return null;
    }

    @Override
    public MerchantConfigDto modifyRemotePayGatewayConfig(IntegralPayGatewayPO integralPayGatewayPO) {
        String bizvaneMid = integralPayGatewayPO.getBizvaneMid();
        String companyName = integralPayGatewayPO.getCompanyName();
        String brandName = integralPayGatewayPO.getBrandName();
        String bizvaneSecretKey = integralPayGatewayPO.getBizvaneSecretKey();
        String domainName = integralPayGatewayPO.getDomainName();
        String notifyUrl = integralPayGatewayPO.getNotifyUrl();
        String refundNotifyUrl = integralPayGatewayPO.getRefundNotifyUrl();
        ResultBean merchantConfigDtoResultBean = this.iRemoteMerchantConfigService.updateMerchantConfig(bizvaneMid, companyName, brandName, bizvaneSecretKey, domainName, notifyUrl, refundNotifyUrl);
        log.info("iRemoteMerchantConfigService.updateMerchantConfig:{}", (Object)JSON.toJSONString((Object)merchantConfigDtoResultBean));
        Boolean success = merchantConfigDtoResultBean.getSuccess();
        if (success.booleanValue()) {
            MerchantConfigDto result = (MerchantConfigDto)merchantConfigDtoResultBean.getResult();
            return result;
        }
        return null;
    }

    @Override
    public MerchantConfigDto addRemotePayGatewayConfig(IntegralPayGatewayPO integralPayGatewayPO) {
        try {
            String companyName = integralPayGatewayPO.getCompanyName();
            String brandName = integralPayGatewayPO.getBrandName();
            String bizvaneSecretKey = integralPayGatewayPO.getBizvaneSecretKey();
            String domainName = integralPayGatewayPO.getDomainName();
            String notifyUrl = integralPayGatewayPO.getNotifyUrl();
            String refundNotifyUrl = integralPayGatewayPO.getRefundNotifyUrl();
            log.info("iRemoteMerchantConfigService:{}", (Object)this.iRemoteMerchantConfigService);
            log.info("iRemoteMerchantConfigService#addRemotePayGatewayConfig#integralPayGatewayPO:{}", (Object)JSON.toJSONString((Object)integralPayGatewayPO));
            ResultBean merchantConfigDtoResultBean = this.iRemoteMerchantConfigService.saveMerchantConfig(companyName, brandName, bizvaneSecretKey, domainName, notifyUrl, refundNotifyUrl);
            log.info("iRemoteMerchantConfigService.saveMerchantConfig:{}", (Object)JSON.toJSONString((Object)merchantConfigDtoResultBean));
            Boolean success = merchantConfigDtoResultBean.getSuccess();
            if (success.booleanValue()) {
                MerchantConfigDto result = (MerchantConfigDto)merchantConfigDtoResultBean.getResult();
                return result;
            }
        }
        catch (Exception e) {
            log.warn("PayGatewayConfigServiceImpl#addRemotePayGatewayConfig\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    @Override
    public IntegralPayGatewayPO getPayGatewayConfigByMid(String bizvaneMid) {
        IntegralPayGatewayPOExample integralPayGatewayPOExample = new IntegralPayGatewayPOExample();
        integralPayGatewayPOExample.createCriteria().andBizvaneMidEqualTo(bizvaneMid).andValidEqualTo(Boolean.TRUE);
        List integralPayGatewayPOS = this.integralPayGatewayPOMapper.selectByExample(integralPayGatewayPOExample);
        if (CollectionUtils.isEmpty((Collection)integralPayGatewayPOS)) {
            return null;
        }
        return (IntegralPayGatewayPO)integralPayGatewayPOS.get(0);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(RandomUtil.randomString((int)20));
    }
}

