/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.constants.admin.ImportConstant;
import com.wmeimob.fastboot.bizvane.constants.admin.OrdersConstant;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.enums.MarketOrderStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.admin.BatchSendExportTemplateEnum;
import com.wmeimob.fastboot.bizvane.enums.admin.ExportTempleHelp;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CourierPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ExcelImportPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SendOrderMsgRecordPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.custommapper.OrdersStatusCheckMapper;
import com.wmeimob.fastboot.bizvane.po.CourierPOExample;
import com.wmeimob.fastboot.bizvane.po.ExcelImportPOExample;
import com.wmeimob.fastboot.bizvane.po.ExcelImportPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.SendOrderMsgRecordPOExample;
import com.wmeimob.fastboot.bizvane.po.SendOrderMsgRecordPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.logistics.LogisticsService;
import com.wmeimob.fastboot.bizvane.service.order.OrderNewService;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.admin.BatchSendExportResponseVO;
import com.wmeimob.fastboot.bizvane.vo.admin.BatchSendExportTempleVO;
import com.wmeimob.fastboot.bizvane.vo.admin.ImportVO;
import com.wmeimob.fastboot.bizvane.vo.admin.SendInfoErrorExportMessageVO;
import com.wmeimob.fastboot.bizvane.vo.admin.SendInfoExportCheck;
import com.wmeimob.fastboot.bizvane.vo.admin.ShippingInfoRequestVO;
import com.wmeimob.fastboot.bizvane.vo.order.PreSellOrderApprovalVO;
import com.wmeimob.fastboot.config.MallAdminException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.util.Strings;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OrderNewServiceImpl
implements OrderNewService {
    private static final Logger log = LoggerFactory.getLogger(OrderNewServiceImpl.class);
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Resource
    private LoginUtil loginUtil;
    @Resource
    private ExcelImportPOMapper excelImportPOMapper;
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Resource
    private CourierPOMapper courierPOMapper;
    @Resource
    private MarketActivityOrdersPOMapper marketActivityOrdersPOMapper;
    @Resource
    private OrdersStatusCheckMapper ordersStatusCheckMapper;
    @Autowired
    private ThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private LogisticsService logisticsService;
    @Resource
    private SendOrderMsgRecordPOMapper sendOrderMsgRecordPOMapper;
    @Autowired
    private BizvaneInterface bizvaneInterface;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOrderShippingInfo(ShippingInfoRequestVO shippingInfoRequestVO) {
        try {
            OrdersPOExample queryOrderByOrderNoExample = new OrdersPOExample();
            queryOrderByOrderNoExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(shippingInfoRequestVO.getMerchantId()).andOrderNoEqualTo(shippingInfoRequestVO.getOrderNo());
            List orderList = this.ordersPOMapper.selectByExample(queryOrderByOrderNoExample);
            if (CollectionUtils.isEmpty((Collection)orderList)) {
                throw new MallAdminException("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\uff01");
            }
            if (orderList.size() > 1) {
                throw new MallAdminException("\u6709\u91cd\u590d\u8ba2\u5355\u7f16\u53f7\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\uff01");
            }
            OrdersPO ordersPo = (OrdersPO)orderList.get(0);
            Date modifyDate = new Date();
            String logisticsStatus = ordersPo.getLogisticsStatus();
            Integer shippingMode = ordersPo.getShippingMode();
            String payStatus = ordersPo.getPayStatus();
            String orderStatus = ordersPo.getOrderStatus();
            if (!"UN_SEND".equals(logisticsStatus)) {
                throw new MallAdminException("\u8ba2\u5355\u975e\u672a\u53d1\u8d27\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\uff01");
            }
            if (!OrdersConstant.IS_SEND_ORDER.equals(shippingMode)) {
                throw new MallAdminException("\u8ba2\u5355\u975e\u53d1\u8d27\u7c7b\u578b\u8ba2\u5355\uff0c\u65e0\u6cd5\u4fee\u6539\uff01");
            }
            if (!"TRADE".equals(orderStatus)) {
                throw new MallAdminException("\u8ba2\u5355\u72b6\u6001\u975e\u4ea4\u6613\u72b6\u6001\uff0c\u65e0\u6cd5\u4fee\u6539\uff01");
            }
            OrdersPO modifyOrdersPo = this.convertShippingInfoToModifyOrdersPo(shippingInfoRequestVO, ordersPo, modifyDate);
            int n = this.ordersPOMapper.updateByPrimaryKeySelective(modifyOrdersPo);
        }
        catch (Exception e) {
            throw new MallAdminException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseData orderBatchSend(Integer merchantId, ImportVO importVO, HttpServletRequest request) throws Exception {
        LoginUser loginUser = this.loginUtil.getLoginUser(request);
        String accountCode = loginUser.getAccountCode();
        String accountName = loginUser.getNickName();
        log.info("\u5f53\u524d\u7528\u6237:[{}]_[{}]", (Object)accountCode, (Object)accountName);
        BatchSendExportResponseVO exportResponseVO = new BatchSendExportResponseVO();
        String qiNiuUrl = importVO.getQiNiuUrl();
        if (StringUtils.isEmpty((Object)qiNiuUrl)) {
            return ResponseUtil.getFailedMsg((String)"\u8bf7\u8f93\u5165\u6b63\u786eurl");
        }
        String fileUrl = qiNiuUrl.replace("https", "http").replace("http", "https");
        ExcelImportPOExample excelImportPOExample = new ExcelImportPOExample();
        excelImportPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andStatusEqualTo(ImportConstant.EXCEL_IMPORT_STATUS_EXECUTION).andImportTypeEqualTo("orderBatchSend").andAccountcodeEqualTo(accountCode);
        List excelImportPOS = this.excelImportPOMapper.selectByExample(excelImportPOExample);
        if (!CollectionUtils.isEmpty((Collection)excelImportPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u6237\u5f53\u524d\u3010\u6279\u91cf\u53d1\u8d27\u3011\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        URL url = new URL(qiNiuUrl);
        InputStream is = url.openConnection().getInputStream();
        if (is == null) {
            return ResponseUtil.getFailedMsg((String)"\u65e0\u5185\u5bb9,\u5bfc\u5165\u5904\u7406\u5931\u8d25!");
        }
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)is);
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            ResponseData responseData = ResponseUtil.getFailedMsg((String)"\u89e3\u6790\u6587\u4ef6\u5931\u8d25,\u8bf7\u786e\u5b9a\u4e0a\u4f20\u4e86\u6b63\u786e\u6587\u4ef6!");
            return responseData;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        Sheet firstSheet = wb.getSheetAt(0);
        int lastRowNum = firstSheet.getLastRowNum();
        log.info("\u6700\u540e\u4e00\u884c\u884c\u53f7:{}", (Object)lastRowNum);
        if (lastRowNum > 50001) {
            return ResponseUtil.getFailedMsg((String)"\u6587\u6863\u5185\u5bb9\u8d85\u8fc750000\u6761,\u8bf7\u624b\u52a8\u62c6\u5206\u6587\u6863\u540e\u518d\u4e0a\u4f20");
        }
        Integer brandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(merchantId);
        ExportTempleHelp exportTempleHelp = BatchSendExportTemplateEnum.getExportTempleHelp();
        List notesList = exportTempleHelp.getNotesList();
        Row firstSheetRow = firstSheet.getRow(0);
        for (int i = 0; i < notesList.size(); ++i) {
            String header = firstSheetRow.getCell(i).getStringCellValue();
            if (StringUtils.isEmpty((Object)header)) {
                return ResponseUtil.getFailedMsg((String)"\u8868\u5934\u6709\u7a7a\u5217,\u8bf7\u91cd\u65b0\u67e5\u770b\u6587\u4ef6\u540e\u4e0a\u4f20");
            }
            if (header.trim().equalsIgnoreCase((String)notesList.get(i))) continue;
            return ResponseUtil.getFailedMsg((String)"\u8868\u5934\u4fe1\u606f\u6709\u8bef,\u8bf7\u4f7f\u7528\u6b63\u786e\u6a21\u677f\u6587\u4ef6");
        }
        ExcelImportPOWithBLOBs excelImportPOWithBLOBs = new ExcelImportPOWithBLOBs();
        excelImportPOWithBLOBs.setMerchantId(merchantId);
        excelImportPOWithBLOBs.setImportTime(new Date());
        excelImportPOWithBLOBs.setImportUrl(fileUrl);
        excelImportPOWithBLOBs.setImportType("orderBatchSend");
        excelImportPOWithBLOBs.setStatus(ImportConstant.EXCEL_IMPORT_STATUS_EXECUTION);
        excelImportPOWithBLOBs.setGmtCreate(new Date());
        excelImportPOWithBLOBs.setBeginTime(new Date());
        excelImportPOWithBLOBs.setAccountcode(accountCode);
        this.excelImportPOMapper.insertSelective(excelImportPOWithBLOBs);
        log.info("\u65b0\u589e\u5bfc\u5165\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)excelImportPOWithBLOBs));
        log.info("\u6279\u91cf\u53d1\u8d27\u4fe1\u606f\u5bfc\u5165\u5f00\u59cb\u4efb\u52a1");
        HashMap<String, HashMap<String, List<SendInfoErrorExportMessageVO>>> successAndErrorInfoMap = this.orderBatchSendInfoImportAsync(merchantId, brandId, excelImportPOWithBLOBs, lastRowNum, firstSheet, accountCode, accountName);
        log.info("\u53d1\u8d27\u5b8c\u6210\u540e\u4fe1\u606f\u8fd4\u56de:{}", (Object)JSON.toJSONString(successAndErrorInfoMap));
        HashMap<String, List<SendInfoErrorExportMessageVO>> firstStageInfoMap = successAndErrorInfoMap.get("firstStageInfoMap");
        HashMap<String, List<SendInfoErrorExportMessageVO>> secondStageInfoMap = successAndErrorInfoMap.get("secondStageInfoMap");
        List<SendInfoErrorExportMessageVO> firstErrorInfo = firstStageInfoMap.get("firstErrorInfo");
        List<SendInfoErrorExportMessageVO> secondErrorInfoMap = secondStageInfoMap.get("secondErrorInfoMap");
        List<SendInfoErrorExportMessageVO> secondSuccessInfoMap = secondStageInfoMap.get("secondSuccessInfoMap");
        int successCount = 0;
        int firstErrorCount = 0;
        int secondErrorCount = 0;
        if (!CollectionUtils.isEmpty(firstErrorInfo)) {
            firstErrorCount = firstErrorInfo.size();
        }
        if (!CollectionUtils.isEmpty(secondErrorInfoMap)) {
            secondErrorCount = secondErrorInfoMap.size();
        }
        if (!CollectionUtils.isEmpty(secondSuccessInfoMap)) {
            successCount = secondSuccessInfoMap.size();
        }
        ArrayList<SendInfoErrorExportMessageVO> infoErrorExportMessageVOS = new ArrayList<SendInfoErrorExportMessageVO>();
        infoErrorExportMessageVOS.addAll(firstErrorInfo);
        infoErrorExportMessageVOS.addAll(secondErrorInfoMap);
        exportResponseVO.setTaskId(excelImportPOWithBLOBs.getExcelImportId());
        exportResponseVO.setSuccessCount(Integer.valueOf(successCount));
        exportResponseVO.setErrorCount(Integer.valueOf(firstErrorCount + secondErrorCount));
        exportResponseVO.setErrorList(infoErrorExportMessageVOS);
        exportResponseVO.setAllCount(Integer.valueOf(lastRowNum));
        return ResponseUtil.getSuccessData((Object)exportResponseVO);
    }

    public HashMap<String, HashMap<String, List<SendInfoErrorExportMessageVO>>> orderBatchSendInfoImportAsync(Integer merchantId, Integer brandId, ExcelImportPOWithBLOBs excelImportPOWithBLOBs, int lastRowNum, Sheet firstSheet, String accountCode, String accountName) {
        ArrayList<BatchSendExportTempleVO> successSendInfoExportTempleVoList = new ArrayList<BatchSendExportTempleVO>(50001);
        ArrayList<SendInfoErrorExportMessageVO> sendInfoErrorExportMessageVoList = new ArrayList<SendInfoErrorExportMessageVO>(50001);
        HashMap<String, HashMap<String, List<SendInfoErrorExportMessageVO>>> categoryData = new HashMap<String, HashMap<String, List<SendInfoErrorExportMessageVO>>>();
        for (int i = 1; i <= lastRowNum; ++i) {
            Row row = firstSheet.getRow(i);
            if (row == null) continue;
            String orderNo = OrderNewServiceImpl.getHandleValue(this.getValue(row.getCell(0)).trim());
            String shippingVendor = this.getValue(row.getCell(1)).trim();
            String shippingNo = OrderNewServiceImpl.getHandleValue(this.getValue(row.getCell(2)).trim());
            log.info("orderNo : " + orderNo);
            log.info("shippingVendor : " + shippingVendor);
            log.info("shippingNo : " + shippingNo);
            if (this.rowIsNull(orderNo, shippingVendor, shippingNo)) {
                log.info("poi\u8bc6\u522b\u5230\u6570\u636e\u4e3a\u7a7a,\u884c\u53f7:{}", (Object)i);
                continue;
            }
            BatchSendExportTempleVO batchSendExportTempleVo = new BatchSendExportTempleVO();
            batchSendExportTempleVo.setIndex(Integer.valueOf(i));
            batchSendExportTempleVo.setOrderNo(orderNo);
            batchSendExportTempleVo.setShippingVendor(shippingVendor);
            batchSendExportTempleVo.setShippingNo(shippingNo);
            boolean b = SendInfoExportCheck.checkParam((BatchSendExportTempleVO)batchSendExportTempleVo);
            log.info("\u68c0\u67e5\u5f53\u524d\u884c:{},\u6570\u636e:{}", (Object)batchSendExportTempleVo.getIndex(), (Object)JSON.toJSONString((Object)batchSendExportTempleVo));
            if (b) {
                successSendInfoExportTempleVoList.add(batchSendExportTempleVo);
                continue;
            }
            SendInfoErrorExportMessageVO sendInfoErrorExportMessageVo = new SendInfoErrorExportMessageVO();
            sendInfoErrorExportMessageVo.setIndex(batchSendExportTempleVo.getIndex());
            sendInfoErrorExportMessageVo.setOrderNo(batchSendExportTempleVo.getOrderNo());
            sendInfoErrorExportMessageVo.setErrorMsg(batchSendExportTempleVo.getErrorMsg());
            sendInfoErrorExportMessageVoList.add(sendInfoErrorExportMessageVo);
        }
        ExcelImportPOWithBLOBs param = new ExcelImportPOWithBLOBs();
        param.setFirstErrorInfo(JSON.toJSONString(sendInfoErrorExportMessageVoList));
        param.setGmtModified(new Date());
        param.setExcelImportId(excelImportPOWithBLOBs.getExcelImportId());
        this.excelImportPOMapper.updateByPrimaryKeySelective(param);
        HashMap<String, List<SendInfoErrorExportMessageVO>> firstStageInfoMap = new HashMap<String, List<SendInfoErrorExportMessageVO>>();
        List<SendInfoErrorExportMessageVO> firstSuccessInfo = this.convertListData(successSendInfoExportTempleVoList);
        firstStageInfoMap.put("firstErrorInfo", sendInfoErrorExportMessageVoList);
        firstStageInfoMap.put("firstSuccessInfo", firstSuccessInfo);
        categoryData.put("firstStageInfoMap", firstStageInfoMap);
        log.info("\u66f4\u65b0\u4efb\u52a1:{}", (Object)JSON.toJSONString((Object)param));
        HashMap<String, List<SendInfoErrorExportMessageVO>> secondStageInfoMap = this.disposeSendInfoImport(merchantId, brandId, successSendInfoExportTempleVoList, categoryData, excelImportPOWithBLOBs.getExcelImportId());
        categoryData.put("secondStageInfoMap", secondStageInfoMap);
        return categoryData;
    }

    private List<SendInfoErrorExportMessageVO> convertListData(List<BatchSendExportTempleVO> successSendInfoExportTempleVoList) {
        if (!CollectionUtils.isEmpty(successSendInfoExportTempleVoList)) {
            ArrayList<SendInfoErrorExportMessageVO> successMessage = new ArrayList<SendInfoErrorExportMessageVO>();
            successSendInfoExportTempleVoList.forEach(e -> {
                SendInfoErrorExportMessageVO exportMessageVo = new SendInfoErrorExportMessageVO();
                exportMessageVo.setIndex(e.getIndex());
                exportMessageVo.setShippingNo(e.getShippingNo());
                exportMessageVo.setShippingVendor(e.getShippingVendor());
                exportMessageVo.setOrderNo(e.getOrderNo());
                successMessage.add(exportMessageVo);
            });
            return successMessage;
        }
        return null;
    }

    public HashMap<String, List<SendInfoErrorExportMessageVO>> disposeSendInfoImport(Integer merchantId, Integer brandId, List<BatchSendExportTempleVO> successSendInfoExportTempleVoList, HashMap<String, HashMap<String, List<SendInfoErrorExportMessageVO>>> categoryData, Integer excelImportId) {
        log.info("\u6301\u4e45\u5316\u9636\u6bb5 OrderNewServiceImpl_disposeSendInfoImport_excelImportId:{}", (Object)excelImportId);
        ArrayList<SendInfoErrorExportMessageVO> errorList = new ArrayList<SendInfoErrorExportMessageVO>();
        ArrayList<SendInfoErrorExportMessageVO> successList = new ArrayList<SendInfoErrorExportMessageVO>();
        log.info("\u5f00\u59cb\u5904\u7406\u6279\u91cf\u53d1\u8d27\u6570\u636e");
        for (BatchSendExportTempleVO batchSendExportTempleVo : successSendInfoExportTempleVoList) {
            try {
                int count;
                SendInfoErrorExportMessageVO errorInfo;
                SendInfoErrorExportMessageVO errorInfo2;
                String orderNo = batchSendExportTempleVo.getOrderNo();
                String shippingVendor = batchSendExportTempleVo.getShippingVendor();
                String shippingNo = batchSendExportTempleVo.getShippingNo();
                OrdersPOExample example = new OrdersPOExample();
                example.createCriteria().andValidEqualTo(Boolean.TRUE).andOrderNoEqualTo(orderNo).andMerchantIdEqualTo(merchantId);
                List ordersPOList = this.ordersPOMapper.selectByExample(example);
                if (CollectionUtils.isEmpty((Collection)ordersPOList)) {
                    errorInfo2 = this.gatherErrorMessage(batchSendExportTempleVo, "\u6ca1\u6709\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u8ba2\u5355");
                    errorList.add(errorInfo2);
                    continue;
                }
                if (ordersPOList.size() > 1) {
                    errorInfo2 = this.gatherErrorMessage(batchSendExportTempleVo, "\u8ba2\u5355\u4e0d\u552f\u4e00");
                    errorList.add(errorInfo2);
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)ordersPOList)) continue;
                OrdersPO ordersPo = (OrdersPO)ordersPOList.get(0);
                String payStatus = ordersPo.getPayStatus();
                Integer shippingMode = ordersPo.getShippingMode();
                String logisticsStatus = ordersPo.getLogisticsStatus();
                String orderStatus = ordersPo.getOrderStatus();
                if (!"SUCCESS".equals(payStatus)) {
                    errorInfo = this.gatherErrorMessage(batchSendExportTempleVo, "\u672a\u652f\u4ed8\u8ba2\u5355");
                    errorList.add(errorInfo);
                    continue;
                }
                if (!OrdersConstant.IS_SEND_ORDER.equals(shippingMode)) {
                    errorInfo = this.gatherErrorMessage(batchSendExportTempleVo, "\u975e\u53d1\u8d27\u8ba2\u5355");
                    errorList.add(errorInfo);
                    continue;
                }
                if (!"UN_SEND".equals(logisticsStatus)) {
                    errorInfo = this.gatherErrorMessage(batchSendExportTempleVo, "\u8ba2\u5355\u975e\u672a\u53d1\u8d27\u72b6\u6001");
                    errorList.add(errorInfo);
                    continue;
                }
                if (!"TRADE".equals(orderStatus)) {
                    errorInfo = this.gatherErrorMessage(batchSendExportTempleVo, "\u8ba2\u5355\u72b6\u6001\u4e0d\u5728\u4ea4\u6613\u4e2d");
                    errorList.add(errorInfo);
                    continue;
                }
                CourierPOExample courierPoExample = new CourierPOExample();
                courierPoExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andNameEqualTo(shippingVendor);
                List courierPoList = this.courierPOMapper.selectByExample(courierPoExample);
                if (CollectionUtils.isEmpty((Collection)courierPoList)) {
                    SendInfoErrorExportMessageVO errorInfo3 = this.gatherErrorMessage(batchSendExportTempleVo, "\u5fae\u5546\u57ce\u4e2d\u5feb\u9012\u516c\u53f8\u4e0d\u5b58\u5728\uff01");
                    errorList.add(errorInfo3);
                    continue;
                }
                String ordersActivityType = ordersPo.getOrdersActivityType();
                log.info("\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)ordersPo));
                if (StringUtils.isEmpty((Object)ordersActivityType)) {
                    throw new MallAdminException("\u8be5\u8ba2\u5355\u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                }
                if (OrderActivityTypeEnum.PIT.getCode().equals(Integer.valueOf(ordersActivityType))) {
                    SendInfoErrorExportMessageVO errorInfo4;
                    MarketActivityOrdersPOExample marketActivityOrdersPOExample = new MarketActivityOrdersPOExample();
                    marketActivityOrdersPOExample.createCriteria().andOrdersNoEqualTo(orderNo).andMerchantIdEqualTo(merchantId).andValidEqualTo(Integer.valueOf(1));
                    List marketActivityOrdersPOS = this.marketActivityOrdersPOMapper.selectByExample(marketActivityOrdersPOExample);
                    log.info("marketActivityOrdersPOS_checkFullTeam:{}", (Object)JSON.toJSONString((Object)marketActivityOrdersPOS));
                    if (CollectionUtils.isEmpty((Collection)marketActivityOrdersPOS)) {
                        errorInfo4 = this.gatherErrorMessage(batchSendExportTempleVo, "\u62fc\u56e2\u8ba2\u5355\u6ca1\u6709\u6d3b\u52a8\u8ba2\u5355\u4fe1\u606f");
                        errorList.add(errorInfo4);
                        continue;
                    }
                    if (((MarketActivityOrdersPO)marketActivityOrdersPOS.get(0)).getOrdersStatus().equals(MarketOrderStatusEnum.GOING.getCode())) {
                        errorInfo4 = this.gatherErrorMessage(batchSendExportTempleVo, "\u62fc\u56e2\u5f85\u6210\u56e2");
                        errorList.add(errorInfo4);
                        continue;
                    }
                }
                if ((count = this.ordersStatusCheckMapper.checkOrderAfterSaleStatus(orderNo)) > 0) {
                    SendInfoErrorExportMessageVO errorInfo5 = this.gatherErrorMessage(batchSendExportTempleVo, "\u552e\u540e\u4e2d\u7684\u8ba2\u5355\u6682\u65f6\u4e0d\u652f\u6301\u53d1\u8d27\uff01");
                    errorList.add(errorInfo5);
                    continue;
                }
                log.info("\u5f00\u59cb\u5bf9\u7b26\u5408\u6761\u4ef6\u7684\u8ba2\u5355[" + orderNo + "]\u8fdb\u884c\u53d1\u8d27");
                OrdersPO sendOrder = new OrdersPO();
                Date date = new Date();
                sendOrder.setId(ordersPo.getId());
                sendOrder.setShippingVendor(shippingVendor);
                sendOrder.setShippingNo(shippingNo);
                sendOrder.setGmtModified(date);
                sendOrder.setShippingAt(date);
                sendOrder.setLogisticsStatus("SEND");
                int i = this.ordersPOMapper.updateByPrimaryKeySelective(sendOrder);
                if (i > 0) {
                    SendOrderMsgRecordPOWithBLOBs sendOrderMsgRecordPOWithBLOBs = new SendOrderMsgRecordPOWithBLOBs();
                    sendOrderMsgRecordPOWithBLOBs.setLogisticsStatus(Integer.valueOf(1));
                    sendOrderMsgRecordPOWithBLOBs.setGmtModified(date);
                    SendOrderMsgRecordPOExample sendOrderMsgRecordPOExample = new SendOrderMsgRecordPOExample();
                    sendOrderMsgRecordPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andOrderNoEqualTo(orderNo);
                    this.sendOrderMsgRecordPOMapper.updateByExampleSelective(sendOrderMsgRecordPOWithBLOBs, sendOrderMsgRecordPOExample);
                    this.scheduledThreadPoolExecutor.execute(() -> this.logisticsService.insertLogisticsRecord(merchantId, orderNo, ordersPo.getId()));
                }
                SendInfoErrorExportMessageVO successExportMessageVO = new SendInfoErrorExportMessageVO();
                successExportMessageVO.setIndex(batchSendExportTempleVo.getIndex());
                successExportMessageVO.setOrderNo(batchSendExportTempleVo.getOrderNo());
                successList.add(successExportMessageVO);
            }
            catch (Exception e) {
                SendInfoErrorExportMessageVO messageVO = this.gatherErrorMessage(batchSendExportTempleVo, e.getMessage());
                errorList.add(messageVO);
                log.warn("disposeSendInfoImport_error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("\u7ed3\u675f\u5904\u7406\u6279\u91cf\u53d1\u8d27\u6570\u636e");
        ExcelImportPOWithBLOBs record = new ExcelImportPOWithBLOBs();
        record.setEndTime(new Date(endTime));
        record.setSuccessInfo(JSON.toJSONString(successList));
        record.setSecondErrorInfo(JSON.toJSONString(errorList));
        record.setStatus(ImportConstant.EXCEL_IMPORT_STATUS_COMPLETED);
        record.setGmtModified(new Date());
        record.setExcelImportId(excelImportId);
        this.excelImportPOMapper.updateByPrimaryKeySelective(record);
        log.info("\u6279\u91cf\u53d1\u8d27\u4efb\u52a1\u5b8c\u6210");
        HashMap<String, List<SendInfoErrorExportMessageVO>> secondStageInfoMap = new HashMap<String, List<SendInfoErrorExportMessageVO>>();
        secondStageInfoMap.put("secondErrorInfoMap", errorList);
        secondStageInfoMap.put("secondSuccessInfoMap", successList);
        return secondStageInfoMap;
    }

    private SendInfoErrorExportMessageVO gatherErrorMessage(BatchSendExportTempleVO batchSendExportTempleVo, String errorMsg) {
        SendInfoErrorExportMessageVO errorExportMessageVO = new SendInfoErrorExportMessageVO();
        errorExportMessageVO.setIndex(batchSendExportTempleVo.getIndex());
        errorExportMessageVO.setErrorMsg(errorMsg);
        errorExportMessageVO.setOrderNo(batchSendExportTempleVo.getOrderNo());
        errorExportMessageVO.setShippingVendor(batchSendExportTempleVo.getShippingVendor());
        errorExportMessageVO.setShippingNo(batchSendExportTempleVo.getShippingNo());
        return errorExportMessageVO;
    }

    private boolean rowIsNull(String ... param) {
        for (String s : param) {
            if (StringUtils.isEmpty((Object)s)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String getValue(Cell cell) {
        String value = "";
        if (cell == null) {
            return value;
        }
        int cellType = cell.getCellType();
        switch (cellType) {
            case 0: {
                value = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                break;
            }
            case 1: {
                value = cell.getStringCellValue();
                break;
            }
            default: {
                log.info("cellType\u6709\u8bef\uff01:{}", (Object)cellType);
            }
        }
        return value;
    }

    private static String getHandleValue(String value) {
        if (Strings.isNotBlank((String)value) && value.indexOf(".") > 0) {
            int index = value.indexOf(".");
            value = value.substring(0, index);
        }
        return value;
    }

    private OrdersPO convertShippingInfoToModifyOrdersPo(ShippingInfoRequestVO shippingInfoRequestVO, OrdersPO ordersPo, Date modifyDate) {
        boolean isUpdate = false;
        OrdersPO modifyOrdersPo = new OrdersPO();
        modifyOrdersPo.setGmtModified(modifyDate);
        modifyOrdersPo.setId(ordersPo.getId());
        if (!ordersPo.getShippingName().equals(shippingInfoRequestVO.getShippingName())) {
            modifyOrdersPo.setShippingName(shippingInfoRequestVO.getShippingName());
            isUpdate = true;
        }
        if (!ordersPo.getShippingMobile().equals(shippingInfoRequestVO.getShippingMobile())) {
            modifyOrdersPo.setShippingMobile(shippingInfoRequestVO.getShippingMobile());
            isUpdate = true;
        }
        if (!ordersPo.getShippingProvince().equals(shippingInfoRequestVO.getShippingProvince())) {
            modifyOrdersPo.setShippingProvince(shippingInfoRequestVO.getShippingProvince());
            isUpdate = true;
        }
        if (!ordersPo.getShippingCity().equals(shippingInfoRequestVO.getShippingCity())) {
            modifyOrdersPo.setShippingCity(shippingInfoRequestVO.getShippingCity());
            isUpdate = true;
        }
        if (!ordersPo.getShippingDistrict().equals(shippingInfoRequestVO.getShippingDistrict())) {
            modifyOrdersPo.setShippingDistrict(shippingInfoRequestVO.getShippingDistrict());
            isUpdate = true;
        }
        if (!ordersPo.getShippingAddress().equals(shippingInfoRequestVO.getShippingAddress())) {
            modifyOrdersPo.setShippingAddress(shippingInfoRequestVO.getShippingAddress());
            isUpdate = true;
        }
        if (!isUpdate) {
            throw new MallAdminException("\u8be5\u8ba2\u5355\u53d1\u8d27\u4fe1\u606f\u5df2\u7ecf\u662f\u4f60\u60f3\u8981\u7684\u4e86\u54e6\uff01");
        }
        return modifyOrdersPo;
    }

    @Override
    public ResponseData preSellOrderApproval(Integer merchantId, PreSellOrderApprovalVO preSellOrderApprovalVO) {
        Integer orderId = preSellOrderApprovalVO.getOrderId();
        Integer approvalStatus = preSellOrderApprovalVO.getApprovalStatus();
        if (approvalStatus == null) {
            return ResponseUtil.getFailedMsg((String)"approvalStatus\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        OrdersPO ordersPO = this.ordersPOMapper.selectByPrimaryKey(orderId);
        if (ordersPO == null) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        OrdersPO ordersPOParam = new OrdersPO();
        ordersPOParam.setId(orderId);
        ordersPOParam.setPresellOrderStatus(approvalStatus);
        ordersPOParam.setGmtModified(new Date());
        this.ordersPOMapper.updateByPrimaryKeySelective(ordersPOParam);
        return ResponseUtil.getSuccessData(null, (String)"\u5b9a\u91d1\u9884\u552e\u5b9a\u91d1\u9000\u6b3e\u5ba1\u6279\u6210\u529f");
    }

    @Override
    public OrdersPO queryByMerchantIdWithOrderNo(Integer merchantId, String orderNo) {
        log.info("OrderNewServiceImpl#queryByMerchantIdWithOrderNo:[{}]---[{}]", (Object)merchantId, (Object)orderNo);
        try {
            OrdersPOExample ordersPOExample = new OrdersPOExample();
            ordersPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andOrderNoEqualTo(orderNo);
            List poList = this.ordersPOMapper.selectByExample(ordersPOExample);
            log.info("poList:{}", (Object)JSON.toJSONString((Object)poList));
            if (!CollectionUtils.isEmpty((Collection)poList)) {
                return (OrdersPO)poList.get(0);
            }
            return null;
        }
        catch (Exception e) {
            log.warn("OrderNewServiceImpl#queryByMerchantIdWithOrderNo\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Override
    public OrdersPO queryById(Integer orderIdCanEmpty) {
        return this.ordersPOMapper.selectByPrimaryKey(orderIdCanEmpty);
    }
}

