/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.jobhandler.integral;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralConfigPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralConfigPO;
import com.wmeimob.fastboot.bizvane.po.IntegralConfigPOExample;
import com.wmeimob.fastboot.bizvane.service.CommonIntegralOrdersService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@JobHandler(value="IntegralOrderProcessingJob")
public class IntegralOrderProcessing
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(IntegralOrderProcessing.class);
    @Resource
    private IntegralConfigPOMapper integralConfigPoMapper;
    @Resource
    private CommonIntegralOrdersService commonIntegralOrdersService;

    public ReturnT<String> execute(String s) throws Exception {
        log.info("IntegralOrderProcessing#execute:{}", (Object)JSON.toJSONString((Object)s));
        IntegralConfigPOExample example = new IntegralConfigPOExample();
        example.createCriteria().andValidEqualTo(Boolean.TRUE);
        List integralConfigList = this.integralConfigPoMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isEmpty((Collection)integralConfigList)) {
            log.info("IntegralOrderProcessing@\u76f8\u5173\u914d\u7f6e\u4e3a\u7a7a");
            return ReturnT.FAIL;
        }
        log.info("IntegralOrderProcessing#execute#integralConfigList:{}", (Object)JSON.toJSONString((Object)integralConfigList));
        List merchantIdList = integralConfigList.stream().map(IntegralConfigPO::getMerchantId).collect(Collectors.toList());
        for (Integer merchantId : merchantIdList) {
            try {
                this.commonIntegralOrdersService.settle(merchantId);
            }
            catch (Exception e) {
                log.warn("IntegralOrderProcessing#execute\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            }
        }
        return ReturnT.SUCCESS;
    }
}

