/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.fegin.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.utils.responseinfo.ResponseData;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrdersDetails;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersDetailsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.fegin.IntegralApiService;
import com.wmeimob.fastboot.bizvane.service.huairen.vo.BaseResponse;
import com.wmeimob.fastboot.bizvane.vo.fegin.IntegralOrderDetailRequestVo;
import com.wmeimob.fastboot.bizvane.vo.fegin.IntegralOrderRequestVo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralApiServiceImpl
implements IntegralApiService {
    private static final Logger log = LoggerFactory.getLogger(IntegralApiServiceImpl.class);
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Resource
    private IntegralOrdersMapper integralOrdersMapper;
    @Resource
    private IntegralOrdersPOMapper integralOrdersPOMapper;
    @Resource
    private IntegralOrdersDetailsMapper integralOrdersDetailsMapper;
    @Resource
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Resource
    private IntegralGoodsMapper integralGoodsMapper;
    @Resource
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;
    @Autowired
    private BrandServiceRpc brandServiceRpc;

    @Override
    @Async
    public void pushOrderToConnector(String orderNo) {
        log.info("IntegralApiServiceImpl_pushOrderToConnector\u53c2\u6570:{}", (Object)orderNo);
        Example integralOrdersExample = new Example(IntegralOrders.class);
        integralOrdersExample.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        IntegralOrders integralOrders = (IntegralOrders)this.integralOrdersMapper.selectOneByExample((Object)integralOrdersExample);
        if (integralOrders == null) {
            log.error("pustIntegralOrder IntegralOrders\u4e3a\u7a7a,\u76f4\u63a5return");
            return;
        }
        log.info("IntegralOrders:{}", (Object)JSON.toJSONString((Object)integralOrders));
        Example integralOrdersDetailsExample = new Example(IntegralOrdersDetails.class);
        integralOrdersDetailsExample.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        List integralOrdersDetails = this.integralOrdersDetailsMapper.selectByExample((Object)integralOrdersDetailsExample);
        IntegralOrderRequestVo integralOrderRequestVo = new IntegralOrderRequestVo();
        integralOrderRequestVo.setConsigneeName(integralOrders.getShippingName());
        integralOrderRequestVo.setConsigneePhone(integralOrders.getShippingMobile());
        integralOrderRequestVo.setConsigneeProvince(integralOrders.getShippingProvince());
        integralOrderRequestVo.setConsigneeCity(integralOrders.getShippingCity());
        integralOrderRequestVo.setConsigneeArea(integralOrders.getShippingDistrict());
        integralOrderRequestVo.setConsigneeDetailed(integralOrders.getShippingAddress());
        integralOrderRequestVo.setOrderNo(integralOrders.getOrderNo());
        integralOrderRequestVo.setOrderTime(integralOrders.getOrderTime());
        integralOrderRequestVo.setStoreCode(integralOrders.getStoreCode());
        integralOrderRequestVo.setCardNo(integralOrders.getMemberCardNo());
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)integralOrders.getGoodId());
        log.info("IntegralApiServiceImpl#pushOrderToConnector#integralGoods:{}", (Object)JSON.toJSONString((Object)integralGoods));
        if (integralGoods != null && StringUtils.isNotBlank((CharSequence)integralGoods.getClubId())) {
            integralOrderRequestVo.setBrandId(Integer.valueOf(integralGoods.getClubId()));
            ResponseData brandByID = this.brandServiceRpc.getBrandByID(Long.valueOf(integralGoods.getClubId()));
            integralOrderRequestVo.setBrandCode(((SysBrandPo)brandByID.getData()).getBrandCode());
        }
        if ("JH".equals(integralOrderRequestVo.getBrandCode())) {
            return;
        }
        Integer costPoints = 0;
        ArrayList<IntegralOrderDetailRequestVo> integralOrderDetailRequestVos = new ArrayList<IntegralOrderDetailRequestVo>();
        for (IntegralOrdersDetails integralOrdersDetail : integralOrdersDetails) {
            Integer saleIntegral = integralOrdersDetail.getSaleIntegral();
            Integer saleQuantity = integralOrdersDetail.getSaleQuantity();
            costPoints = costPoints + saleIntegral * saleQuantity;
            IntegralOrderDetailRequestVo integralOrderDetailRequestVo = new IntegralOrderDetailRequestVo();
            integralOrderDetailRequestVo.setGoodsName(integralGoods.getGoodsName());
            integralOrderDetailRequestVo.setGoodsSkuNo(integralOrdersDetail.getGoodsSkuNo());
            integralOrderDetailRequestVo.setSaleQuantity(saleQuantity);
            integralOrderDetailRequestVo.setSaleIntegral(saleIntegral);
            integralOrderDetailRequestVos.add(integralOrderDetailRequestVo);
        }
        integralOrderRequestVo.setCostPoints(costPoints);
        integralOrderRequestVo.setOrderDetail(integralOrderDetailRequestVos);
        log.info("\u8c03\u7528ConnectorServiceFeign.addIntegralOrder-->param:{}", (Object)JSON.toJSONString((Object)integralOrderRequestVo));
        BaseResponse memberInfoModelBaseResponse = null;
        try {
            memberInfoModelBaseResponse = this.bizvaneInterface.pushOrderToConnector(integralOrderRequestVo);
            log.info("\u8c03\u7528ConnectorServiceFeign.addIntegralOrder-->result:{}", (Object)JSON.toJSONString((Object)memberInfoModelBaseResponse));
        }
        catch (Exception e) {
            log.info("\u8c03\u7528ConnectorServiceFeign.addIntegralOrder-->error:{}", (Throwable)e);
        }
        int code = memberInfoModelBaseResponse.getCode();
        IntegralOrdersPO integralOrdersPO = new IntegralOrdersPO();
        integralOrdersPO.setId(integralOrders.getId());
        integralOrdersPO.setSyncOfflineResult(memberInfoModelBaseResponse.getMessage());
        if (code == 0) {
            integralOrdersPO.setSyncOfflineState(Integer.valueOf(1));
        } else {
            integralOrdersPO.setSyncOfflineState(Integer.valueOf(2));
        }
        this.integralOrdersPOMapper.updateByPrimaryKeySelective(integralOrdersPO);
    }
}

