/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.Integralstore.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.constants.integaral_shop.IntegralConfigConstants;
import com.wmeimob.fastboot.bizvane.po.IntegralConfigPO;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrderJobService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrdersNewService;
import com.wmeimob.fastboot.bizvane.utils.jobutils.XxlJobUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegralOrderJobServiceImpl
implements IntegralOrderJobService {
    private static final Logger log = LoggerFactory.getLogger(IntegralOrderJobServiceImpl.class);
    @Autowired
    private XxlJobUtil xxlJobUtil;
    @Autowired
    private IntegralOrdersNewService integralOrdersNewService;

    @Override
    public ResponseData<Boolean> addCustomizedIntegralOrderCancelJob(Integer merchantId, String orderNo) {
        log.info("IntegralOrderJobServiceImpl#addCustomizedIntegralOrderCancelJob:merchantId={},orderNo={}", (Object)merchantId, (Object)orderNo);
        ResponseData responseData = new ResponseData();
        responseData.setData((Object)Boolean.FALSE);
        responseData.setCode(100);
        try {
            IntegralOrdersPO integralOrdersPo = this.integralOrdersNewService.queryIntegralOrderByOrderNo(orderNo);
            log.info("\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)integralOrdersPo));
            IntegralConfigPO integralConfigPo = this.integralOrdersNewService.queryIntegralConfigByMerchantId(merchantId);
            if (IntegralConfigConstants.IS_TIMED_CANCEL_ORDER.equals(integralConfigPo.getIsTimedCancelOrder())) {
                Integer awaitOrderCancel = integralConfigPo.getAwaitOrderCancel();
                Date orderTime = integralOrdersPo.getOrderTime();
                Date executeDate = DateUtils.addMinutes((Date)orderTime, (int)awaitOrderCancel);
                this.integralOrdersNewService.updateCancelTimeById(integralOrdersPo.getId(), executeDate);
                JSONObject paramsJsonObject = new JSONObject();
                paramsJsonObject.put("merchantId", (Object)merchantId);
                paramsJsonObject.put("orderNo", (Object)orderNo);
                String paramsJsonString = paramsJsonObject.toString();
                log.info("\u6267\u884c\u53c2\u6570\uff1a{}", (Object)paramsJsonString);
                String bizCode = merchantId + "," + orderNo;
                this.xxlJobUtil.addJob(executeDate, "\u79ef\u5206\u5546\u57ce\u672a\u652f\u4ed8\u8ba2\u5355\u81ea\u52a8\u53d6\u6d88", paramsJsonString, "mall_admin", "CustomizedIntegralOrderCancelJob", 1, bizCode, "mall-admin");
                responseData.setCode(0);
                responseData.setData((Object)Boolean.TRUE);
                return responseData;
            }
            responseData.setCode(0);
            responseData.setData((Object)Boolean.TRUE);
            responseData.setMessage("\u6ca1\u6709\u5f00\u542f\u5b9a\u65f6\u81ea\u52a8\u5173\u95ed\uff0c\u4e0d\u9700\u8981\u521b\u5efa\u5b9a\u65f6job");
            return responseData;
        }
        catch (Exception e) {
            log.warn("IntegralOrderJobServiceImpl#addCustomizedIntegralOrderCancelJob\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            responseData.setMessage("\u521b\u5efa\u5b9a\u65f6\u5173\u95ed\u672a\u652f\u4ed8\u8ba2\u5355\u65f6\u5f02\u5e38:" + e.getMessage());
            return responseData;
        }
    }
}

