/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropHead;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropValue;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropHeadMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropValueCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropValueMapper;
import com.wmeimob.fastboot.bizvane.service.GoodsPropService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class GoodsPropServiceImpl
implements GoodsPropService {
    private static final Logger log = LoggerFactory.getLogger(GoodsPropServiceImpl.class);
    @Autowired
    private GoodsPropHeadMapper goodsPropHeadMapper;
    @Autowired
    private GoodsPropValueMapper goodsPropValueMapper;
    @Autowired
    private GoodsPropValueCustomMapper goodsPropValueCustomMapper;

    public GoodsPropHead add(GoodsPropHead goodsPropHead) {
        InputValidator.checkEmpty((Object)goodsPropHead.getHeadName(), (String)"\u5c5e\u6027\u540d\u79f0");
        InputValidator.checkEmpty((Object)goodsPropHead.getSort(), (String)"\u6392\u5e8f\u503c");
        Example example = new Example(GoodsPropHead.class);
        example.createCriteria().andEqualTo("headName", (Object)goodsPropHead.getHeadName()).andEqualTo("merchantId", (Object)goodsPropHead.getMerchantId());
        List goodsPropHeads = this.goodsPropHeadMapper.selectByExample((Object)example);
        if (goodsPropHeads.size() > 0) {
            throw new CustomException("\u5c5e\u6027\u540d\u79f0\u91cd\u590d");
        }
        List values = goodsPropHead.getGoodsPropValues();
        if (values.size() < 1) {
            throw new CustomException("\u53ef\u9009\u9879\u4e0d\u53ef\u4e3a\u7a7a");
        }
        Date date = new Date();
        goodsPropHead.setGmtCreate(date);
        this.goodsPropHeadMapper.insert((Object)goodsPropHead);
        for (GoodsPropValue gpv : values) {
            gpv.setHeadId(goodsPropHead.getId());
            gpv.setGmtCreate(date);
        }
        this.goodsPropValueMapper.insertList(values);
        return goodsPropHead;
    }

    public int update(GoodsPropHead goodsPropHead) {
        InputValidator.checkEmpty((Object)goodsPropHead.getHeadName(), (String)"\u5c5e\u6027\u540d\u79f0");
        InputValidator.checkEmpty((Object)goodsPropHead.getSort(), (String)"\u6392\u5e8f\u503c");
        List values = goodsPropHead.getGoodsPropValues();
        if (values.size() < 1) {
            throw new CustomException("\u53ef\u9009\u9879\u4e0d\u53ef\u4e3a\u7a7a");
        }
        Date date = new Date();
        goodsPropHead.setGmtModified(date);
        for (GoodsPropValue gpv : values) {
            if (gpv.getId() == null) {
                gpv.setHeadId(goodsPropHead.getId());
                gpv.setGmtCreate(date);
                this.goodsPropValueMapper.insertSelective((Object)gpv);
                continue;
            }
            gpv.setGmtModified(date);
            this.goodsPropValueMapper.updateByPrimaryKeySelective((Object)gpv);
        }
        return this.goodsPropHeadMapper.updateByPrimaryKeySelective((Object)goodsPropHead);
    }

    public int delete(Integer id) {
        Example example = new Example(GoodsPropValue.class);
        example.createCriteria().andEqualTo("headId", (Object)id);
        List goodsPropValues = this.goodsPropValueMapper.selectByExample((Object)example);
        for (GoodsPropValue g : goodsPropValues) {
            this.deletePropValue(g.getId());
        }
        this.goodsPropValueMapper.deleteByExample((Object)example);
        return this.goodsPropHeadMapper.deleteByPrimaryKey((Object)id);
    }

    public int deletePropValue(Integer id) {
        Integer integer = this.goodsPropValueCustomMapper.selectCountGoodsByValueId(id);
        if (integer > 0) {
            throw new CustomException("\u5206\u7c7b\u4e0b\u8fd8\u6709\u5546\u54c1\uff0c\u5220\u9664\u5931\u8d25");
        }
        return this.goodsPropValueMapper.deleteByPrimaryKey((Object)id);
    }

    public List<GoodsPropValue> selectByHeadId(Integer id, String headName) {
        return this.goodsPropValueMapper.selectListByHeadId(id, headName);
    }

    public List<GoodsPropHead> findByCondition(GoodsPropHead condition) {
        List goodsPropHeadList = this.goodsPropHeadMapper.selectList(condition);
        log.info("\u5c5e\u6027\u5217\u8868\uff1a" + JSON.toJSONString((Object)goodsPropHeadList));
        return goodsPropHeadList;
    }
}

