/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.newseckill;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityStatus;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityService;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.ActivityRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SecKillActivityConfigReplaceRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityDetailResponseVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityDisableRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsDTO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivitySearchRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivitySearchResponseVO;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"seckill/activity"})
public class SeckillActivityController {
    private static final Logger log = LoggerFactory.getLogger(SeckillActivityController.class);
    @Autowired
    private SeckillActivityService seckillActivityService;

    @GetMapping(value={"querySecKillActivityConfigList"})
    public ResponseData<SeckillActivitySearchResponseVO> querySecKillActivityConfigList(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody SeckillActivitySearchRequestVO requestVO) {
        requestVO.setMerchantId(merchantId);
        PageInfo<SeckillActivitySearchResponseVO> result = this.seckillActivityService.querySecKillActivityConfigList(requestVO);
        return ResponseUtil.getSuccessData(result);
    }

    @GetMapping(value={"checkOverlapGoods"})
    public ResponseData<List<String>> checkOverlapGoods(List<Integer> goodsIds) {
        return ResponseUtil.getSuccessData(this.seckillActivityService.checkOverlapGoods(goodsIds));
    }

    @PostMapping(value={"addSecKillActivityConfig"})
    public ResponseData<List> addSecKillActivityConfig(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody SecKillActivityConfigReplaceRequestVO requestVO) {
        requestVO.setMerchantId(merchantId);
        return this.seckillActivityService.addSecKillActivityConfig(requestVO);
    }

    @PostMapping(value={"updateSecKillActivityConfig"})
    public ResponseData<Boolean> updateSecKillActivityConfig(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody SecKillActivityConfigReplaceRequestVO requestVO) {
        requestVO.setMerchantId(merchantId);
        return this.seckillActivityService.updateSecKillActivityConfig(requestVO);
    }

    @GetMapping(value={"querySecKillActivityGoods"})
    public ResponseData<SeckillActivityGoodsDTO> querySecKillActivityGoods(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody SeckillActivityGoodsRequestVO requestVO) {
        requestVO.setMerchantId(merchantId);
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        List<SeckillActivityGoodsDTO> list = this.seckillActivityService.querySecKillActivityGoods(requestVO);
        return ResponseUtil.getSuccessData((Object)new PageInfo(list));
    }

    @PostMapping(value={"secKillActivityDetail"})
    public ResponseData<SeckillActivityDetailResponseVO> secKillActivityDetail(@RequestParam(value="activityCode") String activityCode) {
        return this.seckillActivityService.secKillActivityDetail(activityCode);
    }

    @PostMapping(value={"disableActivity"})
    public ResponseData<SeckillActivityDetailResponseVO> disableActivity(@RequestBody SeckillActivityDisableRequestVO requestVO) {
        return ResponseUtil.getSuccessData((Object)this.seckillActivityService.disableActivity(requestVO));
    }

    @GetMapping(value={"queryActiveActivities"})
    public ResponseData<PageInfo<SeckillActivitySearchResponseVO>> queryActiveActivities(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody ActivityRequestVO requestVO) {
        requestVO.setMerchantId(merchantId);
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        requestVO.setStatuses((List)Lists.newArrayList((Object[])new Integer[]{SeckillActivityStatus.HAVE_NOT_START.getCode(), SeckillActivityStatus.ON_GOING.getCode()}));
        List<SeckillActivitySearchResponseVO> result = this.seckillActivityService.queryActivities(requestVO, true, true);
        return ResponseUtil.getSuccessData((Object)new PageInfo(result));
    }
}

