/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.AnalysisQuerySkuRes;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.service.ReducePriceAnalysisService;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reduceActivity"})
public class ReducePriceActivityController {
    @Autowired
    private ReducePriceAnalysisService reducePriceAnalysisService;

    @GetMapping(value={"/analysis"})
    @ResponseBody
    public RestResult reducePriceAnalysis(@RequestParam(value="activityNo") String activityNo) {
        Map<String, Object> maps = null;
        try {
            maps = this.reducePriceAnalysisService.queryAnalysisResult(activityNo);
        }
        catch (Exception e) {
            return RestResult.fail((String)e.getMessage());
        }
        return RestResult.success(maps);
    }

    @GetMapping(value={"/productInfo"})
    @ResponseBody
    public RestResult queryActivityProductInfo(@RequestParam(value="activityNo") String activityNo, @RequestParam(value="goodsName", required=false) String goodsName, @RequestParam(value="goodsNo", required=false) String goodsNo, @RequestParam(value="skuNo", required=false) String skuNo, @RequestParam(value="orderBySign", defaultValue="desc", required=false) String orderBySign, @RequestParam(value="pageNum", defaultValue="0") String pageNum, @RequestParam(value="pageSize", defaultValue="10") String pageSize) {
        MarketActivityGoods marketActivityGoods = new MarketActivityGoods();
        marketActivityGoods.setMarketActivityNo(activityNo);
        marketActivityGoods.setGoodsName(goodsName);
        marketActivityGoods.setGoodsNo(goodsNo);
        PageInfo<AnalysisQuerySkuRes> pages = null;
        HashMap<String, PageInfo<AnalysisQuerySkuRes>> map = new HashMap<String, PageInfo<AnalysisQuerySkuRes>>();
        try {
            pages = this.reducePriceAnalysisService.queryActivityGoodAnalysis(marketActivityGoods, orderBySign, pageNum, pageSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.fail((String)e.getMessage());
        }
        if (pages == null || CollectionUtils.isEmpty((Collection)pages.getList())) {
            RestResult.fail((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7ed3\u679c");
        }
        map.put("result", pages);
        return RestResult.success(map);
    }
}

