/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.rpc;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ConfigPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.WechatMchPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.ConfigPO;
import com.wmeimob.fastboot.bizvane.po.ConfigPOExample;
import com.wmeimob.fastboot.bizvane.po.WechatMchPO;
import com.wmeimob.fastboot.bizvane.po.WechatMchPOExample;
import com.wmeimob.fastboot.bizvane.service.rpc.MerchantRpcService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.rpc.ConfigRpcResponseVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.MallMerchantModifyVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.MallMerchantVO;
import com.wmeimob.fastboot.bizvane.vo.rpc.SysBrandPo;
import com.wmeimob.fastboot.bizvane.vo.rpc.SysCompanyPo;
import com.wmeimob.fastboot.bizvane.vo.rpc.SysMerchantPo;
import com.wmeimob.fastboot.bizvane.vo.rpc.WxPublicPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MerchantRpcServiceImpl
implements MerchantRpcService {
    private static final Logger log = LoggerFactory.getLogger(MerchantRpcServiceImpl.class);
    @Autowired
    private ConfigPOMapper mallConfigPoMapper;
    @Autowired
    private WechatMchPOMapper mallWechatMchPoMapper;
    @Autowired
    private CompanyBrandRelationPOMapper mallCompanyBrandRelationPoMapper;

    public ResponseData<ConfigRpcResponseVO> selectByMerchantId(@RequestParam(value="merchantId") Integer merchantId) {
        ConfigPOExample ConfigPOExample2 = new ConfigPOExample();
        ConfigRpcResponseVO configRpcResponseVO = new ConfigRpcResponseVO();
        ConfigPOExample2.createCriteria().andMerchantIdEqualTo(merchantId);
        List mallConfigPos = this.mallConfigPoMapper.selectByExample(ConfigPOExample2);
        if (CollectionUtils.isEmpty((Collection)mallConfigPos)) {
            return ResponseUtil.getFailedMsg((String)"\u5f53\u524d\u5546\u6237\u4e0b\u672a\u65b0\u589e\u914d\u7f6econfig!");
        }
        ConfigPO ConfigPO2 = (ConfigPO)mallConfigPos.get(0);
        configRpcResponseVO.setAppId(ConfigPO2.getTitle());
        WechatMchPOExample WechatMchPOExample2 = new WechatMchPOExample();
        WechatMchPOExample2.createCriteria().andMerchantIdEqualTo(merchantId);
        List mallWechatMchPos = this.mallWechatMchPoMapper.selectByExample(WechatMchPOExample2);
        if (CollectionUtils.isEmpty((Collection)mallWechatMchPos)) {
            return ResponseUtil.getFailedMsg((String)"\u5f53\u524d\u5546\u6237\u4e0b\u672a\u65b0\u589e\u914d\u7f6ewechat_mch!");
        }
        WechatMchPO WechatMchPO2 = (WechatMchPO)mallWechatMchPos.get(0);
        configRpcResponseVO.setAppId(WechatMchPO2.getAppId());
        configRpcResponseVO.setMchKey(WechatMchPO2.getMchKey());
        configRpcResponseVO.setMchNo(WechatMchPO2.getMchNo());
        configRpcResponseVO.setP12SetFlag(WechatMchPO2.getP12SetFlag());
        configRpcResponseVO.setMerchantId(merchantId);
        configRpcResponseVO.setFileName(WechatMchPO2.getP12FileName());
        return ResponseUtil.getSuccessData((Object)configRpcResponseVO, (String)"\u67e5\u8be2\u914d\u7f6e\u6210\u529f!");
    }

    public ResponseData createOrReplaceByMerchantId(@RequestBody MallMerchantVO mallMerchantVO) {
        log.info("createOrReplaceByMerchantId\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)mallMerchantVO));
        SysMerchantPo sysMerchantPo = mallMerchantVO.getSysMerchantPo();
        Integer merchantId = sysMerchantPo.getSysMerchantId().intValue();
        String title = sysMerchantPo.getMerchantName();
        MallMerchantModifyVO modifyVO = mallMerchantVO.getModifyVO();
        byte[] p12 = modifyVO.getP12();
        String mchKey = (String)StringUtils.defaultIfEmpty((CharSequence)modifyVO.getMchKey(), (CharSequence)"");
        String mchNo = (String)StringUtils.defaultIfEmpty((CharSequence)modifyVO.getMchNo(), (CharSequence)"");
        SysBrandPo sysBrandPo = mallMerchantVO.getSysBrandPo();
        SysCompanyPo sysCompanyPo = mallMerchantVO.getSysCompanyPo();
        ConfigPOExample ConfigPOExample2 = new ConfigPOExample();
        ConfigPOExample2.createCriteria().andMerchantIdEqualTo(merchantId);
        List mallConfigPos = this.mallConfigPoMapper.selectByExample(ConfigPOExample2);
        ConfigPO ConfigPO2 = null;
        if (CollectionUtils.isEmpty((Collection)mallConfigPos)) {
            log.info("\u65b0\u589econfig\u914d\u7f6e");
            ConfigPO2 = new ConfigPO();
            ConfigPO2.setMerchantId(merchantId);
            ConfigPO2.setGmtCreate(new Date());
            ConfigPO2.setTitle(title);
            this.mallConfigPoMapper.insertSelective(ConfigPO2);
            log.info("\u65b0\u589econfig\u914d\u7f6e,\u65b0\u589e\u540e:{}", (Object)JSON.toJSONString((Object)ConfigPO2));
        } else {
            ConfigPO2 = (ConfigPO)mallConfigPos.get(0);
            log.info("\u66f4\u65b0config\u914d\u7f6e,\u66f4\u65b0\u524d:{}", (Object)JSON.toJSONString((Object)ConfigPO2));
            ConfigPO mallConfigPoParam = new ConfigPO();
            mallConfigPoParam.setTitle(title);
            mallConfigPoParam.setGmtModified(new Date());
            mallConfigPoParam.setId(ConfigPO2.getId());
            log.info("\u66f4\u65b0config\u914d\u7f6e,\u66f4\u65b0\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)mallConfigPoParam));
            this.mallConfigPoMapper.updateByPrimaryKeySelective(mallConfigPoParam);
        }
        WechatMchPOExample WechatMchPOExample2 = new WechatMchPOExample();
        WechatMchPOExample2.createCriteria().andMerchantIdEqualTo(merchantId);
        List mallWechatMchPos = this.mallWechatMchPoMapper.selectByExample(WechatMchPOExample2);
        WxPublicPO wxPublicPO = mallMerchantVO.getWxPublicPO();
        String appid = null;
        if (wxPublicPO != null) {
            appid = wxPublicPO.getAppid();
        }
        WechatMchPO WechatMchPO2 = null;
        if (CollectionUtils.isEmpty((Collection)mallWechatMchPos)) {
            log.info("\u65b0\u589ewechat_mch\u914d\u7f6e");
            WechatMchPO2 = new WechatMchPO();
            WechatMchPO2.setMerchantId(merchantId);
            WechatMchPO2.setMchKey(mchKey);
            WechatMchPO2.setMchNo(mchNo);
            WechatMchPO2.setAppId(appid);
            if (p12 != null) {
                WechatMchPO2.setP12(p12);
                WechatMchPO2.setP12SetFlag(Boolean.TRUE);
                WechatMchPO2.setP12FileUrl(modifyVO.getFileUrl());
                WechatMchPO2.setP12FileName(modifyVO.getFileName());
            } else {
                WechatMchPO2.setP12(new byte[0]);
            }
            this.mallWechatMchPoMapper.insertSelective(WechatMchPO2);
            log.info("\u65b0\u589ewechat_mch\u914d\u7f6e,\u65b0\u589e\u540e:{}", (Object)JSON.toJSONString((Object)ConfigPO2));
        } else {
            WechatMchPO2 = (WechatMchPO)mallWechatMchPos.get(0);
            log.info("\u66f4\u65b0wechat_mch\u914d\u7f6e,\u66f4\u65b0\u524d:{}", (Object)JSON.toJSONString((Object)WechatMchPO2));
            WechatMchPO mallWechatMchPoParam = new WechatMchPO();
            mallWechatMchPoParam.setMchKey(mchKey);
            mallWechatMchPoParam.setMchNo(mchNo);
            if (p12 != null) {
                mallWechatMchPoParam.setP12(p12);
                mallWechatMchPoParam.setP12SetFlag(Boolean.TRUE);
                mallWechatMchPoParam.setP12FileUrl(modifyVO.getFileUrl());
                mallWechatMchPoParam.setP12FileName(modifyVO.getFileName());
            }
            mallWechatMchPoParam.setId(WechatMchPO2.getId());
            mallWechatMchPoParam.setAppId(appid);
            log.info("\u66f4\u65b0wechat_mch\u914d\u7f6e,\u66f4\u65b0\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)mallWechatMchPoParam));
            this.mallWechatMchPoMapper.updateByPrimaryKeySelective(mallWechatMchPoParam);
        }
        CompanyBrandRelationPOExample CompanyBrandRelationPOExample2 = new CompanyBrandRelationPOExample();
        CompanyBrandRelationPOExample2.createCriteria().andMerchantIdEqualTo(merchantId);
        List mallCompanyBrandRelationPos = this.mallCompanyBrandRelationPoMapper.selectByExample(CompanyBrandRelationPOExample2);
        if (CollectionUtils.isEmpty((Collection)mallCompanyBrandRelationPos)) {
            log.info("\u65b0\u589ecompany_brand_relation\u914d\u7f6e");
            CompanyBrandRelationPO CompanyBrandRelationPO2 = new CompanyBrandRelationPO();
            CompanyBrandRelationPO2.setBrandId(Integer.valueOf(sysBrandPo.getSysBrandId().intValue()));
            CompanyBrandRelationPO2.setMerchantId(merchantId);
            CompanyBrandRelationPO2.setCompanyId(Integer.valueOf(sysCompanyPo.getSysCompanyId().intValue()));
            CompanyBrandRelationPO2.setCompanyName(sysCompanyPo.getCompanyName());
            CompanyBrandRelationPO2.setMerchantName(title);
            CompanyBrandRelationPO2.setMerchantCode(sysMerchantPo.getMerchantCode());
            CompanyBrandRelationPO2.setAuthenticationKey(UUID.randomUUID().toString());
            CompanyBrandRelationPO2.setIsDefault(sysMerchantPo.getIsDefault());
            this.mallCompanyBrandRelationPoMapper.insertSelective(CompanyBrandRelationPO2);
            log.info("\u65b0\u589ecompany_brand_relation\u914d\u7f6e,\u65b0\u589e\u540e:{}", (Object)JSON.toJSONString((Object)CompanyBrandRelationPO2));
        } else {
            log.info("MerchantRpcServiceImpl#updatecompany_brand_relation\u914d\u7f6e");
            CompanyBrandRelationPO companyBrandRelationPO = new CompanyBrandRelationPO();
            companyBrandRelationPO.setBrandId(Integer.valueOf(sysBrandPo.getSysBrandId().intValue()));
            companyBrandRelationPO.setMerchantId(merchantId);
            companyBrandRelationPO.setCompanyId(Integer.valueOf(sysCompanyPo.getSysCompanyId().intValue()));
            companyBrandRelationPO.setCompanyName(sysCompanyPo.getCompanyName());
            companyBrandRelationPO.setMerchantName(title);
            companyBrandRelationPO.setMerchantCode(sysMerchantPo.getMerchantCode());
            companyBrandRelationPO.setAuthenticationKey(UUID.randomUUID().toString());
            companyBrandRelationPO.setIsDefault(sysMerchantPo.getIsDefault());
            log.info("MerchantRpcServiceImpl#updatecompany_brand_relation\u914d\u7f6e#updatePo:{}", (Object)JSON.toJSONString((Object)companyBrandRelationPO));
            int i = this.mallCompanyBrandRelationPoMapper.updateByExampleSelective(companyBrandRelationPO, CompanyBrandRelationPOExample2);
            log.info("MerchantRpcServiceImpl#updatecompany_brand_relation\u914d\u7f6e#\u4fee\u6539\u8bb0\u5f55\u6570:{}", (Object)i);
        }
        return ResponseUtil.getSuccessData(null, (String)"\u66f4\u65b0\u5fae\u5546\u57ce\u4fe1\u606f\u6210\u529f!");
    }
}

