/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.newseckill.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.wmeimob.fastboot.bizvane.bo.IntegralGoodsSearchBO;
import com.wmeimob.fastboot.bizvane.dto.GoodsStockChangeResponseDTO;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityStatus;
import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityType;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityConfigMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivitySkuMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityUpdateRecordMapper;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityConfigPO;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityGoodsPO;
import com.wmeimob.fastboot.bizvane.po.SeckillActivitySkuPO;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityUpdateRecordPO;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.bizvane.service.IntegralGoodsService;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityService;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.ActivityRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SecKillActivityConfigReplaceRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityDetailResponseVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityDisableRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsDTO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsSkuDTO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivitySearchRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivitySearchResponseVO;
import com.wmeimob.fastboot.bizvane.utils.BeanListUtil;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.config.MallAdminException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SeckillActivityServiceImpl
implements SeckillActivityService {
    @Autowired
    private SeckillActivityConfigMapper seckillActivityConfigMapper;
    @Autowired
    private IntegralGoodsService integralGoodsService;
    @Autowired
    private SeckillActivityGoodsMapper seckillActivityGoodsMapper;
    @Autowired
    private SeckillActivitySkuMapper seckillActivitySkuMapper;
    @Autowired
    private GoodsSkuDetailService goodsSkuDetailService;
    @Autowired
    private SeckillActivityUpdateRecordMapper seckillActivityUpdateRecordMapper;

    public PageInfo<SeckillActivitySearchResponseVO> querySecKillActivityConfigList(SeckillActivitySearchRequestVO requestVO) {
        SeckillActivityConfigPO configPO = new SeckillActivityConfigPO();
        BeanUtils.copyProperties((Object)requestVO, (Object)configPO);
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        List queryResult = this.seckillActivityConfigMapper.querySecKillActivityConfigList(configPO);
        List data = queryResult.stream().map(po -> {
            SeckillActivitySearchResponseVO vo = new SeckillActivitySearchResponseVO();
            BeanUtils.copyProperties((Object)po, (Object)vo);
            vo.setActivityRule(SeckillActivityType.getFormatRule((int)po.getActivityType(), (String)po.getActivityRule()));
            String status = SeckillActivityStatus.correctStatus((Integer)po.getActivityType(), (String)po.getActivityRule(), (Date)po.getSeckillStartTime(), (Date)po.getSeckillEndTime(), (boolean)po.getDisabled()).getMessage();
            vo.setActivityStatusDecr(status);
            vo.setGmtCreate(DateUtil.format((Date)po.getGmtCreate(), (String)DateUtil.ymdhms));
            return vo;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo(data);
        return result;
    }

    public List<Integer> checkOverlapGoods(List<Integer> goodsIds) {
        if (CollectionUtils.isEmpty(goodsIds)) {
            return new ArrayList<Integer>();
        }
        ActivityRequestVO activity = new ActivityRequestVO();
        activity.setStatuses((List)Lists.newArrayList((Object[])new Integer[]{SeckillActivityStatus.HAVE_NOT_START.getCode(), SeckillActivityStatus.ON_GOING.getCode()}));
        List response = this.queryActivities(activity, true, false);
        List activeGoodsIds = response.stream().map(SeckillActivitySearchResponseVO::getGoodsDTOS).flatMap(Collection::stream).map(SeckillActivityGoodsDTO::getGoodsId).collect(Collectors.toList());
        goodsIds.retainAll(activeGoodsIds);
        return goodsIds;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public ResponseData addSecKillActivityConfig(SecKillActivityConfigReplaceRequestVO requestVO) {
        LoginUser user = requestVO.getLoginUser();
        Pair fail = this.check(requestVO);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)fail.getLeft())) || StringUtils.isNotBlank((CharSequence)((CharSequence)fail.getRight()))) {
            return ResponseUtil.getFailedData((Object)fail.getLeft(), (String)((String)fail.getRight()));
        }
        String activityCode = this.generateCode();
        this.insertActivityConfig(requestVO, user, activityCode);
        this.insertGoods(user, requestVO.getGoodses(), activityCode, requestVO.getMerchantId());
        List skus = requestVO.getGoodses().stream().map(SeckillActivityGoodsDTO::getSkus).flatMap(Collection::stream).collect(Collectors.toList());
        this.insertSkus(user, activityCode, skus, requestVO.getMerchantId());
        return ResponseUtil.getSuccessData((Object)true);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public ResponseData updateSecKillActivityConfig(SecKillActivityConfigReplaceRequestVO requestVO) {
        LoginUser user = requestVO.getLoginUser();
        Pair fail = this.check(requestVO);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)fail.getLeft())) || StringUtils.isNotBlank((CharSequence)((CharSequence)fail.getRight()))) {
            return ResponseUtil.getFailedData((Object)fail.getLeft(), (String)((String)fail.getRight()));
        }
        ActivityRequestVO activity = new ActivityRequestVO();
        activity.setActivityCode(requestVO.getActivityCode());
        List activities = this.queryActivities(activity, true, true);
        if (CollectionUtils.isEmpty((Collection)activities)) {
            return ResponseUtil.getFailedData((Object)requestVO.getActivityCode(), (String)"\u79d2\u6740\u6d3b\u52a8\u672a\u627e\u5230");
        }
        SeckillActivitySearchResponseVO vo = (SeckillActivitySearchResponseVO)activities.get(0);
        SeckillActivityStatus currentStatus = SeckillActivityStatus.correctStatus((Integer)vo.getActivityType(), (String)vo.getActivityRule(), (Date)vo.getSeckillBeginTime(), (Date)vo.getSeckillEndTime(), (boolean)vo.getDisabled());
        if (!SeckillActivityStatus.HAVE_NOT_START.equals((Object)currentStatus)) {
            return ResponseUtil.getFailedData((Object)requestVO.getActivityCode(), (String)"\u6d3b\u52a8\u4e0d\u662f\u672a\u5f00\u59cb\u72b6\u6001");
        }
        this.updateActivityConfig(requestVO, user);
        List original = vo.getGoodsDTOS();
        List newGoods = requestVO.getGoodses();
        this.updateNewGoods(requestVO.getActivityCode(), user, original, newGoods, requestVO.getMerchantId());
        this.updateNewSkus(requestVO.getActivityCode(), user, original, newGoods, requestVO.getMerchantId());
        return ResponseUtil.getSuccessData((Object)true);
    }

    public List<SeckillActivityGoodsDTO> querySecKillActivityGoods(SeckillActivityGoodsRequestVO requestVO) {
        IntegralGoodsSearchBO integralGoodsSearchBO = new IntegralGoodsSearchBO();
        integralGoodsSearchBO.setSearchValue(requestVO.getSearchValue());
        integralGoodsSearchBO.setClassifyId(requestVO.getClassifyId());
        integralGoodsSearchBO.setMerchantId(requestVO.getMerchantId());
        List goodses = this.integralGoodsService.getGoods(integralGoodsSearchBO);
        return goodses.parallelStream().map(goods -> {
            if (!goods.getShelf().booleanValue()) {
                return null;
            }
            SeckillActivityGoodsDTO dto = new SeckillActivityGoodsDTO();
            BeanUtils.copyProperties((Object)goods, (Object)dto);
            return dto;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ResponseData<SeckillActivityDetailResponseVO> secKillActivityDetail(String activityCode) {
        ActivityRequestVO requestVO = new ActivityRequestVO();
        requestVO.setActivityCode(activityCode);
        List result = this.queryActivities(requestVO, true, true);
        if (CollectionUtils.isEmpty((Collection)result)) {
            throw new MallAdminException("\u79d2\u6740\u6d3b\u52a8\u672a\u627e\u5230");
        }
        return ResponseUtil.getSuccessData(result.get(0));
    }

    public Boolean disableActivity(SeckillActivityDisableRequestVO requestVO) {
        LoginUser user = null;
        String activityCode = requestVO.getActivityCode();
        ActivityRequestVO activity = new ActivityRequestVO();
        activity.setActivityCode(activityCode);
        List activities = this.queryActivities(activity, true, true);
        if (CollectionUtils.isEmpty((Collection)activities)) {
            throw new MallAdminException("\u6d3b\u52a8\u672a\u627e\u5230");
        }
        SeckillActivitySearchResponseVO vo = (SeckillActivitySearchResponseVO)activities.get(0);
        if (!SeckillActivityStatus.HAVE_NOT_START.equals((Object)vo.getStatus()) && !SeckillActivityStatus.ON_GOING.equals((Object)vo.getStatus())) {
            throw new MallAdminException("\u6d3b\u52a8\u4e0d\u662f\u672a\u5f00\u59cb\u6216\u8005\u6d3b\u52a8\u4e2d\u72b6\u6001");
        }
        SecKillActivityConfigReplaceRequestVO configRequstVO = new SecKillActivityConfigReplaceRequestVO();
        configRequstVO.setActivityStatus(SeckillActivityStatus.HAS_BEEN_STOP.getCode());
        configRequstVO.setActivityCode(activityCode);
        configRequstVO.setVersion(requestVO.getVersion());
        this.updateActivityConfig(configRequstVO, user);
        List<Object> skus = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)vo.getGoodsDTOS())) {
            skus = vo.getGoodsDTOS().stream().map(SeckillActivityGoodsDTO::getSkus).flatMap(Collection::stream).collect(Collectors.toList());
        }
        List copySkus = skus.stream().map(sku -> {
            SeckillActivityGoodsSkuDTO copySku = new SeckillActivityGoodsSkuDTO();
            BeanUtils.copyProperties((Object)sku, (Object)copySku);
            sku.setActivityStock(Integer.valueOf(0));
            return copySku;
        }).collect(Collectors.toList());
        this.updateSkus(user, activityCode, copySkus, skus);
        return true;
    }

    public List<SeckillActivitySearchResponseVO> queryActivities(ActivityRequestVO requestVO, boolean ifQueryGoods, boolean ifQuerySkus) {
        List activeActivitys = this.seckillActivityConfigMapper.queryActiveActivity(requestVO.getActivityCode(), requestVO.getStatuses());
        if (CollectionUtils.isEmpty((Collection)activeActivitys)) {
            return new ArrayList<SeckillActivitySearchResponseVO>();
        }
        List activityCodes = activeActivitys.stream().map(SeckillActivityConfigPO::getActivityCode).collect(Collectors.toList());
        Map<Object, Object> codeMapGoods = new HashMap();
        Map<Object, Object> codeMapSkus = new HashMap();
        if (ifQueryGoods) {
            List goodsPOS = this.seckillActivityGoodsMapper.queryGoodsByActivityCodes(activityCodes);
            codeMapGoods = goodsPOS.stream().collect(Collectors.groupingBy(SeckillActivityGoodsPO::getActivityCode, Collectors.toList()));
        }
        if (ifQueryGoods && ifQuerySkus) {
            List skuPOS = this.seckillActivitySkuMapper.queryByActivityCodes(activityCodes);
            codeMapSkus = skuPOS.stream().collect(Collectors.groupingBy(SeckillActivitySkuPO::getActivityCode, Collectors.toList()));
        }
        ArrayList<SeckillActivitySearchResponseVO> result = new ArrayList<SeckillActivitySearchResponseVO>();
        for (SeckillActivityConfigPO activity : activeActivitys) {
            SeckillActivitySearchResponseVO vo = new SeckillActivitySearchResponseVO();
            BeanUtils.copyProperties((Object)activity, (Object)vo);
            List goodsDtos = BeanListUtil.copy((List)((List)codeMapGoods.get(activity.getActivityCode())), SeckillActivityGoodsDTO.class);
            List skus = (List)codeMapSkus.get(activity.getActivityCode());
            Map goodsMapSkus = skus.stream().collect(Collectors.groupingBy(SeckillActivitySkuPO::getGoodsNo, Collectors.toList()));
            for (SeckillActivityGoodsDTO goodsDto : goodsDtos) {
                List skuPos = goodsMapSkus.get(goodsDto.getGoodsNo());
                goodsDto.setSkus(BeanListUtil.copy(skuPos, SeckillActivityGoodsSkuDTO.class));
                for (SeckillActivityGoodsSkuDTO sku : goodsDto.getSkus()) {
                    Integer stock = this.integralGoodsService.getSkuStockBySkuNo(sku.getSkuNo(), sku.getGoodsId());
                    sku.setActualStock(stock);
                }
            }
            vo.setGoodsDTOS(goodsDtos);
            result.add(vo);
        }
        return result;
    }

    public SeckillActivitySearchResponseVO queryActivityStatus(String activityCode) {
        ActivityRequestVO requestVO = new ActivityRequestVO();
        requestVO.setActivityCode(activityCode);
        List responseVOS = this.queryActivities(requestVO, false, false);
        if (CollectionUtils.isEmpty((Collection)responseVOS)) {
            throw new MallAdminException("\u6d3b\u52a8\u672a\u521b\u5efa\uff0c\u7cfb\u7edf\u9519\u8bef");
        }
        SeckillActivitySearchResponseVO vo = (SeckillActivitySearchResponseVO)responseVOS.get(0);
        SeckillActivityStatus status = SeckillActivityStatus.correctStatus((Integer)vo.getActivityType(), (String)vo.getActivityRule(), (Date)vo.getSeckillBeginTime(), (Date)vo.getSeckillEndTime(), (boolean)vo.getDisabled());
        vo.setStatus(status);
        return vo;
    }

    public Boolean checkStock(List<SeckillActivityGoodsSkuDTO> skusForInsert, Integer goodsId) {
        if (CollectionUtils.isEmpty(skusForInsert)) {
            return false;
        }
        List skuDetails = this.goodsSkuDetailService.findByGoodsId(goodsId);
        Map<String, GoodsSkuDetail> noMapSku = skuDetails.stream().collect(Collectors.toMap(GoodsSkuDetail::getSkuNo, sku -> sku));
        for (SeckillActivityGoodsSkuDTO skuForInsert : skusForInsert) {
            GoodsSkuDetail skuDetail = noMapSku.get(skuForInsert.getSkuNo());
            if (ObjectUtils.notEqual((Object)skuDetail.getStock(), (Object)skuForInsert.getActualStock())) {
                return false;
            }
            if (skuForInsert.getActivityStock() <= skuDetail.getStock()) continue;
            return false;
        }
        return true;
    }

    private void updateNewGoods(String activityCode, LoginUser user, List<SeckillActivityGoodsDTO> original, List<SeckillActivityGoodsDTO> newGoods, Integer merchantId) {
        List originalGoodsNo = original.stream().map(SeckillActivityGoodsDTO::getGoodsNo).collect(Collectors.toList());
        List updateGoodsNo = newGoods.stream().map(SeckillActivityGoodsDTO::getGoodsNo).collect(Collectors.toList());
        List toAdd = newGoods.stream().filter(goods -> !originalGoodsNo.contains(goods.getGoodsNo())).collect(Collectors.toList());
        List toDetele = original.stream().filter(goods -> {
            if (!updateGoodsNo.contains(goods.getGoodsNo())) {
                goods.setDelete(Integer.valueOf(1));
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        List toAddGoodNos = toAdd.stream().map(SeckillActivityGoodsDTO::getGoodsNo).collect(Collectors.toList());
        List toUpdate = newGoods.stream().filter(goods -> !toAddGoodNos.contains(goods.getGoodsNo())).collect(Collectors.toList());
        toUpdate.addAll(toDetele);
        this.insertGoods(user, toAdd, activityCode, merchantId);
        this.updateGoods(user, toUpdate, activityCode);
    }

    private void updateNewSkus(String activityCode, LoginUser user, List<SeckillActivityGoodsDTO> original, List<SeckillActivityGoodsDTO> newGoods, Integer merchantId) {
        List originalSku = original.stream().map(SeckillActivityGoodsDTO::getSkus).flatMap(Collection::stream).collect(Collectors.toList());
        List newSkus = newGoods.stream().map(SeckillActivityGoodsDTO::getSkus).flatMap(Collection::stream).collect(Collectors.toList());
        List originalSkuNos = originalSku.stream().map(SeckillActivityGoodsSkuDTO::getSkuNo).collect(Collectors.toList());
        List updateSkuNos = newSkus.stream().map(SeckillActivityGoodsSkuDTO::getSkuNo).collect(Collectors.toList());
        List toAddSkus = newSkus.stream().filter(sku -> !originalSkuNos.contains(sku.getSkuNo())).collect(Collectors.toList());
        List toAddSkusNo = toAddSkus.stream().map(SeckillActivityGoodsSkuDTO::getSkuNo).collect(Collectors.toList());
        List toDeleteSkus = originalSku.stream().filter(sku -> {
            if (!updateSkuNos.contains(sku.getSkuNo())) {
                sku.setDelete(Integer.valueOf(1));
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        List toUpdateSkus = newSkus.stream().filter(sku -> !toAddSkusNo.contains(sku.getSkuNo())).collect(Collectors.toList());
        toUpdateSkus.addAll(toDeleteSkus);
        this.insertSkus(user, activityCode, toAddSkus, merchantId);
        this.updateSkus(user, activityCode, newSkus, originalSku);
    }

    private void updateGoods(LoginUser user, List<SeckillActivityGoodsDTO> goodses, String activityCode) {
        ArrayList skus = new ArrayList();
        for (SeckillActivityGoodsDTO goods : goodses) {
            SeckillActivityGoodsPO goodsPO = new SeckillActivityGoodsPO();
            BeanUtils.copyProperties((Object)goods, (Object)goodsPO);
            goodsPO.setGmtModified(new Date());
            goodsPO.setModifier(user.getNickName());
            goodsPO.setModifierId(user.getAccountCode());
            goodsPO.setActivityCode(activityCode);
            this.seckillActivityGoodsMapper.updateGoods(goodsPO);
            skus.addAll(goods.getSkus());
        }
    }

    private Pair<List<String>, String> check(SecKillActivityConfigReplaceRequestVO requestVO) {
        String errorMsg = null;
        List goodses = requestVO.getGoodses();
        List failGoods = this.checkPrice(requestVO.getGoodses());
        if (CollectionUtils.isNotEmpty((Collection)failGoods)) {
            errorMsg = "\u4f20\u5165\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a";
        }
        if (requestVO.getSeckillEndTime().compareTo(requestVO.getSeckillStartTime()) < 0) {
            errorMsg = "\u79d2\u6740\u5f00\u59cb\u65f6\u95f4\u5e94\u5c0f\u4e8e\u79d2\u6740\u7ed3\u675f\u65f6\u95f4";
        }
        for (SeckillActivityGoodsDTO goods : goodses) {
            if (!this.checkStock(goods.getSkus(), goods.getGoodsId()).booleanValue()) continue;
            failGoods.add(goods.getGoodsNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)failGoods)) {
            errorMsg = "\u5546\u54c1\u7684sku\u5e93\u5b58\u5df2\u7ecf\u66f4\u6539\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u6dfb\u52a0\uff01";
        }
        return Pair.of((Object)failGoods, (Object)errorMsg);
    }

    private List<String> checkPrice(List<SeckillActivityGoodsDTO> goodses) {
        return goodses.stream().filter(goods -> goods.getPrice() == null && goods.getCashPrice() == null).map(SeckillActivityGoodsDTO::getGoodsNo).collect(Collectors.toList());
    }

    private void insertGoods(LoginUser user, List<SeckillActivityGoodsDTO> goodses, String activityCode, Integer merchantId) {
        if (CollectionUtils.isEmpty(goodses) || StringUtils.isBlank((CharSequence)activityCode)) {
            throw new MallAdminException("\u53c2\u6570\u9519\u8bef");
        }
        for (SeckillActivityGoodsDTO goods : goodses) {
            SeckillActivityGoodsPO goodsPO = new SeckillActivityGoodsPO();
            BeanUtils.copyProperties((Object)goods, (Object)goodsPO);
            goodsPO.setCreatorId(user.getAccountCode());
            goodsPO.setCreator(user.getNickName());
            goodsPO.setGmtCreate(new Date());
            goodsPO.setGmtModified(new Date());
            goodsPO.setModifier(user.getNickName());
            goodsPO.setModifierId(user.getAccountCode());
            goodsPO.setVersion(Integer.valueOf(0));
            goodsPO.setActivityCode(activityCode);
            goodsPO.setMerchantId(merchantId);
            this.seckillActivityGoodsMapper.insertSelective((Object)goodsPO);
        }
    }

    private void insertSkus(LoginUser user, String activityCode, List<SeckillActivityGoodsSkuDTO> skus, Integer merchantId) {
        if (StringUtils.isBlank((CharSequence)activityCode) || CollectionUtils.isEmpty(skus)) {
            throw new MallAdminException("\u53c2\u6570\u9519\u8bef");
        }
        for (SeckillActivityGoodsSkuDTO sku : skus) {
            sku.setStock(sku.getActivityStock());
            SeckillActivitySkuPO skuPO = new SeckillActivitySkuPO();
            BeanUtils.copyProperties((Object)sku, (Object)skuPO);
            skuPO.setActivityCode(activityCode);
            skuPO.setCreatorId(user.getAccountCode());
            skuPO.setCreator(user.getNickName());
            skuPO.setGmtCreate(new Date());
            skuPO.setGmtModified(new Date());
            skuPO.setModifier(user.getNickName());
            skuPO.setModifierId(user.getAccountCode());
            skuPO.setVersion(Integer.valueOf(0));
            skuPO.setMerchantId(merchantId);
            this.seckillActivitySkuMapper.insertSelective((Object)skuPO);
        }
        this.changeStock(skus);
    }

    private void updateSkus(LoginUser user, String activityCode, List<SeckillActivityGoodsSkuDTO> skus, List<SeckillActivityGoodsSkuDTO> originalSku) {
        Map<Integer, Integer> noMapStock = originalSku.stream().collect(Collectors.toMap(SeckillActivityGoodsSkuDTO::getGoodsNo, SeckillActivityGoodsSkuDTO::getActivityStock));
        for (SeckillActivityGoodsSkuDTO sku : skus) {
            if (sku.getDelete() == 1) {
                sku.setStock(Integer.valueOf(-sku.getActivityStock().intValue()));
            } else {
                sku.setStock(Integer.valueOf(sku.getActivityStock() - noMapStock.get(sku.getGoodsNo())));
            }
            SeckillActivitySkuPO skuPO = new SeckillActivitySkuPO();
            BeanUtils.copyProperties((Object)sku, (Object)skuPO);
            skuPO.setActivityCode(activityCode);
            skuPO.setGmtModified(new Date());
            skuPO.setModifier(user.getNickName());
            skuPO.setModifierId(user.getAccountCode());
            this.seckillActivitySkuMapper.updateSku(skuPO);
            if (sku.getDelete() == 1) continue;
            this.insertRecord(user, activityCode, sku.getGoodsId(), sku.getSkuNo(), null, noMapStock.get(sku.getGoodsNo()), sku.getActivityStock());
        }
        this.changeStock(skus);
    }

    private void insertActivityConfig(SecKillActivityConfigReplaceRequestVO requestVO, LoginUser user, String activityCode) {
        SeckillActivityConfigPO configPO = new SeckillActivityConfigPO();
        BeanUtils.copyProperties((Object)requestVO, (Object)configPO);
        configPO.setActivityCode(activityCode);
        configPO.setSysBrandId(user.getBrandId());
        configPO.setSysCompanyId(user.getCompanyId());
        configPO.setActivityStatus(SeckillActivityStatus.HAVE_NOT_START.getCode());
        configPO.setCreatorId(user.getAccountCode());
        configPO.setCreator(user.getNickName());
        configPO.setGmtCreate(new Date());
        configPO.setGmtModified(new Date());
        configPO.setModifier(user.getNickName());
        configPO.setModifierId(user.getAccountCode());
        configPO.setVersion(Integer.valueOf(0));
        this.seckillActivityConfigMapper.insertSelective((Object)configPO);
    }

    private void updateActivityConfig(SecKillActivityConfigReplaceRequestVO requestVO, LoginUser user) {
        SeckillActivityConfigPO configPO = new SeckillActivityConfigPO();
        BeanUtils.copyProperties((Object)requestVO, (Object)configPO);
        configPO.setGmtModified(new Date());
        configPO.setModifier(user.getNickName());
        configPO.setModifierId(user.getAccountCode());
        this.seckillActivityConfigMapper.updateActiveActivity(configPO);
    }

    private boolean changeStock(List<SeckillActivityGoodsSkuDTO> skus) {
        List failSkuChanges;
        List skusForUpdate = BeanListUtil.copy(skus, GoodsSkuDetail.class);
        if (CollectionUtils.isNotEmpty((Collection)skusForUpdate) && CollectionUtils.isNotEmpty((Collection)(failSkuChanges = this.goodsSkuDetailService.inventoryReduction(skusForUpdate)))) {
            List failSku = failSkuChanges.stream().map(GoodsStockChangeResponseDTO::getSkuNo).collect(Collectors.toList());
            throw new MallAdminException("\u6263\u51cfsku\u5e93\u5b58\u5931\u8d25\uff01sku:" + String.join((CharSequence)",", failSku));
        }
        return true;
    }

    private String generateCode() {
        String uuid = UUID.randomUUID().toString();
        return "NSC_" + DateUtil.getNow((String)DateUtil.yymmddHHmmss) + uuid.substring(uuid.length() - 4);
    }

    public List<String> checkGoodsInActivity(String goodsNo, Integer merchantId) {
        List goodsPOS = this.seckillActivityGoodsMapper.queryByGoodsId(goodsNo);
        ArrayList<String> activityCodes = new ArrayList<String>();
        for (SeckillActivityGoodsPO goodsPO : goodsPOS) {
            String activityCode = goodsPO.getActivityCode();
            ActivityRequestVO requestVO = new ActivityRequestVO();
            requestVO.setActivityCode(activityCode);
            requestVO.setStatuses((List)Lists.newArrayList((Object[])new Integer[]{SeckillActivityStatus.HAVE_NOT_START.getCode(), SeckillActivityStatus.ON_GOING.getCode()}));
            List responseVOS = this.queryActivities(requestVO, false, false);
            if (!CollectionUtils.isNotEmpty((Collection)responseVOS)) continue;
            activityCodes.add(activityCode);
        }
        return activityCodes;
    }

    public void insertRecord(LoginUser user, String activityCode, Integer goodsId, String skuNo, Integer merchantId, Integer beforeStock, Integer afterStock) {
        SeckillActivityUpdateRecordPO po = new SeckillActivityUpdateRecordPO();
        po.setGoodsId(goodsId);
        po.setMerchantId(merchantId);
        po.setActivityCode(activityCode);
        po.setSkuNo(skuNo);
        po.setStockBeforeUpdate(beforeStock);
        po.setStockAfterUpdate(afterStock);
        po.setModifier(user.getNickName());
        po.setUpdateTime(new Date());
        this.seckillActivityUpdateRecordMapper.insertSelective((Object)po);
    }
}

