/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.newseckill.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.wmeimob.fastboot.bizvane.dto.integral.GoodSkuSpecDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralClassify;
import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralSpec;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralOrderTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityStatus;
import com.wmeimob.fastboot.bizvane.mapper.IntegralClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralConfigMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralSpecMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityOrderRecordMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivitySkuMapper;
import com.wmeimob.fastboot.bizvane.po.SeckillActivitySkuPO;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityStatisticsPO;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrderJobService;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityOrderSevice;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityService;
import com.wmeimob.fastboot.bizvane.service.seckill.SeckillActivityRpcService;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityBaseSearchVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsRpcVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityResponseRpcVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivitySearchResponseVO;
import com.wmeimob.fastboot.bizvane.utils.response.Result;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class SeckillActivityRpcServiceImpl
implements SeckillActivityRpcService {
    private static final Logger log = LoggerFactory.getLogger(SeckillActivityRpcServiceImpl.class);
    @Resource
    SeckillActivityGoodsMapper seckillActivityGoodsMapper;
    @Resource
    SeckillActivityOrderRecordMapper seckillActivityOrderRecordMapper;
    @Resource
    private IntegralGoodsMapper integralGoodsMapper;
    @Resource
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;
    @Resource
    private IntegralSpecMapper integralSpecMapper;
    @Resource
    private IntegralClassifyMapper integralClassifyMapper;
    @Resource
    private IntegralConfigMapper integralConfigMapper;
    @Autowired
    SeckillActivityRpcService seckillActivityRpcService;
    @Autowired
    private IntegralOrdersService integralOrdersService;
    @Resource
    private ThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private IntegralOrderJobService integralOrderJobService;
    @Resource
    SeckillActivityService seckillActivityService;
    @Resource
    SeckillActivitySkuMapper seckillActivitySkuMapper;
    @Resource
    SeckillActivityOrderSevice seckillActivityOrderSevice;

    public Result<SeckillActivityResponseRpcVO> getSeckillActivityGoodsList(SeckillActivityBaseSearchVO searchVO) {
        log.info("SeckillActivityRpcServiceImpl#getSeckillActivityGoodsList:{}", (Object)JSON.toJSONString((Object)searchVO));
        SeckillActivitySearchResponseVO responseVO = this.seckillActivityService.queryActivityStatus(searchVO.getActivityCode());
        if (SeckillActivityStatus.checkStatus((SeckillActivityStatus)responseVO.getStatus())) {
            return Result.success();
        }
        PageHelper.startPage((int)searchVO.getPageIndex(), (int)searchVO.getPageSize());
        List seckillGoodsList = this.seckillActivityGoodsMapper.getSeckillGoodsList(searchVO.getActivityCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)seckillGoodsList)) {
            return Result.success();
        }
        PageInfo pageInfo = new PageInfo(seckillGoodsList);
        List goodsIdList = pageInfo.getList().stream().map(SeckillActivityGoodsRpcVO::getActivityGoodsId).collect(Collectors.toList());
        List skuList = this.seckillActivitySkuMapper.selectActivitySkuList(searchVO.getActivityCode(), goodsIdList);
        Map<Integer, Integer> stockMap = skuList.stream().collect(Collectors.groupingBy(SeckillActivitySkuPO::getGoodsId, Collectors.summingInt(SeckillActivitySkuPO::getActivityStock)));
        List statisticsPOList = this.seckillActivityOrderRecordMapper.selectSeckillOrderRecordList(searchVO.getActivityCode(), goodsIdList);
        SeckillActivityResponseRpcVO response = new SeckillActivityResponseRpcVO();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)statisticsPOList)) {
            response.setGoodsRpcVOList(seckillGoodsList);
            return Result.success((Object)response, (Long)pageInfo.getTotal());
        }
        Map<Integer, Integer> statisticsPOMap = statisticsPOList.stream().collect(Collectors.toMap(SeckillActivityStatisticsPO::getGoodsId, SeckillActivityStatisticsPO::getGoodsOrderPieceNum));
        pageInfo.getList().forEach(goods -> {
            goods.setOrderGoodsNum((Integer)statisticsPOMap.get(goods.getId()));
            goods.setTotalStock((Integer)stockMap.get(goods.getId()));
        });
        response.setGoodsRpcVOList(seckillGoodsList);
        return Result.success((Object)response, (Long)pageInfo.getTotal());
    }

    public Result<SeckillActivityResponseRpcVO> getGoodsDetail(SeckillActivityBaseSearchVO searchVO) {
        SeckillActivitySearchResponseVO responseVO = this.seckillActivityService.queryActivityStatus(searchVO.getActivityCode());
        if (SeckillActivityStatus.checkStatus((SeckillActivityStatus)responseVO.getStatus())) {
            return Result.success();
        }
        IntegralGoods goods = this.getGoodsById(searchVO);
        SeckillActivityResponseRpcVO vo = new SeckillActivityResponseRpcVO();
        vo.setIntegralGoods(goods);
        return Result.success((Object)vo);
    }

    public Map<String, Object> createOrder(SeckillActivityBaseSearchVO searchVO) {
        log.info("SeckillActivityRpcServiceImpl|createOrder:{}", (Object)JSON.toJSONString((Object)searchVO));
        SeckillActivitySearchResponseVO responseVO = this.seckillActivityService.queryActivityStatus(searchVO.getActivityCode());
        if (!SeckillActivityStatus.ON_GOING.getCode().equals(responseVO.getStatus().getCode())) {
            throw new MallAdminException("\u79d2\u6740\u6d3b\u52a8" + responseVO.getStatus().getMessage());
        }
        IntegralOrders integralOrders = searchVO.getIntegralOrders();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            this.checkOrder(integralOrders);
            if (StringUtils.isNotBlank((CharSequence)integralOrders.getSelfPickTimeStr()) && IntegralOrderTypeEnum.RAISING.getCode().equals(integralOrders.getOrderType())) {
                integralOrders.setSelfPickTime(new Date(Long.parseLong(integralOrders.getSelfPickTimeStr())));
            }
        }
        catch (Exception e) {
            log.error("SeckillActivityRpcServiceImpl|checkOrder:{}", (Throwable)e);
            throw new MallAdminException(e.getMessage());
        }
        searchVO.setGoodsId(integralOrders.getGoodId());
        IntegralGoods searchGoods = this.getGoodsById(searchVO);
        if (searchGoods == null) {
            throw new MallAdminException("\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u5220\u9664~");
        }
        integralOrders.setIntegralGoods(searchGoods);
        String distributionMode = this.integralOrdersService.getDistributionModeBySkuNo(integralOrders.getGoodSkuNo(), integralOrders.getGoodId());
        if ("0".equals(distributionMode)) {
            this.checkEmptyByShipping(integralOrders);
        } else if ("2".equals(distributionMode) && "0".equals(integralOrders.getOrderType())) {
            this.checkEmptyByShipping(integralOrders);
        }
        this.checkMember(integralOrders);
        if ("null".equals(integralOrders.getOrderType())) {
            if (StringUtils.isNotBlank((CharSequence)integralOrders.getShippingAddress())) {
                integralOrders.setOrderType("0");
            } else {
                integralOrders.setOrderType("1");
            }
        }
        IntegralOrders orders = this.seckillActivityOrderSevice.createOrder(integralOrders);
        log.info("WxIntegralOrdersController#confirmGoods#orders:{}", (Object)JSON.toJSONString((Object)orders));
        if (orders != null) {
            map.put("code", 0);
            map.put("msg", "\u64cd\u4f5c\u6210\u529f");
            map.put("data", orders);
            this.scheduledThreadPoolExecutor.execute(() -> {
                log.info("\u8ba2\u5355\u5f85\u652f\u4ed8\u8fdb\u5165job\u5b9a\u65f6\u53d6\u6d88[" + orders.getOrderNo() + "]" + new Date());
                this.integralOrderJobService.addCustomizedIntegralOrderCancelJob(orders.getMerchantId(), orders.getOrderNo());
            });
        } else {
            map.put("code", -1);
            map.put("msg", "\u64cd\u4f5c\u5931\u8d25");
        }
        return map;
    }

    private IntegralGoods getGoodsById(SeckillActivityBaseSearchVO searchVO) {
        log.info("SeckillActivityRpcServiceImpl#searchVO:{}", (Object)JSONObject.toJSONString((Object)searchVO));
        Example example = new Example(IntegralGoods.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", (Object)searchVO.getGoodsId());
        criteria.andEqualTo("valid", (Object)Boolean.TRUE);
        criteria.andEqualTo("shelf", (Object)Boolean.TRUE);
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectOneByExample((Object)example);
        if (integralGoods == null) {
            return null;
        }
        log.info("SeckillActivityRpcServiceImpl#integralGoods:{}", (Object)JSONObject.toJSONString((Object)integralGoods));
        this.buildGoodsSku(integralGoods, searchVO.getGoodsId(), searchVO.getActivityCode());
        this.buildIntegralClassify(integralGoods);
        Example example1 = new Example(IntegralConfig.class);
        example1.createCriteria().andEqualTo("merchantId", (Object)integralGoods.getMerchantId());
        List integralConfigs = this.integralConfigMapper.selectByExample((Object)example1);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)integralConfigs)) {
            log.error("SeckillActivityRpcServiceImpl#\u672a\u521d\u59cb\u5316\u79ef\u5206\u5546\u57ce\u914d\u7f6e:{}", (Object)JSONObject.toJSONString((Object)searchVO));
            return null;
        }
        integralGoods.setIsWholeStore(((IntegralConfig)integralConfigs.get(0)).getIsWholeStore());
        log.info("SeckillActivityRpcServiceImpl#result:{},{}", (Object)JSONObject.toJSONString((Object)searchVO), (Object)JSONObject.toJSONString((Object)integralGoods));
        return integralGoods;
    }

    private void buildGoodsSku(IntegralGoods integralGoods, Integer goodsId, String activityCode) {
        List activitySkuList = this.seckillActivitySkuMapper.selectActivitySkuList(activityCode, (List)Lists.newArrayList((Object[])new Integer[]{goodsId}));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)activitySkuList)) {
            log.error("SeckillActivityRpcServiceImpl|buildGoodsSku is null:{}", (Object)activitySkuList);
            throw new MallAdminException("\u672a\u67e5\u8be2\u5230\u5546\u54c1sku\u4fe1\u606f");
        }
        Map<String, SeckillActivitySkuPO> activitySkuMap = activitySkuList.stream().collect(Collectors.toMap(SeckillActivitySkuPO::getSkuNo, a -> a, (a, b) -> a));
        Example skuExample = new Example(IntegralGoodsSku.class);
        skuExample.createCriteria().andEqualTo("goodsId", (Object)goodsId).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("enabled", (Object)Boolean.TRUE);
        List skuList = new ArrayList();
        skuList = this.integralGoodsSkuMapper.selectByExample((Object)skuExample);
        log.info("SeckillActivityRpcServiceImpl|buildGoodsSku|skuList:{}", (Object)JSON.toJSONString(skuList));
        for (IntegralGoodsSku sku : skuList) {
            ArrayList<GoodSkuSpecDTO> list = new ArrayList<GoodSkuSpecDTO>();
            List specMainList = this.integralSpecMapper.getPidList(sku.getSpecIds());
            for (IntegralSpec mainSpec : specMainList) {
                GoodSkuSpecDTO goodSkuSpecDTO = new GoodSkuSpecDTO();
                IntegralSpec specMain = (IntegralSpec)this.integralSpecMapper.selectByPrimaryKey((Object)mainSpec.getPid());
                goodSkuSpecDTO.setMainSpec(specMain);
                ArrayList<IntegralSpec> child = new ArrayList<IntegralSpec>();
                Example specExample = new Example(IntegralSpec.class);
                specExample.createCriteria().andCondition("id in (" + sku.getSpecIds() + ")");
                List specList = this.integralSpecMapper.selectByExample((Object)specExample);
                for (IntegralSpec childSpec : specList) {
                    if (!childSpec.getPid().equals(specMain.getId())) continue;
                    child.add(childSpec);
                }
                goodSkuSpecDTO.setChilds(child);
                list.add(goodSkuSpecDTO);
            }
            sku.setCashPrice(activitySkuMap.get(sku.getSkuNo()).getCashPrice());
            sku.setPrice(activitySkuMap.get(sku.getSkuNo()).getPrice());
            sku.setStock(activitySkuMap.get(sku.getSkuNo()).getActivityStock());
            sku.setGoodSkuSpecDetails(list);
        }
        int totalStock = activitySkuList.stream().mapToInt(SeckillActivitySkuPO::getActivityStock).sum();
        integralGoods.setTotalStock(Integer.valueOf(totalStock));
        integralGoods.setSkus(skuList);
    }

    private void buildIntegralClassify(IntegralGoods integralGoods) {
        ArrayList<IntegralClassify> integralClassifyList = new ArrayList<IntegralClassify>();
        String classifyStr = integralGoods.getClassifyId();
        if (classifyStr.contains(",")) {
            String[] classifyArray;
            for (String classify : classifyArray = classifyStr.split(",")) {
                IntegralClassify integralClassify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)classify);
                if (integralClassify == null) continue;
                integralClassifyList.add(integralClassify);
            }
        } else {
            IntegralClassify integralClassify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)classifyStr);
            if (integralClassify != null) {
                integralClassifyList.add(integralClassify);
            }
        }
        integralGoods.setClassifyList(integralClassifyList);
        if (integralGoods.getUpperShelfTime() != null) {
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(integralGoods.getUpperShelfTime());
            integralGoods.setUpperShelfTimeStr(time);
        }
    }

    private void checkEmptyByShipping(IntegralOrders integralOrders) {
        if (StringUtils.isEmpty((CharSequence)integralOrders.getShippingName()) || StringUtils.isEmpty((CharSequence)integralOrders.getShippingMobile()) || StringUtils.isEmpty((CharSequence)integralOrders.getShippingProvince()) || StringUtils.isEmpty((CharSequence)integralOrders.getShippingCity()) || StringUtils.isEmpty((CharSequence)integralOrders.getShippingDistrict()) || StringUtils.isEmpty((CharSequence)integralOrders.getShippingAddress()) || "undefined".equals(integralOrders.getShippingName()) || "undefined".equals(integralOrders.getShippingMobile()) || "undefined".equals(integralOrders.getShippingProvince()) || "undefined".equals(integralOrders.getShippingCity()) || "undefined".equals(integralOrders.getShippingDistrict()) || "undefined".equals(integralOrders.getShippingAddress())) {
            throw new MallAdminException("\u8bf7\u5b8c\u5584\u6536\u8d27\u4fe1\u606f\uff01");
        }
    }

    public void checkMember(IntegralOrders integralOrders) {
        log.info("checkMember\u5165\u53c2:[{}]", JSON.toJSON((Object)integralOrders));
        IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)integralOrders.getGoodId());
        log.info("WxIntegralOrdersController#checkMember integralGoods:{}", (Object)JSON.toJSONString((Object)integralGoods));
        if (integralGoods != null && integralGoods.getMemberScope() != 0) {
            String storeWhiteList;
            Object list;
            List list1;
            log.info("\u8be5\u5546\u54c1\u9700\u8981\u6821\u9a8c\u662f\u5426\u9002\u7528\u7b49\u7ea7\u548c\u5e97\u94fa");
            if (!StringUtils.isEmpty((CharSequence)integralGoods.getStoreWhiteList()) && !CollectionUtils.isEmpty((Collection)(list1 = (List)(list = new Gson().fromJson(storeWhiteList = integralGoods.getStoreWhiteList(), new /* Unavailable Anonymous Inner Class!! */.getType())))) && list1.stream().noneMatch(e -> integralOrders.getStoreId().toString().equals(e.getSysStoreId()))) {
                throw new MallAdminException("\u60a8\u76ee\u524d\u7684\u5f00\u5361\u95e8\u5e97\u4e0d\u5c5e\u4e8e\u5546\u54c1\u53ef\u552e\u95e8\u5e97\u8303\u56f4");
            }
            if (!StringUtils.isEmpty((CharSequence)integralGoods.getMemberLevelNames()) && Arrays.stream(integralGoods.getMemberLevelNames().split(",")).noneMatch(e -> integralOrders.getLevelName().equals(e))) {
                throw new MallAdminException("\u60a8\u76ee\u524d\u7684\u5361\u7b49\u7ea7\u4e0d\u5c5e\u4e8e\u5546\u54c1\u53ef\u552e\u7b49\u7ea7\u8303\u56f4");
            }
        }
        log.info("\u5546\u54c1\u901a\u8fc7\u6821\u9a8c:_\u5546\u54c1Id:[{}]", (Object)integralOrders.getGoodId());
    }

    private void checkOrder(IntegralOrders integralOrders) {
        InputValidator.checkEmpty((Object)integralOrders.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)integralOrders.getSysCompanyId(), (String)"\u4f01\u4e1aid");
        InputValidator.checkEmpty((Object)integralOrders.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)integralOrders.getMemberCode(), (String)"\u4f1a\u5458code");
        InputValidator.checkEmpty((Object)integralOrders.getMemberCardNo(), (String)"\u4f1a\u5458\u5361\u53f7");
        InputValidator.checkEmpty((Object)integralOrders.getMemberPhone(), (String)"\u4f1a\u5458\u7535\u8bdd");
        InputValidator.checkEmpty((Object)integralOrders.getGoodId(), (String)"\u5546\u54c1id");
        InputValidator.checkEmpty((Object)integralOrders.getSaleQuantity(), (String)"\u8d2d\u4e70\u6570\u91cf");
        InputValidator.checkEmpty((Object)integralOrders.getGoodSkuNo(), (String)"\u5546\u54c1sku\u7f16\u53f7");
        InputValidator.checkNaturalNumber((Integer)(integralOrders.getSaleQuantity() - 1), (String)"\u8d2d\u4e70\u6570\u91cf");
    }
}

