/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.goodsgroup.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsGroupByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsGroupRelationByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsGroupRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsGroupPO;
import com.wmeimob.fastboot.bizvane.po.GoodsGroupPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.service.goodsgroup.GoodsGroupService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.GoodsGroupLockRequestVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupAddResquestVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupClassAddResquestVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupClassDeleteResquestVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupClassUpdateResquestVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupDeleteResquestVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupSearchListResponseVO;
import com.wmeimob.fastboot.bizvane.vo.goodsgroup.GoodsGroupUpdateResquestVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GoodsGroupServiceImpl
implements GoodsGroupService {
    private static final Logger log = LoggerFactory.getLogger(GoodsGroupServiceImpl.class);
    @Resource
    private GoodsGroupByDesignerPOMapper goodsGroupByDesignerPOMapper;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Resource
    private GoodsGroupRelationByDesignerPOMapper goodsGroupRelationByDesignerPOMapper;
    @Resource
    private GoodsGroupRelationPOMapper goodsGroupRelationPOMapper;

    @Transactional
    public ResponseData addGroupClass(GoodsGroupClassAddResquestVO vo) {
        log.info("GoodsGroupServiceImpl addGroupClass vo:{}", JSON.toJSON((Object)vo));
        vo.setGmtCreate(new Date());
        int result = this.goodsGroupByDesignerPOMapper.insertSelective((GoodsGroupPO)vo);
        log.info("\u63d2\u5165\u7ed3\u679c:{}", (Object)result);
        return result == 1 ? ResponseUtil.getSuccessData(null) : ResponseUtil.getFailedMsg((String)"\u6dfb\u52a0\u5206\u7ec4\u5206\u7c7b\u5931\u8d25");
    }

    public List<GoodsGroupPO> checkClassInUsed(GoodsGroupPO vo) {
        log.info("GoodsGroupServiceImpl addGroupClass vo:{}", JSON.toJSON((Object)vo));
        return this.goodsGroupByDesignerPOMapper.selectGoodClassInUsed(vo.getId(), vo.getMerchantId());
    }

    @Transactional
    public ResponseData deleteGroupClass(GoodsGroupClassDeleteResquestVO vo) {
        log.info("GoodsGroupServiceImpl deleteGroupClass :{}", JSON.toJSON((Object)vo));
        GoodsGroupPO deletePo = new GoodsGroupPO();
        deletePo.setId(vo.getId());
        deletePo.setValid(Boolean.FALSE);
        log.info("\u5546\u54c1\u5206\u7c7b\u4fee\u6539\u53c2\u6570:{}", JSON.toJSON((Object)deletePo));
        int deleteResult = this.goodsGroupByDesignerPOMapper.updateByPrimaryKeySelective(deletePo);
        return deleteResult == 1 ? ResponseUtil.getSuccessData(null) : ResponseUtil.getFailedMsg((String)"\u5220\u9664\u5206\u7ec4\u5206\u7c7b\u5931\u8d25");
    }

    @Transactional
    public ResponseData updateGroupClass(GoodsGroupClassUpdateResquestVO vo) {
        log.info("GoodsGroupServiceImpl updateGroupClass :{}", JSON.toJSON((Object)vo));
        GoodsGroupPO updatePo = new GoodsGroupPO();
        BeanUtils.copyProperties((Object)vo, (Object)updatePo);
        log.info("\u5546\u54c1\u5206\u7c7b\u4fee\u6539\u53c2\u6570:{}", JSON.toJSON((Object)updatePo));
        int updateResult = this.goodsGroupByDesignerPOMapper.updateByPrimaryKeySelective(updatePo);
        return updateResult == 1 ? ResponseUtil.getSuccessData(null) : ResponseUtil.getFailedMsg((String)"\u4fee\u6539\u5206\u7ec4\u5206\u7c7b\u5931\u8d25");
    }

    public ResponseData searchGroupClassList(Integer merchantId) {
        log.info("GoodsGroupServiceImpl searchList :{}", (Object)merchantId);
        GoodsGroupPOExample searchExample = new GoodsGroupPOExample();
        searchExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andPidEqualTo(Integer.valueOf(0));
        List goodsGroupPOS = this.goodsGroupByDesignerPOMapper.selectByExample(searchExample);
        return ResponseUtil.getSuccessData((Object)goodsGroupPOS, (String)"success");
    }

    @Transactional
    public ResponseData addGroup(GoodsGroupAddResquestVO vo) {
        log.info("GoodsGroupServiceImpl addGroup vo:{}", JSON.toJSON((Object)vo));
        vo.setGmtCreate(new Date());
        int insertResult = this.goodsGroupByDesignerPOMapper.insertSelective((GoodsGroupPO)vo);
        log.info("\u63d2\u5165\u7ed3\u679c:{}", (Object)insertResult);
        return insertResult == 1 ? ResponseUtil.getSuccessData(null) : ResponseUtil.getFailedMsg((String)"\u6dfb\u52a0\u5206\u7ec4\u5206\u7c7b\u5931\u8d25");
    }

    public List<GoodsPO> checkGroupInUsed(GoodsGroupDeleteResquestVO vo, Boolean removeJudge) {
        log.info("GoodsGroupServiceImpl checkGroupInUsed vo:{}", JSON.toJSON((Object)vo));
        return this.goodsGroupRelationByDesignerPOMapper.selectGoodsByGroupId(vo.getId());
    }

    @Transactional
    public ResponseData deleteGroup(GoodsGroupDeleteResquestVO vo) {
        log.info("GoodsGroupServiceImpl deleteGroup :{}", JSON.toJSON((Object)vo));
        GoodsGroupPO deletePo = new GoodsGroupPO();
        deletePo.setId(vo.getId());
        deletePo.setValid(Boolean.FALSE);
        GoodsGroupPO checkLocked = this.goodsGroupByDesignerPOMapper.selectByPrimaryKey(vo.getId());
        if (checkLocked != null && Boolean.TRUE.equals(checkLocked.getLocked())) {
            return ResponseUtil.getFailedMsg((String)"\u8be5\u5206\u7ec4\u6b63\u5728\u88ab\u88c5\u4fee\u6a21\u5757\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        log.info("\u5546\u54c1\u5206\u7c7b\u4fee\u6539\u53c2\u6570:{}", JSON.toJSON((Object)deletePo));
        int deleteResult = this.goodsGroupByDesignerPOMapper.updateByPrimaryKeySelective(deletePo);
        List goodsPOS = this.checkGroupInUsed(vo, Boolean.TRUE);
        if (!CollectionUtils.isEmpty((Collection)goodsPOS)) {
            log.info("\u5220\u9664\u5546\u54c1\u4e2d\u5206\u7ec4");
            for (GoodsPO good : goodsPOS) {
                GoodsPO newGood = new GoodsPO();
                newGood.setId(good.getId());
                newGood.setGuessGroupId(good.getGuessGroupId());
                this.goodsPOMapper.updateByPrimaryKeySelective(newGood);
            }
        }
        this.goodsGroupRelationPOMapper.updateGoods(vo.getId(), vo.getMerchantId());
        log.info("\u67e5\u8be2\u51fa\u7684\u5546\u54c1\u96c6\u5408:{}", JSON.toJSON((Object)goodsPOS));
        return deleteResult == 1 ? ResponseUtil.getSuccessData(null) : ResponseUtil.getFailedMsg((String)"\u5220\u9664\u5206\u7ec4\u5206\u7c7b\u5931\u8d25");
    }

    public PageInfo searchGoodsGroupList(GoodsGroupSearchListResponseVO vo) {
        log.info("GoodsGroupServiceImpl searchGoodsGroupList vo:{}", JSON.toJSON((Object)vo));
        GoodsGroupPOExample goodsGroupPOExample = new GoodsGroupPOExample();
        GoodsGroupPOExample.Criteria criteria = goodsGroupPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(vo.getMerchantId()).andPidNotEqualTo(Integer.valueOf(0));
        if (vo.getPid() != null) {
            criteria.andPidEqualTo(vo.getPid());
        }
        if (!StringUtils.isEmpty((Object)vo.getGoodsGroupName())) {
            criteria.andGoodsGroupNameLike("%" + vo.getGoodsGroupName() + "%");
        }
        PageInfo pageInfo = new PageInfo();
        List page = new ArrayList();
        if (vo.getPageJudge().booleanValue()) {
            PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
            page = this.goodsGroupByDesignerPOMapper.selectByExample(goodsGroupPOExample);
            pageInfo = new PageInfo(page);
        } else {
            page = this.goodsGroupByDesignerPOMapper.selectByExample(goodsGroupPOExample);
            pageInfo.setList(page);
        }
        log.info("\u67e5\u8be2\u51fa\u7684\u5206\u9875\u7ed3\u679c:{}", (Object)pageInfo);
        return pageInfo;
    }

    public ResponseData lockUsedGroup(GoodsGroupLockRequestVO vo) {
        log.info("GoodsGroupServiceImpl updateGroup vo:{}", JSON.toJSON((Object)vo));
        GoodsGroupPOExample unLockedAllExample = new GoodsGroupPOExample();
        unLockedAllExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(vo.getMerchantId()).andLockedEqualTo(Boolean.TRUE);
        GoodsGroupPO unLockedAllPo = new GoodsGroupPO();
        unLockedAllPo.setLocked(Boolean.FALSE);
        unLockedAllPo.setGmtModified(new Date());
        this.goodsGroupByDesignerPOMapper.updateByExampleSelective(unLockedAllPo, unLockedAllExample);
        if (!CollectionUtils.isEmpty((Collection)vo.getLockedGroup())) {
            log.info("\u4fee\u6539\u6216\u8005\u6dfb\u52a0\u9501\u5b9a\u5206\u7ec4:{}", (Object)JSON.toJSONString((Object)vo.getLockedGroup()));
            this.goodsGroupByDesignerPOMapper.lockedGroupByIds(vo.getLockedGroup());
        }
        return ResponseUtil.getSuccessData((Object)"null");
    }

    @Transactional
    public ResponseData updateGroup(GoodsGroupUpdateResquestVO vo) {
        log.info("GoodsGroupServiceImpl updateGroup vo:{}", JSON.toJSON((Object)vo));
        GoodsGroupPO updatePo = new GoodsGroupPO();
        BeanUtils.copyProperties((Object)vo, (Object)updatePo);
        log.info("\u5546\u54c1\u5206\u7ec4\u4fee\u6539\u53c2\u6570:{}", JSON.toJSON((Object)updatePo));
        int updateResult = this.goodsGroupByDesignerPOMapper.updateByPrimaryKeySelective(updatePo);
        return updateResult == 1 ? ResponseUtil.getSuccessData(null) : ResponseUtil.getFailedMsg((String)"\u4fee\u6539\u5206\u7ec4\u5206\u7c7b\u5931\u8d25");
    }

    public List<GoodsGroupPO> checkClassIfSameName(GoodsGroupPO vo) {
        log.info("GoodsGroupServiceImpl checkClassIfSameName vo:{}", JSON.toJSON((Object)vo));
        GoodsGroupPOExample goodsGroupPOExample = new GoodsGroupPOExample();
        GoodsGroupPOExample.Criteria criteria = goodsGroupPOExample.createCriteria().andMerchantIdEqualTo(vo.getMerchantId()).andValidEqualTo(Boolean.TRUE).andGoodsGroupNameEqualTo(vo.getGoodsGroupName());
        Integer groupClass = 0;
        if (vo.getPid() != null && groupClass.equals(vo.getPid())) {
            log.info("\u5206\u7ec4\u5206\u7c7b\u67e5\u8be2\u6761\u4ef6\u589e\u52a0");
            criteria.andPidEqualTo(groupClass);
        } else {
            criteria.andPidNotEqualTo(groupClass);
        }
        if (vo.getId() != null) {
            criteria.andIdNotEqualTo(vo.getId());
        }
        goodsGroupPOExample.setOrderByClause("gmt_create desc");
        return this.goodsGroupByDesignerPOMapper.selectByExample(goodsGroupPOExample);
    }
}

