/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.event.pushorder.listener;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.ErpOrderApiService;
import com.wmeimob.fastboot.bizvane.service.event.pushorder.PushIntegralOrderToErpEvent;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.GetPushIntegralOrderToErpRequestVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.event.PushIntegralOrderToErpConstants;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PushIntegralOrderToErpListener
implements ApplicationListener<PushIntegralOrderToErpEvent> {
    private static final Logger log = LoggerFactory.getLogger(PushIntegralOrderToErpListener.class);
    @Autowired
    private ErpOrderApiService erpOrderApiService;
    @Autowired
    private ThreadPoolExecutor scheduledThreadPoolExecutor;

    public void onApplicationEvent(PushIntegralOrderToErpEvent pushIntegralOrderToErpEvent) {
        log.info("\u8fdb\u5165\u79ef\u5206\u8ba2\u5355\u63a8\u9001erp\u4e8b\u4ef6:{}", (Object)pushIntegralOrderToErpEvent.getIntegralOrdersPo().getOrderNo());
        IntegralOrdersPO integralOrdersPo = pushIntegralOrderToErpEvent.getIntegralOrdersPo();
        if (PushIntegralOrderToErpConstants.PUSH_TO_WHERE_361.equals(pushIntegralOrderToErpEvent.getPushToWhere())) {
            this.scheduledThreadPoolExecutor.execute(() -> {
                log.info("\u5f00\u59cb\u5f02\u6b65\u63a8\u9001\u5230361:{}", (Object)integralOrdersPo.getOrderNo());
                ResponseData booleanResponseData = this.erpOrderApiService.pushIntegralOrderOf361ToErp(this.getPusOrderParams(integralOrdersPo));
                log.info("361\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)booleanResponseData));
            });
        }
    }

    private GetPushIntegralOrderToErpRequestVO getPusOrderParams(IntegralOrdersPO integralOrdersPo) {
        GetPushIntegralOrderToErpRequestVO request = new GetPushIntegralOrderToErpRequestVO();
        request.setOrderId(integralOrdersPo.getId());
        request.setOrderNo(integralOrdersPo.getOrderNo());
        request.setExecuteType("pushByIdOrOrderNo");
        request.setMerchantId(integralOrdersPo.getMerchantId());
        return request;
    }
}

