/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralHomePage;
import com.wmeimob.fastboot.bizvane.enums.IntegralStore.activity.IntegralActivityImgTypeSubEnum;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralHomePageMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralActivityPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.service.IntegralHomePageService;
import com.wmeimob.fastboot.bizvane.service.Integralstore.impl.IntegralActivityUtilServiceImpl;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralHomePageServiceImpl
implements IntegralHomePageService {
    private static final Logger log = LoggerFactory.getLogger(IntegralHomePageServiceImpl.class);
    @Resource
    private IntegralHomePageMapper integralHomePageMapper;
    @Resource
    private IntegralGoodsMapper integralGoodsMapper;
    @Resource
    private IntegralActivityPOMapper integralActivityPOMapper;
    @Autowired
    private IntegralActivityUtilServiceImpl integralActivityUtilService;

    public int add(IntegralHomePage integralHomePage) {
        String json = JSONObject.toJSONString((Object)integralHomePage.getImgs());
        integralHomePage.setImgInfo(json);
        integralHomePage.setValid(Boolean.TRUE);
        integralHomePage.setGmtCreate(new Date());
        integralHomePage.setGmtModified(new Date());
        int num = this.integralHomePageMapper.insert((Object)integralHomePage);
        return num;
    }

    public int update(IntegralHomePage integralHomePage) {
        Example example = new Example(IntegralHomePage.class);
        example.createCriteria().andEqualTo("id", (Object)integralHomePage.getId());
        IntegralHomePage homePage = new IntegralHomePage();
        homePage.setImgInterval(integralHomePage.getImgInterval());
        homePage.setGmtModified(new Date());
        if (integralHomePage.getImgs().size() != 0) {
            String json = JSONObject.toJSONString((Object)integralHomePage.getImgs());
            homePage.setImgInfo(json);
        } else {
            homePage.setImgInfo("");
        }
        int num = this.integralHomePageMapper.updateByExampleSelective((Object)homePage, (Object)example);
        return num;
    }

    public IntegralHomePage getHomePage(Integer merchantId) {
        Example example = new Example(IntegralHomePage.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        IntegralHomePage integralHomePage = (IntegralHomePage)this.integralHomePageMapper.selectOneByExample((Object)example);
        if (integralHomePage != null) {
            String imgInfo = integralHomePage.getImgInfo();
            if (StringUtil.isEmpty((CharSequence)imgInfo)) {
                log.info("\u51fa\u73b0\u5f02\u5e38\uff0c\u8be5\u6570\u636e\u6ca1\u6709imgurl");
                return integralHomePage;
            }
            Object list = new Gson().fromJson(imgInfo, new /* Unavailable Anonymous Inner Class!! */.getType());
            List result = (List)list;
            log.info("\u56fe\u7247\u4f4d\u7f6e\u96c6\u5408 param\uff1a{}", JSON.toJSON((Object)result));
            result.stream().forEach(e -> {
                IntegralGoods integralGoods = (IntegralGoods)this.integralGoodsMapper.selectByPrimaryKey((Object)e.getGoodsId());
                if (integralGoods != null) {
                    e.setShelf(Integer.valueOf(integralGoods.getShelf() != false ? 1 : 0));
                }
                if (!StringUtils.isEmpty((CharSequence)e.getZtPath())) {
                    Long activityId = Long.valueOf(e.getZtPath());
                    IntegralActivityPOWithBLOBs activityPO = this.integralActivityPOMapper.selectByPrimaryKey(activityId);
                    Boolean activityStatus = this.integralActivityUtilService.checkActivityStatusUtil(activityPO.getActivityStatus(), activityPO.getBeginTime(), activityPO.getEndTime());
                    e.setActivityName(activityPO.getActivityName());
                    e.setActivityStatus(activityStatus);
                }
                if (e.getImgType() == null && e.getClassifyId() == null) {
                    e.setImgType(IntegralActivityImgTypeSubEnum.ALERT.getCode());
                    if (e.getGoodsId() == null) {
                        e.setClassifyId(IntegralActivityImgTypeSubEnum.CLASSIFY.getCode());
                    } else {
                        e.setClassifyId(IntegralActivityImgTypeSubEnum.GOOD.getCode());
                    }
                }
            });
            integralHomePage.setImgInfo(JSON.toJSON((Object)result).toString());
        }
        return integralHomePage;
    }
}

