/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.newseckill;

import com.wmeimob.fastboot.bizvane.idempotent.Idempotent;
import com.wmeimob.fastboot.bizvane.service.seckill.SeckillActivityRpcService;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityBaseSearchVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityResponseRpcVO;
import com.wmeimob.fastboot.bizvane.utils.response.Result;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/seckill/activity/rpc"})
public class SeckillActivityRpcController {
    private static final Logger log = LoggerFactory.getLogger(SeckillActivityRpcController.class);
    @Autowired
    SeckillActivityRpcService seckillActivityRpcService;

    @PostMapping(value={"/getGoodsList"})
    public Result<SeckillActivityResponseRpcVO> getSeckillActivityGoodsList(@RequestBody SeckillActivityBaseSearchVO searchVO) {
        return this.seckillActivityRpcService.getSeckillActivityGoodsList(searchVO);
    }

    @PostMapping(value={"/getGoodsDetail"})
    public Result<SeckillActivityResponseRpcVO> getGoodsDetail(@RequestBody SeckillActivityBaseSearchVO searchVO) {
        return this.seckillActivityRpcService.getGoodsDetail(searchVO);
    }

    @Idempotent(value="/createOrder", expireMillis=5000L)
    @PostMapping(value={"/createOrder"})
    public Map<String, Object> createOrder(@RequestBody SeckillActivityBaseSearchVO searchVO) {
        return this.seckillActivityRpcService.createOrder(searchVO);
    }
}

