/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.paygateway.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.ChannelConfigDto;
import com.bizvane.base.remote.service.IRemoteMerchantConfigService;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.wmeimob.fastboot.bizvane.enums.paygateway.PayGatewayChannelMidEnum;
import com.wmeimob.fastboot.bizvane.enums.paygateway.PayGatewayChannelTypeEnum;
import com.wmeimob.fastboot.bizvane.po.IntegralPayGatewayPO;
import com.wmeimob.fastboot.bizvane.po.IntegralUnionPayMchPO;
import com.wmeimob.fastboot.bizvane.service.paygateway.AppletInfoService;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayChannelService;
import com.wmeimob.fastboot.bizvane.service.paygateway.PayGatewayConfigService;
import com.wmeimob.fastboot.bizvane.service.skyworth.IntegralUnionPayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayGatewayChannelServiceImpl
implements PayGatewayChannelService {
    private static final Logger log = LoggerFactory.getLogger(PayGatewayChannelServiceImpl.class);
    @Autowired
    private IRemoteMerchantConfigService iRemoteMerchantConfigService;
    @Autowired
    private PayGatewayConfigService payGatewayConfigService;
    @Autowired
    private IntegralUnionPayService integralUnionPayService;
    @Autowired
    private AppletInfoService appletInfoService;

    @Override
    public ChannelConfigDto getRemotePayGatewayChannelUnion(Integer merchantId) {
        IntegralPayGatewayPO integralPayGatewayPO = this.payGatewayConfigService.findByMerchantId(merchantId);
        if (integralPayGatewayPO == null) {
            return null;
        }
        String bizvaneMid = integralPayGatewayPO.getBizvaneMid();
        if (StringUtils.isEmpty((Object)bizvaneMid)) {
            return null;
        }
        ResultBean channelConfig = this.iRemoteMerchantConfigService.getChannelConfig(bizvaneMid, PayGatewayChannelTypeEnum.UNION_TYPE.getType());
        log.info("iRemoteMerchantConfigService.getChannelConfig:{}", (Object)JSON.toJSONString((Object)channelConfig));
        Boolean success = channelConfig.getSuccess();
        if (!success.booleanValue()) {
            return null;
        }
        return (ChannelConfigDto)channelConfig.getResult();
    }

    @Override
    public ChannelConfigDto saveRemotePayGatewayChannelUnion(Integer merchantId) {
        IntegralPayGatewayPO integralPayGatewayPO = this.payGatewayConfigService.findByMerchantId(merchantId);
        if (integralPayGatewayPO == null) {
            return null;
        }
        String bizvaneMid = integralPayGatewayPO.getBizvaneMid();
        if (StringUtils.isEmpty((Object)bizvaneMid)) {
            return null;
        }
        IntegralUnionPayMchPO unionPayMchPO = this.integralUnionPayService.findByBrandId(merchantId);
        if (unionPayMchPO == null) {
            return null;
        }
        WxPublicPO memberInfoAppletInfo = this.appletInfoService.getMemberInfoAppletInfo(merchantId);
        if (memberInfoAppletInfo == null) {
            return null;
        }
        String appid = memberInfoAppletInfo.getAppid();
        String payType = PayGatewayChannelTypeEnum.UNION_TYPE.getType();
        String channelTid = unionPayMchPO.getUnionpayTerminalNo();
        String channelMid = PayGatewayChannelMidEnum.UNION.getType();
        String unionAssignCode = unionPayMchPO.getUnionpaySystemNo();
        String channelSecretKey = unionPayMchPO.getUnionpaySecretKey();
        String channelP12 = null;
        String companyName = integralPayGatewayPO.getCompanyName();
        String brandName = integralPayGatewayPO.getBrandName();
        ResultBean channelConfigDtoResultBean = this.iRemoteMerchantConfigService.saveChannelConfig(bizvaneMid, appid, payType, channelTid, channelMid, unionAssignCode, channelSecretKey, channelP12, companyName, brandName);
        log.info("iRemoteMerchantConfigService.saveChannelConfig:{}", (Object)JSON.toJSONString((Object)channelConfigDtoResultBean));
        Boolean success = channelConfigDtoResultBean.getSuccess();
        if (!success.booleanValue()) {
            return null;
        }
        return (ChannelConfigDto)channelConfigDtoResultBean.getResult();
    }

    @Override
    public ChannelConfigDto modifyRemotePayGatewayChannelUnion(Integer merchantId) {
        IntegralPayGatewayPO integralPayGatewayPO = this.payGatewayConfigService.findByMerchantId(merchantId);
        if (integralPayGatewayPO == null) {
            return null;
        }
        String bizvaneMid = integralPayGatewayPO.getBizvaneMid();
        if (StringUtils.isEmpty((Object)bizvaneMid)) {
            return null;
        }
        IntegralUnionPayMchPO unionPayMchPO = this.integralUnionPayService.findByBrandId(merchantId);
        if (unionPayMchPO == null) {
            return null;
        }
        WxPublicPO memberInfoAppletInfo = this.appletInfoService.getMemberInfoAppletInfo(merchantId);
        if (memberInfoAppletInfo == null) {
            return null;
        }
        String appid = memberInfoAppletInfo.getAppid();
        String payType = PayGatewayChannelTypeEnum.UNION_TYPE.getType();
        String channelTid = unionPayMchPO.getUnionpayTerminalNo();
        String channelMid = PayGatewayChannelMidEnum.UNION.getType();
        String unionAssignCode = unionPayMchPO.getUnionpaySystemNo();
        String channelSecretKey = unionPayMchPO.getUnionpaySecretKey();
        String channelP12 = null;
        String companyName = integralPayGatewayPO.getCompanyName();
        String brandName = integralPayGatewayPO.getBrandName();
        ResultBean channelConfigDtoResultBean = this.iRemoteMerchantConfigService.updateChannelConfig(bizvaneMid, appid, payType, channelTid, channelMid, unionAssignCode, channelSecretKey, channelP12, companyName, brandName);
        log.info("iRemoteMerchantConfigService.updateChannelConfig:{}", (Object)JSON.toJSONString((Object)channelConfigDtoResultBean));
        Boolean success = channelConfigDtoResultBean.getSuccess();
        if (!success.booleanValue()) {
            return null;
        }
        return (ChannelConfigDto)channelConfigDtoResultBean.getResult();
    }
}

