/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.api.integaralstore.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralGoodsSkuPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsPO;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuPO;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsSkuPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralMerchantOfflineConfigPO;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrdersNewService;
import com.wmeimob.fastboot.bizvane.service.api.integaralstore.ErpOrderApiService;
import com.wmeimob.fastboot.bizvane.service.config.IntegralMerchantOfflineConfigService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.thirdpartyapi.constants.Constants361;
import com.wmeimob.fastboot.bizvane.utils.thirdpartyapi.skd361.Client361;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.order.QueryIntegralOrderItemsListResponseVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.order.QueryIntegralOrderWithDetailsRequestVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.order.QueryIntegralOrderWithDetailsResponseVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.GetPushIntegralOrderToErpRequestVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.Get361IntegralOrdersFromErpRequestVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.InterfaceResponse361DTO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.vo361.InterfaceResponseResult361DTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ErpOrderApiServiceImpl
implements ErpOrderApiService {
    private static final Logger log = LoggerFactory.getLogger(ErpOrderApiServiceImpl.class);
    @Autowired
    private Client361 client361;
    @Autowired
    private IntegralOrdersNewService integralOrdersNewService;
    @Resource
    private IntegralGoodsPOMapper integralGoodsPoMapper;
    @Resource
    private IntegralGoodsSkuPOMapper integralGoodsSkuPoMapper;
    @Autowired
    private IntegralMerchantOfflineConfigService integralMerchantOfflineConfigService;

    @Override
    public ResponseData<Boolean> pushIntegralOrderOf361ToErp(GetPushIntegralOrderToErpRequestVO requestParameters) {
        log.info("ErpOrderApiServiceImpl#pushIntegralOrderOf361ToErp:{}", (Object)JSON.toJSONString((Object)requestParameters));
        ResponseData responseData = new ResponseData();
        responseData.setCode(100);
        responseData.setData((Object)Boolean.FALSE);
        try {
            IntegralMerchantOfflineConfigPO offlineConfig = this.integralMerchantOfflineConfigService.getIntegralMerchantOfflineConfig(requestParameters.getMerchantId());
            if (offlineConfig == null) {
                responseData.setMessage(requestParameters.getMerchantId() + "\u4e0d\u7528\u63a8\u9001");
                return responseData;
            }
            if (!"361".equals(offlineConfig.getPushTarget())) {
                responseData.setMessage(requestParameters.getMerchantId() + "\u4e0d\u7528\u63a8\u90012");
                return responseData;
            }
            ResponseData<Boolean> needPushIntegralOrderWithDetails = this.getNeedPushIntegralOrderWithDetails(requestParameters);
            String message = needPushIntegralOrderWithDetails.getMessage();
            if (!((Boolean)needPushIntegralOrderWithDetails.getData()).booleanValue()) {
                responseData.setMessage(message);
                return responseData;
            }
            Map<String, String> map = this.convertPushParams(message);
            if (map == null) {
                responseData.setMessage("IOpenAPI.AddOrder\u8bf7\u6c42\u53c2\u6570\u7a7a\uff01");
                return responseData;
            }
            HashMap resultMap = this.client361.doPostWithSuffixUrl(requestParameters.getMerchantId(), "IOpenAPI.AddOrder", map);
            log.info("\u63a8\u9001361\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c:{}", (Object)resultMap);
            InterfaceResponse361DTO response361DTO = new InterfaceResponse361DTO();
            response361DTO.setCode(Integer.parseInt((String)resultMap.get("code")));
            response361DTO.setMsg((String)resultMap.get("msg"));
            response361DTO.setResult((InterfaceResponseResult361DTO)JSON.parseObject((String)((String)resultMap.get("result")), InterfaceResponseResult361DTO.class));
            if (Constants361.INTERFACE_SUCCESS.equals(response361DTO.getResult().getCode())) {
                responseData.setCode(0);
                responseData.setData((Object)Boolean.TRUE);
                responseData.setMessage(JSON.toJSONString((Object)response361DTO));
                return responseData;
            }
            responseData.setMessage(JSON.toJSONString((Object)response361DTO.getResult()));
            return responseData;
        }
        catch (Exception e) {
            log.warn("ErpOrderApiServiceImpl#pushIntegralOrderOf361ToErp\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    private Map<String, String> convertPushParams(String message) {
        log.info("ErpOrderApiServiceImpl#convertPushParams:{}", (Object)message);
        try {
            QueryIntegralOrderWithDetailsResponseVO pushToErpIntegralOrderInfo = (QueryIntegralOrderWithDetailsResponseVO)JSONObject.parseObject((String)message, QueryIntegralOrderWithDetailsResponseVO.class);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("orderNo", pushToErpIntegralOrderInfo.getOrderNo());
            map.put("userName", "111");
            map.put("uName", pushToErpIntegralOrderInfo.getMemberName());
            String shippingProvince = pushToErpIntegralOrderInfo.getShippingProvince();
            map.put("province", shippingProvince);
            String shippingCity = pushToErpIntegralOrderInfo.getShippingCity();
            map.put("city", shippingCity);
            String shippingDistrict = pushToErpIntegralOrderInfo.getShippingDistrict();
            map.put("district", shippingDistrict);
            String shippingAddress = pushToErpIntegralOrderInfo.getShippingAddress();
            map.put("address", shippingAddress);
            map.put("postcode", "510000");
            map.put("phone", pushToErpIntegralOrderInfo.getMemberPhone());
            map.put("cRemark", StringUtils.isEmpty((Object)pushToErpIntegralOrderInfo.getUserComments()) ? "\u65e0" : pushToErpIntegralOrderInfo.getUserComments());
            map.put("oSumPrice", this.getSumPrice(pushToErpIntegralOrderInfo.getFreight(), pushToErpIntegralOrderInfo.getItems()));
            map.put("expFee", pushToErpIntegralOrderInfo.getFreight() == null ? "" : pushToErpIntegralOrderInfo.getFreight().toString());
            map.put("expCod", "0");
            map.put("storeName", pushToErpIntegralOrderInfo.getStoreName());
            ArrayList apiOrderProInfos = new ArrayList();
            for (QueryIntegralOrderItemsListResponseVO orderDetails : pushToErpIntegralOrderInfo.getItems()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("proNo", orderDetails.getIntegralGoodsPo().getGoodsNo());
                hashMap.put("proTitle", orderDetails.getIntegralGoodsPo().getGoodsName());
                hashMap.put("proCount", orderDetails.getSaleQuantity().toString());
                hashMap.put("proPrice", orderDetails.getIntegralGoodsPo().getCashPrice().toString());
                hashMap.put("proSku", orderDetails.getIntegralGoodsSkuPo().getSkuNo());
                apiOrderProInfos.add(hashMap);
            }
            map.put("OrderPro", JSON.toJSONString(apiOrderProInfos));
            return map;
        }
        catch (Exception e) {
            log.warn("ErpOrderApiServiceImpl#convertPushParams\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private String getSumPrice(BigDecimal freight, List<QueryIntegralOrderItemsListResponseVO> items) {
        log.info("ErpOrderApiServiceImpl#getSumPrice#freight:{},items:{}", (Object)freight, (Object)JSON.toJSONString(items));
        BigDecimal sum = new BigDecimal(0);
        for (QueryIntegralOrderItemsListResponseVO vo : items) {
            BigDecimal salePrice = vo.getSalePrice();
            sum = sum.add(salePrice);
        }
        if (freight != null) {
            sum = sum.add(freight);
        }
        return sum.toString();
    }

    @Override
    public ResponseData<Boolean> getNeedPushIntegralOrderWithDetails(GetPushIntegralOrderToErpRequestVO requestParameters) {
        log.info("ErpOrderApiServiceImpl#getNeedPushIntegralOrderWithDetails:{}", (Object)JSON.toJSONString((Object)requestParameters));
        ResponseData responseData = new ResponseData();
        responseData.setCode(100);
        responseData.setData((Object)Boolean.FALSE);
        try {
            String executeType = requestParameters.getExecuteType();
            Integer merchantId = requestParameters.getMerchantId();
            if ("pushByIdOrOrderNo".equals(executeType) && merchantId != null) {
                if (requestParameters.getOrderId() == null && requestParameters.getOrderNo() == null) {
                    responseData.setMessage("\u8ba2\u5355id\u548c\u8ba2\u5355\u53f7\u540c\u65f6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e0b\u4e00\u6b65\u4efb\u52a1\uff01");
                    return responseData;
                }
                QueryIntegralOrderWithDetailsRequestVO request = new QueryIntegralOrderWithDetailsRequestVO();
                request.setMerchantId(merchantId);
                request.setOrderNo(requestParameters.getOrderNo());
                request.setOrderId(requestParameters.getOrderId());
                List<QueryIntegralOrderWithDetailsResponseVO> queryIntegralOrderWithDetailsResponseVoList = this.integralOrdersNewService.queryIntegralOrderWithDetails(request);
                if (CollectionUtils.isEmpty(queryIntegralOrderWithDetailsResponseVoList)) {
                    responseData.setMessage("\u6839\u636e\u73b0\u6709\u6761\u4ef6\u6ca1\u6709\u627e\u5230\u76f8\u5173\u8ba2\u5355,====>" + JSON.toJSONString((Object)request));
                    return responseData;
                }
                QueryIntegralOrderWithDetailsResponseVO orderWithDetails = queryIntegralOrderWithDetailsResponseVoList.get(0);
                log.info("ErpOrderApiServiceImpl#getNeedPushIntegralOrderWithDetails#\u9700\u8981\u63a8\u9001\u7684\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orderWithDetails));
                List items = orderWithDetails.getItems();
                if (CollectionUtils.isEmpty((Collection)items)) {
                    responseData.setMessage("\u8ba2\u5355\u53f7[" + orderWithDetails.getOrderNo() + "]\u7684\u76f8\u5173\u8be6\u60c5\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e0b\u4e00\u6b65\u4efb\u52a1\uff01");
                    return responseData;
                }
                for (QueryIntegralOrderItemsListResponseVO orderItems : items) {
                    Integer goodId = orderItems.getGoodId();
                    String goodsSkuNo = orderItems.getGoodsSkuNo();
                    if (goodId == null || StringUtils.isEmpty((Object)goodsSkuNo)) {
                        responseData.setMessage("\u8ba2\u5355[" + orderItems.getOrderNo() + "]\u6ca1\u6709\u5173\u8054\u7684goodId\u6216\u8005goodsSkuNo");
                        return responseData;
                    }
                    IntegralGoodsPO integralGoodsPo = this.getGoodsInfoByGoodsId(goodId);
                    if (integralGoodsPo == null) {
                        responseData.setMessage("\u8ba2\u5355[" + orderItems.getOrderNo() + "]\u6ca1\u6709\u5173\u8054\u7684\u5546\u54c1");
                        return responseData;
                    }
                    orderItems.setIntegralGoodsPo(integralGoodsPo);
                    IntegralGoodsSkuPO goodsDetails = this.getGoodsDetailsByGoodSkuNo(merchantId, goodId, goodsSkuNo);
                    if (goodsDetails == null) {
                        responseData.setMessage("\u8ba2\u5355[" + orderItems.getOrderNo() + "]\u6ca1\u6709\u5173\u8054\u7684\u5546\u54c1\u6b3e\u53f7");
                        return responseData;
                    }
                    orderItems.setIntegralGoodsSkuPo(goodsDetails);
                }
                responseData.setCode(0);
                responseData.setData((Object)Boolean.TRUE);
                responseData.setMessage(JSON.toJSONString((Object)orderWithDetails));
                return responseData;
            }
            responseData.setMessage("executeType or merchantId error!");
            return responseData;
        }
        catch (Exception e) {
            log.warn("ErpOrderApiServiceImpl#getNeedPushIntegralOrderWithDetails\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    @Override
    public ResponseData<InterfaceResponse361DTO> get361IntegralOrdersFromErp(Get361IntegralOrdersFromErpRequestVO get361IntegralOrdersFromErpRequest) {
        log.info("ErpOrderApiServiceImpl#get361IntegralOrdersFromErp:{}", (Object)JSON.toJSONString((Object)get361IntegralOrdersFromErpRequest));
        ResponseData responseData = new ResponseData();
        responseData.setCode(100);
        responseData.setData(null);
        try {
            Integer merchantId = get361IntegralOrdersFromErpRequest.getMerchantId();
            HashMap<String, String> paramsMap = this.convertGet361IntegralOrdersFromErpParams(get361IntegralOrdersFromErpRequest);
            HashMap resultMap = this.client361.doPostWithSuffixUrl(merchantId, "IOpenAPI.GetOrder", paramsMap);
            InterfaceResponse361DTO response361DTO = new InterfaceResponse361DTO();
            response361DTO.setCode(Integer.parseInt((String)resultMap.get("code")));
            response361DTO.setMsg((String)resultMap.get("msg"));
            response361DTO.setResult((InterfaceResponseResult361DTO)JSON.parseObject((String)((String)resultMap.get("result")), InterfaceResponseResult361DTO.class));
            if (Constants361.INTERFACE_SUCCESS.equals(response361DTO.getResult().getCode())) {
                responseData.setCode(0);
                responseData.setMessage(response361DTO.getMsg());
                responseData.setData((Object)response361DTO);
                return responseData;
            }
            responseData.setData((Object)response361DTO);
            return responseData;
        }
        catch (Exception e) {
            log.warn("ErpOrderApiServiceImpl#get361IntegralOrdersFromErp\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    private HashMap<String, String> convertGet361IntegralOrdersFromErpParams(Get361IntegralOrdersFromErpRequestVO get361IntegralOrdersFromErpRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((Object)get361IntegralOrdersFromErpRequest.getAppKey())) {
            hashMap.put("appKey", get361IntegralOrdersFromErpRequest.getAppKey());
        }
        if (StringUtils.isEmpty((Object)get361IntegralOrdersFromErpRequest.getOrderId())) {
            hashMap.put("orderId", get361IntegralOrdersFromErpRequest.getOrderId());
        }
        if (StringUtils.isEmpty((Object)get361IntegralOrdersFromErpRequest.getOrderNo())) {
            hashMap.put("orderNo", get361IntegralOrdersFromErpRequest.getOrderNo());
        }
        if (StringUtils.isEmpty((Object)get361IntegralOrdersFromErpRequest.getOrderStatus())) {
            hashMap.put("orderStatus", get361IntegralOrdersFromErpRequest.getOrderStatus());
        }
        if (StringUtils.isEmpty((Object)get361IntegralOrdersFromErpRequest.getStartTime())) {
            hashMap.put("startTime", get361IntegralOrdersFromErpRequest.getStartTime());
        }
        if (StringUtils.isEmpty((Object)get361IntegralOrdersFromErpRequest.getEndTime())) {
            hashMap.put("endTime", get361IntegralOrdersFromErpRequest.getEndTime());
        }
        if (StringUtils.isEmpty((Object)get361IntegralOrdersFromErpRequest.getPageIndex())) {
            hashMap.put("pageIndex", get361IntegralOrdersFromErpRequest.getPageIndex());
        }
        if (StringUtils.isEmpty((Object)get361IntegralOrdersFromErpRequest.getPageSize())) {
            hashMap.put("pageSize", get361IntegralOrdersFromErpRequest.getPageSize());
        }
        return hashMap;
    }

    private IntegralGoodsSkuPO getGoodsDetailsByGoodSkuNo(Integer merchantId, Integer goodId, String goodsSkuNo) {
        log.info("ErpOrderApiServiceImpl#getGoodsDetailsByGoodSkuNo#merchantId:{},goodId{},goodsSkuNo:{}", new Object[]{merchantId, goodId, goodsSkuNo});
        try {
            IntegralGoodsSkuPOExample example = new IntegralGoodsSkuPOExample();
            example.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andGoodsIdEqualTo(goodId).andSkuNoEqualTo(goodsSkuNo);
            List integralGoodsSkuList = this.integralGoodsSkuPoMapper.selectByExample(example);
            if (CollectionUtils.isEmpty((Collection)integralGoodsSkuList)) {
                return null;
            }
            return (IntegralGoodsSkuPO)integralGoodsSkuList.get(0);
        }
        catch (Exception e) {
            log.warn("ErpOrderApiServiceImpl#getGoodsDetailsByGoodSkuNo\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private IntegralGoodsPO getGoodsInfoByGoodsId(Integer goodId) {
        log.info("ErpOrderApiServiceImpl#getGoodsInfoByGoodsId:{}", (Object)goodId);
        try {
            return this.integralGoodsPoMapper.selectByPrimaryKey(goodId);
        }
        catch (Exception e) {
            log.warn("ErpOrderApiServiceImpl#getGoodsInfoByGoodsId\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

