/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.qdqm;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.entity.MerchantImportTask;
import com.wmeimob.fastboot.bizvane.service.qdqm.ImportTaskService;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.qdqm.ImportTaskRequestVO;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"importTask"})
public class MerchantImportTaskController {
    private static final Logger log = LoggerFactory.getLogger(MerchantImportTaskController.class);
    @Autowired
    private LoginUtil loginUtil;
    @Autowired
    private ImportTaskService importTaskService;

    @PostMapping(value={"add"})
    public ResponseData<MerchantImportTask> addGoodsSyncRecordBatch(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody ImportTaskRequestVO requestVO, HttpServletRequest request) {
        LoginUser loginUser = this.loginUtil.getLoginUser(request);
        requestVO.setMerchantId(merchantId);
        log.info("MerchantImportTaskController_addGoodsSyncRecordBatch_param:{}", (Object)JSON.toJSONString((Object)requestVO));
        ResponseData merchantImportTaskResponseData = null;
        try {
            merchantImportTaskResponseData = this.importTaskService.addTask(requestVO, loginUser);
        }
        catch (Exception e) {
            log.warn("MerchantImportTaskController_addGoodsSyncRecordBatch_error:{}", (Object)e.getMessage(), (Object)e);
            merchantImportTaskResponseData = ResponseUtil.getFailedMsg((String)"\u65b0\u589e\u5bfc\u5165\u5931\u8d25!");
        }
        log.info("MerchantImportTaskController_addGoodsSyncRecordBatch_response:{}", (Object)JSON.toJSONString((Object)merchantImportTaskResponseData));
        return merchantImportTaskResponseData;
    }
}

