/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral_wx;

import com.wmeimob.fastboot.bizvane.dto.LogisticInfoDTO;
import com.wmeimob.fastboot.bizvane.entity.LogisticCompany;
import com.wmeimob.fastboot.bizvane.entity.LogisticCompanyData;
import com.wmeimob.fastboot.bizvane.service.LogisticInfoService;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"logistics"})
@Api(value="\u7269\u6d41\u4fe1\u606f")
public class LogisticInfoController {
    private static final Logger log = LoggerFactory.getLogger(LogisticInfoController.class);
    @Autowired
    private LogisticInfoService logisticInfoService;

    @ApiOperation(value="\u7269\u6d41\u8be6\u60c5")
    @GetMapping(value={"/queryLogisticInfo"})
    public List<LogisticInfoDTO> queryLogisticInfo(@RequestParam(value="companyCode") String companyCode, @RequestParam(value="num") String num, @RequestParam(value="phone") String phone) {
        try {
            InputValidator.checkEmpty((Object)companyCode, (String)"\u7269\u6d41\u516c\u53f8\u7f16\u7801");
            InputValidator.checkEmpty((Object)num, (String)"\u7269\u6d41\u5355\u53f7");
            InputValidator.checkEmpty((Object)phone, (String)"\u6536\u4ef6\u4eba\u624b\u673a\u53f7");
            log.info("====\u67e5\u8be2\u7269\u6d41\u4fe1\u606f====\u53c2\u6570:{},{},{}", new Object[]{companyCode, num, phone});
        }
        catch (Exception e) {
            log.warn("\u67e5\u8be2\u7269\u6d41\u4fe1\u606f_error:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
        return this.logisticInfoService.queryLogisticInfo(companyCode, num, phone);
    }

    @ApiOperation(value="\u5feb\u9012\u516c\u53f8\u5217\u8868")
    @GetMapping(value={"/logisticList"})
    public List<LogisticCompany> logisticList() {
        return this.logisticInfoService.logisticList();
    }

    @ApiOperation(value="\u5feb\u9012\u516c\u53f8\u5217\u8868")
    @GetMapping(value={"/companyList"})
    public LogisticCompanyData companyList() {
        LogisticCompanyData data = new LogisticCompanyData();
        List list = this.logisticInfoService.logisticList();
        data.setCompanyList(list);
        return data;
    }
}

